
const shareBaseUrl = "https://s.maxask.com"
const SUM_LEN = 100
let UploadDelay = 10000
const oldServerRunning = (new Date("2024-06-30")).getTime()
export class Note {
    static async create(gl) {
        if (gl.note) return gl.note
        const inst = new Note
        inst.gl = gl
        const { api, mxsync } = gl
        api.registerReceiver({ name: "note", client: inst })
        if (mxsync)
            mxsync.registerClient({ name: "notem", client: inst })
        inst.isInit = false
        return inst
    }
    constructor() {
        this.gl = null
        this.dbid = null
        this.metaCache = null
        this.debounceUploadNote = new Map()
        this.metaUploaded = true
    }
    async run() {

    }
    async onLoginEnd({ success, user_id }) {
        const { mxsync, api, pl } = this.gl
        api.debug("login_end:", success, user_id)
        if (!success) {
            api.debug("login_failed,won't sync note")
            return
        }
        user_id = +user_id
        if (!this.handle_profileLoaded) {
            setTimeout(() => { this.onLoginEnd({ success, user_id }) }, 1000)
            return
        }
        const lv = await this.getMetaVer()
        if (lv > 0) {
            api.debug("found new meta, no need to import")
            return //has new meta, no need to import
        }
        this.initProcess = 0
        if (!user_id) {
            console.log("1")
            await this.importLocalNotes()
        } else {
            const ret = await mxsync.getAllRemoteVersions(['notem'])
            const rv = ret['notem'].ver
            if (rv === 0) {
                console.log("2")
                await this.importLocalNotes()
            } else if (lv === 0 && pl == 'android') {
                await this.importLocalNotes({ removeRemote: false })
            }
            if (rv > lv) {
                mxsync.syncOnce({ names: ['notem'] })
            }
        }
    }
    async onProfileLoaded() {
        this.handle_profileLoaded = false
        const { mxsync, api } = this.gl
        await this.initDB()
        this.handle_profileLoaded = true
    }
    async onCall({ cmd, param }) {
        this.cmdFrom = param?.from
        if (cmd === 'profile_loaded') {
            return await this.onProfileLoaded();
        }
        if (cmd === 'login_end') {
            return await this.onLoginEnd(param);
        }
        if (cmd === 'readNotes') {
            return await this.readNotes(param)
        }
        if (cmd === 'emptyTrash') {
            return await this.emptyTrash(param)
        }
        if (cmd === 'checkNoteUpdate') {
            return await this.checkUpdate(param)
        }
        if (cmd === 'readMeta') {
            return await this.getMeta(param)
        }
        if (cmd === 'findNotes') {
            return await this.findNotes(param)
        }
        if (cmd === 'saveMeta') {
            return await this.saveMeta(param)
        }

        return this[cmd] ? await this[cmd](param) : null
    }
    async onSyncCall({ cmd, param }) {
        const { api, pl } = this.gl
        if (cmd === 'getLocalVersion') {
            return await this.getMetaVer()
        }
        if (cmd === 'getLocalData') {
            const ret = { data: await this.getMeta({ json: false }), ver: await this.getMetaVer() }
            this.checkAndUploadNotes()
            return ret
        }
        if (cmd === 'newData') {
            const { name, uid, data, ver, merge = false } = param
            if (!this.metaUploaded && !merge) {
                const values = await this.getMeta()
                return { code: 1, values }
            }
            this.cmdFrom = null
            const ret = await this.saveMeta({ name, uid, meta: data, ver, merge, fromServer: true })
            return ret
        }
    }
    async initDB() {
        const { api } = this.gl
        api.debug("note: initDB")
        this.metaCache = null
        let ret = await api.openDB({ name: "mxnote.db", param: { type: "user" } })
        if (ret.code != 0) {
            console.error("cannot open mxnote.db")
            return false
        }
        this.dbid = ret.values
        let sql = `CREATE TABLE kv (
                key TEXT UNIQUE,
                value TEXT
            ); `
        ret = await api.callDB({ dbid: this.dbid, sql, vars: [] })
        if (ret.code === 0) {
            //insert init data
            const meta = {
                1: {
                    "pid": -1,
                    "fn": "",
                    "ft": 0,
                    "ns": 414,
                    "sum": "",
                    "ct": 0,
                    "mt": 0,
                    "id": 1,
                    "ot": 0,
                },
                2: {
                    "pid": -1,
                    "fn": "",
                    "ft": 0,
                    "ns": 414,
                    "sum": "",
                    "ct": 0,
                    "mt": 0,
                    "id": 2,
                    "ot": 0,
                },
            }
            ret = await this.saveKV({ key: "meta_ver", value: 0 })
            ret = await this.saveKV({ key: "meta", value: meta })
        }

        sql = `CREATE TABLE notes (
            id INTEGER UNIQUE,
            data TEXT,mt INTEGER, fn TEXT,sum TEXT, ns INTEGER
        ); `
        ret = await api.callDB({ dbid: this.dbid, sql, vars: [] })

        sql = `CREATE index index_note on notes (data); `
        ret = await api.callDB({ dbid: this.dbid, sql, vars: [] })

        return true
    }
    async resetDB() {
        const { api } = this.gl;
        if (this.dbid) {
            let sql = 'DROP Table kv'
            let ret = await api.callDB({ dbid: this.dbid, sql, vars: [] })
            sql = 'Drop Table notes'
            ret = await api.callDB({ dbid: this.dbid, sql, vars: [] })
        }
        return await this.initDB()
    }
    async removeAllRemoteData() {
        return await this._postData({ path: 'removeAll' })
    }
    async readOldMeta({ UserName, noteMetaUrl, force }) {
        const { pl, api } = this.gl
        api.debug("readOldMeta:", force)
        if (pl === 'ios' || pl === 'android') {
            const meta = await api.callBrowser({ cmd: 'getOldMeta', from: 'note', param: { force } })
            return meta
        }
        const res = await fetch(noteMetaUrl + force, { headers: { UserName } })
        const meta = await res.json()
        return meta
    }
    async readOldNote({ UserName, id, noteDataUrl }) {
        const { pl, api } = this.gl
        api.debug("readOldNote:", id)
        if (pl === 'ios' || pl === 'android') {
            const meta = await api.callBrowser({ cmd: 'getOldData', from: 'note', param: { id, downIfMissing: true } })
            return meta
        }
        const res = await fetch(noteDataUrl + id + "&downIfMissing=true", { headers: { UserName } })
        const note = await res.json()
        return note
    }
    async _importOldNotes({ oldmeta, UserName, noteDataUrl }) {
        const { api } = this.gl
        if (!oldmeta) return null
        const uuidmap = {
            "-1": -1,
            "null": 0,
            0: 0,
            "00000000-0000-0000-0000-000000000000": 0,
            "00000001-0000-0000-0000-000000000000": 1,
            "00000002-0000-0000-0000-000000000000": 2,
            "00000003-0000-0000-0000-000000000000": 3,
            "00000004-0000-0000-0000-000000000000": 4,
        }
        const usedIds = new Set();
        let lastId = 1000
        const _get_newid = (item) => {
            let idnew = +item.ct
            if (!idnew) idnew = lastId
            if (usedIds.has(idnew)) idnew = lastId
            while (usedIds.has(idnew)) {
                ++idnew //Math.round(Math.random() * 100000)
                console.log('add one:', idnew)
            }
            usedIds.add(idnew)
            lastId = idnew + 1
            return idnew
        }
        const mostFav = oldmeta["00000003-0000-0000-0000-000000000000"] //most fav
        const newMeta = {}
        const len = Object.keys(oldmeta).length
        let index = 0
        for (const key in oldmeta) {
            index++
            this.initProcess = index * 90 / len
            const item = oldmeta[key]
            let { id, url, pid } = item
            const newid = _get_newid(item)
            if (pid === '' || !pid) pid = "-1"
            if (typeof (oldmeta[pid]) === 'undefined' && !(Object.keys(uuidmap).includes(pid))) {//remove item without a real parent
                delete oldmeta[key]
                continue
            }
            if (!uuidmap[id]) {
                uuidmap[id] = newid
            }
            if (item.ft != 0) {
                item.id = newid
                if (url && url != 'null') item.ft = 2
                else delete item.url
                if (item.pid != 3 && item.pid != '00000003-0000-0000-0000-000000000000') {
                    try {
                        const note = await this.readOldNote({ UserName, id, noteDataUrl })
                        if (note.code === 0 && note.content)
                            await this.saveNote({ ...item, data: note.content, updateMeta: false })
                    } catch (e) {
                        console.error("_importOldNotes:", e.message)
                    }
                }

                newMeta[newid] = item
            } else {
                item.id = uuidmap[id]
                newMeta[uuidmap[id]] = item
            }
        }

        for (const id in newMeta) {
            const item = newMeta[id]
            let { pid, lid } = item
            pid = item.pid = uuidmap[pid]
            if (lid && uuidmap[lid])
                item.lid = uuidmap[lid]
            if (uuidmap[pid] === 0) item.pid = -1
            if (pid === 3) newMeta[item.lid].fav = true
        }
        delete newMeta[3]
        return newMeta
    }
    async importLocalNotes({ data = null, force = false, removeRemote = true } = {}) {
        const { api, mxsync, pl, ver } = this.gl
        try {
            const isImported = await this.readKV({ key: "imported" })
            if (isImported && !force) {
                console.log("already imported on:", isImported)
                return true
            }
            console.log("importLocalNotes")
            const { user_id } = await api.userInfo()
            let ret = null
            const config = await api.callBrowser({ cmd: "getConfig" })
            if (config) {
                this.initProcess = 0
                this.isInit = true
                const { UserName } = config
                const { noteDataUrl, noteMetaUrl } = config.urls || {}
                const forceFlag = Date.now() > oldServerRunning ? "?force=true" : ""
                const oldmeta = await this.readOldMeta({ UserName, noteMetaUrl, force: forceFlag })
                if (oldmeta.isDefault) {
                    this.isInit = false
                    api.debug("importLocalNotes default data, won't import", oldmeta)
                    return
                }
                if (oldmeta.code === 1) {
                    api.debug("readOldMeta code=1", oldmeta)
                    setTimeout(() => { this.importLocalNotes({ force }) }, 10000)
                    return
                }
                if (oldmeta && oldmeta.code === 0) {
                    await this.resetDB()
                    data === null ? data = oldmeta.data : data = data.data
                    const meta = await this._importOldNotes({ oldmeta: data, UserName, noteDataUrl })
                    if (meta) {
                        if (+user_id) {
                            ret = await mxsync.getAllRemoteVersions(['notem'])
                            const rv = removeRemote ? ret['notem'].ver : 1
                            ret = removeRemote && await this.removeAllRemoteData()
                            await this.saveMeta({ meta, ver: rv + 1, fromServer: false, replace: true && removeRemote })
                            this.initProcess = 90
                            await this.checkAndUploadNotes()
                        } else {
                            await this.saveMeta({ meta, ver: 1, fromServer: false, replace: true && removeRemote })
                        }
                        this.initProcess = 100
                        await this.saveKV({ key: "imported", value: Math.floor(Date.now() / 1000) })
                    }
                }

            }
        } catch (e) {
            api.debug("importLocalNotes err:" + e.message, e.stack)
            //api.postError("importLocalNotes err:" + e.message + " " + pl + "-" + ver)
        }

        this.isInit = false
    }
    async readKV({ key }) {
        const { api } = this.gl
        if (key === 'meta') {
            let { user_id } = await api.userInfo()
            if (!user_id) user_id = 0
            let ret = await api.readData({ key: 'noteMeta' + user_id })
            if (!ret) {
                ret = await api.readData({ key: 'noteMeta' })
                if (ret && ret !== 'null') {
                    await this.saveKV({ key: 'meta', value: ret })
                    await api.removeData({ key: 'noteMeta' })
                }
            }
            if (ret && ret !== 'null') return ret
        }
        const sql = "select * from kv where key = ?"
        const ret = await api.callDB({ dbid: this.dbid, name: "readKV", sql, vars: [key] })
        if (ret.code != 0) {
            api.debug("readKV error:", ret)
            return null
        }
        return ret.values[0]?.value
    }
    async saveKV({ key, value }) {
        const { api } = this.gl
        if (key === 'meta') {
            let { user_id } = await api.userInfo()
            if (!user_id) user_id = 0
            const ret = await api.saveData({ key: 'noteMeta' + user_id, value })
            return ret
        }
        if (typeof value === 'object') value = JSON.stringify(value)

        const sql = "Insert or replace into kv (key,value) values (?,?)"
        const ret = await api.callDB({ dbid: this.dbid, name: "saveKV", sql, vars: [key, value] })
        return ret
    }

    async checkAndUploadNotes({ ids } = {}) {
        const { dbid } = this
        const { api } = this.gl
        const sql = ids ? `SELECT id,mt FROM notes WHERE id IN (${ids.join(',')})` : 'SELECT id,mt from notes'
        let ret = await api.callDB({ dbid, sql, vars: [] })
        const remote_mt = await this._postData({ path: "getmt", body: { ids } })
        if (remote_mt.code === 1) return false
        const newNotes = ret.values.filter(item => {
            for (const ri of remote_mt) {
                if (ri.id === item.id) return ri.mt < item.mt
            }
            return true
        })
        if (newNotes.length > 0) {
            const ids = []
            newNotes.forEach(item => ids.push(item.id))
            this.uploadNotes({ ids })
        }
        return true
    }
    async downloadNotes(ids) {
        const itemsObj = {}
        ids.forEach(id => itemsObj[id] = {})
        console.log("downloading notes:", ids)
        //delete ids[1], delete ids[2], delete ids[3]
        ids = ids.filter(id => ![1, 2, 3].includes(id));
        if (Object.keys(ids).length === 0) return { code: 0, msg: "nothing to download" }
        let ret = await this._postData({ path: 'down', body: { itemsObj } })
        console.log("downloading notes return:", ret)
        if (ret.code === 0 && ret.notes) { //has update
            for (const note of ret.notes) {
                const { id, mt, data, fn, ns, sum } = note
                await this.saveNote({ id, mt, data, fn, ns, sum, disableUpload: true, updateMeta: false })
            }
        }
        return ret
    }
    async checkUpdate({ id, mt }) {
        let ret = await this._postData({ path: 'checkUpdate', body: { id, mt } })
        if (ret.code === 0) { //has update
            const { id, mt, data, fn, ns } = ret.note
            //this.saveNote({ id, mt, data, fn, ns })
        }
        if (ret.code === 102) { //client newer
            this.uploadNotes({ ids: [id] })
        }
        return ret
    }
    async emptyTrash({ ids }) {
        const { dbid } = this
        const { api } = this.gl
        const children = []
        for (const id of ids) {
            const c1 = await this.getChildren({ id, filter: { sum: 0 }, recursive: true })
            children.push(...c1)
        }
        ids = ids.concat(children.map(item => item.id))
        const sql = `DELETE FROM notes WHERE id IN (${ids.join(',')})`
        let ret = await api.callDB({ dbid, sql, vars: [] })
        if (ret.code === 0) {
            const meta = await this.getMeta()
            const ver = await this.getMetaVer()
            for (const id of ids) {
                meta[id] = { pid: 100, ft: 100, mt: Date.now() } //mark as deleted
            }
            await this.saveMeta({ meta, ver: ver + 1, upload: true })
            this._postData({ path: 'del', body: { ids } })
        } else {
            console.error("emptyTrash error:", ret)
        }
        return ret
    }
    async findNotes({ keyword, matchContent = true, matchTitle = false }) {
        const { api } = this.gl
        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        let retContent = [], retTitle = []
        if (matchContent) {
            const sql = `select * from notes where data LIKE ?`
            const ret = await api.callDB({ dbid: this.dbid, name: "findNotes", sql, vars: [`%${keyword}%`] })
            for (const item of ret.values) {
                const { id } = item
                meta[id] && retContent.push(meta[id])
            }
            if (!matchTitle) return retContent
        }
        for (const id in meta) {
            const { fn, ft, url, sum } = meta[id]
            //if (ft === 0) continue
            if (fn && fn.toLowerCase().includes(keyword.toLowerCase())) {
                retTitle.push(meta[id]); continue
            }
            if (url && url.toLowerCase().includes(keyword.toLowerCase())) { retTitle.push(meta[id]); continue }
            if (sum && sum.toLowerCase().includes(keyword.toLowerCase())) { retTitle.push(meta[id]); continue }
        }
        return retTitle.concat(retContent)
    }
    async noteFrom({ url }) {
        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        const result = []
        for (const id in meta) {
            const item = meta[id]
            if ((item.ft === 2) && (item.pid !== 2) && (item.url.toLowerCase() === url.toLowerCase())) result.push(item)
        }
        return { code: 0, result }
    }
    metaToTree(itemMap, ftOnly) {
        if (!itemMap) return null
        //const mapCopy = this.copyObj(itemMap)

        // 深度复制时去掉 children 字段
        const mapCopy = _.cloneDeepWith(itemMap, (value, key) => {
            if (key === 'children') return undefined; // 忽略 children
        });
        const tree = [];
        for (let id in mapCopy) {
            id = +id
            const item = mapCopy[id]
            const { pid, ft } = item
            if (item.ft == 0 && !item.children) item.children = []

            if (id === 1 || id === 2) { //root
                tree.push(item);
            } else if (pid && mapCopy[pid]) {
                const pItem = mapCopy[pid]
                if (!pItem.children) pItem.children = []
                if (ftOnly === ft || ftOnly === null)
                    pItem.children.push(item);
            }
        }
        return tree
    }
    async getMeta({ type, json = true, ft = null } = {}) {
        const { api } = this.gl
        if (!this.metaCache) {
            this.metaCache = api.parseJson(await this.readKV({ key: "meta" }))
        }
        if (type === 'tree') {
            const meta = this.metaToTree(this.metaCache, ft)
            return json ? meta : JSON.stringify(meta)
        }
        let cache = this.metaCache
        if (ft !== null) {
            //cache = this.metaCache.filter(item => item.ft = ft)
            cache = Object.fromEntries(
                Object.entries(this.metaCache).filter(([key, item]) => item.ft === ft))
        }
        return json ? cache : JSON.stringify(cache)
    }
    async getMetaVer() {
        const ret = await this.readKV({ key: "meta_ver" })
        return +ret || 0
    }
    async setMetaVer(value) {
        await this.saveKV({ key: "meta_ver", value })
    }
    isNewerOrMissingId(oldmeta, item) {
        if (!oldmeta) return true
        if (!oldmeta[item.id]) return true
        const oi = oldmeta[item.id]
        return oi.mt < item.mt
    }
    async uploadMeta({ meta, ver, replace = false }) {
        const { mxsync, api } = this.gl
        let ret = null
        const { user_id } = await api.userInfo()
        if (!user_id) return { code: 1, err: "not login" }
        if (!meta) {
            console.error("uploadMeta: meta is null", meta)
            return { code: 1 }
        }
        //remove children of meta
        let needUpdateMeta = false
        const deletedItems = []
        for (const id in meta) {
            const item = meta[id]
            //delete fully deleted logs that are older than 30 days
            if (item.pid === 100 && item.mt < Date.now() - 1000 * 60 * 60 * 24 * 30) {
                deletedItems.push(id)
            }
            if (item.children) {
                delete item.children
                needUpdateMeta = true
            }
            if (item.data && item.data.length > 1024) {
                await this.saveNote({ id: item.id, data: item.data, fn: item.fn, mt: item.mt, updateMeta: false, updateImages: false })
                item.data = null
                delete item.data
                needUpdateMeta = true
            }
        }
        if (deletedItems.length > 0) {
            console.log("uploadMeta: deleting items:", deletedItems)
            deletedItems.forEach(id => delete meta[id]);
            needUpdateMeta = true
        }
        if (needUpdateMeta) {
            ret = await this.saveKV({ key: "meta", value: meta })
            this.metaCache = null
        }
        api.debug("Uploading notem...")
        if (!ver)
            ver = +(await this.readKV({ key: "meta_ver" })) || 0

        user_id && (ret = await mxsync.onUpdateData({ ver, name: "notem", data: meta, incVer: replace ? 2 : true }))
        if (ret.code === 1) {
            console.error("uploadMeta", ret)
            ver = await this.getMetaVer()
            this.uploadTimer = setTimeout(() => {
                this.uploadMeta({ meta, ver, replace })
            }, UploadDelay)
            return ret
        }
        if (ret.code === 0) {
            this.metaUploaded = true
            ver = ret.ver
            await this.saveKV({ key: "meta_ver", value: ver })
        }
        return ret
    }
    async notifyNewData() {
        const { pl, api } = this.gl
        const callBrowser = (this.cmdFrom != 'mx'), callNote1 = (this.cmdFrom != 'note_mgr'), callNote2 = (this.cmdFrom != 'note_side'), callNote3 = (this.cmdFrom != 'note_quick')
        callBrowser && api.callBrowser({ from: "mxsync_js", cmd: "newData", param: { name: 'notem' } })
        if (pl == 'win' || pl == 'mac') {
            callNote1 && api.callModule({ from: "note", name: "note_mgr", param: { cmd: "newData", param: { name: 'notem' } } })
            callNote2 && api.callModule({ from: "note", name: "note_side", param: { cmd: "newData", param: { name: 'notem' } } })
            callNote3 && api.callModule({ from: "note", name: "note_quick", param: { cmd: "newData", param: { name: 'notem' } } })
        }
        this.cmdFrom = null
    }
    async saveMeta({ meta, ver, fromServer = false, replace = false }) {
        const { api } = this.gl
        let oldMeta = null, ret = null
        if (!meta) return ret
        if (!fromServer) {
            this.metaUploaded = false
            ret = await this.saveKV({ key: "meta", value: meta })
            if (this.uploadTimer) clearTimeout(this.uploadTimer)
            const metaCopy = this.copyObj(meta)
            this.uploadTimer = setTimeout(() => {
                this.uploadMeta({ meta: metaCopy, ver, replace })
            }, UploadDelay)
            this.metaCache = null
            this.notifyNewData()
            return ret
        }

        oldMeta = await this.getMeta()

        ret = await this.saveKV({ key: "meta_ver", value: ver })
        ret = await this.saveKV({ key: "meta", value: meta })

        this.notifyNewData()
        if (ret.code != 0) {
            console.error("saveMeta", ret)
            return ret
        }
        this.metaCache = null //clear cache                
        if (oldMeta) { //check notes update
            //find modified notes
            meta = api.parseJson(meta)
            const ids = []
            for (const id in meta) {
                const item = meta[id]
                if (item.id === 1 || item.id === 2 || item.id === 3 || item.ft === 0) continue
                if (item.id && this.isNewerOrMissingId(oldMeta, item))
                    ids.push(item.id)
            }
            if (ids.length > 0) {
                console.log("[saveMeta]found new notes downloading:", ids)
                this.downloadNotes(ids)
            }
        }
        this.metaUploaded = true
        return ret
    }
    async updateNoteInMeta({ id, data, ns, mt, sum, fn, action = 'update' }) {
        const { api } = this.gl
        if (!this.metaCache) {
            this.metaCache = await this.getMeta()
        }
        if (!this.metaCache) return { code: 100, err: "no meta" }
        const note = this.metaCache[id]
        if (!note) return { code: 100, err: "not found" }
        if (action === 'update') {
            note.ns = ns, note.mt = mt, note.fn = fn, note.sum = sum
        }
        await this.saveMeta({ meta: this.metaCache })
    }
    async uploadNotes({ ids, notes, wait = 5000 }) {
        const { api } = this.gl
        const debounceMap = this.debounceUploadNote
        if (ids) {
            const ret = await this.readNotes({ ids, download: false })
            if (ret.code != 0) {
                console.error(ret)
                return { code: 100, ret }
            }
            notes = ret.values
        }
        const key = notes.map(n => n.id).sort().join('-');
        console.log(`[uploadNotes] call with key: ${key}`);
        console.log(`[uploadNotes] debounceMap has key?`, debounceMap.has(key));
        if (!debounceMap.has(key)) {
            debounceMap.set(key, _.debounce(() => {
                const _notes = debounceMap.get(key)._notes
                console.log("uploadNotes:", _notes)
                this._postData({ path: 'up', body: { notes: _notes } }).then(ret => {
                    const allids = _notes.map(n => n.id).join(',')
                    api.callBrowser({ cmd: "uploadNotesResult", param: { ret, ids: allids } })
                    // 清理 debounce 函数
                    if (debounceMap.has(key)) {
                        debounceMap.delete(key);
                        console.log(`已清理组合 ${key} 的 debounce 函数`);
                    }
                })
            }, wait, { maxWait: 5000 }))
        }
        debounceMap.get(key)._notes = notes
        debounceMap.get(key)();
    }
    async getEmbededImages({ note_id, data }) {
        if (!data) {
            const ret = await this.readNotes({ ids: [note_id] })
            if (ret.code != 0) {
                console.error(ret)
                return { code: 100, ret }
            }
            data = ret[0].data
        }
        let tempDiv = document.createElement('div');
        tempDiv.innerHTML = data;
        const images = tempDiv.getElementsByTagName('img');
        if (!images) return null
        // Log the src of each image
        const ims = []
        for (let img of images) {
            const { src, alt } = img
            if (img.src.startsWith("data:image")) ims.push({ src, alt })
        }
        tempDiv.remove()
        tempDiv = null
        return ims.length === 0 ? null : ims
    }
    async replaceEmbededImages({ data, images }) {
        let tempDiv = document.createElement('div');
        tempDiv.innerHTML = data;
        const images_org = tempDiv.getElementsByTagName('img');
        if (!images_org) return null
        // Log the src of each image
        const ims = []
        for (let img of images_org) {
            images.forEach(im => {
                if (im.alt === img.alt) {
                    img.src = im.src
                }
            })
        }
        const result = tempDiv.innerHTML
        tempDiv.remove()
        tempDiv = null
        return result
    }
    async uploadEmbededImage({ id, uploadWait = 5000 }) {
        const { api } = this.gl
        const { code, result } = await this.readNotes({ ids: [id] })
        if (code != 0) return false
        const images = await this.getEmbededImages({ data: result[0].data })
        if (!images) return { code: 100, err: "no image" }
        const replaceImages = []
        for (const image of images) {
            const { alt, src } = image
            if (!alt || !src) continue
            const { url, uploadUrl, token, filename } = await this.getUploadUrl({ filename: alt })
            console.log(url, uploadUrl, token, filename)
            const uint8array = Uint8Array.from(atob(src.split(',')[1]), c => c.charCodeAt(0));
            const sha1 = await api.sha1({ uint8array })
            const uploadOptions = {
                method: 'POST', type: 'file', file_ext: filename.split('.').pop(),
                headers: {
                    'Authorization': token, 'X-Bz-File-Name': filename, 'X-Bz-Content-Sha1': sha1,
                    'Content-Type': 'b2/x-auto'
                },
                body: uint8array
            }
            //const { code, values } = await api.clientFetch({ url: uploadUrl, options: uploadOptions })
            const res = await fetch(uploadUrl, uploadOptions)
            const values = await res.json()
            console.log(values)
            //if (code === 0) {
            image.src = "mxn://r?u=" + encodeURIComponent(url)
            replaceImages.push(image)
            //}
        }
        const newData = await this.replaceEmbededImages({ data: result[0].data, images: replaceImages })
        await this.saveNote({ id, data: newData, fn: result[0].fn, uploadWait, updateImages: false })
    }
    async getUploadUrl({ filename }) {
        const { api } = this.gl
        const mxtoken = await api.getCookie("MXTOKEN")
        const res = await fetch(
            "https://syncapi.maxthon.com/userfile/getUploadUrl",
            {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    mxtoken
                },
                body: JSON.stringify({
                    type: "noteres",
                    filename
                }),
            }
        );

        return await res.json();
    }
    async saveNote1(para) {
        if (!para.upload) para.upload = false
        return await this.saveNote(para)
    }

    async saveNote({ id, data, ns = 0, mt = null, fn, sum, uploadWait = 5000, disableUpload = false, updateMeta = true, updateImages = false }) {
        this.gl.api.debug("saveNote")
        const { dbid } = this
        const { api } = this.gl
        const { user_id } = await api.userInfo()
        if (!user_id) disableUpload = true;
        if (ns === 0) ns = data ? data.length : (sum ? sum.length : 0)
        if (updateImages) {
            const images = await this.getEmbededImages({ data })
            if (images) {
                const imgToUpload = api.parseJson(await api.readData({ key: "imgToUpload" })) || {}
                if (!imgToUpload[id]) {
                    imgToUpload[id] = id
                    await api.saveData({ key: "imgToUpload", value: imgToUpload })
                }
                disableUpload = true //disable upload
                setTimeout(() => {
                    this.uploadEmbededImage({ id, uploadWait })
                }, uploadWait)
            }
        }

        const sql = 'Insert or replace into notes (id,data,ns,sum,fn,mt) VALUES(?,?,?,?,?,?)'
        if (!mt) mt = Date.now()
        let ret = await api.callDB({ dbid, sql, name: "savenote", vars: [id, data, ns, sum, fn, mt] })
        if (ret.code != 0) {
            console.error("saveNote error:", ret)
            return { code: 100, err: ret }
        }
        const meta = await this.getMeta()
        if (meta[id]?.data) delete meta[id].data
        if (!disableUpload) {
            this.uploadNotes({ notes: [{ id, data, mt, ns, fn }], wait: uploadWait })
        }
        if (!sum && data) {
            sum = data.slice(0, SUM_LEN * 3)
            sum = api.htmlToText(sum)
            sum = sum.slice(0, SUM_LEN)
            if (data.length < SUM_LEN && sum.at(-1) != '^') sum += "^^"
        }
        if (ret.code == 0 && updateMeta) {
            this.updateNoteInMeta({ id, data, ns, mt, sum, fn })
        }
        return { code: 0, id, mt, ns, fn, sum }
    }
    async getChildren({ id, filter, useCopy = true, recursive = false }) {
        const meta = await this.getMeta()
        if (!meta) return []
        //if (!meta[id]) return []
        //if (meta[id].ft != 0) return []
        const children = []
        for (const iid in meta) {
            const item = meta[iid]
            if (item.pid === id) {
                const item1 = useCopy ? this.copyObj(item) : item
                if (filter && filter.sum === 0) delete item1.sum
                children.push(item1)
                if (recursive && item1.ft === 0) {
                    const childs = await this.getChildren({ id: item1.id, filter, useCopy, recursive })
                    if (childs.length > 0) {
                        children.push(...childs)
                    }
                }
            }
        }
        return children
    }
    is_Init() {
        console.log("is_Init:", this.isInit)
        return this.isInit ? { code: 1, msg: "initing", process: this.initProcess } : { code: 0, process: this.initProcess }
    }
    //强制导入

    async forceImportFromOld() {
        const { pl, mxsync, api } = this.gl
        let UserName = ""
        const { user_id } = await api.userInfo()
        const config = await api.callBrowser({ cmd: "getConfig" })
        if (config) {
            this.isInit = true
            UserName = config.UserName
            const { noteDataUrl, noteMetaUrl } = config.urls
            const forceFlag = Date.now() > oldServerRunning ? "?force=true" : ""
            const oldmeta = await this.readOldMeta({ UserName, noteMetaUrl, force: forceFlag })
            if (!oldmeta || oldmeta.isDefault) {
                await mxsync.downloadData({ names: ['notem'], uid: user_id, forceMig: true })
            } else {
                await this.importLocalNotes({ force: true })
            }
            this.isInit = false
        }
    }
    //读取笔记
    async readNotes({ ids, download = true }) {
        this.gl.api.debug("readNotes", ids)
        try {
            const { dbid } = this
            const { api } = this.gl
            const sql = `SELECT * FROM notes WHERE id IN (${ids.join(',')})`
            let ret = await api.callDB({ dbid, sql, vars: [] })
            const items = ret.values || []
            let results = []
            const toDownload = []
            const meta = await this.getMeta()
            for (const id of ids) {
                if (!meta[id]) continue
                const note = this.copyObj(meta[id])
                if (note.sum && note.sum.slice(-2) === '^^')
                    note.data = note.sum.slice(0, -2)

                const item = items.find(item => item.id === id)
                if (item) {
                    if (!note.data || item.data?.length > note.data.length)
                        note.data = item.data
                    note.ns = note?.data?.length || 0
                    if (note.sum && note.data && (note.data.length < note.sum.length - 2)) {
                        console.log("found wrong data, try to fix")
                        note.data = note.sum //shall not happen
                    }
                } else {
                    toDownload.push(id)
                    if (!download) {
                        if (!note.data || note.data?.length < note?.sum?.length - 2) note.data = note.sum
                    }
                }

                results.push(note)
            }
            if (toDownload.length > 0 && download) {
                const { code } = await this.downloadNotes(toDownload) || {}
                if (code === 0) {
                    const ret1 = await this.readNotes({ ids, download: false })
                    return ret1
                }
            }
            ret.result = results
            if (this.gl.pl === 'ios')
                ret.values = results
            return ret
        } catch (e) {
            console.error(e)
            return { code: 100, err: e.message }
        }

    }
    // 获取极简笔记目录
    async getQuicknoteFolderId() {
        this.gl.api.debug("getQuicknoteFolderId")
        const meta = await this.getMeta()
        const user_sel = +(await this.readKV({ key: "quickNoteId" }))
        const def_id = meta[4] ? 4 : 1
        return meta[user_sel] ? user_sel : def_id
    }
    // 设置极简笔记目录
    async setQuicknoteFolderId({ id }) {
        this.gl.api.debug("setQuicknoteFolderId")
        return await this.saveKV({ key: "quickNoteId", value: id })
    }
    // 获取搜索结果
    // findNotes
    // 是否在回收站
    async isInTrash({ id }) {
        this.gl.api.debug("isInTrash")

        const meta = await this.getMeta()
        if (!meta || !meta[id]) return false
        let item = meta[id]
        while (item.pid != -1 && item.pid && item.id !== item.pid) {
            item = meta[item.pid]
            if (!item) return false
        }
        return item.id === 2
    }
    _topNByMt(data, n = 20) {
        // 内部小顶堆实现
        const heap = [];

        const bubbleUp = (i) => {
            while (i > 0) {
                const parent = Math.floor((i - 1) / 2);
                if (heap[parent].mt <= heap[i].mt) break;
                [heap[parent], heap[i]] = [heap[i], heap[parent]];
                i = parent;
            }
        };

        const bubbleDown = (i) => {
            const length = heap.length;
            while (true) {
                let left = 2 * i + 1;
                let right = 2 * i + 2;
                let smallest = i;
                if (left < length && heap[left].mt < heap[smallest].mt) smallest = left;
                if (right < length && heap[right].mt < heap[smallest].mt) smallest = right;
                if (smallest === i) break;
                [heap[i], heap[smallest]] = [heap[smallest], heap[i]];
                i = smallest;
            }
        };

        for (const [key, value] of Object.entries(data)) {
            const entry = { key, ...value };
            if (entry.ft === 0) continue; // 跳过文件夹
            if (entry.pid === 2 || entry.pid === 100) continue; // 跳过回收站和已经标记删除的
            if (heap.length < n) {
                heap.push(entry);
                bubbleUp(heap.length - 1);
            } else if (entry.mt > heap[0].mt) {
                heap[0] = entry;
                bubbleDown(0);
            }
        }

        return heap.sort((a, b) => b.mt - a.mt); // 返回从大到小排序的前 n 项
    }
    // 获取最近添加
    async getEntriesByRecent({ num = 20 } = {}) {
        this.gl.api.debug("getEntriesByRecent")

        const { api } = this.gl
        const meta = await this.getMeta()
        if (!meta) return null
        /*const sql = "select id from notes order by mt DESC limit ?"
        const res = await api.callDB({ dbid: this.dbid, name: "getEntriesByRecent", sql, vars: [num] })
        if (res.code != 0) return res
        const result = []
        for (const item of res.values) {
            if (await this.isInTrash({ id: item.id })) continue
            result.push(meta[item.id])
        }*/
        const result = this._topNByMt(meta, num)
        if (result.length === 0) return { code: 1, err: "no recent entries" }
        return { code: 0, result }
    }
    // 获取我的分享
    async getEntriesByShare() {
        this.gl.api.debug("getEntriesByShare")

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        const result = []
        for (const id in meta) {
            if (meta[id].s) result.push(meta[id])
        }
        return { code: 0, result }
    }
    // 获取我的最爱
    async getEntriesByFavor() {
        this.gl.api.debug("getEntriesByFavor")

        const { api } = this.gl
        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        const result = []
        for (const id in meta) {
            if (meta[id].fav) {
                const itemCopy = this.copyObj(meta[id])
                if (itemCopy.ft === 0) {
                    itemCopy.children = await this.getChildren({ id: itemCopy.id })
                }
                result.push(itemCopy)
            }
        }
        return { code: 0, result }
    }
    // 获取重复项
    async getEntriesByDup() {
        this.gl.api.debug("getEntriesByDup")

        const { api } = this.gl
        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        const result = [], urlCount = {};
        for (const id in meta) {
            const item = meta[id]
            const { url } = item
            if (!url || item.pid === 2 || item.pid === 100) continue
            if (urlCount[url]) {
                urlCount[url].count++;
                urlCount[url].items.push(item)
            } else {
                urlCount[url] = { count: 1, items: [item] }
            }
        }
        // 找出重复的URL
        for (let url in urlCount) {
            if (urlCount[url].count > 1) {
                result.push(urlCount[url]);
            }
        }
        return { code: 0, result }
    }
    copyObj(obj) {
        return obj ? JSON.parse(JSON.stringify(obj)) : {}
    }
    // 获取指定目录下的记录
    async getEntriesByPid({ pid }) {
        this.gl.api.debug("getEntriesByPid")

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        if (!meta[pid]) return { code: 2, err: "no item of: " + pid }
        const result = this.copyObj(meta[pid]), children = []
        for (const id in meta) {
            const item = meta[id]
            if (item.pid === pid) children.push(item)
        }
        result.children = children
        return { code: 0, result }
    }
    // 获取meta
    async getEntryMeta({ id }) {
        this.gl.api.debug("getEntryMeta")

        const { api } = this.gl
        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        return meta[id] ? { code: 0, result: meta[id] } : { code: 1, err: "not found" }
    }
    // 获取子集数量
    async getEntryCount({ id, deep = false }) {
        this.gl.api.debug("getEntryCount")

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        let count = 0
        let ret = { ft: {} }
        for (const key in meta) {
            const { ft, pid, id: idItem } = meta[key]
            if (pid === id) {
                count++
                if (!ret.ft[ft]) ret.ft[ft] = 0
                ret.ft[ft]++
                if (ft === 0 && deep) {
                    const ret1 = await this.getEntryCount({ id: idItem, deep: true })
                    count += ret1.count
                    for (const type in ret1.ft) {
                        if (!ret.ft[type]) ret.ft[type] = 0
                        ret.ft[type] += ret1.ft[type]
                    }
                }
            }

        }
        ret.count = count
        return ret
    }
    //导入书签
    async _importChildBookmark({ pid, children, meta }) {
        for (const item of children) {
            const id = this.genNoteId(meta)
            const node = {
                id, pid, fn: item.name, ct: item.date_added ? +item.date_added : Date.now(), mt: item.date_last_used ? +item.date_last_used : Date.now()
            }
            if (item.url) {
                node.ft = 2, node.url = item.url
            } else node.ft = 0
            meta[node.id] = node
            if (item.children) {
                await this._importChildBookmark({ pid: id, children: item.children, meta })
            }
        }
    }
    async importBookmarks({ bookmarks }) {
        const meta = await this.getMeta()
        try {
            await this.emptyTrash({ ids: [6] })
            meta[6] = {
                fn: bookmarks.name,
                id: 6, pid: 1, ct: Date.now(), mt: Date.now(), ft: 0
            }
            await this._importChildBookmark({ pid: 6, children: bookmarks.children, meta })
            await this.saveMeta({ meta })
            return { code: 0, msg: "success" }
        } catch (e) {
            return { code: 1, msg: e.message, stack: e.stack }
        }
    }
    // 获取路径
    async getEntryPath({ id }) {
        this.gl.api.debug("getEntryPath")

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        let item = meta[id]
        if (!item) return { code: 2, err: "no item found for: " + id }
        const result = []
        result.push(item)
        while (item.pid != -1 && item.pid && item.id !== item.pid) {
            result.push(meta[item.pid])
            item = meta[item.pid]
        }
        return { code: 0, result }
    }
    // 获取路径初始化状态
    getEntryPathInitState() {
        return "true"
    }
    genNoteId(meta) {
        const { api } = this.gl
        let id = api.randomNumber(6)
        while (meta[id]) {
            id = api.randomNumber(8)
        }
        return +id
    }
    // 新建笔记/网址/文件夹
    async addEntry({ ft, pid, fn, id, url, data }) {
        this.gl.api.debug("addEntry")

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        if (!meta[pid]) return { code: 1, err: "pid not found:" + pid }
        const newid = id ? id : this.genNoteId(meta)
        meta[newid] = { ft, pid, fn, url, id: newid, ct: Date.now(), mt: Date.now() }
        if (data?.length > 0)
            await this.saveNote({ ...meta[newid], data, disableUpload: false, updateMeta: false })
        this.saveMeta({ meta })
        return { code: 0, result: meta[newid] }
    }
    // 下载笔记正文
    async downloadNoteContent({ id }) {
        this.gl.api.debug("downloadNoteContent")

        return await this.checkUpdate({ id })
    }
    async getNoteMeta({ id }) {
        this.gl.api.debug("getNoteMeta")

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        const item = meta[id]
        if (!item) return { code: 2, err: "no item found" }
        return item
    }
    // 获取笔记正文
    async getNoteContent({ ids }) {
        this.gl.api.debug("getNoteContent")

        return await this.readNotes({ ids })
    }
    // 保存笔记正文
    //saveNote

    // 修改排序
    async changeSortTag({ id, ot }) {
        this.gl.api.debug("changeSortTag")

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        const item = meta[id]
        if (!item) return { code: 2, err: "no item found" }
        item.ot = ot
        return this.saveMeta({ meta })
    }
    // 分享
    async shareEntry({ ids, type }) {
        this.gl.api.debug("shareEntry")

        //type: 1 分享 type:2 取消分享
        const { api } = this.gl
        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        const cmd = (type === 1 ? "share" : "unshare")
        if (type === 1) {
            await this.checkAndUploadNotes({ ids })
        }
        const { code, result, err } = await this._postData({ path: 'share', body: { cmd, ids } })
        if (result) {
            const { user_id } = await api.userInfo()
            for (const id in result) {
                result[id] = shareBaseUrl + '/?uid=' + user_id + '&sid=' + result[id]
                if (meta[id]) {
                    if (type === 1) meta[id].s = result[id]
                    else delete meta[id].s
                }
            }
        }
        this.saveMeta({ meta })
        return { code, result, err }
    }
    // 最爱
    async favorEntry({ ids, type }) {
        this.gl.api.debug("favorEntry")

        //type: 1 设置最爱 type:2 取消最爱

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        for (const id of ids) {
            meta[id].fav = (type === 1)
            if (type === 2) delete meta[id].fav
        }
        return await this.saveMeta({ meta, upload: true })
    }
    // 修改标题
    async changeEntryTitle({ id, fn }) {
        this.gl.api.debug("changeEntryTitle")

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        const item = meta[id]
        if (!item) return { code: 2, err: "no item found" }
        item.fn = fn
        return await this.saveMeta({ meta })
    }
    // 修改网址
    async changeEntryUrl({ id, url }) {
        this.gl.api.debug("changeEntryUrl")

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        const item = meta[id]
        if (!item) return { code: 2, err: "no item found" }
        item.url = url
        return await this.saveMeta({ meta })

    }
    /*排序
    { type: 0  }, // 创建时间降序（默认）
    { type: 1  }, // 创建时间升序
    { type: 2  }, // 修改时间降序
    { type: 3  }, // 修改时间升序
    { type: 4  }, // 标题降序
    { type: 5  }, // 标题升序
    { type: 20  } // 自定义排序 
    { type: 21  } // 按目录本身ot值排序
    deep:N n级目录
    */
    /*async sortFolder({ id, type = 21, deep = 0, filter, useCopy = false }) {
        this.gl.api.debug("sortFolder")
        if (filter) useCopy = true
        //type 0:
        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        if (!meta[id]) return { code: 1, err: "no item:" + id }
        if (meta[id].ft != 0) return { code: 1, err: "not a folder:" + id }

        const children = await this.getChildren({ id, filter, useCopy })
        let otThis = (type === 21 ? meta[id].ot : type)
        if (meta[id].ot === 20) //自定义规则优先
            otThis = 20
        children.sort((a, b) => {
            if (otThis === 0) return a.ct > b.ct ? -1 : 1
            if (otThis === 1) return a.ct < b.ct ? -1 : 1
            if (otThis === 2) return a.mt > b.mt ? -1 : 1
            if (otThis === 3) return a.mt < b.mt ? -1 : 1
            if (otThis === 4) {
                if (!a.fn) return -1
                if (!b.fn) return 1
                if (a.ft == 0 && b.ft != 0) {
                    return -1
                }
                if (a.ft != 0 && b.ft === 0) {
                    return 1
                }
                return b.fn.localeCompare(a.fn, 'zh-Hans-CN')
                //return a.fn > b.fn ? -1 : 1
            }
            if (otThis === 5) {
                if (!a.fn) return 1
                if (!b.fn) return -1
                if (a.ft == 0 && b.ft != 0) {
                    return -1
                }
                if (a.ft != 0 && b.ft === 0) {
                    return 1
                }
                return a.fn.localeCompare(b.fn, 'zh-Hans-CN')
                //return a.fn < b.fn ? -1 : 1
            }
            if (otThis === 20) return a.eo < b.eo ? -1 : 1
        })
        if (deep) {
            for (let i = 0; i < children.length; i++) {
                const item = children[i]
                if (item.ft === 0) {
                    children[i] = { ...await this.sortFolder({ id: item.id, type, deep: deep - 1, save: false, filter }) }
                }
            }
        }
        const itemRet = { ...meta[id], children }
        if (filter && filter.sum === 0) delete itemRet.sum
        return itemRet
    }*/
    async sortFolder({ id, type = 21, deep = 0, filter, useCopy = false }) {
        this.gl.api.debug("sortFolder");

        const meta = await this.getMeta();
        const folderMeta = meta?.[id];
        if (!folderMeta || folderMeta.ft !== 0) {
            return { code: 1, err: !meta ? "no meta" : (!folderMeta ? "no item:" + id : "not a folder:" + id) };
        }

        const children = await this.getChildren({ id, filter, useCopy: useCopy || !!filter });
        if (!children.length) {
            return { ...folderMeta, children };
        }

        const otThis = folderMeta.ot === 20 ? 20 : (type === 21 ? folderMeta.ot : type);

        const sortFunctions = {
            0: (a, b) => b.ct - a.ct,
            1: (a, b) => a.ct - b.ct,
            2: (a, b) => b.mt - a.mt,
            3: (a, b) => a.mt - b.mt,
            4: (a, b) => this.compareTitles(b, a),
            5: (a, b) => this.compareTitles(a, b),
            20: (a, b) => a.eo - b.eo
        };

        const sortFunction = sortFunctions[otThis] || sortFunctions[0];
        children.sort(sortFunction);

        if (deep > 0) {
            const folderChildren = children.filter(item => item.ft === 0);
            await Promise.all(folderChildren.map(async (item) => {
                const sortedSubfolder = await this.sortFolder({
                    id: item.id,
                    type,
                    deep: deep - 1,
                    filter,
                    useCopy: false  // 避免不必要的复制
                });
                Object.assign(item, sortedSubfolder);
            }));
        }

        const result = { ...folderMeta, children };
        if (filter?.sum === 0) {
            delete result.sum;
        }
        return result;
    }

    compareTitles(a, b) {
        if (a.ft !== b.ft) {
            return a.ft === 0 ? -1 : 1;
        }
        return (a.fn || '').localeCompare(b.fn || '', 'zh-Hans-CN');
    }
    //判断 id1是否是 id2的父目录
    async isParentFolder({ id1, id2 }) {
        if (id1 == id2) return false
        const meta = await this.getMeta()
        if (!meta) return false
        let item = meta[id2]
        if (!item) return false
        while (item.pid != -1 && item.pid && item.id !== item.pid) {
            if (item.pid == id1) return true
            item = meta[item.pid]
        }
        return false
    }
    // 移动记录
    // type:全局排序规则，忽略就取pid当前规则
    async moveEntry({ id, ids, pid, type, eo = -1 }) {
        this.gl.api.debug("moveEntry")

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        if (!ids) {
            ids = []
            ids.push(id)
        }
        // 确认不能父目录移动到子目录下
        for (const iid of ids) {
            const item = meta[iid]
            if (!item) return { code: 2, err: "no item found" + iid }
            if (iid == pid) return { code: 2, err: "can't move to self" }
            if (item.ft != 0) continue //不是目录，不用判断
            if (await this.isParentFolder({ id1: iid, id2: pid })) {
                return { code: 2, err: "can't move to child folder" }
            }
        }
        const items = []
        for (const iid of ids) {
            const item = meta[iid]
            if (!item) return { code: 2, err: "no item found" + iid }
            const itemp = meta[pid]
            if (!itemp) return { code: 2, err: "no item found:" + pid }
            item.pid = pid, item.eo = eo
            items.push(item)
        }
        let ret = null
        type ? type : type = meta[pid].ot

        ret = await this.sortFolder({ id: pid, type, useCopy: false })
        if (eo != -1) {
            type = 20
            const children = ret.children.filter(item => {
                return !items.find(i => i.id === item.id)
            })
            children.splice(eo, 0, ...items)
            eo = 0
            children.forEach(item => item.eo = eo++)
            ret.children = children
        }
        meta[pid].ot = type
        await this.saveMeta({ meta })
        return { code: 0, ...meta[pid], children: ret.children }
    }
    // 删除记录
    async removeEntries({ ids }) {
        this.gl.api.debug("removeEntries")

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        for (const id of ids) {
            const item = meta[id]
            if (!item) continue
            item.lid = item.pid
            item.pid = 2
        }
        await this.saveMeta({ meta })
        return { code: 0 }
    }
    // 获取删除前的原始目录
    async getRecoverFolder({ id }) {
        this.gl.api.debug("getRecoverFolder")

        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        const item = meta[id]
        if (!item) return { code: 2, err: "no item found" }
        return { code: 0, lid: item.lid }
    }
    // 恢复记录
    async recoverEntries({ ids, pidTo, type = 1 }) {
        this.gl.api.debug("recoverEntries")

        //type: 1 默认原路径 2.强制目标路径
        const meta = await this.getMeta()
        if (!meta) return { code: 1, err: "no meta" }
        for (const id of ids) {
            const item = meta[id]
            if (!item) continue
            if (!meta[item.lid]) type = 2
            item.pid = (type === 2 && pidTo) ? pidTo : item.lid
            delete item.lid
        }
        await this.saveMeta({ meta })
        return { code: 0 }
    }
    // 彻底删除记录
    //emptyTrash

    async _postData({ path, body = {} }) {
        const { api, syncAPI, pl } = this.gl
        let err = null
        const { user_id, device, region, region_domain, vip } = await api.userInfo()
        if (!user_id) {
            err = "user not login, skip sync"
            console.error(err)
            return { code: 1, err }
        }
        const isvip = vip && vip.level > 0 && vip.state === 'enabled'
        const mxtoken = await api.getCookie("MXTOKEN")
        api.debug("got mxtoken:", mxtoken)
        if (body) {
            body.from = device
            body.uid = user_id + ''
            body.region = region || region_domain
            body.os = await api.browserInfo().os
            body.mv = await api.browserInfo().version
            body.isv = isvip
            body.pl = pl
        }
        const sBody = JSON.stringify(body)
        const usegzip = sBody.length > 2048
        const packedData = usegzip ? pako.gzip(sBody) : msgpackr.pack(body)
        const url = syncAPI + `/note/` + path
        try {
            const headers = {
                'Content-Type': usegzip ? 'application/json' : 'application/msgpack',
                'mxtoken': mxtoken
            }
            if (usegzip) headers['Content-Encoding'] = 'gzip'
            const ret = await fetch(url, {
                method: "POST",
                headers,
                credentials: 'include',
                body: packedData
            })
            const result = await ret.json()
            return result
        } catch (e) {
            err = e.message
            console.error("_postData:", e.message)
            api.postError("_postData err url:" + syncAPI + `/note/` + path + " err:" + err)
            return { code: 1, err }
        }
        return { code: 1, err }
    }
}