/**
 * An enumeration of common navigation equivalents.
 */


class gfx.ui.NavigationCode
{
	/* CONSTANTS */

	/** A constant representing the navigation direction "up". */
	public static var UP: String = "up";
	/** A constant representing the navigation direction "down". */
	public static var DOWN: String = "down";
	/** A constant representing the navigation direction "left". */
	public static var LEFT: String = "left";
	/** A constant representing the navigation direction "right". */
	public static var RIGHT: String = "right";

	/** A constant representing a "start" navigation direction */
	public static var START: String = "start";
	/** A constant representing the navigation direction "back". */
	public static var BACK: String = "back";

	/** Constants representing the typical gamepad keys. */
	public static var GAMEPAD_A: String  = "enter-gamepad_A";
	public static var GAMEPAD_B: String  = "escape-gamepad_B";
	public static var GAMEPAD_X: String  = "gamepad_X";
	public static var GAMEPAD_Y: String  = "gamepad_Y";
	public static var GAMEPAD_L1: String = "gamepad_L1";
	public static var GAMEPAD_L2: String = "gamepad_L2";
	public static var GAMEPAD_L3: String = "gamepad_L3";
	public static var GAMEPAD_R1: String = "gamepad_R1";
	public static var GAMEPAD_R2: String = "gamepad_R2";
	public static var GAMEPAD_R3: String = "gamepad_R3";
	public static var GAMEPAD_START: String = "start";
	public static var GAMEPAD_BACK: String = "back";

	/** A constant representing the an enter key or equivalent". */
	public static var ENTER: String = "enter-gamepad_A";
	/** A constant representing the navigation direction "escape". */
	public static var ESCAPE: String = "escape-gamepad_B";

	/** A constant representing the navigation direction "end". */
	public static var END: String = "end";
	/** A constant representing the navigation direction "home". */
	public static var HOME: String = "home";

	/** A constant representing the navigation direction "pageDown". */
	public static var PAGE_DOWN: String = "pageDown";
	/** A constant representing the navigation direction "pageUp". */
	public static var PAGE_UP: String = "pageUp";

	/** A constant representing the navigation direction "tab". */
	public static var TAB: String = "tab";
	/** A constant representing the navigation direction "shift-tab". */
	public static var SHIFT_TAB: String = "shifttab"; // Lowercase to match GFx implementation.
}
