#pragma once

#include "RE/B/bhkRefObject.h"

namespace RE
{
	class ahkpWorld;
	class hkpWorld;
	class bhkWorld;

	class bhkSerializable : public bhkRefObject
	{
	public:
		inline static constexpr auto RTTI = RTTI_bhkSerializable;
		inline static constexpr auto Ni_RTTI = NiRTTI_bhkSerializable;
		inline static constexpr auto VTABLE = VTABLE_bhkSerializable;

		~bhkSerializable() override;  // 00

		// override (bhkRefObject)
		const NiRTTI* GetRTTI() const override;                                    // 02
		void          LoadBinary(NiStream& a_stream) override;                     // 18
		void          LinkObject(NiStream& a_stream) override;                     // 19
		bool          RegisterStreamables(NiStream& a_stream) override;            // 1A - { return NiObject::RegisterStreamables(a_stream); }
		void          SaveBinary(NiStream& a_stream) override;                     // 1B
		void          SetReferencedObject(hkReferencedObject* a_object) override;  // 25

		// add
		virtual hkpWorld*  GetWorld1();                     // 27 - { return 0; }
		virtual ahkpWorld* GetWorld2();                     // 28 - { return 0; }
		virtual void       MoveToWorld(bhkWorld* a_world);  // 29
		virtual void       RemoveFromCurrentWorld();        // 2A
		virtual void       Unk_2B(void);                    // 2B
		virtual void       Unk_2C(void);                    // 2C - { return 1; }
		virtual void       Unk_2D(void);                    // 2D
		virtual void       Unk_2E(void) = 0;                // 2E
		virtual void       Unk_2F(void) = 0;                // 2F
		virtual void       Unk_30(void);                    // 30
		virtual void       Unk_31(void);                    // 31

		// members
		bhkSerializable* serializable;  // 18
	};
	static_assert(sizeof(bhkSerializable) == 0x20);
}
