#pragma once

#include "RE/B/BSExtraData.h"
#include "RE/B/BSSimpleList.h"
#include "RE/E/ExtraDataTypes.h"

namespace RE
{
	class TESObjectREFR;

	class ExtraLitWaterRefs : public BSExtraData
	{
	public:
		inline static constexpr auto RTTI = RTTI_ExtraLitWaterRefs;
		inline static constexpr auto VTABLE = VTABLE_ExtraLitWaterRefs;
		inline static constexpr auto EXTRADATATYPE = ExtraDataType::kLitWaterRefs;

		~ExtraLitWaterRefs() override;  // 00

		// override (BSExtraData)
		ExtraDataType GetType() const override;                             // 01 - { return kLitWaterRefs; }
		bool          IsNotEqual(const BSExtraData* a_rhs) const override;  // 02 - { return refs != a_rhs->refs; }

		// members
		BSSimpleList<TESObjectREFR*> refs;  // 10
	};
	static_assert(sizeof(ExtraLitWaterRefs) == 0x20);
}
