#pragma once

#include "RE/B/BSExtraData.h"
#include "RE/B/BSSoundHandle.h"
#include "RE/E/ExtraDataTypes.h"

namespace RE
{
	class ExtraWeaponIdleSound : public BSExtraData
	{
	public:
		inline static constexpr auto RTTI = RTTI_ExtraWeaponIdleSound;
		inline static constexpr auto VTABLE = VTABLE_ExtraWeaponIdleSound;
		inline static constexpr auto EXTRADATATYPE = ExtraDataType::kWeaponIdleSound;

		~ExtraWeaponIdleSound() override;  // 00

		// override (BSExtraData)
		[[nodiscard]] ExtraDataType GetType() const override;  // 01 - { return kWeaponIdleSound; }

		// members
		BSSoundHandle handle;  // 10
		std::uint32_t pad1C;   // 1C
	};
	static_assert(sizeof(ExtraWeaponIdleSound) == 0x20);
}
