#pragma once

#include "REX/W32/D3D.h"

namespace REX::W32
{
	struct ID3D11Asynchronous;
	struct ID3D11AuthenticatedChannel;
	struct ID3D11BlendState;
	struct ID3D11Buffer;
	struct ID3D11ClassInstance;
	struct ID3D11ClassLinkage;
	struct ID3D11CommandList;
	struct ID3D11ComputeShader;
	struct ID3D11Counter;
	struct ID3D11CryptoSession;
	struct ID3D11Device;
	struct ID3D11DeviceChild;
	struct ID3D11DeviceContext;
	struct ID3D11DepthStencilState;
	struct ID3D11DepthStencilView;
	struct ID3D11DomainShader;
	struct ID3D11GeometryShader;
	struct ID3D11HullShader;
	struct ID3D11InputLayout;
	struct ID3D11PixelShader;
	struct ID3D11Predicate;
	struct ID3D11Query;
	struct ID3D11RasterizerState;
	struct ID3D11RenderTargetView;
	struct ID3D11Resource;
	struct ID3D11SamplerState;
	struct ID3D11ShaderResourceView;
	struct ID3D11Texture1D;
	struct ID3D11Texture2D;
	struct ID3D11Texture3D;
	struct ID3D11UnorderedAccessView;
	struct ID3D11VertexShader;
	struct ID3D11VideoContext;
	struct ID3D11VideoDecoder;
	struct ID3D11VideoDecoderOutputView;
	struct ID3D11VideoDevice;
	struct ID3D11VideoProcessor;
	struct ID3D11VideoProcessorEnumerator;
	struct ID3D11VideoProcessorInputView;
	struct ID3D11VideoProcessorOutputView;
	struct ID3D11View;
}

namespace REX::W32
{
	inline constexpr auto D3D11_16BIT_INDEX_STRIP_CUT_VALUE{ 0xffff };

	inline constexpr auto D3D11_32BIT_INDEX_STRIP_CUT_VALUE{ 0xffffffff };

	inline constexpr auto D3D11_8BIT_INDEX_STRIP_CUT_VALUE{ 0xff };

	inline constexpr auto D3D11_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT{ 9 };

	inline constexpr auto D3D11_CLIP_OR_CULL_DISTANCE_COUNT{ 8 };
	inline constexpr auto D3D11_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT{ 2 };

	inline constexpr auto D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT{ 14 };
	inline constexpr auto D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT{ 15 };
	inline constexpr auto D3D11_COMMONSHADER_CONSTANT_BUFFER_PARTIAL_UPDATE_EXTENTS_BYTE_ALIGNMENT{ 16 };
	inline constexpr auto D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT{ 15 };
	inline constexpr auto D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST{ 1 };
	inline constexpr auto D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT{ 64 };

	inline constexpr auto D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT{ 1 };
	inline constexpr auto D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST{ 1 };
	inline constexpr auto D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT{ 32 };

	inline constexpr auto D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT{ 128 };
	inline constexpr auto D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST{ 1 };
	inline constexpr auto D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT{ 128 };

	inline constexpr auto D3D11_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_COMMONSHADER_SAMPLER_REGISTER_COUNT{ 16 };
	inline constexpr auto D3D11_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST{ 1 };
	inline constexpr auto D3D11_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT{ 16 };

	inline constexpr auto D3D11_COMMONSHADER_SUBROUTINE_NESTING_LIMIT{ 32 };

	inline constexpr auto D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_COMMONSHADER_TEMP_REGISTER_COUNT{ 4096 };
	inline constexpr auto D3D11_COMMONSHADER_TEMP_REGISTER_READS_PER_INST{ 3 };
	inline constexpr auto D3D11_COMMONSHADER_TEMP_REGISTER_READ_PORTS{ 3 };

	inline constexpr auto D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX{ 10 };
	inline constexpr auto D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN{ -10 };

	inline constexpr auto D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE{ -8 };
	inline constexpr auto D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE{ 7 };

	inline constexpr auto D3D11_CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 256 };
	inline constexpr auto D3D11_CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP{ 64 };

	inline constexpr auto D3D11_CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 240 };
	inline constexpr auto D3D11_CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP{ 68 };

	inline constexpr auto D3D11_CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 224 };
	inline constexpr auto D3D11_CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP{ 72 };

	inline constexpr auto D3D11_CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 208 };
	inline constexpr auto D3D11_CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP{ 76 };

	inline constexpr auto D3D11_CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 192 };
	inline constexpr auto D3D11_CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP{ 84 };

	inline constexpr auto D3D11_CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 176 };
	inline constexpr auto D3D11_CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP{ 92 };

	inline constexpr auto D3D11_CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 160 };
	inline constexpr auto D3D11_CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP{ 100 };

	inline constexpr auto D3D11_CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 144 };
	inline constexpr auto D3D11_CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP{ 112 };

	inline constexpr auto D3D11_CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 128 };
	inline constexpr auto D3D11_CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP{ 128 };

	inline constexpr auto D3D11_CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 112 };
	inline constexpr auto D3D11_CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP{ 144 };

	inline constexpr auto D3D11_CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 96 };
	inline constexpr auto D3D11_CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP{ 168 };

	inline constexpr auto D3D11_CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 80 };
	inline constexpr auto D3D11_CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP{ 204 };

	inline constexpr auto D3D11_CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 64 };
	inline constexpr auto D3D11_CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP{ 256 };

	inline constexpr auto D3D11_CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 48 };
	inline constexpr auto D3D11_CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP{ 340 };

	inline constexpr auto D3D11_CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 32 };
	inline constexpr auto D3D11_CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP{ 512 };

	inline constexpr auto D3D11_CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD{ 16 };
	inline constexpr auto D3D11_CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP{ 768 };

	inline constexpr auto D3D11_CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION{ 1 };

	inline constexpr auto D3D11_CS_4_X_RAW_UAV_BYTE_ALIGNMENT{ 256 };

	inline constexpr auto D3D11_CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP{ 768 };
	inline constexpr auto D3D11_CS_4_X_THREAD_GROUP_MAX_X{ 768 };
	inline constexpr auto D3D11_CS_4_X_THREAD_GROUP_MAX_Y{ 768 };

	inline constexpr auto D3D11_CS_4_X_UAV_REGISTER_COUNT{ 1 };

	inline constexpr auto D3D11_CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION{ 65535 };

	inline constexpr auto D3D11_CS_TGSM_REGISTER_COUNT{ 8192 };
	inline constexpr auto D3D11_CS_TGSM_REGISTER_READS_PER_INST{ 1 };

	inline constexpr auto D3D11_CS_TGSM_RESOURCE_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_CS_TGSM_RESOURCE_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_CS_THREADGROUPID_REGISTER_COMPONENTS{ 3 };
	inline constexpr auto D3D11_CS_THREADGROUPID_REGISTER_COUNT{ 1 };

	inline constexpr auto D3D11_CS_THREADIDINGROUPFLATTENED_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_CS_THREADIDINGROUPFLATTENED_REGISTER_COUNT{ 1 };

	inline constexpr auto D3D11_CS_THREADIDINGROUP_REGISTER_COMPONENTS{ 3 };
	inline constexpr auto D3D11_CS_THREADIDINGROUP_REGISTER_COUNT{ 1 };

	inline constexpr auto D3D11_CS_THREADID_REGISTER_COMPONENTS{ 3 };
	inline constexpr auto D3D11_CS_THREADID_REGISTER_COUNT{ 1 };

	inline constexpr auto D3D11_CS_THREAD_GROUP_MAX_THREADS_PER_GROUP{ 1024 };

	inline constexpr auto D3D11_CS_THREAD_GROUP_MAX_X{ 1024 };
	inline constexpr auto D3D11_CS_THREAD_GROUP_MAX_Y{ 1024 };
	inline constexpr auto D3D11_CS_THREAD_GROUP_MAX_Z{ 64 };
	inline constexpr auto D3D11_CS_THREAD_GROUP_MIN_X{ 1 };
	inline constexpr auto D3D11_CS_THREAD_GROUP_MIN_Y{ 1 };
	inline constexpr auto D3D11_CS_THREAD_GROUP_MIN_Z{ 1 };

	inline constexpr auto D3D11_CS_THREAD_LOCAL_TEMP_REGISTER_POOL{ 16384 };

	inline constexpr auto D3D11_DEFAULT_BLEND_FACTOR_ALPHA{ 1.0f };
	inline constexpr auto D3D11_DEFAULT_BLEND_FACTOR_BLUE{ 1.0f };
	inline constexpr auto D3D11_DEFAULT_BLEND_FACTOR_GREEN{ 1.0f };
	inline constexpr auto D3D11_DEFAULT_BLEND_FACTOR_RED{ 1.0f };

	inline constexpr auto D3D11_DEFAULT_BORDER_COLOR_COMPONENT{ 0.0f };

	inline constexpr auto D3D11_DEFAULT_DEPTH_BIAS{ 0 };
	inline constexpr auto D3D11_DEFAULT_DEPTH_BIAS_CLAMP{ 0.0f };

	inline constexpr auto D3D11_DEFAULT_MAX_ANISOTROPY{ 16 };

	inline constexpr auto D3D11_DEFAULT_MIP_LOD_BIAS{ 0.0f };

	inline constexpr auto D3D11_DEFAULT_RENDER_TARGET_ARRAY_INDEX{ 0 };

	inline constexpr auto D3D11_DEFAULT_SAMPLE_MASK{ 0xffffffff };

	inline constexpr auto D3D11_DEFAULT_SCISSOR_ENDX{ 0 };
	inline constexpr auto D3D11_DEFAULT_SCISSOR_ENDY{ 0 };
	inline constexpr auto D3D11_DEFAULT_SCISSOR_STARTX{ 0 };
	inline constexpr auto D3D11_DEFAULT_SCISSOR_STARTY{ 0 };

	inline constexpr auto D3D11_DEFAULT_SLOPE_SCALED_DEPTH_BIAS{ 0.0f };

	inline constexpr auto D3D11_DEFAULT_STENCIL_READ_MASK{ 0xff };
	inline constexpr auto D3D11_DEFAULT_STENCIL_REFERENCE{ 0 };
	inline constexpr auto D3D11_DEFAULT_STENCIL_WRITE_MASK{ 0xff };

	inline constexpr auto D3D11_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX{ 0 };
	inline constexpr auto D3D11_DEFAULT_VIEWPORT_HEIGHT{ 0 };
	inline constexpr auto D3D11_DEFAULT_VIEWPORT_MAX_DEPTH{ 0.0f };
	inline constexpr auto D3D11_DEFAULT_VIEWPORT_MIN_DEPTH{ 0.0f };
	inline constexpr auto D3D11_DEFAULT_VIEWPORT_TOPLEFTX{ 0 };
	inline constexpr auto D3D11_DEFAULT_VIEWPORT_TOPLEFTY{ 0 };
	inline constexpr auto D3D11_DEFAULT_VIEWPORT_WIDTH{ 0 };

	inline constexpr auto D3D11_DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS{ 3968 };

	inline constexpr auto D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COUNT{ 32 };
	inline constexpr auto D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS{ 3 };
	inline constexpr auto D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COUNT{ 1 };
	inline constexpr auto D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT{ 32 };
	inline constexpr auto D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_COUNT{ 1 };
	inline constexpr auto D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_DS_OUTPUT_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_DS_OUTPUT_REGISTER_COUNT{ 32 };

	inline constexpr auto D3D11_FLOAT16_FUSED_TOLERANCE_IN_ULP{ 0.6 };

	inline constexpr auto D3D11_FLOAT32_MAX{ 3.402823466e+38f };
	inline constexpr auto D3D11_FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP{ 0.6f };

	inline constexpr auto D3D11_FLOAT_TO_SRGB_EXPONENT_DENOMINATOR{ 2.4f };
	inline constexpr auto D3D11_FLOAT_TO_SRGB_EXPONENT_NUMERATOR{ 1.0f };
	inline constexpr auto D3D11_FLOAT_TO_SRGB_OFFSET{ 0.055f };
	inline constexpr auto D3D11_FLOAT_TO_SRGB_SCALE_1{ 12.92f };
	inline constexpr auto D3D11_FLOAT_TO_SRGB_SCALE_2{ 1.055f };
	inline constexpr auto D3D11_FLOAT_TO_SRGB_THRESHOLD{ 0.0031308f };

	inline constexpr auto D3D11_FTOI_INSTRUCTION_MAX_INPUT{ 2147483647.999f };
	inline constexpr auto D3D11_FTOI_INSTRUCTION_MIN_INPUT{ -2147483648.999f };

	inline constexpr auto D3D11_FTOU_INSTRUCTION_MAX_INPUT{ 4294967295.999f };
	inline constexpr auto D3D11_FTOU_INSTRUCTION_MIN_INPUT{ 0.0f };

	inline constexpr auto D3D11_GS_INPUT_INSTANCE_ID_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_GS_INPUT_INSTANCE_ID_READ_PORTS{ 1 };

	inline constexpr auto D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COUNT{ 1 };

	inline constexpr auto D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_GS_INPUT_PRIM_CONST_REGISTER_COUNT{ 1 };
	inline constexpr auto D3D11_GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_GS_INPUT_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_GS_INPUT_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_GS_INPUT_REGISTER_COUNT{ 32 };
	inline constexpr auto D3D11_GS_INPUT_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_GS_INPUT_REGISTER_READ_PORTS{ 1 };
	inline constexpr auto D3D11_GS_INPUT_REGISTER_VERTICES{ 32 };

	inline constexpr auto D3D11_GS_MAX_INSTANCE_COUNT{ 32 };

	inline constexpr auto D3D11_GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES{ 1024 };

	inline constexpr auto D3D11_GS_OUTPUT_ELEMENTS{ 32 };

	inline constexpr auto D3D11_GS_OUTPUT_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_GS_OUTPUT_REGISTER_COUNT{ 32 };

	inline constexpr auto D3D11_HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT{ 32 };
	inline constexpr auto D3D11_HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT{ 32 };

	inline constexpr auto D3D11_HS_CONTROL_POINT_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_HS_CONTROL_POINT_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_HS_CONTROL_POINT_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND{ 0xffffffff };

	inline constexpr auto D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT{ 1 };
	inline constexpr auto D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS{ 1 };
	inline constexpr auto D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT{ 1 };
	inline constexpr auto D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT{ 1 };
	inline constexpr auto D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND{ 0xffffffff };

	inline constexpr auto D3D11_HS_MAXTESSFACTOR_LOWER_BOUND{ 1.0f };
	inline constexpr auto D3D11_HS_MAXTESSFACTOR_UPPER_BOUND{ 64.0f };
	inline constexpr auto D3D11_HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS{ 3968 };

	inline constexpr auto D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT{ 1 };
	inline constexpr auto D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT{ 32 };
	inline constexpr auto D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS{ 1 };
	inline constexpr auto D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_SCALAR_COMPONENTS{ 128 };

	inline constexpr auto D3D11_IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES{ 0 };

	inline constexpr auto D3D11_IA_DEFAULT_PRIMITIVE_TOPOLOGY{ 0 };

	inline constexpr auto D3D11_IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES{ 0 };

	inline constexpr auto D3D11_IA_INDEX_INPUT_RESOURCE_SLOT_COUNT{ 1 };

	inline constexpr auto D3D11_IA_INSTANCE_ID_BIT_COUNT{ 32 };

	inline constexpr auto D3D11_IA_INTEGER_ARITHMETIC_BIT_COUNT{ 32 };

	inline constexpr auto D3D11_IA_PATCH_MAX_CONTROL_POINT_COUNT{ 32 };

	inline constexpr auto D3D11_IA_PRIMITIVE_ID_BIT_COUNT{ 32 };

	inline constexpr auto D3D11_IA_VERTEX_ID_BIT_COUNT{ 32 };

	inline constexpr auto D3D11_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT{ 32 };

	inline constexpr auto D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS{ 128 };
	inline constexpr auto D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT{ 32 };

	inline constexpr auto D3D11_INTEGER_DIVIDE_BY_ZERO_QUOTIENT{ 0xffffffff };
	inline constexpr auto D3D11_INTEGER_DIVIDE_BY_ZERO_REMAINDER{ 0xffffffff };

	inline constexpr auto D3D11_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL{ 0xffffffff };

	inline constexpr auto D3D11_KEEP_UNORDERED_ACCESS_VIEWS{ 0xffffffff };

	inline constexpr auto D3D11_LINEAR_GAMMA{ 1.0f };

	inline constexpr auto D3D11_MAJOR_VERSION{ 11 };

	inline constexpr auto D3D11_MAX_BORDER_COLOR_COMPONENT{ 1.0f };
	inline constexpr auto D3D11_MAX_DEPTH{ 1.0f };
	inline constexpr auto D3D11_MAX_MAXANISOTROPY{ 16 };
	inline constexpr auto D3D11_MAX_MULTISAMPLE_SAMPLE_COUNT{ 32 };
	inline constexpr auto D3D11_MAX_POSITION_VALUE{ 3.402823466e+34f };
	inline constexpr auto D3D11_MAX_TEXTURE_DIMENSION_2_TO_EXP{ 17 };

	inline constexpr auto D3D11_MINOR_VERSION{ 0 };

	inline constexpr auto D3D11_MIN_BORDER_COLOR_COMPONENT{ 0.0f };
	inline constexpr auto D3D11_MIN_DEPTH{ 0.0f };
	inline constexpr auto D3D11_MIN_MAXANISOTROPY{ 0 };

	inline constexpr auto D3D11_MIP_LOD_BIAS_MAX{ 15.99f };
	inline constexpr auto D3D11_MIP_LOD_BIAS_MIN{ -16.0f };
	inline constexpr auto D3D11_MIP_LOD_FRACTIONAL_BIT_COUNT{ 8 };

	inline constexpr auto D3D11_MIP_LOD_RANGE_BIT_COUNT{ 8 };

	inline constexpr auto D3D11_MULTISAMPLE_ANTIALIAS_LINE_WIDTH{ 1.4f };
	inline constexpr auto D3D11_NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT{ 0 };

	inline constexpr auto D3D11_PIXEL_ADDRESS_RANGE_BIT_COUNT{ 15 };

	inline constexpr auto D3D11_PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT{ 16 };

	inline constexpr auto D3D11_PS_CS_UAV_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_PS_CS_UAV_REGISTER_COUNT{ 8 };
	inline constexpr auto D3D11_PS_CS_UAV_REGISTER_READS_PER_INST{ 1 };
	inline constexpr auto D3D11_PS_CS_UAV_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_PS_FRONTFACING_DEFAULT_VALUE{ 0xffffffff };
	inline constexpr auto D3D11_PS_FRONTFACING_FALSE_VALUE{ 0 };
	inline constexpr auto D3D11_PS_FRONTFACING_TRUE_VALUE{ 0xffffffff };

	inline constexpr auto D3D11_PS_INPUT_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_PS_INPUT_REGISTER_COUNT{ 32 };
	inline constexpr auto D3D11_PS_INPUT_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_PS_INPUT_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT{ 0.0f };

	inline constexpr auto D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_PS_OUTPUT_DEPTH_REGISTER_COUNT{ 1 };
	inline constexpr auto D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENTS{ 1 };
	inline constexpr auto D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_PS_OUTPUT_MASK_REGISTER_COUNT{ 1 };
	inline constexpr auto D3D11_PS_OUTPUT_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_PS_OUTPUT_REGISTER_COUNT{ 8 };

	inline constexpr auto D3D11_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT{ 0.5f };
	inline constexpr auto D3D11_RAW_UAV_SRV_BYTE_ALIGNMENT{ 16 };

	inline constexpr auto D3D11_REQ_BLEND_OBJECT_COUNT_PER_DEVICE{ 4096 };

	inline constexpr auto D3D11_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP{ 27 };

	inline constexpr auto D3D11_REQ_CONSTANT_BUFFER_ELEMENT_COUNT{ 4096 };

	inline constexpr auto D3D11_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE{ 4096 };

	inline constexpr auto D3D11_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP{ 32 };

	inline constexpr auto D3D11_REQ_DRAW_VERTEX_COUNT_2_TO_EXP{ 32 };

	inline constexpr auto D3D11_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION{ 16384 };

	inline constexpr auto D3D11_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT{ 1024 };

	inline constexpr auto D3D11_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT{ 4096 };

	inline constexpr auto D3D11_REQ_MAXANISOTROPY{ 16 };

	inline constexpr auto D3D11_REQ_MIP_LEVELS{ 15 };

	inline constexpr auto D3D11_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES{ 2048 };

	inline constexpr auto D3D11_REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE{ 4096 };

	inline constexpr auto D3D11_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH{ 16384 };

	inline constexpr auto D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM{ 128 };
	inline constexpr auto D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM{ 0.25f };
	inline constexpr auto D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_C_TERM{ 2048 };

	inline constexpr auto D3D11_REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP{ 20 };

	inline constexpr auto D3D11_REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE{ 4096 };

	inline constexpr auto D3D11_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION{ 2048 };
	inline constexpr auto D3D11_REQ_TEXTURE1D_U_DIMENSION{ 16384 };
	inline constexpr auto D3D11_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION{ 2048 };
	inline constexpr auto D3D11_REQ_TEXTURE2D_U_OR_V_DIMENSION{ 16384 };
	inline constexpr auto D3D11_REQ_TEXTURE3D_U_V_OR_W_DIMENSION{ 2048 };

	inline constexpr auto D3D11_REQ_TEXTURECUBE_DIMENSION{ 16384 };

	inline constexpr auto D3D11_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL{ 0 };

	inline constexpr auto D3D11_SHADER_MAJOR_VERSION{ 5 };

	inline constexpr auto D3D11_SHADER_MAX_INSTANCES{ 65535 };
	inline constexpr auto D3D11_SHADER_MAX_INTERFACES{ 253 };
	inline constexpr auto D3D11_SHADER_MAX_INTERFACE_CALL_SITES{ 4096 };
	inline constexpr auto D3D11_SHADER_MAX_TYPES{ 65535 };

	inline constexpr auto D3D11_SHADER_MINOR_VERSION{ 0 };

	inline constexpr auto D3D11_SHIFT_INSTRUCTION_PAD_VALUE{ 0 };
	inline constexpr auto D3D11_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT{ 5 };

	inline constexpr auto D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT{ 8 };

	inline constexpr auto D3D11_SO_BUFFER_MAX_STRIDE_IN_BYTES{ 2048 };
	inline constexpr auto D3D11_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES{ 512 };
	inline constexpr auto D3D11_SO_BUFFER_SLOT_COUNT{ 4 };
	inline constexpr auto D3D11_SO_DDI_REGISTER_INDEX_DENOTING_GAP{ 0xffffffff };
	inline constexpr auto D3D11_SO_NO_RASTERIZED_STREAM{ 0xffffffff };
	inline constexpr auto D3D11_SO_OUTPUT_COMPONENT_COUNT{ 128 };
	inline constexpr auto D3D11_SO_STREAM_COUNT{ 4 };

	inline constexpr auto D3D11_SPEC_DATE_DAY{ 16 };
	inline constexpr auto D3D11_SPEC_DATE_MONTH{ 05 };
	inline constexpr auto D3D11_SPEC_DATE_YEAR{ 2011 };
	inline constexpr auto D3D11_SPEC_VERSION{ 1.07 };

	inline constexpr auto D3D11_SRGB_GAMMA{ 2.2f };
	inline constexpr auto D3D11_SRGB_TO_FLOAT_DENOMINATOR_1{ 12.92f };
	inline constexpr auto D3D11_SRGB_TO_FLOAT_DENOMINATOR_2{ 1.055f };
	inline constexpr auto D3D11_SRGB_TO_FLOAT_EXPONENT{ 2.4f };
	inline constexpr auto D3D11_SRGB_TO_FLOAT_OFFSET{ 0.055f };
	inline constexpr auto D3D11_SRGB_TO_FLOAT_THRESHOLD{ 0.04045f };
	inline constexpr auto D3D11_SRGB_TO_FLOAT_TOLERANCE_IN_ULP{ 0.5f };

	inline constexpr auto D3D11_STANDARD_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_STANDARD_COMPONENT_BIT_COUNT_DOUBLED{ 64 };
	inline constexpr auto D3D11_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE{ 4 };
	inline constexpr auto D3D11_STANDARD_PIXEL_COMPONENT_COUNT{ 128 };
	inline constexpr auto D3D11_STANDARD_PIXEL_ELEMENT_COUNT{ 32 };
	inline constexpr auto D3D11_STANDARD_VECTOR_SIZE{ 4 };
	inline constexpr auto D3D11_STANDARD_VERTEX_ELEMENT_COUNT{ 32 };
	inline constexpr auto D3D11_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT{ 64 };

	inline constexpr auto D3D11_SUBPIXEL_FRACTIONAL_BIT_COUNT{ 8 };
	inline constexpr auto D3D11_SUBTEXEL_FRACTIONAL_BIT_COUNT{ 8 };

	inline constexpr auto D3D11_TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR{ 64 };
	inline constexpr auto D3D11_TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR{ 64 };
	inline constexpr auto D3D11_TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR{ 63 };
	inline constexpr auto D3D11_TESSELLATOR_MAX_TESSELLATION_FACTOR{ 64 };
	inline constexpr auto D3D11_TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR{ 2 };
	inline constexpr auto D3D11_TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR{ 1 };
	inline constexpr auto D3D11_TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR{ 1 };

	inline constexpr auto D3D11_TEXEL_ADDRESS_RANGE_BIT_COUNT{ 16 };

	inline constexpr auto D3D11_UNBOUND_MEMORY_ACCESS_RESULT{ 0 };

	inline constexpr auto D3D11_VIEWPORT_AND_SCISSORRECT_MAX_INDEX{ 15 };
	inline constexpr auto D3D11_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE{ 16 };

	inline constexpr auto D3D11_VIEWPORT_BOUNDS_MAX{ 32767 };
	inline constexpr auto D3D11_VIEWPORT_BOUNDS_MIN{ -32768 };

	inline constexpr auto D3D11_VS_INPUT_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_VS_INPUT_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_VS_INPUT_REGISTER_COUNT{ 32 };
	inline constexpr auto D3D11_VS_INPUT_REGISTER_READS_PER_INST{ 2 };
	inline constexpr auto D3D11_VS_INPUT_REGISTER_READ_PORTS{ 1 };

	inline constexpr auto D3D11_VS_OUTPUT_REGISTER_COMPONENTS{ 4 };
	inline constexpr auto D3D11_VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT{ 32 };
	inline constexpr auto D3D11_VS_OUTPUT_REGISTER_COUNT{ 32 };

	inline constexpr auto D3D11_WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT{ 10 };
	inline constexpr auto D3D11_WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP{ 25 };
	inline constexpr auto D3D11_WHQL_DRAW_VERTEX_COUNT_2_TO_EXP{ 25 };
}

namespace REX::W32
{
	enum D3D11_ASYNC_GETDATA_FLAG
	{
		D3D11_ASYNC_GETDATA_DONOTFLUSH = 0x1,
	};

	enum D3D11_AUTHENTICATED_CHANNEL_TYPE
	{
		D3D11_AUTHENTICATED_CHANNEL_D3D11 = 1,
		D3D11_AUTHENTICATED_CHANNEL_DRIVER_SOFTWARE = 2,
		D3D11_AUTHENTICATED_CHANNEL_DRIVER_HARDWARE = 3,
	};

	enum D3D11_BIND_FLAG
	{
		D3D11_BIND_VERTEX_BUFFER = 0x1L,
		D3D11_BIND_INDEX_BUFFER = 0x2L,
		D3D11_BIND_CONSTANT_BUFFER = 0x4L,
		D3D11_BIND_SHADER_RESOURCE = 0x8L,
		D3D11_BIND_STREAM_OUTPUT = 0x10L,
		D3D11_BIND_RENDER_TARGET = 0x20L,
		D3D11_BIND_DEPTH_STENCIL = 0x40L,
		D3D11_BIND_UNORDERED_ACCESS = 0x80L,
		D3D11_BIND_DECODER = 0x200L,
		D3D11_BIND_VIDEO_ENCODER = 0x400L,
	};

	enum D3D11_BLEND
	{
		D3D11_BLEND_ZERO = 1,
		D3D11_BLEND_ONE = 2,
		D3D11_BLEND_SRC_COLOR = 3,
		D3D11_BLEND_INV_SRC_COLOR = 4,
		D3D11_BLEND_SRC_ALPHA = 5,
		D3D11_BLEND_INV_SRC_ALPHA = 6,
		D3D11_BLEND_DEST_ALPHA = 7,
		D3D11_BLEND_INV_DEST_ALPHA = 8,
		D3D11_BLEND_DEST_COLOR = 9,
		D3D11_BLEND_INV_DEST_COLOR = 10,
		D3D11_BLEND_SRC_ALPHA_SAT = 11,
		D3D11_BLEND_BLEND_FACTOR = 14,
		D3D11_BLEND_INV_BLEND_FACTOR = 15,
		D3D11_BLEND_SRC1_COLOR = 16,
		D3D11_BLEND_INV_SRC1_COLOR = 17,
		D3D11_BLEND_SRC1_ALPHA = 18,
		D3D11_BLEND_INV_SRC1_ALPHA = 19,
	};

	enum D3D11_BLEND_OP
	{
		D3D11_BLEND_OP_ADD = 1,
		D3D11_BLEND_OP_SUBTRACT = 2,
		D3D11_BLEND_OP_REV_SUBTRACT = 3,
		D3D11_BLEND_OP_MIN = 4,
		D3D11_BLEND_OP_MAX = 5,
	};

	enum D3D11_BUFFER_UAV_FLAG
	{
		D3D11_BUFFER_UAV_FLAG_RAW = 0x1,
		D3D11_BUFFER_UAV_FLAG_APPEND = 0x2,
		D3D11_BUFFER_UAV_FLAG_COUNTER = 0x4,
	};

	enum D3D11_BUFFEREX_SRV_FLAG
	{
		D3D11_BUFFEREX_SRV_FLAG_RAW = 0x1,
	};

	enum D3D11_CLEAR_FLAG
	{
		D3D11_CLEAR_DEPTH = 0x1L,
		D3D11_CLEAR_STENCIL = 0x2L,
	};

	enum D3D11_COLOR_WRITE_ENABLE
	{
		D3D11_COLOR_WRITE_ENABLE_RED = 1,
		D3D11_COLOR_WRITE_ENABLE_GREEN = 2,
		D3D11_COLOR_WRITE_ENABLE_BLUE = 4,
		D3D11_COLOR_WRITE_ENABLE_ALPHA = 8,
		D3D11_COLOR_WRITE_ENABLE_ALL = (((D3D11_COLOR_WRITE_ENABLE_RED | D3D11_COLOR_WRITE_ENABLE_GREEN) | D3D11_COLOR_WRITE_ENABLE_BLUE) | D3D11_COLOR_WRITE_ENABLE_ALPHA),
	};

	enum D3D11_COMPARISON_FUNC
	{
		D3D11_COMPARISON_NEVER = 1,
		D3D11_COMPARISON_LESS = 2,
		D3D11_COMPARISON_EQUAL = 3,
		D3D11_COMPARISON_LESS_EQUAL = 4,
		D3D11_COMPARISON_GREATER = 5,
		D3D11_COMPARISON_NOT_EQUAL = 6,
		D3D11_COMPARISON_GREATER_EQUAL = 7,
		D3D11_COMPARISON_ALWAYS = 8,
	};

	enum D3D11_CONTENT_PROTECTION_CAPS
	{
		D3D11_CONTENT_PROTECTION_CAPS_SOFTWARE = 0x1,
		D3D11_CONTENT_PROTECTION_CAPS_HARDWARE = 0x2,
		D3D11_CONTENT_PROTECTION_CAPS_PROTECTION_ALWAYS_ON = 0x4,
		D3D11_CONTENT_PROTECTION_CAPS_PARTIAL_DECRYPTION = 0x8,
		D3D11_CONTENT_PROTECTION_CAPS_CONTENT_KEY = 0x10,
		D3D11_CONTENT_PROTECTION_CAPS_FRESHEN_SESSION_KEY = 0x20,
		D3D11_CONTENT_PROTECTION_CAPS_ENCRYPTED_READ_BACK = 0x40,
		D3D11_CONTENT_PROTECTION_CAPS_ENCRYPTED_READ_BACK_KEY = 0x80,
		D3D11_CONTENT_PROTECTION_CAPS_SEQUENTIAL_CTR_IV = 0x100,
		D3D11_CONTENT_PROTECTION_CAPS_ENCRYPT_SLICEDATA_ONLY = 0x200,
		D3D11_CONTENT_PROTECTION_CAPS_DECRYPTION_BLT = 0x400,
		D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_PROTECT_UNCOMPRESSED = 0x800,
		D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_PROTECTED_MEMORY_PAGEABLE = 0x1000,
		D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_TEARDOWN = 0x2000,
		D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_DRM_COMMUNICATION = 0x4000,
		D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_DRM_COMMUNICATION_MULTI_THREADED = 0x8000,
	};

	enum D3D11_COUNTER
	{
		D3D11_COUNTER_DEVICE_DEPENDENT_0 = 0x40000000
	};

	enum D3D11_COUNTER_TYPE
	{
		D3D11_COUNTER_TYPE_FLOAT32 = 0,
		D3D11_COUNTER_TYPE_UINT16 = (D3D11_COUNTER_TYPE_FLOAT32 + 1),
		D3D11_COUNTER_TYPE_UINT32 = (D3D11_COUNTER_TYPE_UINT16 + 1),
		D3D11_COUNTER_TYPE_UINT64 = (D3D11_COUNTER_TYPE_UINT32 + 1),
	};

	enum D3D11_CPU_ACCESS_FLAG
	{
		D3D11_CPU_ACCESS_WRITE = 0x10000L,
		D3D11_CPU_ACCESS_READ = 0x20000L,
	};

	enum D3D11_CREATE_DEVICE_FLAG
	{
		D3D11_CREATE_DEVICE_SINGLETHREADED = 0x1,
		D3D11_CREATE_DEVICE_DEBUG = 0x2,
		D3D11_CREATE_DEVICE_SWITCH_TO_REF = 0x4,
		D3D11_CREATE_DEVICE_PREVENT_INTERNAL_THREADING_OPTIMIZATIONS = 0x8,
		D3D11_CREATE_DEVICE_BGRA_SUPPORT = 0x20,
		D3D11_CREATE_DEVICE_DEBUGGABLE = 0x40,
		D3D11_CREATE_DEVICE_PREVENT_ALTERING_LAYER_SETTINGS_FROM_REGISTRY = 0x80,
		D3D11_CREATE_DEVICE_DISABLE_GPU_TIMEOUT = 0x100,
		D3D11_CREATE_DEVICE_VIDEO_SUPPORT = 0x800,
	};

	enum D3D11_CULL_MODE
	{
		D3D11_CULL_NONE = 1,
		D3D11_CULL_FRONT = 2,
		D3D11_CULL_BACK = 3,
	};

	enum D3D11_DEPTH_WRITE_MASK
	{
		D3D11_DEPTH_WRITE_MASK_ZERO = 0,
		D3D11_DEPTH_WRITE_MASK_ALL = 1,
	};

	enum D3D11_DEVICE_CONTEXT_TYPE
	{
		D3D11_DEVICE_CONTEXT_IMMEDIATE = 0,
		D3D11_DEVICE_CONTEXT_DEFERRED = (D3D11_DEVICE_CONTEXT_IMMEDIATE + 1),
	};

	enum D3D11_DSV_DIMENSION
	{
		D3D11_DSV_DIMENSION_UNKNOWN = 0,
		D3D11_DSV_DIMENSION_TEXTURE1D = 1,
		D3D11_DSV_DIMENSION_TEXTURE1DARRAY = 2,
		D3D11_DSV_DIMENSION_TEXTURE2D = 3,
		D3D11_DSV_DIMENSION_TEXTURE2DARRAY = 4,
		D3D11_DSV_DIMENSION_TEXTURE2DMS = 5,
		D3D11_DSV_DIMENSION_TEXTURE2DMSARRAY = 6,
	};

	enum D3D11_DSV_FLAG
	{
		D3D11_DSV_READ_ONLY_DEPTH = 0x1L,
		D3D11_DSV_READ_ONLY_STENCIL = 0x2L,
	};

	enum D3D11_FEATURE
	{
		D3D11_FEATURE_THREADING = 0,
		D3D11_FEATURE_DOUBLES = (D3D11_FEATURE_THREADING + 1),
		D3D11_FEATURE_FORMAT_SUPPORT = (D3D11_FEATURE_DOUBLES + 1),
		D3D11_FEATURE_FORMAT_SUPPORT2 = (D3D11_FEATURE_FORMAT_SUPPORT + 1),
		D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS = (D3D11_FEATURE_FORMAT_SUPPORT2 + 1),
		D3D11_FEATURE_D3D11_OPTIONS = (D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS + 1),
		D3D11_FEATURE_ARCHITECTURE_INFO = (D3D11_FEATURE_D3D11_OPTIONS + 1),
		D3D11_FEATURE_D3D9_OPTIONS = (D3D11_FEATURE_ARCHITECTURE_INFO + 1),
		D3D11_FEATURE_SHADER_MIN_PRECISION_SUPPORT = (D3D11_FEATURE_D3D9_OPTIONS + 1),
		D3D11_FEATURE_D3D9_SHADOW_SUPPORT = (D3D11_FEATURE_SHADER_MIN_PRECISION_SUPPORT + 1),
		D3D11_FEATURE_D3D11_OPTIONS1 = (D3D11_FEATURE_D3D9_SHADOW_SUPPORT + 1),
		D3D11_FEATURE_D3D9_SIMPLE_INSTANCING_SUPPORT = (D3D11_FEATURE_D3D11_OPTIONS1 + 1),
		D3D11_FEATURE_MARKER_SUPPORT = (D3D11_FEATURE_D3D9_SIMPLE_INSTANCING_SUPPORT + 1),
		D3D11_FEATURE_D3D9_OPTIONS1 = (D3D11_FEATURE_MARKER_SUPPORT + 1),
		D3D11_FEATURE_D3D11_OPTIONS2 = (D3D11_FEATURE_D3D9_OPTIONS1 + 1),
		D3D11_FEATURE_D3D11_OPTIONS3 = (D3D11_FEATURE_D3D11_OPTIONS2 + 1),
		D3D11_FEATURE_GPU_VIRTUAL_ADDRESS_SUPPORT = (D3D11_FEATURE_D3D11_OPTIONS3 + 1),
		D3D11_FEATURE_D3D11_OPTIONS4 = (D3D11_FEATURE_GPU_VIRTUAL_ADDRESS_SUPPORT + 1),
		D3D11_FEATURE_SHADER_CACHE = (D3D11_FEATURE_D3D11_OPTIONS4 + 1),
		D3D11_FEATURE_D3D11_OPTIONS5 = (D3D11_FEATURE_SHADER_CACHE + 1),
		D3D11_FEATURE_DISPLAYABLE = (D3D11_FEATURE_D3D11_OPTIONS5 + 1),
	};

	enum D3D11_FILL_MODE
	{
		D3D11_FILL_WIREFRAME = 2,
		D3D11_FILL_SOLID = 3,
	};

	enum D3D11_FILTER
	{
		D3D11_FILTER_MIN_MAG_MIP_POINT = 0,
		D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR = 0x1,
		D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x4,
		D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR = 0x5,
		D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT = 0x10,
		D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x11,
		D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT = 0x14,
		D3D11_FILTER_MIN_MAG_MIP_LINEAR = 0x15,
		D3D11_FILTER_ANISOTROPIC = 0x55,
		D3D11_FILTER_COMPARISON_MIN_MAG_MIP_POINT = 0x80,
		D3D11_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR = 0x81,
		D3D11_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x84,
		D3D11_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR = 0x85,
		D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT = 0x90,
		D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x91,
		D3D11_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT = 0x94,
		D3D11_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR = 0x95,
		D3D11_FILTER_COMPARISON_ANISOTROPIC = 0xd5,
		D3D11_FILTER_MINIMUM_MIN_MAG_MIP_POINT = 0x100,
		D3D11_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR = 0x101,
		D3D11_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x104,
		D3D11_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR = 0x105,
		D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT = 0x110,
		D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x111,
		D3D11_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT = 0x114,
		D3D11_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR = 0x115,
		D3D11_FILTER_MINIMUM_ANISOTROPIC = 0x155,
		D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_POINT = 0x180,
		D3D11_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR = 0x181,
		D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x184,
		D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR = 0x185,
		D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT = 0x190,
		D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x191,
		D3D11_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT = 0x194,
		D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR = 0x195,
		D3D11_FILTER_MAXIMUM_ANISOTROPIC = 0x1d5,
	};

	enum D3D11_FILTER_TYPE
	{
		D3D11_FILTER_TYPE_POINT = 0,
		D3D11_FILTER_TYPE_LINEAR = 1,
	};

	enum D3D11_FILTER_REDUCTION_TYPE
	{
		D3D11_FILTER_REDUCTION_TYPE_STANDARD = 0,
		D3D11_FILTER_REDUCTION_TYPE_COMPARISON = 1,
		D3D11_FILTER_REDUCTION_TYPE_MINIMUM = 2,
		D3D11_FILTER_REDUCTION_TYPE_MAXIMUM = 3,
	};

	enum D3D11_FORMAT_SUPPORT
	{
		D3D11_FORMAT_SUPPORT_BUFFER = 0x1,
		D3D11_FORMAT_SUPPORT_IA_VERTEX_BUFFER = 0x2,
		D3D11_FORMAT_SUPPORT_IA_INDEX_BUFFER = 0x4,
		D3D11_FORMAT_SUPPORT_SO_BUFFER = 0x8,
		D3D11_FORMAT_SUPPORT_TEXTURE1D = 0x10,
		D3D11_FORMAT_SUPPORT_TEXTURE2D = 0x20,
		D3D11_FORMAT_SUPPORT_TEXTURE3D = 0x40,
		D3D11_FORMAT_SUPPORT_TEXTURECUBE = 0x80,
		D3D11_FORMAT_SUPPORT_SHADER_LOAD = 0x100,
		D3D11_FORMAT_SUPPORT_SHADER_SAMPLE = 0x200,
		D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_COMPARISON = 0x400,
		D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_MONO_TEXT = 0x800,
		D3D11_FORMAT_SUPPORT_MIP = 0x1000,
		D3D11_FORMAT_SUPPORT_MIP_AUTOGEN = 0x2000,
		D3D11_FORMAT_SUPPORT_RENDER_TARGET = 0x4000,
		D3D11_FORMAT_SUPPORT_BLENDABLE = 0x8000,
		D3D11_FORMAT_SUPPORT_DEPTH_STENCIL = 0x10000,
		D3D11_FORMAT_SUPPORT_CPU_LOCKABLE = 0x20000,
		D3D11_FORMAT_SUPPORT_MULTISAMPLE_RESOLVE = 0x40000,
		D3D11_FORMAT_SUPPORT_DISPLAY = 0x80000,
		D3D11_FORMAT_SUPPORT_CAST_WITHIN_BIT_LAYOUT = 0x100000,
		D3D11_FORMAT_SUPPORT_MULTISAMPLE_RENDERTARGET = 0x200000,
		D3D11_FORMAT_SUPPORT_MULTISAMPLE_LOAD = 0x400000,
		D3D11_FORMAT_SUPPORT_SHADER_GATHER = 0x800000,
		D3D11_FORMAT_SUPPORT_BACK_BUFFER_CAST = 0x1000000,
		D3D11_FORMAT_SUPPORT_TYPED_UNORDERED_ACCESS_VIEW = 0x2000000,
		D3D11_FORMAT_SUPPORT_SHADER_GATHER_COMPARISON = 0x4000000,
		D3D11_FORMAT_SUPPORT_DECODER_OUTPUT = 0x8000000,
		D3D11_FORMAT_SUPPORT_VIDEO_PROCESSOR_OUTPUT = 0x10000000,
		D3D11_FORMAT_SUPPORT_VIDEO_PROCESSOR_INPUT = 0x20000000,
		D3D11_FORMAT_SUPPORT_VIDEO_ENCODER = 0x40000000,
	};

	enum D3D11_FORMAT_SUPPORT2
	{
		D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_ADD = 0x1,
		D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_BITWISE_OPS = 0x2,
		D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE = 0x4,
		D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_EXCHANGE = 0x8,
		D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_SIGNED_MIN_OR_MAX = 0x10,
		D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_UNSIGNED_MIN_OR_MAX = 0x20,
		D3D11_FORMAT_SUPPORT2_UAV_TYPED_LOAD = 0x40,
		D3D11_FORMAT_SUPPORT2_UAV_TYPED_STORE = 0x80,
		D3D11_FORMAT_SUPPORT2_OUTPUT_MERGER_LOGIC_OP = 0x100,
		D3D11_FORMAT_SUPPORT2_TILED = 0x200,
		D3D11_FORMAT_SUPPORT2_SHAREABLE = 0x400,
		D3D11_FORMAT_SUPPORT2_MULTIPLANE_OVERLAY = 0x4000,
		D3D11_FORMAT_SUPPORT2_DISPLAYABLE = 0x10000,
	};

	enum D3D11_INPUT_CLASSIFICATION
	{
		D3D11_INPUT_PER_VERTEX_DATA = 0,
		D3D11_INPUT_PER_INSTANCE_DATA = 1,
	};

	enum D3D11_MAP
	{
		D3D11_MAP_READ = 1,
		D3D11_MAP_WRITE = 2,
		D3D11_MAP_READ_WRITE = 3,
		D3D11_MAP_WRITE_DISCARD = 4,
		D3D11_MAP_WRITE_NO_OVERWRITE = 5,
	};

	enum D3D11_MAP_FLAG
	{
		D3D11_MAP_FLAG_DO_NOT_WAIT = 0x100000L,
	};

	using D3D11_PRIMITIVE = D3D_PRIMITIVE;
	using D3D11_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY;

	enum D3D11_QUERY
	{
		D3D11_QUERY_EVENT = 0,
		D3D11_QUERY_OCCLUSION = (D3D11_QUERY_EVENT + 1),
		D3D11_QUERY_TIMESTAMP = (D3D11_QUERY_OCCLUSION + 1),
		D3D11_QUERY_TIMESTAMP_DISJOINT = (D3D11_QUERY_TIMESTAMP + 1),
		D3D11_QUERY_PIPELINE_STATISTICS = (D3D11_QUERY_TIMESTAMP_DISJOINT + 1),
		D3D11_QUERY_OCCLUSION_PREDICATE = (D3D11_QUERY_PIPELINE_STATISTICS + 1),
		D3D11_QUERY_SO_STATISTICS = (D3D11_QUERY_OCCLUSION_PREDICATE + 1),
		D3D11_QUERY_SO_OVERFLOW_PREDICATE = (D3D11_QUERY_SO_STATISTICS + 1),
		D3D11_QUERY_SO_STATISTICS_STREAM0 = (D3D11_QUERY_SO_OVERFLOW_PREDICATE + 1),
		D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0 = (D3D11_QUERY_SO_STATISTICS_STREAM0 + 1),
		D3D11_QUERY_SO_STATISTICS_STREAM1 = (D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0 + 1),
		D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1 = (D3D11_QUERY_SO_STATISTICS_STREAM1 + 1),
		D3D11_QUERY_SO_STATISTICS_STREAM2 = (D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1 + 1),
		D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2 = (D3D11_QUERY_SO_STATISTICS_STREAM2 + 1),
		D3D11_QUERY_SO_STATISTICS_STREAM3 = (D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2 + 1),
		D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM3 = (D3D11_QUERY_SO_STATISTICS_STREAM3 + 1),
	};

	enum D3D11_QUERY_MISC_FLAG
	{
		D3D11_QUERY_MISC_PREDICATEHINT = 0x1,
	};

	enum D3D11_RAISE_FLAG
	{
		D3D11_RAISE_FLAG_DRIVER_INTERNAL_ERROR = 0x1L,
	};

	enum D3D11_RESOURCE_DIMENSION
	{
		D3D11_RESOURCE_DIMENSION_UNKNOWN = 0,
		D3D11_RESOURCE_DIMENSION_BUFFER = 1,
		D3D11_RESOURCE_DIMENSION_TEXTURE1D = 2,
		D3D11_RESOURCE_DIMENSION_TEXTURE2D = 3,
		D3D11_RESOURCE_DIMENSION_TEXTURE3D = 4,
	};

	enum D3D11_RESOURCE_MISC_FLAG
	{
		D3D11_RESOURCE_MISC_GENERATE_MIPS = 0x1L,
		D3D11_RESOURCE_MISC_SHARED = 0x2L,
		D3D11_RESOURCE_MISC_TEXTURECUBE = 0x4L,
		D3D11_RESOURCE_MISC_DRAWINDIRECT_ARGS = 0x10L,
		D3D11_RESOURCE_MISC_BUFFER_ALLOW_RAW_VIEWS = 0x20L,
		D3D11_RESOURCE_MISC_BUFFER_STRUCTURED = 0x40L,
		D3D11_RESOURCE_MISC_RESOURCE_CLAMP = 0x80L,
		D3D11_RESOURCE_MISC_SHARED_KEYEDMUTEX = 0x100L,
		D3D11_RESOURCE_MISC_GDI_COMPATIBLE = 0x200L,
		D3D11_RESOURCE_MISC_SHARED_NTHANDLE = 0x800L,
		D3D11_RESOURCE_MISC_RESTRICTED_CONTENT = 0x1000L,
		D3D11_RESOURCE_MISC_RESTRICT_SHARED_RESOURCE = 0x2000L,
		D3D11_RESOURCE_MISC_RESTRICT_SHARED_RESOURCE_DRIVER = 0x4000L,
		D3D11_RESOURCE_MISC_GUARDED = 0x8000L,
		D3D11_RESOURCE_MISC_TILE_POOL = 0x20000L,
		D3D11_RESOURCE_MISC_TILED = 0x40000L,
		D3D11_RESOURCE_MISC_HW_PROTECTED = 0x80000L,
		D3D11_RESOURCE_MISC_SHARED_DISPLAYABLE = 0x100000L,
		D3D11_RESOURCE_MISC_SHARED_EXCLUSIVE_WRITER = 0x200000L,
	};

	enum D3D11_RTV_DIMENSION
	{
		D3D11_RTV_DIMENSION_UNKNOWN = 0,
		D3D11_RTV_DIMENSION_BUFFER = 1,
		D3D11_RTV_DIMENSION_TEXTURE1D = 2,
		D3D11_RTV_DIMENSION_TEXTURE1DARRAY = 3,
		D3D11_RTV_DIMENSION_TEXTURE2D = 4,
		D3D11_RTV_DIMENSION_TEXTURE2DARRAY = 5,
		D3D11_RTV_DIMENSION_TEXTURE2DMS = 6,
		D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY = 7,
		D3D11_RTV_DIMENSION_TEXTURE3D = 8,
	};

	using D3D11_SRV_DIMENSION = D3D_SRV_DIMENSION;

	enum D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS
	{
		D3D11_STANDARD_MULTISAMPLE_PATTERN = 0xFFFFFFFF,
		D3D11_CENTER_MULTISAMPLE_PATTERN = 0xFFFFFFFE,
	};

	enum D3D11_STENCIL_OP
	{
		D3D11_STENCIL_OP_KEEP = 1,
		D3D11_STENCIL_OP_ZERO = 2,
		D3D11_STENCIL_OP_REPLACE = 3,
		D3D11_STENCIL_OP_INCR_SAT = 4,
		D3D11_STENCIL_OP_DECR_SAT = 5,
		D3D11_STENCIL_OP_INVERT = 6,
		D3D11_STENCIL_OP_INCR = 7,
		D3D11_STENCIL_OP_DECR = 8,
	};

	enum D3D11_TEXTURE_ADDRESS_MODE
	{
		D3D11_TEXTURE_ADDRESS_WRAP = 1,
		D3D11_TEXTURE_ADDRESS_MIRROR = 2,
		D3D11_TEXTURE_ADDRESS_CLAMP = 3,
		D3D11_TEXTURE_ADDRESS_BORDER = 4,
		D3D11_TEXTURE_ADDRESS_MIRROR_ONCE = 5,
	};

	enum D3D11_TEXTURECUBE_FACE
	{
		D3D11_TEXTURECUBE_FACE_POSITIVE_X = 0,
		D3D11_TEXTURECUBE_FACE_NEGATIVE_X = 1,
		D3D11_TEXTURECUBE_FACE_POSITIVE_Y = 2,
		D3D11_TEXTURECUBE_FACE_NEGATIVE_Y = 3,
		D3D11_TEXTURECUBE_FACE_POSITIVE_Z = 4,
		D3D11_TEXTURECUBE_FACE_NEGATIVE_Z = 5,
	};

	enum D3D11_UAV_DIMENSION
	{
		D3D11_UAV_DIMENSION_UNKNOWN = 0,
		D3D11_UAV_DIMENSION_BUFFER = 1,
		D3D11_UAV_DIMENSION_TEXTURE1D = 2,
		D3D11_UAV_DIMENSION_TEXTURE1DARRAY = 3,
		D3D11_UAV_DIMENSION_TEXTURE2D = 4,
		D3D11_UAV_DIMENSION_TEXTURE2DARRAY = 5,
		D3D11_UAV_DIMENSION_TEXTURE3D = 8,
	};

	enum D3D11_USAGE
	{
		D3D11_USAGE_DEFAULT = 0,
		D3D11_USAGE_IMMUTABLE = 1,
		D3D11_USAGE_DYNAMIC = 2,
		D3D11_USAGE_STAGING = 3,
	};

	enum D3D11_VDOV_DIMENSION
	{
		D3D11_VDOV_DIMENSION_UNKNOWN = 0,
		D3D11_VDOV_DIMENSION_TEXTURE2D = 1,
	};

	enum D3D11_VPIV_DIMENSION
	{
		D3D11_VPIV_DIMENSION_UNKNOWN = 0,
		D3D11_VPIV_DIMENSION_TEXTURE2D = 1,
	};

	enum D3D11_VPOV_DIMENSION
	{
		D3D11_VPOV_DIMENSION_UNKNOWN = 0,
		D3D11_VPOV_DIMENSION_TEXTURE2D = 1,
		D3D11_VPOV_DIMENSION_TEXTURE2DARRAY = 2,
	};

	enum D3D11_VIDEO_DECODER_BUFFER_TYPE
	{
		D3D11_VIDEO_DECODER_BUFFER_PICTURE_PARAMETERS = 0,
		D3D11_VIDEO_DECODER_BUFFER_MACROBLOCK_CONTROL = 1,
		D3D11_VIDEO_DECODER_BUFFER_RESIDUAL_DIFFERENCE = 2,
		D3D11_VIDEO_DECODER_BUFFER_DEBLOCKING_CONTROL = 3,
		D3D11_VIDEO_DECODER_BUFFER_INVERSE_QUANTIZATION_MATRIX = 4,
		D3D11_VIDEO_DECODER_BUFFER_SLICE_CONTROL = 5,
		D3D11_VIDEO_DECODER_BUFFER_BITSTREAM = 6,
		D3D11_VIDEO_DECODER_BUFFER_MOTION_VECTOR = 7,
		D3D11_VIDEO_DECODER_BUFFER_FILM_GRAIN = 8,
	};

	enum D3D11_VIDEO_FRAME_FORMAT
	{
		D3D11_VIDEO_FRAME_FORMAT_PROGRESSIVE = 0,
		D3D11_VIDEO_FRAME_FORMAT_INTERLACED_TOP_FIELD_FIRST = 1,
		D3D11_VIDEO_FRAME_FORMAT_INTERLACED_BOTTOM_FIELD_FIRST = 2,
	};

	enum D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE
	{
		D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_OPAQUE = 0,
		D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_BACKGROUND = 1,
		D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_DESTINATION = 2,
		D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_SOURCE_STREAM = 3,
	};

	enum D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS
	{
		D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_DENOISE = 0x1,
		D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_DERINGING = 0x2,
		D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_EDGE_ENHANCEMENT = 0x4,
		D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_COLOR_CORRECTION = 0x8,
		D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_FLESH_TONE_MAPPING = 0x10,
		D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_IMAGE_STABILIZATION = 0x20,
		D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_SUPER_RESOLUTION = 0x40,
		D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_ANAMORPHIC_SCALING = 0x80,
	};

	enum D3D11_VIDEO_PROCESSOR_DEVICE_CAPS
	{
		D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_LINEAR_SPACE = 0x1,
		D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_xvYCC = 0x2,
		D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_RGB_RANGE_CONVERSION = 0x4,
		D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_YCbCr_MATRIX_CONVERSION = 0x8,
		D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_NOMINAL_RANGE = 0x10,
	};

	enum D3D11_VIDEO_PROCESSOR_FEATURE_CAPS
	{
		D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_FILL = 0x1,
		D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_CONSTRICTION = 0x2,
		D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_LUMA_KEY = 0x4,
		D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_PALETTE = 0x8,
		D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_LEGACY = 0x10,
		D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_STEREO = 0x20,
		D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ROTATION = 0x40,
		D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_STREAM = 0x80,
		D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_PIXEL_ASPECT_RATIO = 0x100,
		D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_MIRROR = 0x200,
		D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_SHADER_USAGE = 0x400,
		D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_METADATA_HDR10 = 0x800,
	};

	enum D3D11_VIDEO_PROCESSOR_FILTER
	{
		D3D11_VIDEO_PROCESSOR_FILTER_BRIGHTNESS = 0,
		D3D11_VIDEO_PROCESSOR_FILTER_CONTRAST = 1,
		D3D11_VIDEO_PROCESSOR_FILTER_HUE = 2,
		D3D11_VIDEO_PROCESSOR_FILTER_SATURATION = 3,
		D3D11_VIDEO_PROCESSOR_FILTER_NOISE_REDUCTION = 4,
		D3D11_VIDEO_PROCESSOR_FILTER_EDGE_ENHANCEMENT = 5,
		D3D11_VIDEO_PROCESSOR_FILTER_ANAMORPHIC_SCALING = 6,
		D3D11_VIDEO_PROCESSOR_FILTER_STEREO_ADJUSTMENT = 7,
	};

	enum D3D11_VIDEO_PROCESSOR_FILTER_CAPS
	{
		D3D11_VIDEO_PROCESSOR_FILTER_CAPS_BRIGHTNESS = 0x1,
		D3D11_VIDEO_PROCESSOR_FILTER_CAPS_CONTRAST = 0x2,
		D3D11_VIDEO_PROCESSOR_FILTER_CAPS_HUE = 0x4,
		D3D11_VIDEO_PROCESSOR_FILTER_CAPS_SATURATION = 0x8,
		D3D11_VIDEO_PROCESSOR_FILTER_CAPS_NOISE_REDUCTION = 0x10,
		D3D11_VIDEO_PROCESSOR_FILTER_CAPS_EDGE_ENHANCEMENT = 0x20,
		D3D11_VIDEO_PROCESSOR_FILTER_CAPS_ANAMORPHIC_SCALING = 0x40,
		D3D11_VIDEO_PROCESSOR_FILTER_CAPS_STEREO_ADJUSTMENT = 0x80,
	};

	enum D3D11_VIDEO_PROCESSOR_FORMAT_CAPS
	{
		D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_INTERLACED = 0x1,
		D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_PROCAMP = 0x2,
		D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_LUMA_KEY = 0x4,
		D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_PALETTE_INTERLACED = 0x8,
	};

	enum D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT
	{
		D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_INPUT = 0x1,
		D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_OUTPUT = 0x2,
	};

	enum D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS
	{
		D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32 = 0x1,
		D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_22 = 0x2,
		D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2224 = 0x4,
		D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2332 = 0x8,
		D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32322 = 0x10,
		D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_55 = 0x20,
		D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_64 = 0x40,
		D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_87 = 0x80,
		D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_222222222223 = 0x100,
		D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_OTHER = 0x80000000,
	};

	enum D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE
	{
		D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_UNDEFINED = 0,
		D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_16_235 = 1,
		D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_0_255 = 2,
	};

	enum D3D11_VIDEO_PROCESSOR_OUTPUT_RATE
	{
		D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_NORMAL = 0,
		D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_HALF = 1,
		D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_CUSTOM = 2,
	};

	enum D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS
	{
		D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_BLEND = 0x1,
		D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_BOB = 0x2,
		D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_ADAPTIVE = 0x4,
		D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_MOTION_COMPENSATION = 0x8,
		D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_INVERSE_TELECINE = 0x10,
		D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_FRAME_RATE_CONVERSION = 0x20,
	};

	enum D3D11_VIDEO_PROCESSOR_ROTATION
	{
		D3D11_VIDEO_PROCESSOR_ROTATION_IDENTITY = 0,
		D3D11_VIDEO_PROCESSOR_ROTATION_90 = 1,
		D3D11_VIDEO_PROCESSOR_ROTATION_180 = 2,
		D3D11_VIDEO_PROCESSOR_ROTATION_270 = 3,
	};

	enum D3D11_VIDEO_PROCESSOR_STEREO_CAPS
	{
		D3D11_VIDEO_PROCESSOR_STEREO_CAPS_MONO_OFFSET = 0x1,
		D3D11_VIDEO_PROCESSOR_STEREO_CAPS_ROW_INTERLEAVED = 0x2,
		D3D11_VIDEO_PROCESSOR_STEREO_CAPS_COLUMN_INTERLEAVED = 0x4,
		D3D11_VIDEO_PROCESSOR_STEREO_CAPS_CHECKERBOARD = 0x8,
		D3D11_VIDEO_PROCESSOR_STEREO_CAPS_FLIP_MODE = 0x10,
	};

	enum D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE
	{
		D3D11_VIDEO_PROCESSOR_STEREO_FLIP_NONE = 0,
		D3D11_VIDEO_PROCESSOR_STEREO_FLIP_FRAME0 = 1,
		D3D11_VIDEO_PROCESSOR_STEREO_FLIP_FRAME1 = 2,
	};

	enum D3D11_VIDEO_PROCESSOR_STEREO_FORMAT
	{
		D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_MONO = 0,
		D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_HORIZONTAL = 1,
		D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_VERTICAL = 2,
		D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_SEPARATE = 3,
		D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_MONO_OFFSET = 4,
		D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_ROW_INTERLEAVED = 5,
		D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_COLUMN_INTERLEAVED = 6,
		D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_CHECKERBOARD = 7,
	};

	enum D3D11_VIDEO_USAGE
	{
		D3D11_VIDEO_USAGE_PLAYBACK_NORMAL = 0,
		D3D11_VIDEO_USAGE_OPTIMAL_SPEED = 1,
		D3D11_VIDEO_USAGE_OPTIMAL_QUALITY = 2,
	};
}

namespace REX::W32
{
	using D3D11_RECT = RECT;

	struct D3D11_AES_CTR_IV
	{
		std::uint64_t iv;
		std::uint64_t count;
	};

	struct D3D11_BOX
	{
		std::uint32_t left;
		std::uint32_t top;
		std::uint32_t front;
		std::uint32_t right;
		std::uint32_t bottom;
		std::uint32_t back;
	};

	struct D3D11_BUFFER_DESC
	{
		std::uint32_t byteWidth;
		D3D11_USAGE   usage;
		std::uint32_t bindFlags;
		std::uint32_t cpuAccessFlags;
		std::uint32_t miscFlags;
		std::uint32_t structureByteStride;
	};

	struct D3D11_BUFFER_RTV
	{
		union
		{
			std::uint32_t firstElement;
			std::uint32_t elementOffset;
		};
		union
		{
			std::uint32_t numElements;
			std::uint32_t elementWidth;
		};
	};

	struct D3D11_BUFFER_SRV
	{
		union
		{
			std::uint32_t firstElement;
			std::uint32_t elementOffset;
		};
		union
		{
			std::uint32_t numElements;
			std::uint32_t elementWidth;
		};
	};

	struct D3D11_BUFFER_UAV
	{
		std::uint32_t firstElement;
		std::uint32_t numElements;
		std::uint32_t flags;
	};

	struct D3D11_BUFFEREX_SRV
	{
		std::uint32_t firstElement;
		std::uint32_t numElements;
		std::uint32_t flags;
	};

	struct D3D11_CLASS_INSTANCE_DESC
	{
		std::uint32_t instanceId;
		std::uint32_t instanceIndex;
		std::uint32_t typeId;
		std::uint32_t constantBuffer;
		std::uint32_t baseConstantBufferOffset;
		std::uint32_t baseTexture;
		std::uint32_t baseSampler;
		BOOL          created;
	};

	struct D3D11_COUNTER_DESC
	{
		D3D11_COUNTER counter;
		std::uint32_t miscFlags;
	};

	struct D3D11_COUNTER_INFO
	{
		D3D11_COUNTER lastDeviceDependentCounter;
		std::uint32_t numSimultaneousCounters;
		std::uint8_t  numDetectableParallelUnits;
	};

	struct D3D11_DRAW_INSTANCED_INDIRECT_ARGS
	{
		std::uint32_t vertexCountPerInstance;
		std::uint32_t instanceCount;
		std::uint32_t startVertexLocation;
		std::uint32_t startInstanceLocation;
	};

	struct D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS
	{
		std::uint32_t indexCountPerInstance;
		std::uint32_t instanceCount;
		std::uint32_t startIndexLocation;
		std::int32_t  baseVertexLocation;
		std::uint32_t startInstanceLocation;
	};

	struct D3D11_ENCRYPTED_BLOCK_INFO
	{
		std::uint32_t numEncryptedBytesAtBeginning;
		std::uint32_t numBytesInSkipPattern;
		std::uint32_t numBytesInEncryptPattern;
	};

	struct D3D11_INPUT_ELEMENT_DESC
	{
		const char*                semanticName;
		std::uint32_t              semanticIndex;
		DXGI_FORMAT                format;
		std::uint32_t              inputSlot;
		std::uint32_t              alignedByteOffset;
		D3D11_INPUT_CLASSIFICATION inputSlotClass;
		std::uint32_t              instanceDataStepRate;
	};

	struct D3D11_MAPPED_SUBRESOURCE
	{
		void*         data;
		std::uint32_t rowPitch;
		std::uint32_t depthPitch;
	};

	struct D3D11_QUERY_DATA_PIPELINE_STATISTICS
	{
		std::uint64_t iaVertices;
		std::uint64_t iaPrimitives;
		std::uint64_t vsInvocations;
		std::uint64_t gsInvocations;
		std::uint64_t gsPrimitives;
		std::uint64_t cInvocations;
		std::uint64_t cPrimitives;
		std::uint64_t psInvocations;
		std::uint64_t hsInvocations;
		std::uint64_t dsInvocations;
		std::uint64_t csInvocations;
	};

	struct D3D11_QUERY_DATA_SO_STATISTICS
	{
		std::uint64_t numPrimitivesWritten;
		std::uint64_t primitivesStorageNeeded;
	};

	struct D3D11_QUERY_DATA_TIMESTAMP_DISJOINT
	{
		std::uint64_t frequency;
		BOOL          disjoint;
	};

	struct D3D11_QUERY_DESC
	{
		D3D11_QUERY   query;
		std::uint32_t miscFlags;
	};

	struct D3D11_RASTERIZER_DESC
	{
		D3D11_FILL_MODE fillMode;
		D3D11_CULL_MODE cullMode;
		BOOL            frontCounterClockwise;
		std::int32_t    depthBias;
		float           depthBiasClamp;
		float           slopeScaledDepthBias;
		BOOL            depthClipEnable;
		BOOL            scissorEnable;
		BOOL            multisampleEnable;
		BOOL            antialiasedLineEnable;
	};

	struct D3D11_RENDER_TARGET_BLEND_DESC
	{
		BOOL           blendEnable;
		D3D11_BLEND    srcBlend;
		D3D11_BLEND    destBlend;
		D3D11_BLEND_OP blendOp;
		D3D11_BLEND    srcBlendAlpha;
		D3D11_BLEND    destBlendAlpha;
		D3D11_BLEND_OP blendOpAlpha;
		std::uint8_t   renderTargetWriteMask;
	};

	struct D3D11_BLEND_DESC
	{
		BOOL                           alphaToCoverageEnable;
		BOOL                           independentBlendEnable;
		D3D11_RENDER_TARGET_BLEND_DESC renderTarget[8];
	};

	struct D3D11_SO_DECLARATION_ENTRY
	{
		std::uint32_t stream;
		const char*   semanticName;
		std::uint32_t semanticIndex;
		std::uint8_t  startComponent;
		std::uint8_t  componentCount;
		std::uint8_t  outputSlot;
	};

	struct D3D11_SAMPLER_DESC
	{
		D3D11_FILTER               filter;
		D3D11_TEXTURE_ADDRESS_MODE addressU;
		D3D11_TEXTURE_ADDRESS_MODE addressV;
		D3D11_TEXTURE_ADDRESS_MODE addressW;
		float                      mipLODBias;
		std::uint32_t              maxAnisotropy;
		D3D11_COMPARISON_FUNC      comparisonFunc;
		float                      borderColor[4];
		float                      minLOD;
		float                      maxLOD;
	};

	struct D3D11_SUBRESOURCE_DATA
	{
		const void*   sysMem;
		std::uint32_t sysMemPitch;
		std::uint32_t sysMemSlicePitch;
	};

	struct D3D11_TEX1D_DSV
	{
		std::uint32_t mipSlice;
	};

	struct D3D11_TEX1D_RTV
	{
		std::uint32_t mipSlice;
	};

	struct D3D11_TEX1D_SRV
	{
		std::uint32_t mostDetailedMip;
		std::uint32_t mipLevels;
	};

	struct D3D11_TEX1D_UAV
	{
		std::uint32_t mipSlice;
	};

	struct D3D11_TEX1D_ARRAY_DSV
	{
		std::uint32_t mipSlice;
		std::uint32_t firstArraySlice;
		std::uint32_t arraySize;
	};

	struct D3D11_TEX1D_ARRAY_RTV
	{
		std::uint32_t mipSlice;
		std::uint32_t firstArraySlice;
		std::uint32_t arraySize;
	};

	struct D3D11_TEX1D_ARRAY_SRV
	{
		std::uint32_t mostDetailedMip;
		std::uint32_t mipLevels;
		std::uint32_t firstArraySlice;
		std::uint32_t arraySize;
	};

	struct D3D11_TEX1D_ARRAY_UAV
	{
		std::uint32_t mipSlice;
		std::uint32_t firstArraySlice;
		std::uint32_t arraySize;
	};

	struct D3D11_TEX2D_DSV
	{
		std::uint32_t mipSlice;
	};

	struct D3D11_TEX2D_RTV
	{
		std::uint32_t mipSlice;
	};

	struct D3D11_TEX2D_SRV
	{
		std::uint32_t mostDetailedMip;
		std::uint32_t mipLevels;
	};

	struct D3D11_TEX2D_UAV
	{
		std::uint32_t mipSlice;
	};

	struct D3D11_TEX2D_VDOV
	{
		std::uint32_t arraySlice;
	};

	struct D3D11_TEX2D_VPIV
	{
		std::uint32_t mipSlice;
		std::uint32_t arraySlice;
	};

	struct D3D11_TEX2D_VPOV
	{
		std::uint32_t mipSlice;
	};

	struct D3D11_TEX2D_ARRAY_DSV
	{
		std::uint32_t mipSlice;
		std::uint32_t firstArraySlice;
		std::uint32_t arraySize;
	};

	struct D3D11_TEX2D_ARRAY_RTV
	{
		std::uint32_t mipSlice;
		std::uint32_t firstArraySlice;
		std::uint32_t arraySize;
	};

	struct D3D11_TEX2D_ARRAY_SRV
	{
		std::uint32_t mostDetailedMip;
		std::uint32_t mipLevels;
		std::uint32_t firstArraySlice;
		std::uint32_t arraySize;
	};

	struct D3D11_TEX2D_ARRAY_UAV
	{
		std::uint32_t mipSlice;
		std::uint32_t firstArraySlice;
		std::uint32_t arraySize;
	};

	struct D3D11_TEX2D_ARRAY_VPOV
	{
		std::uint32_t mipSlice;
		std::uint32_t firstArraySlice;
		std::uint32_t arraySize;
	};

	struct D3D11_TEX2DMS_DSV
	{
		std::uint32_t _unusedField_NothingToDefine;
	};

	struct D3D11_TEX2DMS_RTV
	{
		std::uint32_t _unusedField_NothingToDefine;
	};

	struct D3D11_TEX2DMS_SRV
	{
		std::uint32_t _unusedField_NothingToDefine;
	};

	struct D3D11_TEX2DMS_ARRAY_DSV
	{
		std::uint32_t firstArraySlice;
		std::uint32_t arraySize;
	};

	struct D3D11_TEX2DMS_ARRAY_RTV
	{
		std::uint32_t firstArraySlice;
		std::uint32_t arraySize;
	};

	struct D3D11_TEX2DMS_ARRAY_SRV
	{
		std::uint32_t firstArraySlice;
		std::uint32_t arraySize;
	};

	struct D3D11_TEX3D_RTV
	{
		std::uint32_t mipSlice;
		std::uint32_t firstWSlice;
		std::uint32_t wSize;
	};

	struct D3D11_TEX3D_SRV
	{
		std::uint32_t mostDetailedMip;
		std::uint32_t mipLevels;
	};

	struct D3D11_TEX3D_UAV
	{
		std::uint32_t mipSlice;
		std::uint32_t firstWSlice;
		std::uint32_t wSize;
	};

	struct D3D11_TEXCUBE_SRV
	{
		std::uint32_t mostDetailedMip;
		std::uint32_t mipLevels;
	};

	struct D3D11_TEXCUBE_ARRAY_SRV
	{
		std::uint32_t mostDetailedMip;
		std::uint32_t mipLevels;
		std::uint32_t first2DArrayFace;
		std::uint32_t numCubes;
	};

	struct D3D11_DEPTH_STENCILOP_DESC
	{
		D3D11_STENCIL_OP      stencilFailOp;
		D3D11_STENCIL_OP      stencilDepthFailOp;
		D3D11_STENCIL_OP      stencilPassOp;
		D3D11_COMPARISON_FUNC stencilFunc;
	};

	struct D3D11_DEPTH_STENCIL_DESC
	{
		BOOL                       depthEnable;
		D3D11_DEPTH_WRITE_MASK     depthWriteMask;
		D3D11_COMPARISON_FUNC      depthFunc;
		BOOL                       stencilEnable;
		std::uint8_t               stencilReadMask;
		std::uint8_t               stencilWriteMask;
		D3D11_DEPTH_STENCILOP_DESC frontFace;
		D3D11_DEPTH_STENCILOP_DESC backFace;
	};

	struct D3D11_DEPTH_STENCIL_VIEW_DESC
	{
		DXGI_FORMAT         format;
		D3D11_DSV_DIMENSION viewDimension;
		std::uint32_t       flags;
		union
		{
			D3D11_TEX1D_DSV         texture1D;
			D3D11_TEX1D_ARRAY_DSV   texture1DArray;
			D3D11_TEX2D_DSV         texture2D;
			D3D11_TEX2D_ARRAY_DSV   texture2DArray;
			D3D11_TEX2DMS_DSV       texture2DMS;
			D3D11_TEX2DMS_ARRAY_DSV texture2DMSArray;
		};
	};

	struct D3D11_OMAC
	{
		std::uint8_t omac[16];
	};

	struct D3D11_AUTHENTICATED_CONFIGURE_OUTPUT
	{
		D3D11_OMAC    omac;
		GUID          configureType;
		HANDLE        channel;
		std::uint32_t sequenceNumber;
		HRESULT       returnCode;
	};

	struct D3D11_RENDER_TARGET_VIEW_DESC
	{
		DXGI_FORMAT         format;
		D3D11_RTV_DIMENSION viewDimension;
		union
		{
			D3D11_BUFFER_RTV        buffer;
			D3D11_TEX1D_RTV         texture1D;
			D3D11_TEX1D_ARRAY_RTV   texture1DArray;
			D3D11_TEX2D_RTV         texture2D;
			D3D11_TEX2D_ARRAY_RTV   texture2DArray;
			D3D11_TEX2DMS_RTV       texture2DMS;
			D3D11_TEX2DMS_ARRAY_RTV texture2DMSArray;
			D3D11_TEX3D_RTV         texture3D;
		};
	};

	struct D3D11_SHADER_RESOURCE_VIEW_DESC
	{
		DXGI_FORMAT         format;
		D3D11_SRV_DIMENSION viewDimension;
		union
		{
			D3D11_BUFFER_SRV        buffer;
			D3D11_TEX1D_SRV         texture1D;
			D3D11_TEX1D_ARRAY_SRV   texture1DArray;
			D3D11_TEX2D_SRV         texture2D;
			D3D11_TEX2D_ARRAY_SRV   texture2DArray;
			D3D11_TEX2DMS_SRV       texture2DMS;
			D3D11_TEX2DMS_ARRAY_SRV texture2DMSArray;
			D3D11_TEX3D_SRV         texture3D;
			D3D11_TEXCUBE_SRV       textureCube;
			D3D11_TEXCUBE_ARRAY_SRV textureCubeArray;
			D3D11_BUFFEREX_SRV      bufferEx;
		};
	};

	struct D3D11_TEXTURE1D_DESC
	{
		std::uint32_t width;
		std::uint32_t mipLevels;
		std::uint32_t arraySize;
		DXGI_FORMAT   format;
		D3D11_USAGE   usage;
		std::uint32_t bindFlags;
		std::uint32_t cpuAccessFlags;
		std::uint32_t miscFlags;
	};

	struct D3D11_TEXTURE2D_DESC
	{
		std::uint32_t    width;
		std::uint32_t    height;
		std::uint32_t    mipLevels;
		std::uint32_t    arraySize;
		DXGI_FORMAT      format;
		DXGI_SAMPLE_DESC sampleDesc;
		D3D11_USAGE      usage;
		std::uint32_t    bindFlags;
		std::uint32_t    cpuAccessFlags;
		std::uint32_t    miscFlags;
	};

	struct D3D11_TEXTURE3D_DESC
	{
		std::uint32_t width;
		std::uint32_t height;
		std::uint32_t depth;
		std::uint32_t mipLevels;
		DXGI_FORMAT   format;
		D3D11_USAGE   usage;
		std::uint32_t bindFlags;
		std::uint32_t cpuAccessFlags;
		std::uint32_t miscFlags;
	};

	struct D3D11_UNORDERED_ACCESS_VIEW_DESC
	{
		DXGI_FORMAT         format;
		D3D11_UAV_DIMENSION viewDimension;
		union
		{
			D3D11_BUFFER_UAV      buffer;
			D3D11_TEX1D_UAV       texture1D;
			D3D11_TEX1D_ARRAY_UAV texture1DArray;
			D3D11_TEX2D_UAV       texture2D;
			D3D11_TEX2D_ARRAY_UAV texture2DArray;
			D3D11_TEX3D_UAV       texture3D;
		};
	};

	struct D3D11_VIDEO_COLOR_RGBA
	{
		float r;
		float g;
		float b;
		float a;
	};

	struct D3D11_VIDEO_COLOR_YCbCrA
	{
		float y;
		float cb;
		float cr;
		float a;
	};

	struct D3D11_VIDEO_COLOR
	{
		union
		{
			D3D11_VIDEO_COLOR_YCbCrA ycbcr;
			D3D11_VIDEO_COLOR_RGBA   rgba;
		};
	};

	struct D3D11_VIDEO_CONTENT_PROTECTION_CAPS
	{
		std::uint32_t caps;
		std::uint32_t keyExchangeTypeCount;
		std::uint32_t blockAlignmentSize;
		std::uint64_t protectedMemorySize;
	};

	struct D3D11_VIDEO_DECODER_BUFFER_DESC
	{
		D3D11_VIDEO_DECODER_BUFFER_TYPE bufferType;
		std::uint32_t                   bufferIndex;
		std::uint32_t                   dataOffset;
		std::uint32_t                   dataSize;
		std::uint32_t                   firstMBAddress;
		std::uint32_t                   numMBsInBuffer;
		std::uint32_t                   width;
		std::uint32_t                   height;
		std::uint32_t                   stride;
		std::uint32_t                   reservedBits;
		void*                           iv;
		std::uint32_t                   ivSize;
		BOOL                            partialEncryption;
		D3D11_ENCRYPTED_BLOCK_INFO      encryptedBlockInfo;
	};

	struct D3D11_VIDEO_DECODER_CONFIG
	{
		GUID          guidConfigBitstreamEncryption;
		GUID          guidConfigMBControlEncryption;
		GUID          guidConfigResidDiffEncryption;
		std::uint32_t configBitstreamRaw;
		std::uint32_t configMBControlRasterOrder;
		std::uint32_t configResidDiffHost;
		std::uint32_t configSpatialResid8;
		std::uint32_t configResid8Subtraction;
		std::uint32_t configSpatialHost8or9Clipping;
		std::uint32_t configSpatialResidInterleaved;
		std::uint32_t configIntraResidUnsigned;
		std::uint32_t configResidDiffAccelerator;
		std::uint32_t configHostInverseScan;
		std::uint32_t configSpecificIDCT;
		std::uint32_t config4GroupedCoefs;
		std::uint16_t configMinRenderTargetBuffCount;
		std::uint16_t configDecoderSpecific;
	};

	struct D3D11_VIDEO_DECODER_DESC
	{
		GUID          guid;
		std::uint32_t sampleWidth;
		std::uint32_t sampleHeight;
		DXGI_FORMAT   outputFormat;
	};

	struct D3D11_VIDEO_DECODER_EXTENSION
	{
		std::uint32_t    function;
		void*            privateInputData;
		std::uint32_t    privateInputDataSize;
		void*            privateOutputData;
		std::uint32_t    privateOutputDataSize;
		std::uint32_t    resourceCount;
		ID3D11Resource** resourceList;
	};

	struct D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC
	{
		GUID                 decodeProfile;
		D3D11_VDOV_DIMENSION viewDimension;
		union
		{
			D3D11_TEX2D_VDOV texture2D;
		};
	};

	struct D3D11_VIDEO_PROCESSOR_CAPS
	{
		std::uint32_t aeviceCaps;
		std::uint32_t featureCaps;
		std::uint32_t filterCaps;
		std::uint32_t inputFormatCaps;
		std::uint32_t autoStreamCaps;
		std::uint32_t stereoCaps;
		std::uint32_t rateConversionCapsCount;
		std::uint32_t maxInputStreams;
		std::uint32_t maxStreamStates;
	};

	struct D3D11_VIDEO_PROCESSOR_COLOR_SPACE
	{
		std::uint32_t usage: 1;
		std::uint32_t rgb_Range: 1;
		std::uint32_t yCbCr_Matrix: 1;
		std::uint32_t yCbCr_xvYCC: 1;
		std::uint32_t nominal_Range: 2;
		std::uint32_t reserved: 26;
	};

	struct D3D11_VIDEO_PROCESSOR_CONTENT_DESC
	{
		D3D11_VIDEO_FRAME_FORMAT inputFrameFormat;
		DXGI_RATIONAL            inputFrameRate;
		std::uint32_t            inputWidth;
		std::uint32_t            inputHeight;
		DXGI_RATIONAL            outputFrameRate;
		std::uint32_t            outputWidth;
		std::uint32_t            outputHeight;
		D3D11_VIDEO_USAGE        usage;
	};

	struct D3D11_VIDEO_PROCESSOR_CUSTOM_RATE
	{
		DXGI_RATIONAL customRate;
		std::uint32_t outputFrames;
		BOOL          inputInterlaced;
		std::uint32_t inputFramesOrFields;
	};

	struct D3D11_VIDEO_PROCESSOR_FILTER_RANGE
	{
		std::int32_t min;
		std::int32_t max;
		std::int32_t def;
		float        mult;
	};

	struct D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC
	{
		std::uint32_t        fourCC;
		D3D11_VPIV_DIMENSION viewDimension;
		union
		{
			D3D11_TEX2D_VPIV texture2D;
		};
	};

	struct D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC
	{
		D3D11_VPOV_DIMENSION viewDimension;
		union
		{
			D3D11_TEX2D_VPOV       texture2D;
			D3D11_TEX2D_ARRAY_VPOV texture2DArray;
		};
	};

	struct D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS
	{
		std::uint32_t pastFrames;
		std::uint32_t futureFrames;
		std::uint32_t processorCaps;
		std::uint32_t iTelecineCaps;
		std::uint32_t customRateCount;
	};

	struct D3D11_VIDEO_PROCESSOR_STREAM
	{
		BOOL                            enable;
		std::uint32_t                   outputIndex;
		std::uint32_t                   inputFrameOrField;
		std::uint32_t                   pastFrames;
		std::uint32_t                   futureFrames;
		ID3D11VideoProcessorInputView** pastSurfaces;
		ID3D11VideoProcessorInputView*  inputSurface;
		ID3D11VideoProcessorInputView** futureSurfaces;
		ID3D11VideoProcessorInputView** pastSurfacesRight;
		ID3D11VideoProcessorInputView*  inputSurfaceRight;
		ID3D11VideoProcessorInputView** futureSurfacesRight;
	};

	struct D3D11_VIEWPORT
	{
		float topLeftX;
		float topLeftY;
		float width;
		float height;
		float minDepth;
		float maxDepth;

		friend bool operator==(const D3D11_VIEWPORT& a_lhs, const D3D11_VIEWPORT& a_rhs)
		{
			return a_lhs.topLeftX == a_rhs.topLeftX && a_lhs.topLeftY == a_rhs.topLeftY && a_lhs.width == a_rhs.width &&
			       a_lhs.height == a_rhs.height && a_lhs.minDepth == a_rhs.minDepth && a_lhs.maxDepth == a_rhs.maxDepth;
		}

		friend bool operator!=(const D3D11_VIEWPORT& a_lhs, const D3D11_VIEWPORT& a_rhs)
		{
			return !(a_lhs == a_rhs);
		}
	};
}

namespace REX::W32
{
	struct __declspec(novtable, uuid("db6f6ddb-ac77-4e88-8253-819df9bbf140"))
		ID3D11Device : public IUnknown
	{
		virtual HRESULT           CreateBuffer(const D3D11_BUFFER_DESC* a_desc, const D3D11_SUBRESOURCE_DATA* a_initialData, ID3D11Buffer** a_buffer) = 0;
		virtual HRESULT           CreateTexture1D(const D3D11_TEXTURE1D_DESC* a_desc, const D3D11_SUBRESOURCE_DATA* a_initialData, ID3D11Texture1D** a_texture1D) = 0;
		virtual HRESULT           CreateTexture2D(const D3D11_TEXTURE2D_DESC* a_desc, const D3D11_SUBRESOURCE_DATA* a_initialData, ID3D11Texture2D** a_texture2D) = 0;
		virtual HRESULT           CreateTexture3D(const D3D11_TEXTURE3D_DESC* a_desc, const D3D11_SUBRESOURCE_DATA* a_initialData, ID3D11Texture3D** a_texture3D) = 0;
		virtual HRESULT           CreateShaderResourceView(ID3D11Resource* a_resource, const D3D11_SHADER_RESOURCE_VIEW_DESC* a_desc, ID3D11ShaderResourceView** a_srView) = 0;
		virtual HRESULT           CreateUnorderedAccessView(ID3D11Resource* a_resource, const D3D11_UNORDERED_ACCESS_VIEW_DESC* a_desc, ID3D11UnorderedAccessView** a_uaView) = 0;
		virtual HRESULT           CreateRenderTargetView(ID3D11Resource* a_resource, const D3D11_RENDER_TARGET_VIEW_DESC* a_desc, ID3D11RenderTargetView** a_rtView) = 0;
		virtual HRESULT           CreateDepthStencilView(ID3D11Resource* a_resource, const D3D11_DEPTH_STENCIL_VIEW_DESC* a_desc, ID3D11DepthStencilView** a_dsView) = 0;
		virtual HRESULT           CreateInputLayout(const D3D11_INPUT_ELEMENT_DESC* a_desc, std::uint32_t a_numElements, const void* a_shaderBytecodeWithInputSignature, std::size_t a_bytecodeLength, ID3D11InputLayout** a_inputLayout) = 0;
		virtual HRESULT           CreateVertexShader(const void* a_shaderBytecode, std::size_t a_bytecodeLength, ID3D11ClassLinkage* a_classLinkage, ID3D11VertexShader** a_vertexShader) = 0;
		virtual HRESULT           CreateGeometryShader(const void* a_shaderBytecode, std::size_t a_bytecodeLength, ID3D11ClassLinkage* a_classLinkage, ID3D11GeometryShader** a_geometryShader) = 0;
		virtual HRESULT           CreateGeometryShaderWithStreamOutput(const void* a_shaderBytecode, std::size_t a_bytecodeLength, const D3D11_SO_DECLARATION_ENTRY* a_soDeclaration, std::uint32_t a_numEntries, const std::uint32_t* a_bufferStrides, std::uint32_t a_numStrides, std::uint32_t a_rasterizedStream, ID3D11ClassLinkage* a_classLinkage, ID3D11GeometryShader** a_geometryShader) = 0;
		virtual HRESULT           CreatePixelShader(const void* a_shaderBytecode, std::size_t a_bytecodeLength, ID3D11ClassLinkage* a_classLinkage, ID3D11PixelShader** a_pixelShader) = 0;
		virtual HRESULT           CreateHullShader(const void* a_shaderBytecode, std::size_t a_bytecodeLength, ID3D11ClassLinkage* a_classLinkage, ID3D11HullShader** a_hullShader) = 0;
		virtual HRESULT           CreateDomainShader(const void* a_shaderBytecode, std::size_t a_bytecodeLength, ID3D11ClassLinkage* a_classLinkage, ID3D11DomainShader** a_domainShader) = 0;
		virtual HRESULT           CreateComputeShader(const void* a_shaderBytecode, std::size_t a_bytecodeLength, ID3D11ClassLinkage* a_classLinkage, ID3D11ComputeShader** a_computeShader) = 0;
		virtual HRESULT           CreateClassLinkage(ID3D11ClassLinkage** a_classLinkage) = 0;
		virtual HRESULT           CreateBlendState(const D3D11_BLEND_DESC* a_blendStateDesc, ID3D11BlendState** a_blendState) = 0;
		virtual HRESULT           CreateDepthStencilState(const D3D11_DEPTH_STENCIL_DESC* a_depthStencilDesc, ID3D11DepthStencilState** a_depthStencilState) = 0;
		virtual HRESULT           CreateRasterizerState(const D3D11_RASTERIZER_DESC* a_rasterizerDesc, ID3D11RasterizerState** a_rasterizerState) = 0;
		virtual HRESULT           CreateSamplerState(const D3D11_SAMPLER_DESC* a_samplerDesc, ID3D11SamplerState** a_samplerState) = 0;
		virtual HRESULT           CreateQuery(const D3D11_QUERY_DESC* a_queryDesc, ID3D11Query** a_query) = 0;
		virtual HRESULT           CreatePredicate(const D3D11_QUERY_DESC* a_predicateDesc, ID3D11Predicate** a_predicate) = 0;
		virtual HRESULT           CreateCounter(const D3D11_COUNTER_DESC* a_counterDesc, ID3D11Counter** a_counter) = 0;
		virtual HRESULT           CreateDeferredContext(std::uint32_t a_contextFlags, ID3D11DeviceContext** a_deferredContext) = 0;
		virtual HRESULT           OpenSharedResource(HANDLE a_resourceHandle, const IID& a_returnedInterface, void** a_resource) = 0;
		virtual HRESULT           CheckFormatSupport(DXGI_FORMAT a_format, std::uint32_t* a_formatSupport) = 0;
		virtual HRESULT           CheckMultisampleQualityLevels(DXGI_FORMAT a_format, std::uint32_t a_sampleCount, std::uint32_t* a_numQualityLevels) = 0;
		virtual void              CheckCounterInfo(D3D11_COUNTER_INFO* a_counterInfo) = 0;
		virtual HRESULT           CheckCounter(const D3D11_COUNTER_DESC* a_desc, D3D11_COUNTER_TYPE* a_type, std::uint32_t* a_activeCounters, char* a_name, std::uint32_t* a_nameLength, char* a_units, std::uint32_t* a_unitsLength, char* a_description, std::uint32_t* a_descriptionLength) = 0;
		virtual HRESULT           CheckFeatureSupport(D3D11_FEATURE a_feature, void* a_featureSupportData, std::uint32_t a_featureSupportDataSize) = 0;
		virtual HRESULT           GetPrivateData(const GUID& a_guid, std::uint32_t* a_dataSize, void* a_data) = 0;
		virtual HRESULT           SetPrivateData(const GUID& a_guid, std::uint32_t a_dataSize, const void* a_data) = 0;
		virtual HRESULT           SetPrivateDataInterface(const GUID& a_guid, const IUnknown* a_data) = 0;
		virtual D3D_FEATURE_LEVEL GetFeatureLevel(void) = 0;
		virtual std::uint32_t     GetCreationFlags(void) = 0;
		virtual HRESULT           GetDeviceRemovedReason(void) = 0;
		virtual void              GetImmediateContext(ID3D11DeviceContext** a_immediateContext) = 0;
		virtual HRESULT           SetExceptionMode(std::uint32_t a_raiseFlags) = 0;
		virtual std::uint32_t     GetExceptionMode(void) = 0;
	};

	struct __declspec(novtable, uuid("1841e5c8-16b0-489b-bcc8-44cfb0d5deae"))
		ID3D11DeviceChild : public IUnknown
	{
		virtual void    GetDevice(ID3D11Device** a_device) = 0;
		virtual HRESULT GetPrivateData(const GUID& a_guid, std::uint32_t* a_dataSize, void* a_data) = 0;
		virtual HRESULT SetPrivateData(const GUID& a_guid, std::uint32_t a_dataSize, const void* a_data) = 0;
		virtual HRESULT SetPrivateDataInterface(const GUID& a_guid, const IUnknown* a_data) = 0;
	};

	struct __declspec(novtable, uuid("c0bfa96c-e089-44fb-8eaf-26f8796190da"))
		ID3D11DeviceContext : public ID3D11DeviceChild
	{
		virtual void                      VSSetConstantBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer* const* a_constantBuffers) = 0;
		virtual void                      PSSetShaderResources(std::uint32_t a_startSlot, std::uint32_t a_numViews, ID3D11ShaderResourceView* const* a_shaderResourceViews) = 0;
		virtual void                      PSSetShader(ID3D11PixelShader* a_pixelShader, ID3D11ClassInstance* const* a_classInstances, std::uint32_t a_numClassInstances) = 0;
		virtual void                      PSSetSamplers(std::uint32_t a_startSlot, std::uint32_t a_numSamplers, ID3D11SamplerState* const* a_samplers) = 0;
		virtual void                      VSSetShader(ID3D11VertexShader* a_vertexShader, ID3D11ClassInstance* const* a_classInstances, std::uint32_t a_numClassInstances) = 0;
		virtual void                      DrawIndexed(std::uint32_t IndexCount, std::uint32_t a_startIndexLocation, std::int32_t a_baseVertexLocation) = 0;
		virtual void                      Draw(std::uint32_t a_vertexCount, std::uint32_t a_startVertexLocation) = 0;
		virtual HRESULT                   Map(ID3D11Resource* a_resource, std::uint32_t a_subResource, D3D11_MAP a_mapType, std::uint32_t a_mapFlags, D3D11_MAPPED_SUBRESOURCE* a_mappedResource) = 0;
		virtual void                      Unmap(ID3D11Resource* a_resource, std::uint32_t a_subResource) = 0;
		virtual void                      PSSetConstantBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer* const* a_constantBuffers) = 0;
		virtual void                      IASetInputLayout(ID3D11InputLayout* a_inputLayout) = 0;
		virtual void                      IASetVertexBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer* const* a_vertexBuffers, const std::uint32_t* a_strides, const std::uint32_t* a_offsets) = 0;
		virtual void                      IASetIndexBuffer(ID3D11Buffer* a_indexBuffer, DXGI_FORMAT a_format, std::uint32_t a_offset) = 0;
		virtual void                      DrawIndexedInstanced(std::uint32_t a_indexCountPerInstance, std::uint32_t a_instanceCount, std::uint32_t a_startIndexLocation, std::int32_t a_baseVertexLocation, std::uint32_t a_startInstanceLocation) = 0;
		virtual void                      DrawInstanced(std::uint32_t a_vertexCountPerInstance, std::uint32_t a_instanceCount, std::uint32_t a_startVertexLocation, std::uint32_t a_startInstanceLocation) = 0;
		virtual void                      GSSetConstantBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer* const* a_constantBuffers) = 0;
		virtual void                      GSSetShader(ID3D11GeometryShader* a_shader, ID3D11ClassInstance* const* a_classInstances, std::uint32_t a_numClassInstances) = 0;
		virtual void                      IASetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY a_topology) = 0;
		virtual void                      VSSetShaderResources(std::uint32_t a_startSlot, std::uint32_t a_numViews, ID3D11ShaderResourceView* const* a_shaderResourceViews) = 0;
		virtual void                      VSSetSamplers(std::uint32_t a_startSlot, std::uint32_t a_numSamplers, ID3D11SamplerState* const* a_samplers) = 0;
		virtual void                      Begin(ID3D11Asynchronous* a_async) = 0;
		virtual void                      End(ID3D11Asynchronous* a_async) = 0;
		virtual HRESULT                   GetData(ID3D11Asynchronous* a_async, void* a_data, std::uint32_t a_dataSize, std::uint32_t a_getDataFlags) = 0;
		virtual void                      SetPredication(ID3D11Predicate* a_predicate, BOOL a_predicateValue) = 0;
		virtual void                      GSSetShaderResources(std::uint32_t a_startSlot, std::uint32_t a_numViews, ID3D11ShaderResourceView* const* a_shaderResourceViews) = 0;
		virtual void                      GSSetSamplers(std::uint32_t a_startSlot, std::uint32_t a_numSamplers, ID3D11SamplerState* const* a_samplers) = 0;
		virtual void                      OMSetRenderTargets(std::uint32_t a_numViews, ID3D11RenderTargetView* const* a_renderTargetViews, ID3D11DepthStencilView* a_depthStencilView) = 0;
		virtual void                      OMSetRenderTargetsAndUnorderedAccessViews(std::uint32_t a_numRTVs, ID3D11RenderTargetView* const* a_renderTargetViews, ID3D11DepthStencilView* a_depthStencilView, std::uint32_t a_uavStartSlot, std::uint32_t a_numUAVs, ID3D11UnorderedAccessView* const* a_unorderedAccessViews, const std::uint32_t* a_uavInitialCounts) = 0;
		virtual void                      OMSetBlendState(ID3D11BlendState* a_blendState, const float a_blendFactor[4], std::uint32_t a_sampleMask) = 0;
		virtual void                      OMSetDepthStencilState(ID3D11DepthStencilState* a_depthStencilState, std::uint32_t a_stencilRef) = 0;
		virtual void                      SOSetTargets(std::uint32_t a_numBuffers, ID3D11Buffer* const* a_soTargets, const std::uint32_t* a_offsets) = 0;
		virtual void                      DrawAuto(void) = 0;
		virtual void                      DrawIndexedInstancedIndirect(ID3D11Buffer* a_bufferForArgs, std::uint32_t a_alignedByteOffsetForArgs) = 0;
		virtual void                      DrawInstancedIndirect(ID3D11Buffer* a_bufferForArgs, std::uint32_t a_alignedByteOffsetForArgs) = 0;
		virtual void                      Dispatch(std::uint32_t a_threadGroupCountX, std::uint32_t a_threadGroupCountY, std::uint32_t a_threadGroupCountZ) = 0;
		virtual void                      DispatchIndirect(ID3D11Buffer* a_bufferForArgs, std::uint32_t a_alignedByteOffsetForArgs) = 0;
		virtual void                      RSSetState(ID3D11RasterizerState* a_rasterizerState) = 0;
		virtual void                      RSSetViewports(std::uint32_t a_numViewports, const D3D11_VIEWPORT* a_viewports) = 0;
		virtual void                      RSSetScissorRects(std::uint32_t a_numRects, const D3D11_RECT* a_rects) = 0;
		virtual void                      CopySubresourceRegion(ID3D11Resource* a_dstResource, std::uint32_t a_dstSubresource, std::uint32_t a_dstX, std::uint32_t a_dstY, std::uint32_t a_dstZ, ID3D11Resource* a_srcResource, std::uint32_t a_srcSubresource, const D3D11_BOX* a_srcBox) = 0;
		virtual void                      CopyResource(ID3D11Resource* a_dstResource, ID3D11Resource* a_srcResource) = 0;
		virtual void                      UpdateSubresource(ID3D11Resource* a_dstResource, std::uint32_t a_dstSubresource, const D3D11_BOX* a_dstBox, const void* a_srcData, std::uint32_t a_srcRowPitch, std::uint32_t a_srcDepthPitch) = 0;
		virtual void                      CopyStructureCount(ID3D11Buffer* a_dstBuffer, std::uint32_t a_dstAlignedByteOffset, ID3D11UnorderedAccessView* a_srcView) = 0;
		virtual void                      ClearRenderTargetView(ID3D11RenderTargetView* a_renderTargetView, const float a_colorRGBA[4]) = 0;
		virtual void                      ClearUnorderedAccessViewUint(ID3D11UnorderedAccessView* a_unorderedAccessView, const std::uint32_t a_values[4]) = 0;
		virtual void                      ClearUnorderedAccessViewFloat(ID3D11UnorderedAccessView* a_unorderedAccessView, const float a_values[4]) = 0;
		virtual void                      ClearDepthStencilView(ID3D11DepthStencilView* a_depthStencilView, std::uint32_t a_clearFlags, float a_depth, std::uint8_t a_stencil) = 0;
		virtual void                      GenerateMips(ID3D11ShaderResourceView* a_shaderResourceView) = 0;
		virtual void                      SetResourceMinLOD(ID3D11Resource* a_resource, float a_minLOD) = 0;
		virtual float                     GetResourceMinLOD(ID3D11Resource* a_resource) = 0;
		virtual void                      ResolveSubresource(ID3D11Resource* a_dstResource, std::uint32_t a_dstSubresource, ID3D11Resource* a_srcResource, std::uint32_t a_srcSubresource, DXGI_FORMAT a_format) = 0;
		virtual void                      ExecuteCommandList(ID3D11CommandList* a_commandList, BOOL a_restoreContextState) = 0;
		virtual void                      HSSetShaderResources(std::uint32_t a_startSlot, std::uint32_t a_numViews, ID3D11ShaderResourceView* const* a_shaderResourceViews) = 0;
		virtual void                      HSSetShader(ID3D11HullShader* a_hullShader, ID3D11ClassInstance* const* a_classInstances, std::uint32_t a_numClassInstances) = 0;
		virtual void                      HSSetSamplers(std::uint32_t a_startSlot, std::uint32_t a_numSamplers, ID3D11SamplerState* const* a_samplers) = 0;
		virtual void                      HSSetConstantBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer* const* a_constantBuffers) = 0;
		virtual void                      DSSetShaderResources(std::uint32_t a_startSlot, std::uint32_t a_numViews, ID3D11ShaderResourceView* const* a_shaderResourceViews) = 0;
		virtual void                      DSSetShader(ID3D11DomainShader* a_domainShader, ID3D11ClassInstance* const* a_classInstances, std::uint32_t a_numClassInstances) = 0;
		virtual void                      DSSetSamplers(std::uint32_t a_startSlot, std::uint32_t a_numSamplers, ID3D11SamplerState* const* a_samplers) = 0;
		virtual void                      DSSetConstantBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer* const* a_constantBuffers) = 0;
		virtual void                      CSSetShaderResources(std::uint32_t a_startSlot, std::uint32_t a_numViews, ID3D11ShaderResourceView* const* a_shaderResourceViews) = 0;
		virtual void                      CSSetUnorderedAccessViews(std::uint32_t a_startSlot, std::uint32_t a_numUAVs, ID3D11UnorderedAccessView* const* a_unorderedAccessViews, const std::uint32_t* a_uavInitialCounts) = 0;
		virtual void                      CSSetShader(ID3D11ComputeShader* a_computeShader, ID3D11ClassInstance* const* a_classInstances, std::uint32_t a_numClassInstances) = 0;
		virtual void                      CSSetSamplers(std::uint32_t a_startSlot, std::uint32_t a_numSamplers, ID3D11SamplerState* const* a_samplers) = 0;
		virtual void                      CSSetConstantBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer* const* a_constantBuffers) = 0;
		virtual void                      VSGetConstantBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer** a_constantBuffers) = 0;
		virtual void                      PSGetShaderResources(std::uint32_t a_startSlot, std::uint32_t a_numViews, ID3D11ShaderResourceView** a_shaderResourceViews) = 0;
		virtual void                      PSGetShader(ID3D11PixelShader** a_pixelShader, ID3D11ClassInstance** a_classInstances, std::uint32_t* a_numClassInstances) = 0;
		virtual void                      PSGetSamplers(std::uint32_t a_startSlot, std::uint32_t a_numSamplers, ID3D11SamplerState** a_samplers) = 0;
		virtual void                      VSGetShader(ID3D11VertexShader** a_vertexShader, ID3D11ClassInstance** a_classInstances, std::uint32_t* a_numClassInstances) = 0;
		virtual void                      PSGetConstantBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer** a_constantBuffers) = 0;
		virtual void                      IAGetInputLayout(ID3D11InputLayout** a_inputLayout) = 0;
		virtual void                      IAGetVertexBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer** a_vertexBuffers, std::uint32_t* a_strides, std::uint32_t* a_offsets) = 0;
		virtual void                      IAGetIndexBuffer(ID3D11Buffer** a_indexBuffer, DXGI_FORMAT* a_format, std::uint32_t* a_offset) = 0;
		virtual void                      GSGetConstantBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer** a_constantBuffers) = 0;
		virtual void                      GSGetShader(ID3D11GeometryShader** a_geometryShader, ID3D11ClassInstance** a_classInstances, std::uint32_t* a_numClassInstances) = 0;
		virtual void                      IAGetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY* a_topology) = 0;
		virtual void                      VSGetShaderResources(std::uint32_t a_startSlot, std::uint32_t a_numViews, ID3D11ShaderResourceView** a_shaderResourceViews) = 0;
		virtual void                      VSGetSamplers(std::uint32_t a_startSlot, std::uint32_t a_numSamplers, ID3D11SamplerState** a_samplers) = 0;
		virtual void                      GetPredication(ID3D11Predicate** a_predicate, BOOL* a_predicateValue) = 0;
		virtual void                      GSGetShaderResources(std::uint32_t a_startSlot, std::uint32_t a_numViews, ID3D11ShaderResourceView** a_shaderResourceViews) = 0;
		virtual void                      GSGetSamplers(std::uint32_t a_startSlot, std::uint32_t a_numSamplers, ID3D11SamplerState** a_samplers) = 0;
		virtual void                      OMGetRenderTargets(std::uint32_t a_numViews, ID3D11RenderTargetView** a_renderTargetViews, ID3D11DepthStencilView** a_depthStencilView) = 0;
		virtual void                      OMGetRenderTargetsAndUnorderedAccessViews(std::uint32_t a_numRTVs, ID3D11RenderTargetView** a_renderTargetViews, ID3D11DepthStencilView** a_depthStencilView, std::uint32_t a_uavStartSlot, std::uint32_t a_numUAVs, ID3D11UnorderedAccessView** a_unorderedAccessViews) = 0;
		virtual void                      OMGetBlendState(ID3D11BlendState** a_blendState, float a_blendFactor[4], std::uint32_t* a_sampleMask) = 0;
		virtual void                      OMGetDepthStencilState(ID3D11DepthStencilState** a_depthStencilState, std::uint32_t* a_stencilRef) = 0;
		virtual void                      SOGetTargets(std::uint32_t a_numBuffers, ID3D11Buffer** a_soTargets) = 0;
		virtual void                      RSGetState(ID3D11RasterizerState** a_rasterizerState) = 0;
		virtual void                      RSGetViewports(std::uint32_t* a_numViewports, D3D11_VIEWPORT* a_viewports) = 0;
		virtual void                      RSGetScissorRects(std::uint32_t* a_numRects, D3D11_RECT* a_rects) = 0;
		virtual void                      HSGetShaderResources(std::uint32_t a_startSlot, std::uint32_t a_numViews, ID3D11ShaderResourceView** a_shaderResourceViews) = 0;
		virtual void                      HSGetShader(ID3D11HullShader** a_hullShader, ID3D11ClassInstance** a_classInstances, std::uint32_t* a_numClassInstances) = 0;
		virtual void                      HSGetSamplers(std::uint32_t a_startSlot, std::uint32_t a_numSamplers, ID3D11SamplerState** a_samplers) = 0;
		virtual void                      HSGetConstantBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer** a_constantBuffers) = 0;
		virtual void                      DSGetShaderResources(std::uint32_t a_startSlot, std::uint32_t a_numViews, ID3D11ShaderResourceView** a_shaderResourceViews) = 0;
		virtual void                      DSGetShader(ID3D11DomainShader** a_domainShader, ID3D11ClassInstance** a_classInstances, std::uint32_t* a_numClassInstances) = 0;
		virtual void                      DSGetSamplers(std::uint32_t a_startSlot, std::uint32_t a_numSamplers, ID3D11SamplerState** a_samplers) = 0;
		virtual void                      DSGetConstantBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer** a_constantBuffers) = 0;
		virtual void                      CSGetShaderResources(std::uint32_t a_startSlot, std::uint32_t a_numViews, ID3D11ShaderResourceView** a_shaderResourceViews) = 0;
		virtual void                      CSGetUnorderedAccessViews(std::uint32_t a_startSlot, std::uint32_t a_numUAVs, ID3D11UnorderedAccessView** a_unorderedAccessViews) = 0;
		virtual void                      CSGetShader(ID3D11ComputeShader** a_computeShader, ID3D11ClassInstance** a_classInstances, std::uint32_t* a_numClassInstances) = 0;
		virtual void                      CSGetSamplers(std::uint32_t a_startSlot, std::uint32_t a_numSamplers, ID3D11SamplerState** a_samplers) = 0;
		virtual void                      CSGetConstantBuffers(std::uint32_t a_startSlot, std::uint32_t a_numBuffers, ID3D11Buffer** a_constantBuffers) = 0;
		virtual void                      ClearState(void) = 0;
		virtual void                      Flush(void) = 0;
		virtual D3D11_DEVICE_CONTEXT_TYPE GetType(void) = 0;
		virtual std::uint32_t             GetContextFlags(void) = 0;
		virtual HRESULT                   FinishCommandList(BOOL a_restoreDeferredContextState, ID3D11CommandList** a_commandList) = 0;
	};

	struct __declspec(novtable, uuid("4b35d0cd-1e15-4258-9c98-1b1333f6dd3b"))
		ID3D11Asynchronous : public ID3D11DeviceChild
	{
		virtual std::uint32_t GetDataSize(void) = 0;
	};

	struct __declspec(novtable, uuid("3015A308-DCBD-47aa-A747-192486D14D4A"))
		ID3D11AuthenticatedChannel : public ID3D11DeviceChild
	{
		virtual HRESULT GetCertificateSize(std::uint32_t* a_certificateSize) = 0;
		virtual HRESULT GetCertificate(std::uint32_t a_certificateSize, std::uint8_t* a_certificate) = 0;
		virtual void    GetChannelHandle(HANDLE* a_channelHandle) = 0;
	};

	struct __declspec(novtable, uuid("75b68faa-347d-4159-8f45-a0640f01cd9a"))
		ID3D11BlendState : public ID3D11DeviceChild
	{
		virtual void GetDesc(D3D11_BLEND_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("a6cd7faa-b0b7-4a2f-9436-8662a65797cb"))
		ID3D11ClassInstance : public ID3D11DeviceChild
	{
		virtual void GetClassLinkage(ID3D11ClassLinkage** a_linkage) = 0;
		virtual void GetDesc(D3D11_CLASS_INSTANCE_DESC* a_desc) = 0;
		virtual void GetInstanceName(char* a_instanceName, std::size_t* a_bufferLength) = 0;
		virtual void GetTypeName(char* a_typeName, std::size_t* a_bufferLength) = 0;
	};

	struct __declspec(novtable, uuid("ddf57cba-9543-46e4-a12b-f207a0fe7fed"))
		ID3D11ClassLinkage : public ID3D11DeviceChild
	{
		virtual HRESULT GetClassInstance(const char* a_classInstanceName, std::uint32_t a_instanceIndex, ID3D11ClassInstance** a_instance) = 0;
		virtual HRESULT CreateClassInstance(const char* a_classTypeName, std::uint32_t a_constantBufferOffset, std::uint32_t a_constantVectorOffset, std::uint32_t a_textureOffset, std::uint32_t a_samplerOffset, ID3D11ClassInstance** a_instance) = 0;
	};

	struct __declspec(novtable, uuid("a24bc4d1-769e-43f7-8013-98ff566c18e2"))
		ID3D11CommandList : public ID3D11DeviceChild
	{
		virtual std::uint32_t GetContextFlags(void) = 0;
	};

	struct __declspec(novtable, uuid("4f5b196e-c2bd-495e-bd01-1fded38e4969"))
		ID3D11ComputeShader : public ID3D11DeviceChild
	{};

	struct __declspec(novtable, uuid("6e8c49fb-a371-4770-b440-29086022b741"))
		ID3D11Counter : public ID3D11Asynchronous
	{
		virtual void GetDesc(D3D11_COUNTER_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("9B32F9AD-BDCC-40a6-A39D-D5C865845720"))
		ID3D11CryptoSession : public ID3D11DeviceChild
	{
		virtual void    GetCryptoType(GUID* a_cryptoType) = 0;
		virtual void    GetDecoderProfile(GUID* a_decoderProfile) = 0;
		virtual HRESULT GetCertificateSize(std::uint32_t* a_certificateSize) = 0;
		virtual HRESULT GetCertificate(std::uint32_t a_certificateSize, std::uint8_t* a_certificate) = 0;
		virtual void    GetCryptoSessionHandle(HANDLE* a_cryptoSessionHandle) = 0;
	};

	struct __declspec(novtable, uuid("03823efb-8d8f-4e1c-9aa2-f64bb2cbfdf1"))
		ID3D11DepthStencilState : public ID3D11DeviceChild
	{
		virtual void GetDesc(D3D11_DEPTH_STENCIL_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("f582c508-0f36-490c-9977-31eece268cfa"))
		ID3D11DomainShader : public ID3D11DeviceChild
	{};

	struct __declspec(novtable, uuid("38325b96-effb-4022-ba02-2e795b70275c"))
		ID3D11GeometryShader : public ID3D11DeviceChild
	{};

	struct __declspec(novtable, uuid("8e5c6061-628a-4c8e-8264-bbe45cb3d5dd"))
		ID3D11HullShader : public ID3D11DeviceChild
	{};

	struct __declspec(novtable, uuid("e4819ddc-4cf0-4025-bd26-5de82a3e07b7"))
		ID3D11InputLayout : public ID3D11DeviceChild
	{};

	struct __declspec(novtable, uuid("ea82e40d-51dc-4f33-93d4-db7c9125ae8c"))
		ID3D11PixelShader : public ID3D11DeviceChild
	{};

	struct __declspec(novtable, uuid("9bb4ab81-ab1a-4d8f-b506-fc04200b6ee7"))
		ID3D11RasterizerState : public ID3D11DeviceChild
	{
		virtual void GetDesc(D3D11_RASTERIZER_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("dc8e63f3-d12b-4952-b47b-5e45026a862d"))
		ID3D11Resource : public ID3D11DeviceChild
	{
		virtual void          GetType(D3D11_RESOURCE_DIMENSION* a_resourceDimension) = 0;
		virtual void          SetEvictionPriority(std::uint32_t a_evictionPriority) = 0;
		virtual std::uint32_t GetEvictionPriority(void) = 0;
	};

	struct __declspec(novtable, uuid("da6fea51-564c-4487-9810-f0d0f9b4e3a5"))
		ID3D11SamplerState : public ID3D11DeviceChild
	{
		virtual void GetDesc(D3D11_SAMPLER_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("3b301d64-d678-4289-8897-22f8928b72f3"))
		ID3D11VertexShader : public ID3D11DeviceChild
	{};

	struct __declspec(novtable, uuid("839d1216-bb2e-412b-b7f4-a9dbebe08ed1"))
		ID3D11View : public ID3D11DeviceChild
	{
		virtual void GetResource(ID3D11Resource** a_resource) = 0;
	};

	struct __declspec(novtable, uuid("48570b85-d1ee-4fcd-a250-eb350722b037"))
		ID3D11Buffer : public ID3D11Resource
	{
		virtual void GetDesc(D3D11_BUFFER_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("9fdac92a-1876-48c3-afad-25b94f84a9b6"))
		ID3D11DepthStencilView : public ID3D11View
	{
		virtual void GetDesc(D3D11_DEPTH_STENCIL_VIEW_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("d6c00747-87b7-425e-b84d-44d108560afd"))
		ID3D11Query : public ID3D11Asynchronous
	{
		virtual void GetDesc(D3D11_QUERY_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("9eb576dd-9f77-4d86-81aa-8bab5fe490e2"))
		ID3D11Predicate : public ID3D11Query
	{};

	struct __declspec(novtable, uuid("f8fb5c27-c6b3-4f75-a4c8-439af2ef564c"))
		ID3D11Texture1D : public ID3D11Resource
	{
		virtual void GetDesc(D3D11_TEXTURE1D_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("6f15aaf2-d208-4e89-9ab4-489535d34f9c"))
		ID3D11Texture2D : public ID3D11Resource
	{
		virtual void GetDesc(D3D11_TEXTURE2D_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("037e866e-f56d-4357-a8af-9dabbe6e250e"))
		ID3D11Texture3D : public ID3D11Resource
	{
		virtual void GetDesc(D3D11_TEXTURE3D_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("dfdba067-0b8d-4865-875b-d7b4516cc164"))
		ID3D11RenderTargetView : public ID3D11View
	{
		virtual void GetDesc(D3D11_RENDER_TARGET_VIEW_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("b0e06fe0-8192-4e1a-b1ca-36d7414710b2"))
		ID3D11ShaderResourceView : public ID3D11View
	{
		virtual void GetDesc(D3D11_SHADER_RESOURCE_VIEW_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("28acf509-7f5c-48f6-8611-f316010a6380"))
		ID3D11UnorderedAccessView : public ID3D11View
	{
		virtual void GetDesc(D3D11_UNORDERED_ACCESS_VIEW_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("61F21C45-3C0E-4a74-9CEA-67100D9AD5E4"))
		ID3D11VideoContext : public ID3D11DeviceChild
	{
		virtual HRESULT GetDecoderBuffer(ID3D11VideoDecoder* a_decoder, D3D11_VIDEO_DECODER_BUFFER_TYPE a_type, std::uint32_t* a_bufferSize, void** a_buffer) = 0;
		virtual HRESULT ReleaseDecoderBuffer(ID3D11VideoDecoder* a_decoder, D3D11_VIDEO_DECODER_BUFFER_TYPE a_type) = 0;
		virtual HRESULT DecoderBeginFrame(ID3D11VideoDecoder* a_decoder, ID3D11VideoDecoderOutputView* a_view, std::uint32_t a_contentKeySize, const void* a_contentKey) = 0;
		virtual HRESULT DecoderEndFrame(ID3D11VideoDecoder* a_decoder) = 0;
		virtual HRESULT SubmitDecoderBuffers(ID3D11VideoDecoder* a_decoder, std::uint32_t a_numBuffers, const D3D11_VIDEO_DECODER_BUFFER_DESC* a_bufferDesc) = 0;
		virtual HRESULT DecoderExtension(ID3D11VideoDecoder* a_decoder, const D3D11_VIDEO_DECODER_EXTENSION* a_extensionData) = 0;
		virtual void    VideoProcessorSetOutputTargetRect(ID3D11VideoProcessor* a_videoProcessor, BOOL a_enable, const RECT* a_rect) = 0;
		virtual void    VideoProcessorSetOutputBackgroundColor(ID3D11VideoProcessor* a_videoProcessor, BOOL a_bYCbCr, const D3D11_VIDEO_COLOR* a_color) = 0;
		virtual void    VideoProcessorSetOutputColorSpace(ID3D11VideoProcessor* a_videoProcessor, const D3D11_VIDEO_PROCESSOR_COLOR_SPACE* a_colorSpace) = 0;
		virtual void    VideoProcessorSetOutputAlphaFillMode(ID3D11VideoProcessor* a_videoProcessor, D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE a_alphaFillMode, std::uint32_t a_streamIndex) = 0;
		virtual void    VideoProcessorSetOutputConstriction(ID3D11VideoProcessor* a_videoProcessor, BOOL a_enable, SIZE a_size) = 0;
		virtual void    VideoProcessorSetOutputStereoMode(ID3D11VideoProcessor* a_videoProcessor, BOOL a_enable) = 0;
		virtual HRESULT VideoProcessorSetOutputExtension(ID3D11VideoProcessor* a_videoProcessor, const GUID* a_extensionGuid, std::uint32_t a_dataSize, void* a_data) = 0;
		virtual void    VideoProcessorGetOutputTargetRect(ID3D11VideoProcessor* a_videoProcessor, BOOL* a_enabled, RECT* a_rect) = 0;
		virtual void    VideoProcessorGetOutputBackgroundColor(ID3D11VideoProcessor* a_videoProcessor, BOOL* a_bYCbCr, D3D11_VIDEO_COLOR* a_color) = 0;
		virtual void    VideoProcessorGetOutputColorSpace(ID3D11VideoProcessor* a_videoProcessor, D3D11_VIDEO_PROCESSOR_COLOR_SPACE* a_colorSpace) = 0;
		virtual void    VideoProcessorGetOutputAlphaFillMode(ID3D11VideoProcessor* a_videoProcessor, D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE* a_alphaFillMode, std::uint32_t* a_streamIndex) = 0;
		virtual void    VideoProcessorGetOutputConstriction(ID3D11VideoProcessor* a_videoProcessor, BOOL* a_enabled, SIZE* a_size) = 0;
		virtual void    VideoProcessorGetOutputStereoMode(ID3D11VideoProcessor* a_videoProcessor, BOOL* a_enabled) = 0;
		virtual HRESULT VideoProcessorGetOutputExtension(ID3D11VideoProcessor* a_videoProcessor, const GUID* a_extensionGuid, std::uint32_t a_dataSize, void* a_data) = 0;
		virtual void    VideoProcessorSetStreamFrameFormat(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, D3D11_VIDEO_FRAME_FORMAT a_frameFormat) = 0;
		virtual void    VideoProcessorSetStreamColorSpace(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, const D3D11_VIDEO_PROCESSOR_COLOR_SPACE* a_colorSpace) = 0;
		virtual void    VideoProcessorSetStreamOutputRate(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, D3D11_VIDEO_PROCESSOR_OUTPUT_RATE a_outputRate, BOOL a_repeatFrame, const DXGI_RATIONAL* a_customRate) = 0;
		virtual void    VideoProcessorSetStreamSourceRect(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL a_enable, const RECT* a_rect) = 0;
		virtual void    VideoProcessorSetStreamDestRect(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL a_enable, const RECT* a_rect) = 0;
		virtual void    VideoProcessorSetStreamAlpha(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL a_enable, float a_alpha) = 0;
		virtual void    VideoProcessorSetStreamPalette(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, std::uint32_t a_count, const std::uint32_t* a_entries) = 0;
		virtual void    VideoProcessorSetStreamPixelAspectRatio(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL a_enable, const DXGI_RATIONAL* a_sourceAspectRatio, const DXGI_RATIONAL* a_destinationAspectRatio) = 0;
		virtual void    VideoProcessorSetStreamLumaKey(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t StreamIndex, BOOL a_enable, float a_lower, float a_upper) = 0;
		virtual void    VideoProcessorSetStreamStereoFormat(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL a_enable, D3D11_VIDEO_PROCESSOR_STEREO_FORMAT a_format, BOOL a_leftViewFrame0, BOOL a_baseViewFrame0, D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE a_flipMode, std::int32_t a_monoOffset) = 0;
		virtual void    VideoProcessorSetStreamAutoProcessingMode(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL a_enable) = 0;
		virtual void    VideoProcessorSetStreamFilter(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, D3D11_VIDEO_PROCESSOR_FILTER a_filter, BOOL a_enable, std::int32_t a_level) = 0;
		virtual HRESULT VideoProcessorSetStreamExtension(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, const GUID* a_extensionGuid, std::uint32_t a_dataSize, void* a_data) = 0;
		virtual void    VideoProcessorGetStreamFrameFormat(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, D3D11_VIDEO_FRAME_FORMAT* a_frameFormat) = 0;
		virtual void    VideoProcessorGetStreamColorSpace(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, D3D11_VIDEO_PROCESSOR_COLOR_SPACE* a_colorSpace) = 0;
		virtual void    VideoProcessorGetStreamOutputRate(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, D3D11_VIDEO_PROCESSOR_OUTPUT_RATE* a_outputRate, BOOL* a_repeatFrame, DXGI_RATIONAL* a_customRate) = 0;
		virtual void    VideoProcessorGetStreamSourceRect(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL* a_enabled, RECT* a_rect) = 0;
		virtual void    VideoProcessorGetStreamDestRect(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL* a_enabled, RECT* a_rect) = 0;
		virtual void    VideoProcessorGetStreamAlpha(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL* a_enabled, float* a_alpha) = 0;
		virtual void    VideoProcessorGetStreamPalette(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, std::uint32_t a_count, std::uint32_t* a_entries) = 0;
		virtual void    VideoProcessorGetStreamPixelAspectRatio(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL* a_enabled, DXGI_RATIONAL* a_sourceAspectRatio, DXGI_RATIONAL* a_destinationAspectRatio) = 0;
		virtual void    VideoProcessorGetStreamLumaKey(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL* a_enabled, float* a_lower, float* a_upper) = 0;
		virtual void    VideoProcessorGetStreamStereoFormat(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL* a_enable, D3D11_VIDEO_PROCESSOR_STEREO_FORMAT* a_format, BOOL* a_leftViewFrame0, BOOL* a_baseViewFrame0, D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE* a_flipMode, std::int32_t* a_monoOffset) = 0;
		virtual void    VideoProcessorGetStreamAutoProcessingMode(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL* a_enabled) = 0;
		virtual void    VideoProcessorGetStreamFilter(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, D3D11_VIDEO_PROCESSOR_FILTER a_filter, BOOL* a_enabled, std::int32_t* a_level) = 0;
		virtual HRESULT VideoProcessorGetStreamExtension(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, const GUID* a_extensionGuid, std::uint32_t a_dataSize, void* a_data) = 0;
		virtual HRESULT VideoProcessorBlt(ID3D11VideoProcessor* a_videoProcessor, ID3D11VideoProcessorOutputView* a_view, std::uint32_t a_outputFrame, std::uint32_t a_streamCount, const D3D11_VIDEO_PROCESSOR_STREAM* a_streams) = 0;
		virtual HRESULT NegotiateCryptoSessionKeyExchange(ID3D11CryptoSession* a_cryptoSession, std::uint32_t a_dataSize, void* a_data) = 0;
		virtual void    EncryptionBlt(ID3D11CryptoSession* a_cryptoSession, ID3D11Texture2D* a_srcSurface, ID3D11Texture2D* a_dstSurface, std::uint32_t a_ivSize, void* a_iv) = 0;
		virtual void    DecryptionBlt(ID3D11CryptoSession* a_cryptoSession, ID3D11Texture2D* a_srcSurface, ID3D11Texture2D* a_dstSurface, D3D11_ENCRYPTED_BLOCK_INFO* a_encryptedBlockInfo, std::uint32_t a_contentKeySize, const void* a_contentKey, std::uint32_t a_ivSize, void* a_iv) = 0;
		virtual void    StartSessionKeyRefresh(ID3D11CryptoSession* a_cryptoSession, std::uint32_t a_randomNumberSize, void* a_randomNumber) = 0;
		virtual void    FinishSessionKeyRefresh(ID3D11CryptoSession* a_cryptoSession) = 0;
		virtual HRESULT GetEncryptionBltKey(ID3D11CryptoSession* a_cryptoSession, std::uint32_t a_keySize, void* a_readbackKey) = 0;
		virtual HRESULT NegotiateAuthenticatedChannelKeyExchange(ID3D11AuthenticatedChannel* a_channel, std::uint32_t a_dataSize, void* a_data) = 0;
		virtual HRESULT QueryAuthenticatedChannel(ID3D11AuthenticatedChannel* a_channel, std::uint32_t a_inputSize, const void* a_input, std::uint32_t a_outputSize, void* a_output) = 0;
		virtual HRESULT ConfigureAuthenticatedChannel(ID3D11AuthenticatedChannel* a_channel, std::uint32_t a_inputSize, const void* a_input, D3D11_AUTHENTICATED_CONFIGURE_OUTPUT* a_output) = 0;
		virtual void    VideoProcessorSetStreamRotation(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL a_enable, D3D11_VIDEO_PROCESSOR_ROTATION a_rotation) = 0;
		virtual void    VideoProcessorGetStreamRotation(ID3D11VideoProcessor* a_videoProcessor, std::uint32_t a_streamIndex, BOOL* a_enable, D3D11_VIDEO_PROCESSOR_ROTATION* a_rotation) = 0;
	};

	struct __declspec(novtable, uuid("3C9C5B51-995D-48d1-9B8D-FA5CAEDED65C"))
		ID3D11VideoDecoder : public ID3D11DeviceChild
	{
		virtual HRESULT GetCreationParameters(D3D11_VIDEO_DECODER_DESC* a_videoDesc, D3D11_VIDEO_DECODER_CONFIG* a_config) = 0;
		virtual HRESULT GetDriverHandle(HANDLE* a_driverHandle) = 0;
	};

	struct __declspec(novtable, uuid("C2931AEA-2A85-4f20-860F-FBA1FD256E18"))
		ID3D11VideoDecoderOutputView : public ID3D11View
	{
		virtual void GetDesc(D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("10EC4D5B-975A-4689-B9E4-D0AAC30FE333"))
		ID3D11VideoDevice : public IUnknown
	{
		virtual HRESULT       CreateVideoDecoder(const D3D11_VIDEO_DECODER_DESC* a_videoDesc, const D3D11_VIDEO_DECODER_CONFIG* a_config, ID3D11VideoDecoder** a_decoder) = 0;
		virtual HRESULT       CreateVideoProcessor(ID3D11VideoProcessorEnumerator* a_enum, std::uint32_t a_rateConversionIndex, ID3D11VideoProcessor** a_videoProcessor) = 0;
		virtual HRESULT       CreateAuthenticatedChannel(D3D11_AUTHENTICATED_CHANNEL_TYPE a_channelType, ID3D11AuthenticatedChannel** a_authenticatedChannel) = 0;
		virtual HRESULT       CreateCryptoSession(const GUID* a_cryptoType, const GUID* a_decoderProfile, const GUID* a_keyExchangeType, ID3D11CryptoSession** a_cryptoSession) = 0;
		virtual HRESULT       CreateVideoDecoderOutputView(ID3D11Resource* a_resource, const D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC* a_desc, ID3D11VideoDecoderOutputView** a_dvovView) = 0;
		virtual HRESULT       CreateVideoProcessorInputView(ID3D11Resource* a_resource, ID3D11VideoProcessorEnumerator* a_enum, const D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC* a_desc, ID3D11VideoProcessorInputView** a_vpiView) = 0;
		virtual HRESULT       CreateVideoProcessorOutputView(ID3D11Resource* a_resource, ID3D11VideoProcessorEnumerator* a_enum, const D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC* a_desc, ID3D11VideoProcessorOutputView** a_vpoView) = 0;
		virtual HRESULT       CreateVideoProcessorEnumerator(const D3D11_VIDEO_PROCESSOR_CONTENT_DESC* a_desc, ID3D11VideoProcessorEnumerator** a_enum) = 0;
		virtual std::uint32_t GetVideoDecoderProfileCount(void) = 0;
		virtual HRESULT       GetVideoDecoderProfile(std::uint32_t a_index, GUID* a_decoderProfile) = 0;
		virtual HRESULT       CheckVideoDecoderFormat(const GUID* a_decoderProfile, DXGI_FORMAT a_format, BOOL* a_supported) = 0;
		virtual HRESULT       GetVideoDecoderConfigCount(const D3D11_VIDEO_DECODER_DESC* a_desc, std::uint32_t* a_count) = 0;
		virtual HRESULT       GetVideoDecoderConfig(const D3D11_VIDEO_DECODER_DESC* a_desc, std::uint32_t a_index, D3D11_VIDEO_DECODER_CONFIG* a_config) = 0;
		virtual HRESULT       GetContentProtectionCaps(const GUID* a_cryptoType, const GUID* a_decoderProfile, D3D11_VIDEO_CONTENT_PROTECTION_CAPS* a_caps) = 0;
		virtual HRESULT       CheckCryptoKeyExchange(const GUID* a_cryptoType, const GUID* a_decoderProfile, std::uint32_t a_index, GUID* a_keyExchangeType) = 0;
		virtual HRESULT       SetPrivateData(const GUID& a_guid, std::uint32_t a_dataSize, const void* a_data) = 0;
		virtual HRESULT       SetPrivateDataInterface(const GUID& a_guid, const IUnknown* a_data) = 0;
	};

	struct __declspec(novtable, uuid("1D7B0652-185F-41c6-85CE-0C5BE3D4AE6C"))
		ID3D11VideoProcessor : public ID3D11DeviceChild
	{
		virtual void GetContentDesc(D3D11_VIDEO_PROCESSOR_CONTENT_DESC* a_desc) = 0;
		virtual void GetRateConversionCaps(D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS* a_caps) = 0;
	};

	struct __declspec(novtable, uuid("31627037-53AB-4200-9061-05FAA9AB45F9"))
		ID3D11VideoProcessorEnumerator : public ID3D11DeviceChild
	{
		virtual HRESULT GetVideoProcessorContentDesc(D3D11_VIDEO_PROCESSOR_CONTENT_DESC* a_contentDesc) = 0;
		virtual HRESULT CheckVideoProcessorFormat(DXGI_FORMAT a_format, std::uint32_t* a_flags) = 0;
		virtual HRESULT GetVideoProcessorCaps(D3D11_VIDEO_PROCESSOR_CAPS* a_caps) = 0;
		virtual HRESULT GetVideoProcessorRateConversionCaps(std::uint32_t a_typeIndex, D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS* a_caps) = 0;
		virtual HRESULT GetVideoProcessorCustomRate(std::uint32_t a_typeIndex, std::uint32_t a_customRateIndex, D3D11_VIDEO_PROCESSOR_CUSTOM_RATE* a_rate) = 0;
		virtual HRESULT GetVideoProcessorFilterRange(D3D11_VIDEO_PROCESSOR_FILTER a_filter, D3D11_VIDEO_PROCESSOR_FILTER_RANGE* a_range) = 0;
	};

	struct __declspec(novtable, uuid("11EC5A5F-51DC-4945-AB34-6E8C21300EA5"))
		ID3D11VideoProcessorInputView : public ID3D11View
	{
		virtual void GetDesc(D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC* a_desc) = 0;
	};

	struct __declspec(novtable, uuid("A048285E-25A9-4527-BD93-D68B68C44254"))
		ID3D11VideoProcessorOutputView : public ID3D11View
	{
		virtual void GetDesc(D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC* a_desc) = 0;
	};
}

namespace REX::W32
{
	using PFN_D3D11_CREATE_DEVICE = HRESULT(__stdcall*)(IDXGIAdapter*, D3D_DRIVER_TYPE, HMODULE, std::uint32_t, const D3D_FEATURE_LEVEL*, std::uint32_t, std::uint32_t, ID3D11Device**, D3D_FEATURE_LEVEL*, ID3D11DeviceContext**);
	using PFN_D3D11_CREATE_DEVICE_AND_SWAP_CHAIN = HRESULT(__stdcall*)(IDXGIAdapter*, D3D_DRIVER_TYPE, HMODULE, std::uint32_t, const D3D_FEATURE_LEVEL*, std::uint32_t, std::uint32_t, const DXGI_SWAP_CHAIN_DESC*, IDXGISwapChain**, ID3D11Device**, D3D_FEATURE_LEVEL*, ID3D11DeviceContext**);

	HRESULT D3D11CreateDevice(IDXGIAdapter* a_adapter, D3D_DRIVER_TYPE a_driverType, HMODULE a_software, std::uint32_t a_flags, const D3D_FEATURE_LEVEL* a_pFeatureLevels, std::uint32_t a_featureLevels, std::uint32_t a_sdkVersion, ID3D11Device** a_device, D3D_FEATURE_LEVEL* a_pFeatureLevel, ID3D11DeviceContext** a_immediateContext) noexcept;
	HRESULT D3D11CreateDeviceAndSwapChain(IDXGIAdapter* a_adapter, D3D_DRIVER_TYPE a_driverType, HMODULE a_software, std::uint32_t a_flags, const D3D_FEATURE_LEVEL* a_pFeatureLevels, std::uint32_t a_featureLevels, std::uint32_t a_sdkVersion, const DXGI_SWAP_CHAIN_DESC* a_swapChainDesc, IDXGISwapChain** a_swapChain, ID3D11Device** a_device, D3D_FEATURE_LEVEL* a_pFeatureLevel, ID3D11DeviceContext** a_immediateContext) noexcept;
}

namespace REX::W32
{
	inline constexpr IID IID_ID3D11Asynchronous{ 0x4B35D0CD, 0x1E15, 0x4258, { 0x9C, 0x98, 0x1B, 0x13, 0x33, 0xF6, 0xDD, 0x3B } };
	inline constexpr IID IID_ID3D11AuthenticatedChannel{ 0x3015A308, 0xDCBD, 0x47AA, { 0xA7, 0x47, 0x19, 0x24, 0x86, 0xD1, 0x4D, 0x4A } };
	inline constexpr IID IID_ID3D11BlendState{ 0x75B68FAA, 0x347D, 0x4159, { 0x8F, 0x45, 0xA0, 0x64, 0x0F, 0x01, 0xCD, 0x9A } };
	inline constexpr IID IID_ID3D11Buffer{ 0x48570B85, 0xD1EE, 0x4FCD, { 0xA2, 0x50, 0xEB, 0x35, 0x07, 0x22, 0xB0, 0x37 } };
	inline constexpr IID IID_ID3D11ClassInstance{ 0xA6CD7FAA, 0xB0B7, 0x4A2F, { 0x94, 0x36, 0x86, 0x62, 0xA6, 0x57, 0x97, 0xCB } };
	inline constexpr IID IID_ID3D11ClassLinkage{ 0xDDF57CBA, 0x9543, 0x46E4, { 0xA1, 0x2B, 0xF2, 0x07, 0xA0, 0xFE, 0x7F, 0xED } };
	inline constexpr IID IID_ID3D11CommandList{ 0xA24BC4D1, 0x769E, 0x43F7, { 0x80, 0x13, 0x98, 0xFF, 0x56, 0x6C, 0x18, 0xE2 } };
	inline constexpr IID IID_ID3D11ComputeShader{ 0x4F5B196E, 0xC2BD, 0x495E, { 0xBD, 0x01, 0x1F, 0xDE, 0xD3, 0x8E, 0x49, 0x69 } };
	inline constexpr IID IID_ID3D11Counter{ 0x6E8C49FB, 0xA371, 0x4770, { 0xB4, 0x40, 0x29, 0x08, 0x60, 0x22, 0xB7, 0x41 } };
	inline constexpr IID IID_ID3D11CryptoSession{ 0x9B32F9AD, 0xBDCC, 0x40A6, { 0xA3, 0x9D, 0xD5, 0xC8, 0x65, 0x84, 0x57, 0x20 } };
	inline constexpr IID IID_ID3D11Device{ 0xDB6F6DDB, 0xAC77, 0x4E88, { 0x82, 0x53, 0x81, 0x9D, 0xF9, 0xBB, 0xF1, 0x40 } };
	inline constexpr IID IID_ID3D11DeviceChild{ 0x1841E5C8, 0x16B0, 0x489B, { 0xBC, 0xC8, 0x44, 0xCF, 0xB0, 0xD5, 0xDE, 0xAE } };
	inline constexpr IID IID_ID3D11DeviceContext{ 0xC0BFA96C, 0xE089, 0x44FB, { 0x8E, 0xAF, 0x26, 0xF8, 0x79, 0x61, 0x90, 0xDA } };
	inline constexpr IID IID_ID3D11DepthStencilState{ 0x03823EFB, 0x8D8F, 0x4E1C, { 0x9A, 0xA2, 0xF6, 0x4B, 0xB2, 0xCB, 0xFD, 0xF1 } };
	inline constexpr IID IID_ID3D11DepthStencilView{ 0x9FDAC92A, 0x1876, 0x48C3, { 0xAF, 0xAD, 0x25, 0xB9, 0x4F, 0x84, 0xA9, 0xB6 } };
	inline constexpr IID IID_ID3D11DomainShader{ 0xF582C508, 0x0F36, 0x490C, { 0x99, 0x77, 0x31, 0xEE, 0xCE, 0x26, 0x8C, 0xFA } };
	inline constexpr IID IID_ID3D11GeometryShader{ 0x38325B96, 0xEFFB, 0x4022, { 0xBA, 0x02, 0x2E, 0x79, 0x5B, 0x70, 0x27, 0x5C } };
	inline constexpr IID IID_ID3D11HullShader{ 0x8E5C6061, 0x628A, 0x4C8E, { 0x82, 0x64, 0xBB, 0xE4, 0x5C, 0xB3, 0xD5, 0xDD } };
	inline constexpr IID IID_ID3D11InputLayout{ 0xE4819DDC, 0x4CF0, 0x4025, { 0xBD, 0x26, 0x5D, 0xE8, 0x2A, 0x3E, 0x07, 0xB7 } };
	inline constexpr IID IID_ID3D11PixelShader{ 0xEA82E40D, 0x51DC, 0x4F33, { 0x93, 0xD4, 0xDB, 0x7C, 0x91, 0x25, 0xAE, 0x8C } };
	inline constexpr IID IID_ID3D11Predicate{ 0x9EB576DD, 0x9F77, 0x4D86, { 0x81, 0xAA, 0x8B, 0xAB, 0x5F, 0xE4, 0x90, 0xE2 } };
	inline constexpr IID IID_ID3D11Query{ 0xD6C00747, 0x87B7, 0x425E, { 0xB8, 0x4D, 0x44, 0xD1, 0x08, 0x56, 0x0A, 0xFD } };
	inline constexpr IID IID_ID3D11RasterizerState{ 0x9BB4AB81, 0xAB1A, 0x4D8F, { 0xB5, 0x06, 0xFC, 0x04, 0x20, 0x0B, 0x6E, 0xE7 } };
	inline constexpr IID IID_ID3D11RenderTargetView{ 0xDFDBA067, 0x0B8D, 0x4865, { 0x87, 0x5B, 0xD7, 0xB4, 0x51, 0x6C, 0xC1, 0x64 } };
	inline constexpr IID IID_ID3D11Resource{ 0xDC8E63F3, 0xD12B, 0x4952, { 0xB4, 0x7B, 0x5E, 0x45, 0x02, 0x6A, 0x86, 0x2D } };
	inline constexpr IID IID_ID3D11SamplerState{ 0xDA6FEA51, 0x564C, 0x4487, { 0x98, 0x10, 0xF0, 0xD0, 0xF9, 0xB4, 0xE3, 0xA5 } };
	inline constexpr IID IID_ID3D11ShaderResourceView{ 0xB0E06FE0, 0x8192, 0x4E1A, { 0xB1, 0xCA, 0x36, 0xD7, 0x41, 0x47, 0x10, 0xB2 } };
	inline constexpr IID IID_ID3D11Texture1D{ 0xF8FB5C27, 0xC6B3, 0x4F75, { 0xA4, 0xC8, 0x43, 0x9A, 0xF2, 0xEF, 0x56, 0x4C } };
	inline constexpr IID IID_ID3D11Texture2D{ 0x6F15AAF2, 0xD208, 0x4E89, { 0x9A, 0xB4, 0x48, 0x95, 0x35, 0xD3, 0x4F, 0x9C } };
	inline constexpr IID IID_ID3D11Texture3D{ 0x037E866E, 0xF56D, 0x4357, { 0xA8, 0xAF, 0x9D, 0xAB, 0xBE, 0x6E, 0x25, 0x0E } };
	inline constexpr IID IID_ID3D11UnorderedAccessView{ 0x28ACF509, 0x7F5C, 0x48F6, { 0x86, 0x11, 0xF3, 0x16, 0x01, 0x0A, 0x63, 0x80 } };
	inline constexpr IID IID_ID3D11VertexShader{ 0x3B301D64, 0xD678, 0x4289, { 0x88, 0x97, 0x22, 0xF8, 0x92, 0x8B, 0x72, 0xF3 } };
	inline constexpr IID IID_ID3D11VideoContext{ 0x61F21C45, 0x3C0E, 0x4A74, { 0x9C, 0xEA, 0x67, 0x10, 0x0D, 0x9A, 0xD5, 0xE4 } };
	inline constexpr IID IID_ID3D11VideoDecoder{ 0x3C9C5B51, 0x995D, 0x48D1, { 0x9B, 0x8D, 0xFA, 0x5C, 0xAE, 0xDE, 0xD6, 0x5C } };
	inline constexpr IID IID_ID3D11VideoDecoderOutputView{ 0xC2931AEA, 0x2A85, 0x4F20, { 0x86, 0x0F, 0xFB, 0xA1, 0xFD, 0x25, 0x6E, 0x18 } };
	inline constexpr IID IID_ID3D11VideoDevice{ 0x10EC4D5B, 0x975A, 0x4689, { 0xB9, 0xE4, 0xD0, 0xAA, 0xC3, 0x0F, 0xE3, 0x33 } };
	inline constexpr IID IID_ID3D11VideoProcessor{ 0x1D7B0652, 0x185F, 0x41C6, { 0x85, 0xCE, 0x0C, 0x5B, 0xE3, 0xD4, 0xAE, 0x6C } };
	inline constexpr IID IID_ID3D11VideoProcessorEnumerator{ 0x31627037, 0x53AB, 0x4200, { 0x90, 0x61, 0x05, 0xFA, 0xA9, 0xAB, 0x45, 0xF9 } };
	inline constexpr IID IID_ID3D11VideoProcessorInputView{ 0x11EC5A5F, 0x51DC, 0x4945, { 0xAB, 0x34, 0x6E, 0x8C, 0x21, 0x30, 0x0E, 0xA5 } };
	inline constexpr IID IID_ID3D11VideoProcessorOutputView{ 0xA048285E, 0x25A9, 0x4527, { 0xBD, 0x93, 0xD6, 0x8B, 0x68, 0xC4, 0x42, 0x54 } };
	inline constexpr IID IID_ID3D11View{ 0x839D1216, 0xBB2E, 0x412B, { 0xB7, 0xF4, 0xA9, 0xDB, 0xEB, 0xE0, 0x8E, 0xD1 } };
}
