/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class RootBuildCacheControllerRef {
    private BuildCacheController buildCacheController;

    public void set(BuildCacheController buildCacheController) {
        this.buildCacheController = new CloseShieldBuildCacheController(buildCacheController);
    }

    public BuildCacheController getForNonRootBuild() {
        if (!this.isSet()) {
            throw new IllegalStateException("Root build cache controller not yet assigned");
        }
        return this.buildCacheController;
    }

    public boolean isSet() {
        return this.buildCacheController != null;
    }

    private static class CloseShieldBuildCacheController
    implements BuildCacheController {
        private final BuildCacheController delegate;

        private CloseShieldBuildCacheController(BuildCacheController delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        @Override
        public boolean isEmitDebugLogging() {
            return this.delegate.isEmitDebugLogging();
        }

        @Override
        public Optional<BuildCacheLoadResult> load(BuildCacheKey cacheKey, CacheableEntity cacheableEntity) {
            return this.delegate.load(cacheKey, cacheableEntity);
        }

        @Override
        public void store(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, FileSystemSnapshot> snapshots, Duration executionTime) {
            this.delegate.store(cacheKey, entity, snapshots, executionTime);
        }

        @Override
        public void close() {
        }
    }
}

