% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{StackedVlnPlot}
\alias{StackedVlnPlot}
\title{Stacked Violin plot}
\usage{
StackedVlnPlot(
  object,
  features,
  idents = NULL,
  split.by = NULL,
  color.use = NULL,
  colors.ggplot = FALSE,
  angle.x = 90,
  vjust.x = NULL,
  hjust.x = NULL,
  show.text.y = TRUE,
  line.size = NULL,
  pt.size = 0,
  plot.margin = margin(0, 0, 0, 0, "cm"),
  ...
)
}
\arguments{
\item{object}{seurat object}

\item{features}{Features to plot (gene expression, metrics)}

\item{idents}{Which classes to include in the plot (default is all)}

\item{split.by}{Name of a metadata column to split plot by;}

\item{color.use}{defining the color for each cell group}

\item{colors.ggplot}{whether use ggplot color scheme; default: colors.ggplot = FALSE}

\item{angle.x}{angle for x-axis text rotation}

\item{vjust.x}{adjust x axis text}

\item{hjust.x}{adjust x axis text}

\item{show.text.y}{whther show y-axis text}

\item{line.size}{line width in the violin plot}

\item{pt.size}{size of the dots}

\item{plot.margin}{adjust the white space between each plot}

\item{...}{Extra parameters passed to VlnPlot from Seurat package}
}
\value{
ggplot2 object
}
\description{
Stacked Violin plot
}
