% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{barPlot}
\alias{barPlot}
\title{Bar plot for average gene expression}
\usage{
barPlot(
  object,
  features,
  group.by = NULL,
  split.by = NULL,
  color.use = NULL,
  method = c("truncatedMean", "triMean", "median"),
  trim = 0.1,
  assay = "RNA",
  x.lab.rot = FALSE,
  ncol = 1,
  ...
)
}
\arguments{
\item{object}{seurat object}

\item{features}{Features to plot (gene expression, metrics)}

\item{group.by}{Name of one or more metadata columns to group (color) cells by
(for example, orig.ident); pass 'ident' to group by identity class}

\item{split.by}{Name of a metadata column to split plot by;}

\item{color.use}{defining the color for each condition/dataset}

\item{method}{methods for computing the average gene expression per cell group. By default = "truncatedMean", where a value should be assigned to 'trim;}

\item{trim}{the fraction (0 to 0.5) of observations to be trimmed from each end of x before the mean is computed.}

\item{assay}{Name of assay to use, defaults to the active assay}

\item{x.lab.rot}{whether do rotation for the x.tick.label}

\item{ncol}{number of columns to show in the plot}

\item{...}{Extra parameters passed to barplot_internal}
}
\value{
ggplot2 object
}
\description{
Please check \code{\link{barplot_internal}}for detailed description of the arguments.
}
