% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{colorRamp3}
\alias{colorRamp3}
\title{Color interpolation}
\usage{
colorRamp3(breaks, colors, transparency = 0, space = "LAB")
}
\arguments{
\item{breaks}{A vector indicating numeric breaks}

\item{colors}{A vector of colors which correspond to values in ``breaks``}

\item{transparency}{A single value in ``[0, 1]``. 0 refers to no transparency and 1 refers to full transparency}

\item{space}{color space in which colors are interpolated. Value should be one of "RGB", "HSV", "HLS", "LAB", "XYZ", "sRGB", "LUV", see `colorspace::color-class` for detail.}
}
\value{
It returns a function which accepts a vector of numeric values and returns interpolated colors.
}
\description{
This function is modified from https://rdrr.io/cran/circlize/src/R/utils.R
Colors are linearly interpolated according to break values and corresponding colors through CIE Lab color space (`colorspace::LAB`) by default.
Values exceeding breaks will be assigned with corresponding maximum or minimum colors.
}
\examples{
\dontrun{
col_fun = colorRamp3(c(-1, 0, 1), c("green", "white", "red"))
col_fun(c(-2, -1, -0.5, 0, 0.5, 1, 2))
}
}
