% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{computeCellDistance}
\alias{computeCellDistance}
\title{Compute cell-cell distance based on the spatial coordinates}
\usage{
computeCellDistance(
  coordinates,
  interaction.range = NULL,
  ratio = NULL,
  tol = NULL
)
}
\arguments{
\item{coordinates}{a data matrix in which each row gives the spatial locations/coordinates of each cell/spot}

\item{interaction.range}{The maximum interaction/diffusion range of ligands. This hard threshold is used to filter out the connections between spatially distant cells}

\item{ratio}{The conversion factor when converting spatial coordinates from Pixels or other units to Micrometers (i.e.,Microns).

For example, setting `ratio = 0.18` indicates that 1 pixel equals 0.18um in the coordinates.
For 10X visium, it is the ratio of the theoretical spot size (i.e., 65um) over the number of pixels that span the diameter of a theoretical spot size in the full-resolution image (i.e., 'spot.size.fullres' in the 'scalefactors_json.json' file).}

\item{tol}{The tolerance factor to increase the robustness when comparing the center-to-center distance against the `interaction.range`. This can be the half value of cell/spot size in the unit of um.

For example, for 10X visium, `tol` can be set as `65/2`; for slide-seq, `tol` can be set as `10/2`.
If the cell/spot size is not known, we provide a function `computeCellDistance` to compute the center-to-center distance. `tol` can be the the half value of the minimum center-to-center distance.}
}
\value{
an object of class "dist" giving the pairwise cell-cell distance
}
\description{
Compute cell-cell distance based on the spatial coordinates
}
