% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{computeCommunProb}
\alias{computeCommunProb}
\title{Compute the communication probability/strength between any interacting cell groups}
\usage{
computeCommunProb(
  object,
  type = c("triMean", "truncatedMean", "thresholdedMean", "median"),
  trim = 0.1,
  LR.use = NULL,
  raw.use = TRUE,
  population.size = FALSE,
  distance.use = TRUE,
  interaction.range = 250,
  scale.distance = 0.01,
  k.min = 10,
  contact.dependent = TRUE,
  contact.range = NULL,
  contact.knn.k = NULL,
  contact.dependent.forced = FALSE,
  do.symmetric = TRUE,
  nboot = 100,
  seed.use = 1L,
  Kh = 0.5,
  n = 1
)
}
\arguments{
\item{object}{CellChat object}

\item{type}{Methods for computing the average gene expression per cell group. By default = "triMean", producing fewer but stronger interactions;
When setting `type = "truncatedMean"`, a value should be assigned to 'trim',  producing more interactions.}

\item{trim}{the fraction (0 to 0.25) of observations to be trimmed from each end of x before the mean is computed}

\item{LR.use}{A subset of ligand-receptor interactions used in inferring communication network}

\item{raw.use}{Whether use the raw data (i.e., `object@data.signaling`) or the smoothed data (i.e., `object@data.smooth`).
Set raw.use = FALSE to use the projected data when analyzing single-cell data with shallow sequencing depth because the projected data could help to reduce the dropout effects of signaling genes, in particular for possible zero expression of subunits of ligands/receptors.}

\item{population.size}{Whether consider the proportion of cells in each group across all sequenced cells.
Set population.size = FALSE if analyzing sorting-enriched single cells, to remove the potential artifact of population size.
Set population.size = TRUE if analyzing unsorted single-cell transcriptomes, with the reason that abundant cell populations tend to send collectively stronger signals than the rare cell populations.

Parameters for spatial data analysis:}

\item{distance.use}{Whether to use distance constraints to compute communication probability. Setting `distance.use = TRUE` indicates that the cell-cell communication probability is inversely proportional to the computed distance.
Setting `distance.use = FALSE` will only filter out interactions between spatially distant regions, but not add distance constraints.}

\item{interaction.range}{The maximum interaction/diffusion length of ligands (Unit: microns). This hard threshold is used to filter out the connections between spatially distant regions}

\item{scale.distance}{A scale or normalization factor for the spatial distances when setting `distance.use = TRUE`. For example, scale.distance equals 1, 0.1, 0.01, 0.001, 0.11, or 0.011. We choose this values such that the minimum value of the scaled distances is in [1,2]. This value is not necessary when setting `distance.use = FALSE`.

When comparing communication across different CellChat objects, the same scale factor should be used. For a single CellChat analysis, different scale factors will not affect the ranking of the signaling based on their interaction strength.}

\item{k.min}{The minimum number of interacting cell pairs required for defining spatially proximal cell groups.}

\item{contact.dependent}{Whether using the `contact-dependent` manner for inference signaling, that is determining interacting cell pairs by requiring cells to be in direct membrane-membrane contact. By default `contact.dependent = TRUE` when inferring contact-dependent and juxtacrine signaling (that is "Cell-Cell Contact" signaling classified in CellChatDB$interaction$annotation).
If only focusing on `Secreted Signaling`, the `contact-dependent` manner will be not used except for setting `contact.dependent.forced = TRUE`.}

\item{contact.range}{The interaction range (Unit: microns) to restrict the contact-dependent signaling when `contact.dependent = TRUE`.
For spatial transcriptomics in a single-cell resolution, `contact.range` is approximately equal to the estimated cell diameter (i.e., the cell center-to-center distance), which means that contact-dependent and juxtacrine signaling can only happens when the two cells are contact to each other.

Typically, `contact.range = 10`, which is a typical human cell size. However, for low-resolution spatial data such as 10X visium, it should be the cell center-to-center distance (i.e., `contact.range = 100` for visium data).  The function `computeCellDistance` can compute the center-to-center distance.}

\item{contact.knn.k}{Number of neighbors to restrict the contact-dependent signaling within the neatest neighbors when `contact.dependent = TRUE`. By default, CellChat uses `contact.range` to restrict the contact-dependent signaling; however, users can also provide a value of `contact.knn.k`, in order to determine interacting cell pairs based on the k-nearest neighbors (knn).
For 10X visium, contact.knn.k = 6. For other spatial technologies, this value may be hard to determine because the sequenced cells/spots are usually not regularly arranged.}

\item{contact.dependent.forced}{Whether forcing to use the `contact-dependent` manner for inference signaling for all L-R pairs including secreted signaling. Users can set `contact.dependent.forced = TRUE` if also preferring interactions within a contact manner for `Secreted Signaling`.}

\item{do.symmetric}{Whether converting the adjacent matrix into symmetric one when determining spatially proximal cell groups. Default is TRUE, indicating that if adj(i,j) or adj(j,i) is zero, then both are zeros.}

\item{nboot}{Threshold of p-values}

\item{seed.use}{Set a random seed. By default, set the seed to 1.}

\item{Kh}{Parameter in Hill function}

\item{n}{Parameter in Hill function}
}
\value{
A CellChat object with updated slot 'net':

object@net$prob is the inferred communication probability (strength) array, where the first, second and third dimensions represent a source, target and ligand-receptor pair, respectively.

USER can access all the inferred cell-cell communications using the function 'subsetCommunication(object)', which returns a data frame.

object@net$pval is the corresponding p-values of each interaction
}
\description{
To further speed up on large-scale datasets, USER can downsample the data using the function 'subset' from Seurat package (e.g., pbmc.small <- subset(pbmc, downsample = 500)), or using the function `sketchData` from CellChat, in particular for the large cell clusters;
}
