% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{computeRegionDistance}
\alias{computeRegionDistance}
\title{Compute the region distance based on the spatial locations of each splot/cell of the spatial transcriptomics}
\usage{
computeRegionDistance(
  coordinates,
  meta,
  interaction.range = NULL,
  ratio = NULL,
  tol = NULL,
  k.min = 10,
  contact.dependent = TRUE,
  contact.range = NULL,
  contact.knn.k = NULL,
  do.symmetric = TRUE
)
}
\arguments{
\item{coordinates}{a data matrix in which each row gives the spatial locations/coordinates of each cell/spot}

\item{meta}{a data frame including at least two columns named `group` and `samples`. `meta$group` is a factor vector defining the regions/labels of each cell/spot. `meta$samples` is a factor vector defining the sample labels of each dataset.}

\item{interaction.range}{The maximum interaction/diffusion range of ligands. This hard threshold is used to filter out the connections between spatially distant regions}

\item{ratio}{a numerical vector giving the conversion factor when converting spatial coordinates from Pixels or other units to Micrometers (i.e.,Microns).

For example, setting `ratio = 0.18` indicates that 1 pixel equals 0.18um in the coordinates.
For 10X visium, it is the ratio of the theoretical spot size (i.e., 65um) over the number of pixels that span the diameter of a theoretical spot size in the full-resolution image (i.e., 'spot.size.fullres' in the 'scalefactors_json.json' file).}

\item{tol}{a numerical vector giving the tolerance factor to increase the robustness when comparing the center-to-center distance against the `interaction.range`. This can be the half value of cell/spot size in the unit of um.

For example, for 10X visium, `tol` can be set as `65/2`; for slide-seq, `tol` can be set as `10/2`.
If the cell/spot size is not known, we provide a function `computeCellDistance` to compute the center-to-center distance. `tol` can be the the half value of the minimum center-to-center distance.}

\item{k.min}{the minimum number of interacting cell pairs required for defining adjacent cell groups}

\item{contact.dependent}{Whether determining spatially proximal cell groups based on either the contact.range or the k-nearest neighbors (knn). By default `contact.dependent = TRUE` when inferring contact-dependent and juxtacrine signaling (including ECM-Receptor and Cell-Cell Contact signaling classified in CellChatDB$interaction$annotation).
If only focusing on `Secreted Signaling`, the `contact.dependent` will be automatically set as FALSE except for `contact.dependent.forced = TRUE`.}

\item{contact.range}{The interaction range (Unit: microns) to restrict the contact-dependent signaling.
For spatial transcriptomics in a single-cell resolution, `contact.range` is approximately equal to the estimated cell diameter (i.e., the cell center-to-center distance), which means that contact-dependent and juxtacrine signaling can only happens when the two cells are contact to each other.

Typically, `contact.range = 10`, which is a typical human cell size. However, for low-resolution spatial data such as 10X visium, it should be the cell center-to-center distance (i.e., `contact.range = 100` for visium data). The function `computeCellDistance` can compute the center-to-center distance.}

\item{contact.knn.k}{Number of neighbors to restrict the contact-dependent signaling within the neatest neighbors. By default, CellChat uses `contact.range` to restrict the contact-dependent signaling; however, users can also provide a value of `contact.knn.k`, in order to determine spatially proximal cell groups based on the k-nearest neighbors (knn).
For 10X visium, contact.knn.k = 6. For other spatial technologies, this value may be hard to determine because the sequenced cells/spots are usually not regularly arranged.}

\item{do.symmetric}{Whether converting the adjacent matrix into symmetric one when determining spatially proximal cell groups. Default is TRUE, indicating that if adj(i,j) or adj(j,i) is zero, then both are zeros.}
}
\value{
A list including a square matrix giving the pairwise region distances and an adjacent matrix indicating physically contacting cell groups based on either the contact.range or the k-nearest neighbors
}
\description{
Compute the region distance based on the spatial locations of each splot/cell of the spatial transcriptomics
}
