% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{getMaxWeight}
\alias{getMaxWeight}
\title{Compute the maximum value of certain measures in the inferred cell-cell communication networks}
\usage{
getMaxWeight(
  object.list,
  slot.name = c("idents", "net"),
  attribute = c("idents", "count")
)
}
\arguments{
\item{object.list}{List of CellChat objects}

\item{slot.name}{the slot name of object that is used to compute the maximum value.

When slot.name = "idents", 'attribute' should be "idents", which will compute the maximum number of cells per cell group across all datasets

When slot.name = "net", 'attribute' can be either "count" or "weight", which will compute he maximum number of interactions (or interaction weights) across all datasets

When slot.name = "net" or "netP", 'attribute' can be a single pathway name or a ligand-receptor pair name}

\item{attribute}{the attribute to compute the maximum values. `attribute` should have the same length as `slot.name`.

`attribute` can only be "count", "weight","count.merged","weight.merged" or a single pathway name or a ligand-receptor pair name}
}
\value{
A numeric vector
}
\description{
To better control the node size and edge weights of the inferred networks across different datasets,
we compute the maximum number of cells per cell group and the maximum number of interactions (or interaction weights) across all datasets
}
