% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{identifyEnrichedInteractions}
\alias{identifyEnrichedInteractions}
\title{Identify all the significant interactions (L-R pairs) from some cell groups to other cell groups}
\usage{
identifyEnrichedInteractions(
  object,
  from,
  to,
  bidirection = FALSE,
  pair.only = TRUE,
  pairLR.use0 = NULL,
  thresh = 0.05
)
}
\arguments{
\item{object}{CellChat object}

\item{from}{a vector giving the index or the name of source cell groups}

\item{to}{a corresponding vector giving the index or the name of target cell groups. Note: The length of 'from' and 'to' must be the same, giving the corresponding pair of cell groups for communication.}

\item{bidirection}{whether show the bidirectional communication, i.e., both 'from'->'to' and 'to'->'from'.}

\item{pair.only}{whether only return ligand-receptor pairs without pathway names and communication strength}

\item{pairLR.use0}{ligand-receptor pairs to use; default is all the significant interactions}

\item{thresh}{threshold of the p-value for determining significant interaction}
}
\description{
Identify all the significant interactions (L-R pairs) from some cell groups to other cell groups
}
