% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{identifyOverExpressedGenes}
\alias{identifyOverExpressedGenes}
\title{Identify over-expressed signaling genes associated with each cell group}
\usage{
identifyOverExpressedGenes(
  object,
  data.use = NULL,
  group.by = NULL,
  idents.use = NULL,
  invert = FALSE,
  group.dataset = NULL,
  pos.dataset = NULL,
  group.DE.combined = FALSE,
  features.name = "features",
  only.pos = TRUE,
  features = NULL,
  return.object = TRUE,
  thresh.pc = 0,
  thresh.fc = 0,
  thresh.p = 0.05,
  do.DE = TRUE,
  do.fast = TRUE,
  min.cells = 10
)
}
\arguments{
\item{object}{CellChat object}

\item{data.use}{a customed data matrix. Default: data.use = NULL and the expression matrix in the slot 'data.signaling' is used}

\item{group.by}{cell group information; default is `object@idents`; otherwise it should be one of the column names of the meta slot}

\item{idents.use}{a subset of cell groups used for analysis}

\item{invert}{whether to invert the idents.use}

\item{group.dataset}{dataset origin information in a merged CellChat object; set it as one of the column names of meta slot when identifying the highly enriched genes in one dataset for each cell group}

\item{pos.dataset}{the dataset name used for identifying highly enriched genes in this dataset for each cell group}

\item{group.DE.combined}{Whether to perform differential expression between conditions by ignoring cell group information. By default, group.DE.combined = FALSE, which will perform differential expression analysis between two biological conditions for each cell group;
When group.DE.combined = TRUE, it will perform DE analysis by combining all cell groups together.}

\item{features.name}{a char name used for storing the over-expressed signaling genes in `object@var.features[[features.name]]`}

\item{only.pos}{Only return positive markers}

\item{features}{features used for identifying Over Expressed genes. default use all features}

\item{return.object}{whether to return the object; otherwise return a data frame consisting of over-expressed signaling genes associated with each cell group}

\item{thresh.pc}{Threshold of the fraction of cells expressed in one cluster, i.e., thresh.pc = 0.1}

\item{thresh.fc}{Threshold of Log Fold Change, i.e., thresh.pc = 0.1}

\item{thresh.p}{Threshold of p-values, i.e., thresh.pc = 0.05}

\item{do.DE}{Whether to perform differential expression analysis. By default do.DE = TRUE; When do.DE = FALSE, selecting over-expressed genes that are expressed in more than `min.cells` cells.}

\item{do.fast}{If do.fast = TRUE, then perform a ultra-fast Wilcoxon test using presto package; otherwise using stats package. These two methods produce different logFC values, and the presto::wilcoxauc method gives smaller values.}

\item{min.cells}{the minmum number of expressed cells required for the genes that are considered for cell-cell communication analysis}
}
\value{
A CellChat object or a data frame. If returning a CellChat object, two new elements named 'features.name' and paste0(features.name, ".info") will be added into the list `object@var.features`
`object@var.features[[features.name]]` is a vector consisting of the identified over-expressed signaling genes;
`object@var.features[[paste0(features.name, ".info")]]` is a data frame returned from the differential expression analysis
}
\description{
USERS can use customized gene set as over-expressed signaling genes by setting `object@var.features[[features.name]] <- features.sig`
The Bonferroni corrected/adjusted p value can be obtained via `object@var.features[[paste0(features.name, ".info")]]`. Note that by default `features.name = "features"`
}
