% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{identifyOverExpressedInteractions}
\alias{identifyOverExpressedInteractions}
\title{Identify over-expressed ligand-receptor interactions (pairs) within the used CellChatDB}
\usage{
identifyOverExpressedInteractions(
  object,
  features.name = "features",
  variable.both = TRUE,
  features = NULL,
  return.object = TRUE
)
}
\arguments{
\item{object}{CellChat object}

\item{features.name}{a char name used for assess the results in `object@var.features[[features.name]]`}

\item{variable.both}{variable.both = TRUE will require that both ligand and receptor from one pair are over-expressed;

variable.both = FALSE will only require that either ligand or receptor from one pair is over-expressed, leading to more over-expressed ligand-receptor interactions (pairs) for further analysis.}

\item{features}{a vector of features to use. default use all over-expressed genes in `object@var.features[[features.name]]`}

\item{return.object}{whether returning a CellChat object. If FALSE, it will return a data frame containing the over-expressed ligand-receptor pairs}
}
\value{
A CellChat object or a data frame. If returning a CellChat object, a new element named 'LRsig' will be added into the list `object@LR`
}
\description{
Identify over-expressed ligand-receptor interactions (pairs) within the used CellChatDB
}
