% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{netAnalysis_dot}
\alias{netAnalysis_dot}
\title{Dot plots showing the associations of latent patterns with cell groups and ligand-receptor pairs or signaling pathways}
\usage{
netAnalysis_dot(
  object,
  slot.name = "netP",
  pattern = c("outgoing", "incoming"),
  cutoff = NULL,
  color.use = NULL,
  pathway.show = NULL,
  group.show = NULL,
  shape = 21,
  dot.size = c(1, 3),
  dot.alpha = 1,
  main.title = NULL,
  font.size = 10,
  font.size.title = 12
)
}
\arguments{
\item{object}{CellChat object}

\item{slot.name}{the slot name of object that is used to compute centrality measures of signaling networks}

\item{pattern}{"outgoing" or "incoming"}

\item{cutoff}{the threshold for filtering out weak links. Default is 1/R where R is the number of latent patterns. We set the elements in W and H to be zero if they are less than `cutoff`.}

\item{color.use}{the character vector defining the color of each cell group}

\item{pathway.show}{the character vector defining the signaling to show}

\item{group.show}{the character vector defining the cell group to show}

\item{shape}{the shape of the symbol: 21 for circle and 22 for square}

\item{dot.size}{a range defining the size of the symbol}

\item{dot.alpha}{transparency}

\item{main.title}{the title of plot}

\item{font.size}{font size of the text}

\item{font.size.title}{font size of the title}
}
\description{
Using a contribution score of each cell group to each signaling pathway computed by multiplying W by H obtained from `identifyCommunicationPatterns`, we constructed a dot plot in which the dot size is proportion to the contribution score to show association between cell group and their enriched signaling pathways.
}
