% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{netAnalysis_river}
\alias{netAnalysis_river}
\title{River plot showing the associations of latent patterns with cell groups and ligand-receptor pairs or signaling pathways}
\usage{
netAnalysis_river(
  object,
  slot.name = "netP",
  pattern = c("outgoing", "incoming"),
  cutoff = 0.5,
  sources.use = NULL,
  targets.use = NULL,
  signaling = NULL,
  color.use = NULL,
  color.use.pattern = NULL,
  color.use.signaling = "grey50",
  do.order = FALSE,
  main.title = NULL,
  font.size = 2.5,
  font.size.title = 12
)
}
\arguments{
\item{object}{CellChat object}

\item{slot.name}{the slot name of object: “netP” or “net”. Use “netP” to analyze cell-cell communication at the level of signaling pathways, and “net” to analyze cell-cell communication at the level of ligand-receptor pairs.}

\item{pattern}{"outgoing" or "incoming"}

\item{cutoff}{the threshold for filtering out weak links}

\item{sources.use}{a vector giving the index or the name of source cell groups of interest}

\item{targets.use}{a vector giving the index or the name of target cell groups of interest}

\item{signaling}{a character vector giving the name of signaling pathways of interest}

\item{color.use}{the character vector defining the color of each cell group}

\item{color.use.pattern}{the character vector defining the color of each pattern}

\item{color.use.signaling}{the character vector defining the color of each signaling}

\item{do.order}{whether reorder the cell groups or signaling according to their similarity}

\item{main.title}{the title of plot}

\item{font.size}{font size of the text}

\item{font.size.title}{font size of the title}
}
\description{
River (alluvial) plot shows the correspondence between the inferred latent patterns and cell groups as well as ligand-receptor pairs or signaling pathways.
}
\details{
The thickness of the flow indicates the contribution of the cell group or signaling pathway to each latent pattern. The height of each pattern is proportional to the number of its associated cell groups or signaling pathways.

Outgoing patterns reveal how the sender cells coordinate with each other as well as how they coordinate with certain signaling pathways to drive communication.

Incoming patterns show how the target cells coordinate with each other as well as how they coordinate with certain signaling pathways to respond to incoming signaling.
}
