% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{netAnalysis_signalingChanges_scatter}
\alias{netAnalysis_signalingChanges_scatter}
\title{2D visualization of differential outgoing and incoming signaling associated with one cell group}
\usage{
netAnalysis_signalingChanges_scatter(
  object,
  idents.use,
  color.use = c("grey10", "#F8766D", "#00BFC4"),
  comparison = c(1, 2),
  signaling = NULL,
  signaling.label = NULL,
  top.label = 1,
  signaling.exclude = NULL,
  xlims = NULL,
  ylims = NULL,
  slot.name = "netP",
  dot.size = 2.5,
  point.shape = c(21, 22, 24, 23),
  label.size = 3,
  dot.alpha = 0.6,
  x.measure = "outdeg",
  y.measure = "indeg",
  xlabel = "Differential outgoing interaction strength",
  ylabel = "Differential incoming interaction strength",
  title = NULL,
  font.size = 10,
  font.size.title = 10,
  do.label = T,
  show.legend = T,
  show.axes = T
)
}
\arguments{
\item{object}{A merged CellChat object of a list of CellChat objects}

\item{idents.use}{the cell group names of interest. Should be one of `levels(object@idents$joint)`}

\item{color.use}{a vector with three elements: the first is for coloring shared pathways, the second is for specific pathways in the first dataset, and the third is for specific pathways in the second dataset}

\item{comparison}{an index vector giving the two datasets for comparison}

\item{signaling}{a char vector containing signaling pathway names. signaling = NULL: Signaling role analysis on the aggregated cell-cell communication network from all signaling pathways}

\item{signaling.label}{a char vector giving the signaling names to show when labeling each point}

\item{top.label}{the fraction of signaling pathways to label}

\item{signaling.exclude}{signaling pathways to exclude when plotting}

\item{xlims, ylims}{set x-Axis and y-Axis Limits for zoom into the plot. e.g., xlims = c(-0.05, 0.1), ylims = c(-0.01, 0.035)}

\item{slot.name}{the slot name of object}

\item{dot.size}{the size of the symbol}

\item{point.shape}{point shape}

\item{label.size}{font size of the text}

\item{dot.alpha}{transparency}

\item{x.measure}{The measure used as x-axis. This measure should be one of `names(slot(object, slot.name)$centr[[1]])` computed from `netAnalysis_computeCentrality`

Default = "outdeg" is the weighted outgoing links (i.e., Outgoing interaction strength). If setting as "outdeg_unweighted", it represents the total number of outgoing signaling.}

\item{y.measure}{The measure used as y-axis. This measure should be one of `names(slot(object, slot.name)$centr[[1]])` computed from `netAnalysis_computeCentrality`

Default = "indeg" is the weighted incoming links (i.e., Incoming interaction strength). If setting as "indeg_unweighted", it represents the total number of incoming signaling.}

\item{xlabel}{label of x-axis}

\item{ylabel}{label of y-axis}

\item{title}{main title of the plot}

\item{font.size}{font size of the text}

\item{font.size.title}{font size of the title}

\item{do.label}{label the each point}

\item{show.legend}{whether show the legend}

\item{show.axes}{whether show the axes}
}
\value{
ggplot object
}
\description{
Positive values indicate the increase in the second dataset while negative values indicate the increase in the first dataset
}
