% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{netAnalysis_signalingRole_heatmap}
\alias{netAnalysis_signalingRole_heatmap}
\title{Heatmap showing the contribution of signals (signaling pathways or ligand-receptor pairs) to cell groups in terms of outgoing or incoming signaling}
\usage{
netAnalysis_signalingRole_heatmap(
  object,
  signaling = NULL,
  pattern = c("outgoing", "incoming", "all"),
  slot.name = "netP",
  color.use = NULL,
  color.heatmap = "BuGn",
  title = NULL,
  width = 10,
  height = 8,
  ylim.top = NULL,
  ylim.right = NULL,
  font.size = 8,
  font.size.title = 10,
  cluster.rows = FALSE,
  cluster.cols = FALSE
)
}
\arguments{
\item{object}{CellChat object}

\item{signaling}{a character vector giving the names of signaling networks of interest}

\item{pattern}{this parameter can be set as "outgoing", "incoming" or "all". When pattern = "all", CellChat aggregates the outgoing and incoming signaling strength together;}

\item{slot.name}{the slot name of object that is used to examine the signaling patterns at the level of signaling pathways (slot.name = "netP") or ligand-receptor pairs (slot.name = "net");}

\item{color.use}{the character vector defining the color of each cell group}

\item{color.heatmap}{a color name in brewer.pal}

\item{title}{title name}

\item{width}{width of heatmap}

\item{height}{height of heatmap}

\item{ylim.top}{set the range of the top barplot (e.g., ylim.top = c(0, 4))}

\item{ylim.right}{set the range of the right barplot (e.g., ylim.right = c(0, 5))}

\item{font.size}{fontsize in heatmap}

\item{font.size.title}{font size of the title}

\item{cluster.rows}{whether cluster rows}

\item{cluster.cols}{whether cluster columns}
}
\description{
In this heatmap, colobar represents the relative signaling strength of a signaling pathway across cell groups (NB: values are row-scaled).
The top colored bar plot shows the total signaling strength of a cell group by summarizing all signaling pathways displayed in the heatmap.
The right grey bar plot shows the total signaling strength of a signaling pathway by summarizing all cell groups displayed in the heatmap.
}
