% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{netAnalysis_signalingRole_scatter}
\alias{netAnalysis_signalingRole_scatter}
\title{2D visualization of dominant senders (sources) and receivers (targets)}
\usage{
netAnalysis_signalingRole_scatter(
  object,
  signaling = NULL,
  color.use = NULL,
  slot.name = "netP",
  group = NULL,
  weight.MinMax = NULL,
  dot.size = c(2, 6),
  point.shape = c(21, 22, 24, 23, 25, 8, 3),
  label.size = 3,
  dot.alpha = 0.6,
  x.measure = "outdeg",
  y.measure = "indeg",
  xlabel = "Outgoing interaction strength",
  ylabel = "Incoming interaction strength",
  title = NULL,
  font.size = 10,
  font.size.title = 10,
  do.label = T,
  show.legend = T,
  show.axes = T
)
}
\arguments{
\item{object}{CellChat object}

\item{signaling}{a char vector containing signaling pathway names. signaling = NULL: signaling role analysis on the aggregated cell-cell communication network from all signaling pathways}

\item{color.use}{defining the color for each cell group}

\item{slot.name}{the slot name of object that is used to compute centrality measures of signaling networks}

\item{group}{a vector to categorize the cell groups, e.g., categorize the cell groups into two major categories: immune cells and fibroblasts}

\item{weight.MinMax}{the Minmum/maximum weight, which is useful to control the dot size when comparing multiple datasets}

\item{dot.size}{a range defining the size of the symbol}

\item{point.shape}{point shape when group is not NULL}

\item{label.size}{font size of the text}

\item{dot.alpha}{transparency}

\item{x.measure}{The measure used as x-axis. This measure should be one of `names(slot(object, slot.name)$centr[[1]])` computed from `netAnalysis_computeCentrality`

Default = "outdeg" is the weighted outgoing links (i.e., outgoing interaction strength). If setting as "outdeg_unweighted", it represents the total number of outgoing signaling.}

\item{y.measure}{The measure used as y-axis. This measure should be one of `names(slot(object, slot.name)$centr[[1]])` computed from `netAnalysis_computeCentrality`

Default = "indeg" is the weighted incoming links (i.e., incoming interaction strength). If setting as "indeg_unweighted", it represents the total number of incoming signaling.}

\item{xlabel}{label of x-axis}

\item{ylabel}{label of y-axis}

\item{title}{main title of the plot}

\item{font.size}{font size of the text}

\item{font.size.title}{font size of the title}

\item{do.label}{label the each point}

\item{show.legend}{whether show the legend}

\item{show.axes}{whether show the axes}
}
\value{
ggplot object
}
\description{
This scatter plot shows the dominant senders (sources) and receivers (targets) in a 2D space.
x-axis and y-axis are respectively the total outgoing or incoming communication probability associated with each cell group.
Dot size is proportional to the number of inferred links (both outgoing and incoming) associated with each cell group.
Dot colors indicate different cell groups. Dot shapes indicate different categories of cell groups if `group`` is defined.
}
