% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{netClustering}
\alias{netClustering}
\title{Classification learning of the signaling networks}
\usage{
netClustering(
  object,
  slot.name = "netP",
  type = c("functional", "structural"),
  comparison = NULL,
  k = NULL,
  methods = "kmeans",
  do.plot = TRUE,
  fig.id = NULL,
  do.parallel = TRUE,
  nCores = 4,
  k.eigen = NULL
)
}
\arguments{
\item{object}{CellChat object}

\item{slot.name}{the slot name of object that is used to compute centrality measures of signaling networks}

\item{type}{"functional","structural"}

\item{comparison}{a numerical vector giving the datasets for comparison. No need to define for a single dataset. Default are all datasets when object is a merged object}

\item{k}{the number of signaling groups when running kmeans}

\item{methods}{the methods for clustering: "kmeans" or "spectral"}

\item{do.plot}{whether showing the eigenspectrum for inferring number of clusters; Default will save the plot}

\item{fig.id}{add a unique figure id when saving the plot}

\item{do.parallel}{whether doing parallel when inferring the number of signaling groups when running kmeans}

\item{nCores}{number of workers when doing parallel}

\item{k.eigen}{the number of eigenvalues used when doing spectral clustering}
}
\description{
Classification learning of the signaling networks
}
