% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{netVisual_aggregate}
\alias{netVisual_aggregate}
\title{Visualize the inferred signaling network of signaling pathways by aggregating all L-R pairs}
\usage{
netVisual_aggregate(
  object,
  signaling,
  signaling.name = NULL,
  color.use = NULL,
  thresh = 0.05,
  vertex.receiver = NULL,
  sources.use = NULL,
  targets.use = NULL,
  idents.use = NULL,
  top = 1,
  remove.isolate = FALSE,
  vertex.weight = 1,
  vertex.weight.max = NULL,
  vertex.size.max = NULL,
  weight.scale = TRUE,
  edge.weight.max = NULL,
  edge.width.max = 8,
  layout = c("circle", "hierarchy", "chord", "spatial"),
  pt.title = 12,
  title.space = 6,
  vertex.label.cex = 0.8,
  sample.use = NULL,
  alpha.image = 0.15,
  point.size = 1.5,
  group = NULL,
  cell.order = NULL,
  small.gap = 1,
  big.gap = 10,
  scale = FALSE,
  reduce = -1,
  show.legend = FALSE,
  legend.pos.x = 20,
  legend.pos.y = 20,
  ...
)
}
\arguments{
\item{object}{CellChat object}

\item{signaling}{a signaling pathway name}

\item{signaling.name}{alternative signaling pathway name to show on the plot}

\item{color.use}{the character vector defining the color of each cell group}

\item{thresh}{threshold of the p-value for determining significant interaction}

\item{vertex.receiver}{a numeric vector giving the index of the cell groups as targets in the first hierarchy plot}

\item{sources.use}{a vector giving the index or the name of source cell groups}

\item{targets.use}{a vector giving the index or the name of target cell groups.}

\item{idents.use}{a vector giving the index or the name of cell groups of interest.}

\item{top}{the fraction of interactions to show}

\item{remove.isolate}{whether remove the isolate nodes in the communication network}

\item{vertex.weight}{The weight of vertex: either a scale value or a vector

Default is a scale value being 1, indicating all vertex is plotted in the same size;

Set `vertex.weight` as a vector to plot vertex in different size; setting `vertex.weight = NULL` will have vertex with different size that are portional to the number of cells in each cell group.}

\item{vertex.weight.max}{the maximum weight of vertex; defualt = max(vertex.weight)}

\item{vertex.size.max}{the maximum vertex size for visualization}

\item{weight.scale}{whether scale the edge weight}

\item{edge.weight.max}{the maximum weight of edge; defualt = max(net)}

\item{edge.width.max}{The maximum edge width for visualization}

\item{layout}{"hierarchy", "circle", "chord" or "spatial"}

\item{pt.title}{font size of the text}

\item{title.space}{the space between the title and plot}

\item{vertex.label.cex}{The label size of vertex in the network

Parameters below are set for "spatial" diagram. Please also check the function `netVisual_spatial` for more parameters.}

\item{sample.use}{the sample used for visualization, which should be the element in `object@meta$samples`.}

\item{alpha.image}{the transparency of individual spots}

\item{point.size}{the size of spots

Parameters below are set for "chord" diagram. Please also check the function `netVisual_chord_cell` for more parameters.}

\item{group}{A named group labels for making multiple-group Chord diagrams. The sector names should be used as the names in the vector.
The order of group controls the sector orders and if group is set as a factor, the order of levels controls the order of groups.}

\item{cell.order}{a char vector defining the cell type orders (sector orders)}

\item{small.gap}{Small gap between sectors.}

\item{big.gap}{Gap between the different sets of sectors, which are defined in the `group` parameter}

\item{scale}{scale each sector to same width; default = FALSE; however, it is set to be TRUE when remove.isolate = TRUE}

\item{reduce}{if the ratio of the width of certain grid compared to the whole circle is less than this value, the grid is removed on the plot. Set it to value less than zero if you want to keep all tiny grid.}

\item{show.legend}{whether show the figure legend}

\item{legend.pos.x, legend.pos.y}{adjust the legend position}

\item{...}{other parameters (e.g.,vertex.label.cex, vertex.label.color, alpha.edge, label.edge, edge.label.color, edge.label.cex, edge.curved, text.x,text.y)
passing to `netVisual_hierarchy1`,`netVisual_hierarchy2`,`netVisual_circle`,`netVisual_spatial`. NB: some parameters might be not supported}
}
\value{
an object of class "recordedplot" or ggplot
}
\description{
Visualize the inferred signaling network of signaling pathways by aggregating all L-R pairs
}
