% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{netVisual_chord_cell}
\alias{netVisual_chord_cell}
\title{Chord diagram for visualizing cell-cell communication for a signaling pathway}
\usage{
netVisual_chord_cell(
  object,
  signaling = NULL,
  net = NULL,
  slot.name = "netP",
  color.use = NULL,
  group = NULL,
  cell.order = NULL,
  sources.use = NULL,
  targets.use = NULL,
  lab.cex = 0.8,
  small.gap = 1,
  big.gap = 10,
  annotationTrackHeight = c(0.03),
  remove.isolate = FALSE,
  link.visible = TRUE,
  scale = FALSE,
  directional = 1,
  link.target.prop = TRUE,
  reduce = -1,
  transparency = 0.4,
  link.border = NA,
  title.name = NULL,
  show.legend = FALSE,
  legend.pos.x = 20,
  legend.pos.y = 20,
  nCol = NULL,
  thresh = 0.05,
  ...
)
}
\arguments{
\item{object}{CellChat object}

\item{signaling}{a character vector giving the name of signaling networks}

\item{net}{a weighted matrix or a data frame with three columns defining the cell-cell communication network}

\item{slot.name}{the slot name of object: slot.name = "net" when visualizing cell-cell communication network per each ligand-receptor pair associated with a given signaling pathway;
slot.name = "netP" when visualizing cell-cell communication network at the level of signaling pathways}

\item{color.use}{colors for the cell groups}

\item{group}{A named group labels for making multiple-group Chord diagrams. The sector names should be used as the names in the vector.
The order of group controls the sector orders and if group is set as a factor, the order of levels controls the order of groups.}

\item{cell.order}{a char vector defining the cell type orders (sector orders)}

\item{sources.use}{a vector giving the index or the name of source cell groups}

\item{targets.use}{a vector giving the index or the name of target cell groups.}

\item{lab.cex}{font size for the text}

\item{small.gap}{Small gap between sectors.}

\item{big.gap}{Gap between the different sets of sectors, which are defined in the `group` parameter}

\item{annotationTrackHeight}{annotationTrack Height}

\item{remove.isolate}{whether remove sectors without any links}

\item{link.visible}{whether plot the link. The value is logical, if it is set to FALSE, the corresponding link will not plotted, but the space is still ocuppied. The format is a matrix with names or a data frame with three columns}

\item{scale}{scale each sector to same width; default = FALSE; however, it is set to be TRUE when remove.isolate = TRUE}

\item{directional}{Whether links have directions. 1 means the direction is from the first column in df to the second column, -1 is the reverse, 0 is no direction, and 2 for two directional.}

\item{link.target.prop}{If the Chord diagram is directional, for each source sector, whether to draw bars that shows the proportion of target sectors.}

\item{reduce}{if the ratio of the width of certain grid compared to the whole circle is less than this value, the grid is removed on the plot. Set it to value less than zero if you want to keep all tiny grid.}

\item{transparency}{Transparency of link colors}

\item{link.border}{border for links, single scalar or a matrix with names or a data frame with three columns}

\item{title.name}{title name}

\item{show.legend}{whether show the figure legend}

\item{legend.pos.x, legend.pos.y}{adjust the legend position}

\item{nCol}{number of columns when displaying the figures}

\item{thresh}{threshold of the p-value for determining significant interaction when visualizing links at the level of ligands/receptors;}

\item{...}{other parameters passing to chordDiagram}
}
\value{
an object of class "recordedplot"
}
\description{
Names of cell states will be displayed in this chord diagram
}
