% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{netVisual_circle}
\alias{netVisual_circle}
\title{Circle plot of cell-cell communication network}
\usage{
netVisual_circle(
  net,
  color.use = NULL,
  title.name = NULL,
  sources.use = NULL,
  targets.use = NULL,
  idents.use = NULL,
  remove.isolate = FALSE,
  top = 1,
  weight.scale = FALSE,
  vertex.weight = 20,
  vertex.weight.max = NULL,
  vertex.size.max = NULL,
  vertex.label.cex = 1,
  vertex.label.color = "black",
  edge.weight.max = NULL,
  edge.width.max = 8,
  alpha.edge = 0.6,
  label.edge = FALSE,
  edge.label.color = "black",
  edge.label.cex = 0.8,
  edge.curved = 0.2,
  shape = "circle",
  layout = in_circle(),
  margin = 0.2,
  vertex.size = NULL,
  arrow.width = 1,
  arrow.size = 0.2,
  text.x = 0,
  text.y = 1.5
)
}
\arguments{
\item{net}{A weighted matrix representing the connections}

\item{color.use}{Colors represent different cell groups}

\item{title.name}{the name of the title}

\item{sources.use}{a vector giving the index or the name of source cell groups}

\item{targets.use}{a vector giving the index or the name of target cell groups.}

\item{idents.use}{a vector giving the index or the name of cell groups of interest.}

\item{remove.isolate}{whether remove the isolate nodes in the communication network}

\item{top}{the fraction of interactions to show}

\item{weight.scale}{whether scale the weight}

\item{vertex.weight}{The weight of vertex: either a scale value or a vector}

\item{vertex.weight.max}{the maximum weight of vertex; defualt = max(vertex.weight)}

\item{vertex.size.max}{the maximum vertex size for visualization}

\item{vertex.label.cex}{The label size of vertex}

\item{vertex.label.color}{The color of label for vertex}

\item{edge.weight.max}{the maximum weight of edge; defualt = max(net)}

\item{edge.width.max}{The maximum edge width for visualization}

\item{alpha.edge}{the transprency of edge}

\item{label.edge}{Whether or not shows the label of edges}

\item{edge.label.color}{The color for single arrow}

\item{edge.label.cex}{The size of label for arrows}

\item{edge.curved}{Specifies whether to draw curved edges, or not.
This can be a logical or a numeric vector or scalar.
First the vector is replicated to have the same length as the number of
edges in the graph. Then it is interpreted for each edge separately.
A numeric value specifies the curvature of the edge; zero curvature means
straight edges, negative values means the edge bends clockwise, positive
values the opposite. TRUE means curvature 0.5, FALSE means curvature zero}

\item{shape}{The shape of the vertex, currently “circle”, “square”,
“csquare”, “rectangle”, “crectangle”, “vrectangle”, “pie” (see
vertex.shape.pie), ‘sphere’, and “none” are supported, and only by the
plot.igraph command. “none” does not draw the vertices at all, although
vertex label are plotted (if given). See shapes for details about vertex
shapes and vertex.shape.pie for using pie charts as vertices.}

\item{layout}{The layout specification. It must be a call to a layout
specification function.}

\item{margin}{The amount of empty space below, over, at the left and right
of the plot, it is a numeric vector of length four. Usually values between
0 and 0.5 are meaningful, but negative values are also possible, that will
make the plot zoom in to a part of the graph. If it is shorter than four
then it is recycled.}

\item{vertex.size}{Deprecated. Use `vertex.weight`}

\item{arrow.width}{The width of arrows}

\item{arrow.size}{the size of arrow}

\item{text.x, text.y}{the x- and y-coordinates to add the text}
}
\value{
an object of class "recordedplot"
}
\description{
The width of edges represent the strength of the communication.
}
