% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{netVisual_embeddingPairwise}
\alias{netVisual_embeddingPairwise}
\title{2D visualization of the joint manifold learning of signaling networks from two datasets}
\usage{
netVisual_embeddingPairwise(
  object,
  slot.name = "netP",
  type = c("functional", "structural"),
  comparison = NULL,
  color.use = NULL,
  point.shape = NULL,
  pathway.labeled = NULL,
  top.label = 1,
  pathway.remove = NULL,
  pathway.remove.show = TRUE,
  dot.size = c(2, 6),
  label.size = 2.5,
  dot.alpha = 0.5,
  xlabel = "Dim 1",
  ylabel = "Dim 2",
  title = NULL,
  do.label = T,
  show.legend = T,
  show.axes = T
)
}
\arguments{
\item{object}{CellChat object}

\item{slot.name}{the slot name of object that is used to compute centrality measures of signaling networks}

\item{type}{"functional","structural"}

\item{comparison}{a numerical vector giving the datasets for comparison. Default are all datasets when object is a merged object}

\item{color.use}{defining the color for each cell group}

\item{point.shape}{a numeric vector giving the point shapes. By default point.shape <- c(21, 0, 24, 23, 25, 10, 12), see available shapes at http://www.sthda.com/english/wiki/r-plot-pch-symbols-the-different-point-shapes-available-in-r}

\item{pathway.labeled}{a char vector giving the signaling names to show when labeling each point}

\item{top.label}{the fraction of signaling pathways to label}

\item{pathway.remove}{a character vector defining the signaling to remove}

\item{pathway.remove.show}{whether show the removed signaling names}

\item{dot.size}{a range defining the size of the symbol}

\item{label.size}{font size of the text}

\item{dot.alpha}{transparency}

\item{xlabel}{label of x-axis}

\item{ylabel}{label of y-axis}

\item{title}{main title of the plot}

\item{do.label}{label the each point}

\item{show.legend}{whether show the legend}

\item{show.axes}{whether show the axes}
}
\description{
2D visualization of the joint manifold learning of signaling networks from two datasets
}
