% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{rankNet}
\alias{rankNet}
\title{Rank signaling networks based on the information flow or the number of interactions}
\usage{
rankNet(
  object,
  slot.name = "netP",
  measure = c("weight", "count"),
  mode = c("comparison", "single"),
  comparison = c(1, 2),
  color.use = NULL,
  stacked = FALSE,
  sources.use = NULL,
  targets.use = NULL,
  signaling = NULL,
  pairLR = NULL,
  signaling.type = NULL,
  do.stat = FALSE,
  paired.test = TRUE,
  cutoff.pvalue = 0.05,
  tol = 0.05,
  thresh = 0.05,
  show.raw = FALSE,
  return.data = FALSE,
  x.rotation = 90,
  title = NULL,
  bar.w = 0.75,
  font.size = 8,
  do.flip = TRUE,
  x.angle = NULL,
  y.angle = 0,
  x.hjust = 1,
  y.hjust = 1,
  axis.gap = FALSE,
  ylim = NULL,
  segments = NULL,
  tick_width = NULL,
  rel_heights = c(0.9, 0, 0.1)
)
}
\arguments{
\item{object}{CellChat object}

\item{slot.name}{the slot name of object that is used to compute centrality measures of signaling networks}

\item{measure}{"weight" or "count". "weight": comparing the total interaction weights (strength); "count": comparing the number of interactions;}

\item{mode}{"single","comparison"}

\item{comparison}{a numerical vector giving the datasets for comparison; a single value means ranking for only one dataset and two values means ranking comparison for two datasets}

\item{color.use}{defining the color for each cell group}

\item{stacked}{whether plot the stacked bar plot}

\item{sources.use}{a vector giving the index or the name of source cell groups}

\item{targets.use}{a vector giving the index or the name of target cell groups.}

\item{signaling}{a vector giving the signaling pathway to show}

\item{pairLR}{a vector giving the names of L-R pairs to show (e.g, pairLR = c("IL1A_IL1R1_IL1RAP","IL1B_IL1R1_IL1RAP"))}

\item{signaling.type}{a char giving the types of signaling from the three categories c("Secreted Signaling", "ECM-Receptor", "Cell-Cell Contact")}

\item{do.stat}{whether do a Wilcoxon test to determine whether there is significant difference between two datasets. Default = FALSE}

\item{paired.test}{a logical indicating whether you want a paired test. Paired test is applicable to compare two datasets with the same cellular compositions.}

\item{cutoff.pvalue}{the cutoff of pvalue when doing Wilcoxon test; Default = 0.05}

\item{tol}{a tolerance when considering the relative contribution being equal between two datasets. contribution.relative between 1-tol and 1+tol will be considered as equal contribution}

\item{thresh}{threshold of the p-value for determining significant interaction}

\item{show.raw}{whether show the raw information flow. Default = FALSE, showing the scaled information flow to provide compariable data scale; When stacked = TRUE, use raw information flow by default.}

\item{return.data}{whether return the data.frame consisting of the calculated information flow of each signaling pathway or L-R pair}

\item{x.rotation}{rotation of x-labels}

\item{title}{main title of the plot}

\item{bar.w}{the width of bar plot}

\item{font.size}{font size}

\item{do.flip}{whether flip the x-y axis}

\item{x.angle, y.angle, x.hjust, y.hjust}{parameters for rotating and spacing axis labels}

\item{axis.gap}{whetehr making gaps in y-axes}

\item{ylim, segments, tick_width, rel_heights}{parameters in the function gg.gap when making gaps in y-axes
e.g., ylim = c(0, 35), segments = list(c(11, 14),c(16, 28)), tick_width = c(5,2,5), rel_heights = c(0.8,0,0.1,0,0.1)
https://tobiasbusch.xyz/an-r-package-for-everything-ep2-gaps}
}
\description{
This function can also be used to rank signaling from certain cell groups to other cell groups
}
