% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{selectK}
\alias{selectK}
\title{Select the number of the patterns for running `identifyCommunicationPatterns`}
\usage{
selectK(
  object,
  slot.name = "netP",
  pattern = c("outgoing", "incoming"),
  title.name = NULL,
  do.facet = TRUE,
  k.range = seq(2, 10),
  nrun = 30,
  seed.use = 10
)
}
\arguments{
\item{object}{CellChat object}

\item{slot.name}{the slot name of object that is used to compute centrality measures of signaling networks}

\item{pattern}{"outgoing" or "incoming"}

\item{title.name}{title of plot}

\item{do.facet}{whether use facet plot showing the two measures}

\item{k.range}{a range of the number of patterns}

\item{nrun}{number of runs when performing NMF}

\item{seed.use}{seed when performing NMF}
}
\value{
a ggplot object
}
\description{
We infer the number of patterns based on two metrics that have been implemented in the NMF R package, including Cophenetic and Silhouette. Both metrics measure the stability for a particular number of patterns based on a hierarchical clustering of the consensus matrix. For a range of the number of patterns, a suitable number of patterns is the one at which Cophenetic and Silhouette values begin to drop suddenly.
}
