% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{smoothData}
\alias{smoothData}
\title{Smooth the gene expression data}
\usage{
smoothData(
  object,
  method = c("netSmooth"),
  adj = NULL,
  alpha = 0.5,
  normalizeAdjMatrix = c("rows", "columns")
)
}
\arguments{
\item{object}{CellChat object}

\item{method}{When method = "netSmooth", smoothing a gene’s expression values based on its neighbors defined in a high-confidence experimentally validated protein-protein network.}

\item{adj}{adjacency matrix of protein-protein interaction network to use}

\item{alpha}{numeric in [0,1] alpha = 0: no smoothing; a larger value alpha results in increasing levels of smoothing.}

\item{normalizeAdjMatrix}{how to normalize the adjacency matrix
possible values are 'rows' (in-degree)
and 'columns' (out-degree)}
}
\value{
a smoothed gene expression matrix
}
\description{
A diffusion process is used to smooth genes’ expression values based on their neighbors’ defined in a high-confidence experimentally validated protein-protein network.
}
\details{
This function is useful when analyzing single-cell data with shallow sequencing depth because the projection reduces the dropout effects of signaling genes, in particular for possible zero expression of subunits of ligands/receptors
}
