% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellChat_class.R
\name{subsetCellChat}
\alias{subsetCellChat}
\title{Subset CellChat object using a portion of cells}
\usage{
subsetCellChat(
  object,
  cells.use = NULL,
  idents.use = NULL,
  group.by = NULL,
  invert = FALSE,
  thresh = 0.05
)
}
\arguments{
\item{object}{A CellChat object (either an object from a single dataset or a merged objects from multiple datasets)}

\item{cells.use}{a char vector giving the cell barcodes to subset. If cells.use = NULL, USER must define `idents.use`}

\item{idents.use}{a subset of cell groups used for analysis}

\item{group.by}{cell group information; default is `object@idents`; otherwise it should be one of the column names of the meta slot}

\item{invert}{whether invert the idents.use}

\item{thresh}{threshold of the p-value for determining significant interaction. A parameter as an input of the function `computeCommunProbPathway`}
}
\description{
Subset CellChat object using a portion of cells
}
