// This code contains NVIDIA Confidential Information and is disclosed to you
// under a form of NVIDIA software license agreement provided separately to you.
//
// Notice
// NVIDIA Corporation and its licensors retain all intellectual property and
// proprietary rights in and to this software and related documentation and
// any modifications thereto. Any use, reproduction, disclosure, or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA Corporation is strictly prohibited.
//
// ALL NVIDIA DESIGN SPECIFICATIONS, CODE ARE PROVIDED "AS IS.". NVIDIA MAKES
// NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO
// THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT,
// MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE.
//
// Information and code furnished is believed to be accurate and reliable.
// However, NVIDIA Corporation assumes no responsibility for the consequences of use of such
// information or for any infringement of patents or other rights of third parties that may
// result from its use. No license is granted by implication or otherwise under any patent
// or patent rights of NVIDIA Corporation. Details are subject to change without notice.
// This code supersedes and replaces all information previously supplied.
// NVIDIA Corporation products are not authorized for use as critical
// components in life support devices or systems without express written approval of
// NVIDIA Corporation.
//
// Copyright (c) 2008-2020 NVIDIA Corporation. All rights reserved.

// This file was generated by NvParameterized/scripts/GenParameterized.pl


#include "DestructibleActorParam_0p0.h"
#include <string.h>
#include <stdlib.h>

using namespace NvParameterized;

namespace nvidia
{
namespace parameterized
{

using namespace DestructibleActorParam_0p0NS;

const char* const DestructibleActorParam_0p0Factory::vptr =
    NvParameterized::getVptr<DestructibleActorParam_0p0, DestructibleActorParam_0p0::ClassAlignment>();

const uint32_t NumParamDefs = 140;
static NvParameterized::DefinitionImpl* ParamDefTable; // now allocated in buildTree [NumParamDefs];


static const size_t ParamLookupChildrenTable[] =
{
	1, 2, 3, 4, 5, 6, 7, 9, 11, 50, 60, 94, 123, 8, 10, 12, 13, 14, 15, 16, 17, 18, 19,
	20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 40, 41, 42, 43, 44, 32, 33, 34, 35,
	36, 37, 38, 39, 45, 46, 47, 48, 49, 51, 52, 53, 54, 55, 56, 57, 58, 59, 61, 82, 83,
	89, 90, 91, 92, 93, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
	78, 79, 80, 81, 84, 85, 86, 87, 88, 95, 103, 104, 105, 106, 119, 120, 121, 122, 96,
	97, 98, 99, 100, 101, 102, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117,
	118, 124, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 125, 126, 127, 128,
};

#define TENUM(type) nvidia::##type
#define CHILDREN(index) &ParamLookupChildrenTable[index]
static const NvParameterized::ParamLookupNode ParamLookupTable[NumParamDefs] =
{
	{ TYPE_STRUCT, false, 0, CHILDREN(0), 13 },
	{ TYPE_STRING, false, (size_t)(&((ParametersStruct*)0)->crumbleEmitterName), NULL, 0 }, // crumbleEmitterName
	{ TYPE_STRING, false, (size_t)(&((ParametersStruct*)0)->dustEmitterName), NULL, 0 }, // dustEmitterName
	{ TYPE_MAT34, false, (size_t)(&((ParametersStruct*)0)->globalPose), NULL, 0 }, // globalPose
	{ TYPE_VEC3, false, (size_t)(&((ParametersStruct*)0)->scale), NULL, 0 }, // scale
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->dynamic), NULL, 0 }, // dynamic
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->renderStaticChunksSeparately), NULL, 0 }, // renderStaticChunksSeparately
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->overrideSkinnedMaterialNames), CHILDREN(13), 1 }, // overrideSkinnedMaterialNames
	{ TYPE_STRING, false, 1 * sizeof(NvParameterized::DummyStringStruct), NULL, 0 }, // overrideSkinnedMaterialNames[]
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->overrideStaticMaterialNames), CHILDREN(14), 1 }, // overrideStaticMaterialNames
	{ TYPE_STRING, false, 1 * sizeof(NvParameterized::DummyStringStruct), NULL, 0 }, // overrideStaticMaterialNames[]
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->destructibleParameters), CHILDREN(15), 25 }, // destructibleParameters
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageThreshold), NULL, 0 }, // destructibleParameters.damageThreshold
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageToRadius), NULL, 0 }, // destructibleParameters.damageToRadius
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageCap), NULL, 0 }, // destructibleParameters.damageCap
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->forceToDamage), NULL, 0 }, // destructibleParameters.forceToDamage
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->impactVelocityThreshold), NULL, 0 }, // destructibleParameters.impactVelocityThreshold
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->materialStrength), NULL, 0 }, // destructibleParameters.materialStrength
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageToPercentDeformation), NULL, 0 }, // destructibleParameters.damageToPercentDeformation
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->deformationPercentLimit), NULL, 0 }, // destructibleParameters.deformationPercentLimit
	{ TYPE_U32, false, (size_t)(&((DestructibleParameters_Type*)0)->formExtendedStructures), NULL, 0 }, // destructibleParameters.formExtendedStructures
	{ TYPE_U32, false, (size_t)(&((DestructibleParameters_Type*)0)->supportDepth), NULL, 0 }, // destructibleParameters.supportDepth
	{ TYPE_I32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisDepth), NULL, 0 }, // destructibleParameters.debrisDepth
	{ TYPE_U32, false, (size_t)(&((DestructibleParameters_Type*)0)->essentialDepth), NULL, 0 }, // destructibleParameters.essentialDepth
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisLifetimeMin), NULL, 0 }, // destructibleParameters.debrisLifetimeMin
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisLifetimeMax), NULL, 0 }, // destructibleParameters.debrisLifetimeMax
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisMaxSeparationMin), NULL, 0 }, // destructibleParameters.debrisMaxSeparationMin
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisMaxSeparationMax), NULL, 0 }, // destructibleParameters.debrisMaxSeparationMax
	{ TYPE_BOUNDS3, false, (size_t)(&((DestructibleParameters_Type*)0)->validBounds), NULL, 0 }, // destructibleParameters.validBounds
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->maxChunkSpeed), NULL, 0 }, // destructibleParameters.maxChunkSpeed
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->massScaleExponent), NULL, 0 }, // destructibleParameters.massScaleExponent
	{ TYPE_STRUCT, false, (size_t)(&((DestructibleParameters_Type*)0)->flags), CHILDREN(40), 8 }, // destructibleParameters.flags
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->ACCUMULATE_DAMAGE), NULL, 0 }, // destructibleParameters.flags.ACCUMULATE_DAMAGE
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->ASSET_DEFINED_SUPPORT), NULL, 0 }, // destructibleParameters.flags.ASSET_DEFINED_SUPPORT
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->WORLD_SUPPORT), NULL, 0 }, // destructibleParameters.flags.WORLD_SUPPORT
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->DEBRIS_TIMEOUT), NULL, 0 }, // destructibleParameters.flags.DEBRIS_TIMEOUT
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->DEBRIS_MAX_SEPARATION), NULL, 0 }, // destructibleParameters.flags.DEBRIS_MAX_SEPARATION
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->CRUMBLE_SMALLEST_CHUNKS), NULL, 0 }, // destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->ACCURATE_RAYCASTS), NULL, 0 }, // destructibleParameters.flags.ACCURATE_RAYCASTS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->USE_VALID_BOUNDS), NULL, 0 }, // destructibleParameters.flags.USE_VALID_BOUNDS
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->grbVolumeLimit), NULL, 0 }, // destructibleParameters.grbVolumeLimit
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->grbParticleSpacing), NULL, 0 }, // destructibleParameters.grbParticleSpacing
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->fractureImpulseScale), NULL, 0 }, // destructibleParameters.fractureImpulseScale
	{ TYPE_U16, false, (size_t)(&((DestructibleParameters_Type*)0)->dynamicChunkDominanceGroup), NULL, 0 }, // destructibleParameters.dynamicChunkDominanceGroup
	{ TYPE_STRUCT, false, (size_t)(&((DestructibleParameters_Type*)0)->dynamicChunksGroupsMask), CHILDREN(48), 5 }, // destructibleParameters.dynamicChunksGroupsMask
	{ TYPE_BOOL, false, (size_t)(&((GroupsMask_Type*)0)->useGroupsMask), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.useGroupsMask
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits0), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits0
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits1), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits1
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits2), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits2
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits3), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits3
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->depthParameters), CHILDREN(53), 1 }, // depthParameters
	{ TYPE_STRUCT, false, 1 * sizeof(DestructibleDepthParameters_Type), CHILDREN(54), 8 }, // depthParameters[]
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->TAKE_IMPACT_DAMAGE), NULL, 0 }, // depthParameters[].TAKE_IMPACT_DAMAGE
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->IGNORE_POSE_UPDATES), NULL, 0 }, // depthParameters[].IGNORE_POSE_UPDATES
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->IGNORE_RAYCAST_CALLBACKS), NULL, 0 }, // depthParameters[].IGNORE_RAYCAST_CALLBACKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->IGNORE_CONTACT_CALLBACKS), NULL, 0 }, // depthParameters[].IGNORE_CONTACT_CALLBACKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_0), NULL, 0 }, // depthParameters[].USER_FLAG_0
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_1), NULL, 0 }, // depthParameters[].USER_FLAG_1
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_2), NULL, 0 }, // depthParameters[].USER_FLAG_2
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_3), NULL, 0 }, // depthParameters[].USER_FLAG_3
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->shapeDescTemplate), CHILDREN(62), 8 }, // shapeDescTemplate
	{ TYPE_STRUCT, false, (size_t)(&((ShapeDescTemplate_Type*)0)->flags), CHILDREN(70), 20 }, // shapeDescTemplate.flags
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_TRIGGER_ON_ENTER), NULL, 0 }, // shapeDescTemplate.flags.NX_TRIGGER_ON_ENTER
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_TRIGGER_ON_LEAVE), NULL, 0 }, // shapeDescTemplate.flags.NX_TRIGGER_ON_LEAVE
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_TRIGGER_ON_STAY), NULL, 0 }, // shapeDescTemplate.flags.NX_TRIGGER_ON_STAY
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_VISUALIZATION), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_VISUALIZATION
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_DISABLE_COLLISION), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_DISABLE_COLLISION
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_FEATURE_INDICES), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_FEATURE_INDICES
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_DISABLE_RAYCASTING), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_DISABLE_RAYCASTING
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_POINT_CONTACT_FORCE), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_POINT_CONTACT_FORCE
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_FLUID_DRAIN), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_FLUID_DRAIN
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_FLUID_DISABLE_COLLISION), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_FLUID_DISABLE_COLLISION
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_FLUID_TWOWAY), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_FLUID_TWOWAY
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_DISABLE_RESPONSE), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_DISABLE_RESPONSE
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_DYNAMIC_DYNAMIC_CCD), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_DYNAMIC_DYNAMIC_CCD
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_DISABLE_SCENE_QUERIES), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_DISABLE_SCENE_QUERIES
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_CLOTH_DRAIN), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_CLOTH_DRAIN
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_CLOTH_DISABLE_COLLISION), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_CLOTH_DISABLE_COLLISION
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_CLOTH_TWOWAY), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_CLOTH_TWOWAY
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_SOFTBODY_DRAIN), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_SOFTBODY_DRAIN
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_SOFTBODY_DISABLE_COLLISION), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_SOFTBODY_DISABLE_COLLISION
	{ TYPE_BOOL, false, (size_t)(&((ShapeDescFlags_Type*)0)->NX_SF_SOFTBODY_TWOWAY), NULL, 0 }, // shapeDescTemplate.flags.NX_SF_SOFTBODY_TWOWAY
	{ TYPE_U16, false, (size_t)(&((ShapeDescTemplate_Type*)0)->collisionGroup), NULL, 0 }, // shapeDescTemplate.collisionGroup
	{ TYPE_STRUCT, false, (size_t)(&((ShapeDescTemplate_Type*)0)->groupsMask), CHILDREN(90), 5 }, // shapeDescTemplate.groupsMask
	{ TYPE_BOOL, false, (size_t)(&((GroupsMask_Type*)0)->useGroupsMask), NULL, 0 }, // shapeDescTemplate.groupsMask.useGroupsMask
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits0), NULL, 0 }, // shapeDescTemplate.groupsMask.bits0
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits1), NULL, 0 }, // shapeDescTemplate.groupsMask.bits1
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits2), NULL, 0 }, // shapeDescTemplate.groupsMask.bits2
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits3), NULL, 0 }, // shapeDescTemplate.groupsMask.bits3
	{ TYPE_U16, false, (size_t)(&((ShapeDescTemplate_Type*)0)->materialIndex), NULL, 0 }, // shapeDescTemplate.materialIndex
	{ TYPE_F32, false, (size_t)(&((ShapeDescTemplate_Type*)0)->density), NULL, 0 }, // shapeDescTemplate.density
	{ TYPE_F32, false, (size_t)(&((ShapeDescTemplate_Type*)0)->skinWidth), NULL, 0 }, // shapeDescTemplate.skinWidth
	{ TYPE_U64, false, (size_t)(&((ShapeDescTemplate_Type*)0)->userData), NULL, 0 }, // shapeDescTemplate.userData
	{ TYPE_U64, false, (size_t)(&((ShapeDescTemplate_Type*)0)->name), NULL, 0 }, // shapeDescTemplate.name
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->actorDescTemplate), CHILDREN(95), 9 }, // actorDescTemplate
	{ TYPE_STRUCT, false, (size_t)(&((ActorDescTemplate_Type*)0)->flags), CHILDREN(104), 7 }, // actorDescTemplate.flags
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_DISABLE_COLLISION), NULL, 0 }, // actorDescTemplate.flags.NX_AF_DISABLE_COLLISION
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_DISABLE_RESPONSE), NULL, 0 }, // actorDescTemplate.flags.NX_AF_DISABLE_RESPONSE
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_LOCK_COM), NULL, 0 }, // actorDescTemplate.flags.NX_AF_LOCK_COM
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_FLUID_DISABLE_COLLISION), NULL, 0 }, // actorDescTemplate.flags.NX_AF_FLUID_DISABLE_COLLISION
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_CONTACT_MODIFICATION), NULL, 0 }, // actorDescTemplate.flags.NX_AF_CONTACT_MODIFICATION
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_FORCE_CONE_FRICTION), NULL, 0 }, // actorDescTemplate.flags.NX_AF_FORCE_CONE_FRICTION
	{ TYPE_BOOL, false, (size_t)(&((ActorDescFlags_Type*)0)->NX_AF_USER_ACTOR_PAIR_FILTERING), NULL, 0 }, // actorDescTemplate.flags.NX_AF_USER_ACTOR_PAIR_FILTERING
	{ TYPE_F32, false, (size_t)(&((ActorDescTemplate_Type*)0)->density), NULL, 0 }, // actorDescTemplate.density
	{ TYPE_U16, false, (size_t)(&((ActorDescTemplate_Type*)0)->actorCollisionGroup), NULL, 0 }, // actorDescTemplate.actorCollisionGroup
	{ TYPE_U16, false, (size_t)(&((ActorDescTemplate_Type*)0)->dominanceGroup), NULL, 0 }, // actorDescTemplate.dominanceGroup
	{ TYPE_STRUCT, false, (size_t)(&((ActorDescTemplate_Type*)0)->contactReportFlags), CHILDREN(111), 12 }, // actorDescTemplate.contactReportFlags
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_IGNORE_PAIR), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_IGNORE_PAIR
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_START_TOUCH), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_START_TOUCH
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_END_TOUCH), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_END_TOUCH
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_TOUCH), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_TOUCH
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_IMPACT), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_IMPACT
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_ROLL), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_ROLL
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_SLIDE), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_SLIDE
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_FORCES), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_FORCES
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_START_TOUCH_FORCE_THRESHOLD), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_START_TOUCH_FORCE_THRESHOLD
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_END_TOUCH_FORCE_THRESHOLD), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_END_TOUCH_FORCE_THRESHOLD
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_ON_TOUCH_FORCE_THRESHOLD), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_TOUCH_FORCE_THRESHOLD
	{ TYPE_BOOL, false, (size_t)(&((ContactPairFlag_Type*)0)->NX_NOTIFY_CONTACT_MODIFICATION), NULL, 0 }, // actorDescTemplate.contactReportFlags.NX_NOTIFY_CONTACT_MODIFICATION
	{ TYPE_U16, false, (size_t)(&((ActorDescTemplate_Type*)0)->forceFieldMaterial), NULL, 0 }, // actorDescTemplate.forceFieldMaterial
	{ TYPE_U64, false, (size_t)(&((ActorDescTemplate_Type*)0)->userData), NULL, 0 }, // actorDescTemplate.userData
	{ TYPE_U64, false, (size_t)(&((ActorDescTemplate_Type*)0)->name), NULL, 0 }, // actorDescTemplate.name
	{ TYPE_U64, false, (size_t)(&((ActorDescTemplate_Type*)0)->compartment), NULL, 0 }, // actorDescTemplate.compartment
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->bodyDescTemplate), CHILDREN(123), 12 }, // bodyDescTemplate
	{ TYPE_STRUCT, false, (size_t)(&((BodyDescTemplate_Type*)0)->flags), CHILDREN(135), 4 }, // bodyDescTemplate.flags
	{ TYPE_BOOL, false, (size_t)(&((BodyDescFlags_Type*)0)->NX_BF_DISABLE_GRAVITY), NULL, 0 }, // bodyDescTemplate.flags.NX_BF_DISABLE_GRAVITY
	{ TYPE_BOOL, false, (size_t)(&((BodyDescFlags_Type*)0)->NX_BF_FILTER_SLEEP_VEL), NULL, 0 }, // bodyDescTemplate.flags.NX_BF_FILTER_SLEEP_VEL
	{ TYPE_BOOL, false, (size_t)(&((BodyDescFlags_Type*)0)->NX_BF_ENERGY_SLEEP_TEST), NULL, 0 }, // bodyDescTemplate.flags.NX_BF_ENERGY_SLEEP_TEST
	{ TYPE_BOOL, false, (size_t)(&((BodyDescFlags_Type*)0)->NX_BF_VISUALIZATION), NULL, 0 }, // bodyDescTemplate.flags.NX_BF_VISUALIZATION
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->wakeUpCounter), NULL, 0 }, // bodyDescTemplate.wakeUpCounter
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->linearDamping), NULL, 0 }, // bodyDescTemplate.linearDamping
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->angularDamping), NULL, 0 }, // bodyDescTemplate.angularDamping
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->maxAngularVelocity), NULL, 0 }, // bodyDescTemplate.maxAngularVelocity
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->CCDMotionThreshold), NULL, 0 }, // bodyDescTemplate.CCDMotionThreshold
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->sleepLinearVelocity), NULL, 0 }, // bodyDescTemplate.sleepLinearVelocity
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->sleepAngularVelocity), NULL, 0 }, // bodyDescTemplate.sleepAngularVelocity
	{ TYPE_U32, false, (size_t)(&((BodyDescTemplate_Type*)0)->solverIterationCount), NULL, 0 }, // bodyDescTemplate.solverIterationCount
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->sleepEnergyThreshold), NULL, 0 }, // bodyDescTemplate.sleepEnergyThreshold
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->sleepDamping), NULL, 0 }, // bodyDescTemplate.sleepDamping
	{ TYPE_F32, false, (size_t)(&((BodyDescTemplate_Type*)0)->contactReportThreshold), NULL, 0 }, // bodyDescTemplate.contactReportThreshold
};


bool DestructibleActorParam_0p0::mBuiltFlag = false;
NvParameterized::MutexType DestructibleActorParam_0p0::mBuiltFlagMutex;

DestructibleActorParam_0p0::DestructibleActorParam_0p0(NvParameterized::Traits* traits, void* buf, int32_t* refCount) :
	NvParameters(traits, buf, refCount)
{
	//mParameterizedTraits->registerFactory(className(), &DestructibleActorParam_0p0FactoryInst);

	if (!buf) //Do not init data if it is inplace-deserialized
	{
		initDynamicArrays();
		initStrings();
		initReferences();
		initDefaults();
	}
}

DestructibleActorParam_0p0::~DestructibleActorParam_0p0()
{
	freeStrings();
	freeReferences();
	freeDynamicArrays();
}

void DestructibleActorParam_0p0::destroy()
{
	// We cache these fields here to avoid overwrite in destructor
	bool doDeallocateSelf = mDoDeallocateSelf;
	NvParameterized::Traits* traits = mParameterizedTraits;
	int32_t* refCount = mRefCount;
	void* buf = mBuffer;

	this->~DestructibleActorParam_0p0();

	NvParameters::destroy(this, traits, doDeallocateSelf, refCount, buf);
}

const NvParameterized::DefinitionImpl* DestructibleActorParam_0p0::getParameterDefinitionTree(void)
{
	if (!mBuiltFlag) // Double-checked lock
	{
		NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);
		if (!mBuiltFlag)
		{
			buildTree();
		}
	}

	return(&ParamDefTable[0]);
}

const NvParameterized::DefinitionImpl* DestructibleActorParam_0p0::getParameterDefinitionTree(void) const
{
	DestructibleActorParam_0p0* tmpParam = const_cast<DestructibleActorParam_0p0*>(this);

	if (!mBuiltFlag) // Double-checked lock
	{
		NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);
		if (!mBuiltFlag)
		{
			tmpParam->buildTree();
		}
	}

	return(&ParamDefTable[0]);
}

NvParameterized::ErrorType DestructibleActorParam_0p0::getParameterHandle(const char* long_name, Handle& handle) const
{
	ErrorType Ret = NvParameters::getParameterHandle(long_name, handle);
	if (Ret != ERROR_NONE)
	{
		return(Ret);
	}

	size_t offset;
	void* ptr;

	getVarPtr(handle, ptr, offset);

	if (ptr == NULL)
	{
		return(ERROR_INDEX_OUT_OF_RANGE);
	}

	return(ERROR_NONE);
}

NvParameterized::ErrorType DestructibleActorParam_0p0::getParameterHandle(const char* long_name, Handle& handle)
{
	ErrorType Ret = NvParameters::getParameterHandle(long_name, handle);
	if (Ret != ERROR_NONE)
	{
		return(Ret);
	}

	size_t offset;
	void* ptr;

	getVarPtr(handle, ptr, offset);

	if (ptr == NULL)
	{
		return(ERROR_INDEX_OUT_OF_RANGE);
	}

	return(ERROR_NONE);
}

void DestructibleActorParam_0p0::getVarPtr(const Handle& handle, void*& ptr, size_t& offset) const
{
	ptr = getVarPtrHelper(&ParamLookupTable[0], const_cast<DestructibleActorParam_0p0::ParametersStruct*>(&parameters()), handle, offset);
}


/* Dynamic Handle Indices */
/* [0] - overrideSkinnedMaterialNames (not an array of structs) */
/* [0] - overrideStaticMaterialNames (not an array of structs) */

void DestructibleActorParam_0p0::freeParameterDefinitionTable(NvParameterized::Traits* traits)
{
	if (!traits)
	{
		return;
	}

	if (!mBuiltFlag) // Double-checked lock
	{
		return;
	}

	NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);

	if (!mBuiltFlag)
	{
		return;
	}

	for (uint32_t i = 0; i < NumParamDefs; ++i)
	{
		ParamDefTable[i].~DefinitionImpl();
	}

	traits->free(ParamDefTable);

	mBuiltFlag = false;
}

#define PDEF_PTR(index) (&ParamDefTable[index])

void DestructibleActorParam_0p0::buildTree(void)
{

	uint32_t allocSize = sizeof(NvParameterized::DefinitionImpl) * NumParamDefs;
	ParamDefTable = (NvParameterized::DefinitionImpl*)(mParameterizedTraits->alloc(allocSize));
	memset(ParamDefTable, 0, allocSize);

	for (uint32_t i = 0; i < NumParamDefs; ++i)
	{
		NV_PARAM_PLACEMENT_NEW(ParamDefTable + i, NvParameterized::DefinitionImpl)(*mParameterizedTraits);
	}

	// Initialize DefinitionImpl node: nodeIndex=0, longName=""
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[0];
		ParamDef->init("", TYPE_STRUCT, "STRUCT", true);






	}

	// Initialize DefinitionImpl node: nodeIndex=1, longName="crumbleEmitterName"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[1];
		ParamDef->init("crumbleEmitterName", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The name of the NxMeshParticleSystem to use for crumbling.  This overrides the crumble system defined\nin the NxDestructibleAsset if specified.\n", true);
		HintTable[1].init("shortDescription", "The name of the NxMeshParticleSystem to use for crumbling", true);
		ParamDefTable[1].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=2, longName="dustEmitterName"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[2];
		ParamDef->init("dustEmitterName", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The name of the NxMeshParticleSystem to use for fracture-line dust.  This overrides the dust system defined\nin the NxDestructibleAsset if specified.\n", true);
		HintTable[1].init("shortDescription", "The name of the NxMeshParticleSystem to use for fracture-line dust", true);
		ParamDefTable[2].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=3, longName="globalPose"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[3];
		ParamDef->init("globalPose", TYPE_MAT34, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Initial global pose of undamaged destructible\n", true);
		HintTable[1].init("shortDescription", "The initial pose where the destructible actor will be put into the scene", true);
		ParamDefTable[3].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=4, longName="scale"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[4];
		ParamDef->init("scale", TYPE_VEC3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "3D Scale\n", true);
		HintTable[1].init("shortDescription", "3D Scale", true);
		ParamDefTable[4].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=5, longName="dynamic"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[5];
		ParamDef->init("dynamic", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the destructible starts life as a dynamic actor\n", true);
		HintTable[1].init("shortDescription", "Whether or not the destructible starts life as a dynamic actor", true);
		ParamDefTable[5].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=6, longName="renderStaticChunksSeparately"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[6];
		ParamDef->init("renderStaticChunksSeparately", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, static chunks will be renderered separately from dynamic chunks, as a single mesh (not using skinning).\nThis parameter is ignored if the \'dynamic\' parameter is true.\nDefault value = false.\n", true);
		HintTable[1].init("shortDescription", "Whether or not to render static chunks in a separate mesh", true);
		ParamDefTable[6].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=7, longName="overrideSkinnedMaterialNames"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[7];
		ParamDef->init("overrideSkinnedMaterialNames", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Per-actor material names, to override those in the asset, for skinned rendering.", true);
		HintTable[1].init("shortDescription", "Per-actor material names, to override those in the asset, for skinned rendering", true);
		ParamDefTable[7].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[1] = { 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 1);

	}

	// Initialize DefinitionImpl node: nodeIndex=8, longName="overrideSkinnedMaterialNames[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[8];
		ParamDef->init("overrideSkinnedMaterialNames", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Per-actor material names, to override those in the asset, for skinned rendering.", true);
		HintTable[1].init("shortDescription", "Per-actor material names, to override those in the asset, for skinned rendering", true);
		ParamDefTable[8].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=9, longName="overrideStaticMaterialNames"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[9];
		ParamDef->init("overrideStaticMaterialNames", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Per-actor material names, to override those in the asset, for static rendering.", true);
		HintTable[1].init("shortDescription", "Per-actor material names, to override those in the asset, for static rendering", true);
		ParamDefTable[9].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[1] = { 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 1);

	}

	// Initialize DefinitionImpl node: nodeIndex=10, longName="overrideStaticMaterialNames[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[10];
		ParamDef->init("overrideStaticMaterialNames", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Per-actor material names, to override those in the asset, for static rendering.", true);
		HintTable[1].init("shortDescription", "Per-actor material names, to override those in the asset, for static rendering", true);
		ParamDefTable[10].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=11, longName="destructibleParameters"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[11];
		ParamDef->init("destructibleParameters", TYPE_STRUCT, "DestructibleParameters", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Parameters controlling the destruction properties - damage thresholds, damage radius multipliers, etc.\n", true);
		HintTable[1].init("shortDescription", "Parameters controlling the destruction properties - damage thresholds, damage radius multipliers, etc.", true);
		ParamDefTable[11].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=12, longName="destructibleParameters.damageThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[12];
		ParamDef->init("damageThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.\nThis is obtained from the damage value passed into the NxDestructibleActor::applyDamage,\nor NxDestructibleActor::applyRadiusDamage, or via impact (see 'forceToDamage', below).\n", true);
		HintTable[1].init("shortDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.", true);
		ParamDefTable[12].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=13, longName="destructibleParameters.damageToRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[13];
		ParamDef->init("damageToRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Controls the distance into the destructible to propagate damage.  The damage applied to the chunk\nis multiplied by damageToRadius, to get the propagation distance.  All chunks within the radius\nwill have damage applied to them.  The damage applied to each chunk varies with distance to the damage\napplication position.  Full damage is taken at zero distance, and zero damage at the damage radius.\n", true);
		HintTable[1].init("shortDescription", "Controls the distance into the destructible to propagate damage.", true);
		ParamDefTable[13].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=14, longName="destructibleParameters.damageCap"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[14];
		ParamDef->init("damageCap", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Limits the amount of damage applied to a chunk.  This is useful for preventing the entire destructible\nfrom getting pulverized by a very large application of damage.  This can easily happen when impact damage is\nused, and the damage amount is proportional to the impact force (see forceToDamage).\n", true);
		HintTable[1].init("shortDescription", "Limits the amount of damage applied to a chunk.", true);
		ParamDefTable[14].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=15, longName="destructibleParameters.forceToDamage"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[15];
		ParamDef->init("forceToDamage", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If a chunk is at a depth which has NX_DESTRUCTIBLE_TAKE_IMPACT_DAMAGE set (see NxDestructibleDepthParameters),\nthen when a chunk has a collision in the NxScene, it will take damage equal to forceToDamage mulitplied by\nthe impact force.\nThe default value is zero, which effectively disables impact damage.\n", true);
		HintTable[1].init("shortDescription", "If a chunk is at a depth which has NX_DESTRUCTIBLE_TAKE_IMPACT_DAMAGE set", true);
		ParamDefTable[15].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=16, longName="destructibleParameters.impactVelocityThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[16];
		ParamDef->init("impactVelocityThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Large impact force may be reported if rigid bodies are spawned inside one another.  In this case the realative velocity of the two\nobjects will be low.  This variable allows the user to set a minimum velocity threshold for impacts to ensure that the objects are\nmoving at a min velocity in order for the impact force to be considered.\n", true);
		HintTable[1].init("shortDescription", "Large impact force may be reported if rigid bodies are spawned inside one another.", true);
		ParamDefTable[16].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=17, longName="destructibleParameters.materialStrength"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[17];
		ParamDef->init("materialStrength", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "When a chunk takes impact damage due to physical contact (see NxDestructibleDepthParametersFlag::TAKE_IMPACT_DAMAGE), this parameter\nis the maximum impulse the contact can generate.  Weak materials such as glass may have this set to a low value, so that\nheavier objects will pass through them during fracture.\nN.B.: Setting this parameter to 0 disables the impulse cap; that is, zero is interpreted as infinite.\nDefault value = 0.0f.\n", true);
		HintTable[1].init("shortDescription", "When a chunk takes impact, this is the maximum impulse the contact can generate.", true);
		ParamDefTable[17].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=18, longName="destructibleParameters.damageToPercentDeformation"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[18];
		ParamDef->init("damageToPercentDeformation", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Damage applied to chunks may deform (move) a chunk without fracturing it, if damageToPercentDeformation is\npositive.  The damage applied to the chunk is multiplied by damageToPercentDeformation, and the resulting\n'percent deformation' is used to translate and rotate the chunk.  The translation is the 'percent deformation'\ntimes the size of the chunk, in the direction given by the 'direction' paramater in applyDamage\n(see NxDestructibleActor).  For radius damage, the direction is always radial from the impact position.\nThe rotation appplied is the 'percent deformation' times one radian.\nThe default value is zero, which disables deformation.\n", true);
		HintTable[1].init("shortDescription", "Damage applied to chunks may deform (move) a chunk without fracturing it", true);
		ParamDefTable[18].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=19, longName="destructibleParameters.deformationPercentLimit"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[19];
		ParamDef->init("deformationPercentLimit", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If a chunk\'s percent deformation (see damageToPercentDeformation) exceeds deformationPercentLimit in\neither translation or rotation, then the chunk will fracture.\n", true);
		HintTable[1].init("shortDescription", "If a chunk's percent deformation (see damageToPercentDeformation) exceeds deformationPercentLimit in either translation or rotation, then the chunk will fracture.", true);
		ParamDefTable[19].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=20, longName="destructibleParameters.formExtendedStructures"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[20];
		ParamDef->init("formExtendedStructures", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If initially static, the destructible will become part of an extended support structure if it is\nin contact with another static destructible that also has this flag set.\n", true);
		HintTable[1].init("shortDescription", "If initially static, the destructible will become part of an extended support structure if it is in contact with another static destructible that also has this flag set.", true);
		ParamDefTable[20].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=21, longName="destructibleParameters.supportDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[21];
		ParamDef->init("supportDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth at which to create a support graph.  Higher depth levels give more detailed support,\nbut will give a higher computational load.  Chunks below the support depth will never be supported.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth at which to create a support graph.", true);
		ParamDefTable[21].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=22, longName="destructibleParameters.debrisDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[22];
		ParamDef->init("debrisDepth", TYPE_I32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth at which chunks are considered to be 'debris.'  Chunks at this depth or\nbelow will be considered for various debris settings, such as debrisLifetime.\nNegative values indicate that no chunk depth is considered debris.\nDefault value is -1.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth at which chunks are considered to be 'debris.'", true);
		ParamDefTable[22].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=23, longName="destructibleParameters.essentialDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[23];
		ParamDef->init("essentialDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth up to which chunks will always be processed.  These chunks are considered\nto be essential either for gameplay or visually.\nThe minimum value is 0, meaning the level 0 chunk is always considered essential.\nDefault value is 0.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth up to which chunks will always be processed", true);
		ParamDefTable[23].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=24, longName="destructibleParameters.debrisLifetimeMin"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[24];
		ParamDef->init("debrisLifetimeMin", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between these two values, based upon the module\'s LOD setting.  To disable\nmaxSeparation, clear the NX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum time to destroy debris", true);
		ParamDefTable[24].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=25, longName="destructibleParameters.debrisLifetimeMax"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[25];
		ParamDef->init("debrisLifetimeMax", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between these two values, based upon the module\'s LOD setting.  To disable\nmaxSeparation, clear the NX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Maximum time to destroy debris", true);
		ParamDefTable[25].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=26, longName="destructibleParameters.debrisMaxSeparationMin"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[26];
		ParamDef->init("debrisMaxSeparationMin", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between these two values, based upon the module\'s LOD setting.  To disable\nmaxSeparation, clear the NX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum separation distance", true);
		ParamDefTable[26].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=27, longName="destructibleParameters.debrisMaxSeparationMax"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[27];
		ParamDef->init("debrisMaxSeparationMax", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between these two values, based upon the module\'s LOD setting.  To disable\nmaxSeparation, clear the NX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum separation distance", true);
		ParamDefTable[27].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=28, longName="destructibleParameters.validBounds"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[28];
		ParamDef->init("validBounds", TYPE_BOUNDS3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation multiplied by the original\ndestructible asset size.  The actual maxSeparation is interpolated between these\ntwo values, based upon the module\'s LOD setting.  To disable maxSeparation, clear the\nNX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "valid bounding region for debris", true);
		ParamDefTable[28].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=29, longName="destructibleParameters.maxChunkSpeed"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[29];
		ParamDef->init("maxChunkSpeed", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If greater than 0, the chunks' speeds will not be allowed to exceed this value.  Use 0\nto disable this feature (this is the default).\n", true);
		HintTable[1].init("shortDescription", "Maximum speed of a chunk", true);
		ParamDefTable[29].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=30, longName="destructibleParameters.massScaleExponent"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[30];
		ParamDef->init("massScaleExponent", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Dynamic chunk islands will have their masses raised to this power.  Values less than 1 have the\neffect of reducing the ratio of different masses.  The closer massScaleExponent is to zero, the\nmore the ratio will be 'flattened.'  This helps PhysX converge when there is a very large number\nof interacting rigid bodies (such as a pile of destructible chunks).\nValid range: [0,1].  Default = 0.5.\n", true);
		HintTable[1].init("shortDescription", "Dynamic chunk islands will have their masses raised to this power.", true);
		ParamDefTable[30].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=31, longName="destructibleParameters.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[31];
		ParamDef->init("flags", TYPE_STRUCT, "DestructibleParametersFlag", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A collection of flags defined in NxDestructibleParametersFlag.\n", true);
		HintTable[1].init("shortDescription", "A collection of flags defined in DestructibleParametersFlag.", true);
		ParamDefTable[31].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=32, longName="destructibleParameters.flags.ACCUMULATE_DAMAGE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[32];
		ParamDef->init("ACCUMULATE_DAMAGE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, chunks will 'remember' damage applied to them, so that many applications of a damage amount\nbelow damageThreshold will eventually fracture the chunk.  If not set, a single application of\ndamage must exceed damageThreshold in order to fracture the chunk.\n", true);
		HintTable[1].init("shortDescription", "Determines if chunks accumulate damage", true);
		ParamDefTable[32].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=33, longName="destructibleParameters.flags.ASSET_DEFINED_SUPPORT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[33];
		ParamDef->init("ASSET_DEFINED_SUPPORT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, then chunks which are tagged as 'support' chunks (via NxDestructibleChunkDesc::isSupportChunk)\nwill have environmental support in static destructibles.\n", true);
		HintTable[1].init("shortDescription", "If set, then chunks which are tagged as 'support' chunks", true);
		ParamDefTable[33].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=34, longName="destructibleParameters.flags.WORLD_SUPPORT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[34];
		ParamDef->init("WORLD_SUPPORT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, then chunks which overlap the NxScene\'s static geometry will have environmental support in\nstatic destructibles.\n", true);
		HintTable[1].init("shortDescription", "If set, then chunks which overlap the NxScene's static geometry will have environmental support", true);
		ParamDefTable[34].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=35, longName="destructibleParameters.flags.DEBRIS_TIMEOUT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[35];
		ParamDef->init("DEBRIS_TIMEOUT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not chunks at or deeper than the 'debris' depth (see NxDestructibleParameters::debrisDepth)\nwill time out.  The lifetime is a value between NxDestructibleParameters::debrisLifetimeMin and\nNxDestructibleParameters::debrisLifetimeMax, based upon the destructible module\'s LOD setting.\n", true);
		HintTable[1].init("shortDescription", "Whether or not chunks at or deeper than the 'debris' depth will timeout", true);
		ParamDefTable[35].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=36, longName="destructibleParameters.flags.DEBRIS_MAX_SEPARATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[36];
		ParamDef->init("DEBRIS_MAX_SEPARATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not chunks at or deeper than the 'debris' depth (see NxDestructibleParameters::debrisDepth)\nwill be removed if they separate too far from their origins.  The maxSeparation is a value between\nNxDestructibleParameters::debrisMaxSeparationMin and NxDestructibleParameters::debrisMaxSeparationMax,\nbased upon the destructible module\'s LOD setting.\n", true);
		HintTable[1].init("shortDescription", "Whether or not chunks at or deeper than the 'debris' depth will be removed if separated too far", true);
		ParamDefTable[36].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=37, longName="destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[37];
		ParamDef->init("CRUMBLE_SMALLEST_CHUNKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the smallest chunks may be further broken down, either by fluid crumbles (if a crumble particle\nsystem is specified in the NxDestructibleActorDesc), or by simply removing the chunk if no crumble\nparticle system is specified.  Note: the 'smallest chunks' are normally defined to be the deepest level\nof the fracture hierarchy.  However, they may be taken from higher levels of the hierarchy if\nNxModuleDestructible::setMaxChunkDepthOffset is called with a non-zero value.\n", true);
		HintTable[1].init("shortDescription", "If set, the smallest chunks may be further broken down", true);
		ParamDefTable[37].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=38, longName="destructibleParameters.flags.ACCURATE_RAYCASTS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[38];
		ParamDef->init("ACCURATE_RAYCASTS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the NxDestructibleActor::rayCast function will search within the nearest visible chunk hit\nfor collisions with child chunks.  This is used to get a better raycast position and normal, in\ncase the parent collision volume does not tightly fit the graphics mesh.  The returned chunk index\nwill always be that of the visible parent that is intersected, however.\n", true);
		HintTable[1].init("shortDescription", "If set, the NxDestructibleActor::rayCast function will search within the nearest visible chunk hit", true);
		ParamDefTable[38].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=39, longName="destructibleParameters.flags.USE_VALID_BOUNDS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[39];
		ParamDef->init("USE_VALID_BOUNDS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the validBounds field of NxDestructibleParameters will be used.  These bounds are translated\n(but not scaled or rotated) to the origin of the destructible actor.  If a chunk or chunk island moves\noutside of those bounds, it is destroyed.\n", true);
		HintTable[1].init("shortDescription", "If set, the validBounds field of NxDestructibleParameters will be used.", true);
		ParamDefTable[39].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=40, longName="destructibleParameters.grbVolumeLimit"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[40];
		ParamDef->init("grbVolumeLimit", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The relative volume (chunk volume / whole destructible volume) below which GRBs are used\ninstead of RBs to represent chunks in the physics scene.\n", true);
		HintTable[1].init("shortDescription", "The relative volume (chunk volume / whole destructible volume) below which GRBs are used", true);
		ParamDefTable[40].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=41, longName="destructibleParameters.grbParticleSpacing"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[41];
		ParamDef->init("grbParticleSpacing", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Spacing of particle grid used to represent rigid bodies in GRB\n", true);
		HintTable[1].init("shortDescription", "Spacing of particle grid used to represent rigid bodies in GRB", true);
		ParamDefTable[41].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=42, longName="destructibleParameters.fractureImpulseScale"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[42];
		ParamDef->init("fractureImpulseScale", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Scale factor used to apply an impulse force along the normal of chunk when fractured.  This is used\nin order to 'push' the pieces out as they fracture.\n", true);
		HintTable[1].init("shortDescription", "Scale factor used to apply an impulse force along the normal of chunk when fractured.", true);
		ParamDefTable[42].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=43, longName="destructibleParameters.dynamicChunkDominanceGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[43];
		ParamDef->init("dynamicChunkDominanceGroup", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Optional dominance group for dynamic chunks created when fractured. (ignored if > 31)\n", true);
		HintTable[1].init("shortDescription", "Optional dominance group for dynamic chunks created when fractured.", true);
		ParamDefTable[43].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=44, longName="destructibleParameters.dynamicChunksGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[44];
		ParamDef->init("dynamicChunksGroupsMask", TYPE_STRUCT, "GroupsMask", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Optional groups mask for dynamic chunks created when fractured.\n", true);
		HintTable[1].init("shortDescription", "Optional groups mask for dynamic chunks created when fractured.", true);
		ParamDefTable[44].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=45, longName="destructibleParameters.dynamicChunksGroupsMask.useGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[45];
		ParamDef->init("useGroupsMask", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the groupsMask should be used.  If so, then this will be applied to all NxShapes\n						created to represent this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Whether or not the groupsMask should be used", true);
		ParamDefTable[45].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=46, longName="destructibleParameters.dynamicChunksGroupsMask.bits0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[46];
		ParamDef->init("bits0", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits0 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits0 of the groups mask", true);
		ParamDefTable[46].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=47, longName="destructibleParameters.dynamicChunksGroupsMask.bits1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[47];
		ParamDef->init("bits1", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits1 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits1 of the groups mask", true);
		ParamDefTable[47].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=48, longName="destructibleParameters.dynamicChunksGroupsMask.bits2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[48];
		ParamDef->init("bits2", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits2 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits2 of the groups mask", true);
		ParamDefTable[48].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=49, longName="destructibleParameters.dynamicChunksGroupsMask.bits3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[49];
		ParamDef->init("bits3", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits3 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits3 of the groups mask", true);
		ParamDefTable[49].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=50, longName="depthParameters"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[50];
		ParamDef->init("depthParameters", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Parameters that apply to every chunk at a given level (see NxDestructibleDepthParameters)\nthe element [0] of the array applies to the level 0 (unfractured) chunk, element [1] applies\nto the level 1 chunks, etc.\n", true);
		HintTable[1].init("shortDescription", "Parameters that apply to every chunk at a given level (see NxDestructibleDepthParameters).", true);
		ParamDefTable[50].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=51, longName="depthParameters[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[51];
		ParamDef->init("depthParameters", TYPE_STRUCT, "DestructibleDepthParameters", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Parameters that apply to every chunk at a given level (see NxDestructibleDepthParameters)\nthe element [0] of the array applies to the level 0 (unfractured) chunk, element [1] applies\nto the level 1 chunks, etc.\n", true);
		HintTable[1].init("shortDescription", "Parameters that apply to every chunk at a given level (see NxDestructibleDepthParameters).", true);
		ParamDefTable[51].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=52, longName="depthParameters[].TAKE_IMPACT_DAMAGE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[52];
		ParamDef->init("TAKE_IMPACT_DAMAGE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this hierarchy depth level may take impact damage if this flag is set.\nNote, NxDestructibleParameters::forceToDamage must also be positive for this\nto take effect.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this hierarchy depth level may take impact damage if this flag is set.", true);
		ParamDefTable[52].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=53, longName="depthParameters[].IGNORE_POSE_UPDATES"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[53];
		ParamDef->init("IGNORE_POSE_UPDATES", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this depth should have pose updates ignored.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this depth should have pose updates ignored.", true);
		ParamDefTable[53].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=54, longName="depthParameters[].IGNORE_RAYCAST_CALLBACKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[54];
		ParamDef->init("IGNORE_RAYCAST_CALLBACKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this depth should be ignored in raycast callbacks.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this depth should be ignored in raycast callbacks.", true);
		ParamDefTable[54].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=55, longName="depthParameters[].IGNORE_CONTACT_CALLBACKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[55];
		ParamDef->init("IGNORE_CONTACT_CALLBACKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this depth should be ignored in contact callbacks.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this depth should be ignored in contact callbacks.", true);
		ParamDefTable[55].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=56, longName="depthParameters[].USER_FLAG_0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[56];
		ParamDef->init("USER_FLAG_0", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[56].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=57, longName="depthParameters[].USER_FLAG_1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[57];
		ParamDef->init("USER_FLAG_1", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[57].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=58, longName="depthParameters[].USER_FLAG_2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[58];
		ParamDef->init("USER_FLAG_2", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[58].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=59, longName="depthParameters[].USER_FLAG_3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[59];
		ParamDef->init("USER_FLAG_3", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[59].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=60, longName="shapeDescTemplate"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[60];
		ParamDef->init("shapeDescTemplate", TYPE_STRUCT, "ShapeDescTemplate", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[60].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Contains the parameters the application can override on any actor shapes created.", true);
		HintTable[2].init("shortDescription", "Contains the parameters the application can override on any actor shapes created", true);
		ParamDefTable[60].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=61, longName="shapeDescTemplate.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[61];
		ParamDef->init("flags", TYPE_STRUCT, "ShapeDescFlags", true);






	}

	// Initialize DefinitionImpl node: nodeIndex=62, longName="shapeDescTemplate.flags.NX_TRIGGER_ON_ENTER"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[62];
		ParamDef->init("NX_TRIGGER_ON_ENTER", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Trigger callback will be called when a shape enters the trigger volume.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Trigger callback will be called when a shape enters the trigger volume.", true);
		ParamDefTable[62].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=63, longName="shapeDescTemplate.flags.NX_TRIGGER_ON_LEAVE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[63];
		ParamDef->init("NX_TRIGGER_ON_LEAVE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Trigger callback will be called after a shape leaves the trigger volume.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Trigger callback will be called after a shape leaves the trigger volume.", true);
		ParamDefTable[63].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=64, longName="shapeDescTemplate.flags.NX_TRIGGER_ON_STAY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[64];
		ParamDef->init("NX_TRIGGER_ON_STAY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Trigger callback will be called while a shape is intersecting the trigger volume.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Trigger callback will be called while a shape is intersecting the trigger volume.", true);
		ParamDefTable[64].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=65, longName="shapeDescTemplate.flags.NX_SF_VISUALIZATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[65];
		ParamDef->init("NX_SF_VISUALIZATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable debug renderer for shapes.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable debug renderer for shapes", true);
		ParamDefTable[65].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=66, longName="shapeDescTemplate.flags.NX_SF_DISABLE_COLLISION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[66];
		ParamDef->init("NX_SF_DISABLE_COLLISION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable collision detection for shapes (counterpart of NX_AF_DISABLE_COLLISION).  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable collision detection for shapes (counterpart of NX_AF_DISABLE_COLLISION)", true);
		ParamDefTable[66].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=67, longName="shapeDescTemplate.flags.NX_SF_FEATURE_INDICES"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[67];
		ParamDef->init("NX_SF_FEATURE_INDICES", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable feature indices in contact stream.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable feature indices in contact stream.", true);
		ParamDefTable[67].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=68, longName="shapeDescTemplate.flags.NX_SF_DISABLE_RAYCASTING"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[68];
		ParamDef->init("NX_SF_DISABLE_RAYCASTING", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable raycasting for shapes.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable raycasting for shapes", true);
		ParamDefTable[68].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=69, longName="shapeDescTemplate.flags.NX_SF_POINT_CONTACT_FORCE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[69];
		ParamDef->init("NX_SF_POINT_CONTACT_FORCE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable contact force reporting per contact point in contact stream (otherwise we only report force per actor pair).  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable contact force reporting per contact point in contact stream (otherwise we only report force per actor pair)", true);
		ParamDefTable[69].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=70, longName="shapeDescTemplate.flags.NX_SF_FLUID_DRAIN"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[70];
		ParamDef->init("NX_SF_FLUID_DRAIN", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets a shape to be a fluid drain.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets a shape to be a fluid drain.", true);
		ParamDefTable[70].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=71, longName="shapeDescTemplate.flags.NX_SF_FLUID_DISABLE_COLLISION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[71];
		ParamDef->init("NX_SF_FLUID_DISABLE_COLLISION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable collision with fluids.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable collision with fluids.", true);
		ParamDefTable[71].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=72, longName="shapeDescTemplate.flags.NX_SF_FLUID_TWOWAY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[72];
		ParamDef->init("NX_SF_FLUID_TWOWAY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enables the reaction of a shapes actor on fluid collision.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enables the reaction of a shapes actor on fluid collision.", true);
		ParamDefTable[72].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=73, longName="shapeDescTemplate.flags.NX_SF_DISABLE_RESPONSE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[73];
		ParamDef->init("NX_SF_DISABLE_RESPONSE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable collision response for shapes (counterpart of NX_AF_DISABLE_RESPONSE).  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable collision response for shapes (counterpart of NX_AF_DISABLE_RESPONSE)", true);
		ParamDefTable[73].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=74, longName="shapeDescTemplate.flags.NX_SF_DYNAMIC_DYNAMIC_CCD"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[74];
		ParamDef->init("NX_SF_DYNAMIC_DYNAMIC_CCD", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable dynamic-dynamic CCD for shapes. Used only when CCD is globally enabled and shape have a CCD skeleton.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable dynamic-dynamic CCD for shapes. Used only when CCD is globally enabled and shape have a CCD skeleton.", true);
		ParamDefTable[74].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=75, longName="shapeDescTemplate.flags.NX_SF_DISABLE_SCENE_QUERIES"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[75];
		ParamDef->init("NX_SF_DISABLE_SCENE_QUERIES", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable participation in ray casts, overlap tests and sweeps.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable participation in ray casts, overlap tests and sweeps.", true);
		ParamDefTable[75].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=76, longName="shapeDescTemplate.flags.NX_SF_CLOTH_DRAIN"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[76];
		ParamDef->init("NX_SF_CLOTH_DRAIN", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets a shape to be a cloth drain.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets a shape to be a cloth drain.", true);
		ParamDefTable[76].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=77, longName="shapeDescTemplate.flags.NX_SF_CLOTH_DISABLE_COLLISION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[77];
		ParamDef->init("NX_SF_CLOTH_DISABLE_COLLISION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable collision with cloths.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable collision with cloths.", true);
		ParamDefTable[77].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=78, longName="shapeDescTemplate.flags.NX_SF_CLOTH_TWOWAY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[78];
		ParamDef->init("NX_SF_CLOTH_TWOWAY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enables the reaction of a shapes actor on cloth collision.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enables the reaction of a shapes actor on cloth collision.", true);
		ParamDefTable[78].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=79, longName="shapeDescTemplate.flags.NX_SF_SOFTBODY_DRAIN"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[79];
		ParamDef->init("NX_SF_SOFTBODY_DRAIN", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets a shape to be a soft body drain.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets a shape to be a soft body drain.", true);
		ParamDefTable[79].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=80, longName="shapeDescTemplate.flags.NX_SF_SOFTBODY_DISABLE_COLLISION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[80];
		ParamDef->init("NX_SF_SOFTBODY_DISABLE_COLLISION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable collision with soft bodies.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disable collision with soft bodies.", true);
		ParamDefTable[80].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=81, longName="shapeDescTemplate.flags.NX_SF_SOFTBODY_TWOWAY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[81];
		ParamDef->init("NX_SF_SOFTBODY_TWOWAY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enables the reaction of a shape's actor on soft body collision.  This flag is applied to all\n						NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enables the reaction of a shape's actor on soft body collision.", true);
		ParamDefTable[81].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=82, longName="shapeDescTemplate.collisionGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[82];
		ParamDef->init("collisionGroup", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets which collision group shapes are part of.\n						Default group is 0. Maximum possible group is 31. Collision groups are sets of shapes which may or may not be set to collision detect with each other; this can be set using NxScene::setGroupCollisionFlag() Sleeping: Does NOT wake the associated actor up automatically.  param[in] collisionGroup The collision group for shapes.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets which collision group shapes are part of.", true);
		ParamDefTable[82].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=83, longName="shapeDescTemplate.groupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[83];
		ParamDef->init("groupsMask", TYPE_STRUCT, "GroupsMask", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets the 128-bit mask used for collision filtering.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets the 128-bit mask used for collision filtering.", true);
		ParamDefTable[83].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=84, longName="shapeDescTemplate.groupsMask.useGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[84];
		ParamDef->init("useGroupsMask", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the groupsMask should be used.  If so, then this will be applied to all NxShapes\n						created to represent this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Whether or not the groupsMask should be used", true);
		ParamDefTable[84].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=85, longName="shapeDescTemplate.groupsMask.bits0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[85];
		ParamDef->init("bits0", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits0 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits0 of the groups mask", true);
		ParamDefTable[85].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=86, longName="shapeDescTemplate.groupsMask.bits1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[86];
		ParamDef->init("bits1", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits1 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits1 of the groups mask", true);
		ParamDefTable[86].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=87, longName="shapeDescTemplate.groupsMask.bits2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[87];
		ParamDef->init("bits2", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits2 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits2 of the groups mask", true);
		ParamDefTable[87].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=88, longName="shapeDescTemplate.groupsMask.bits3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[88];
		ParamDef->init("bits3", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits3 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits3 of the groups mask", true);
		ParamDefTable[88].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=89, longName="shapeDescTemplate.materialIndex"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[89];
		ParamDef->init("materialIndex", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The material index of a shape.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "The material index of a shape.", true);
		ParamDefTable[89].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=90, longName="shapeDescTemplate.density"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[90];
		ParamDef->init("density", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The density of this individual shape when computing mass inertial properties for a rigidbody (unless a valid mass >0.0 is provided).  Note that this will only be used if the body has a zero inertia tensor, or if you call NxActor::updateMassFromShapes explicitly.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "The density of an individual shape.", true);
		ParamDefTable[90].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=91, longName="shapeDescTemplate.skinWidth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[91];
		ParamDef->init("skinWidth", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Specifies by how much shapes can interpenetrate; if -1 it uses the global default.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Specifies by how much shapes can interpenetrate; if -1 it uses the global default", true);
		ParamDefTable[91].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=92, longName="shapeDescTemplate.userData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[92];
		ParamDef->init("userData", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[92].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional user data pointer.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional user data pointer", true);
		ParamDefTable[92].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=93, longName="shapeDescTemplate.name"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[93];
		ParamDef->init("name", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[93].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional name string for a shape; must be set by the application and must be a persistent pointer.\n						This is applied to all NxShapes generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional name string for a shape.", true);
		ParamDefTable[93].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=94, longName="actorDescTemplate"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[94];
		ParamDef->init("actorDescTemplate", TYPE_STRUCT, "ActorDescTemplate", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[94].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Contains the parameters the application can override on any actors created.", true);
		HintTable[2].init("shortDescription", "Contains the parameters the application can override on any actors created", true);
		ParamDefTable[94].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=95, longName="actorDescTemplate.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[95];
		ParamDef->init("flags", TYPE_STRUCT, "ActorDescFlags", true);






	}

	// Initialize DefinitionImpl node: nodeIndex=96, longName="actorDescTemplate.flags.NX_AF_DISABLE_COLLISION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[96];
		ParamDef->init("NX_AF_DISABLE_COLLISION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable/disable collision detection.\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable/disable collision detection", true);
		ParamDefTable[96].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=97, longName="actorDescTemplate.flags.NX_AF_DISABLE_RESPONSE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[97];
		ParamDef->init("NX_AF_DISABLE_RESPONSE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable/disable collision response (reports contacts but dont use them).\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable/disable collision response (reports contacts but dont use them)", true);
		ParamDefTable[97].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=98, longName="actorDescTemplate.flags.NX_AF_LOCK_COM"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[98];
		ParamDef->init("NX_AF_LOCK_COM", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disables COM update when computing inertial properties at creation time.\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disables COM update when computing inertial properties at creation time.", true);
		ParamDefTable[98].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=99, longName="actorDescTemplate.flags.NX_AF_FLUID_DISABLE_COLLISION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[99];
		ParamDef->init("NX_AF_FLUID_DISABLE_COLLISION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disables COM update when computing inertial properties at creation time.\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Disables COM update when computing inertial properties at creation time.", true);
		ParamDefTable[99].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=100, longName="actorDescTemplate.flags.NX_AF_CONTACT_MODIFICATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[100];
		ParamDef->init("NX_AF_CONTACT_MODIFICATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Turn on contact modification callback for the actor.\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Turn on contact modification callback for the actor.", true);
		ParamDefTable[100].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=101, longName="actorDescTemplate.flags.NX_AF_FORCE_CONE_FRICTION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[101];
		ParamDef->init("NX_AF_FORCE_CONE_FRICTION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Force cone friction to be used for this actor.\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Force cone friction to be used for this actor.", true);
		ParamDefTable[101].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=102, longName="actorDescTemplate.flags.NX_AF_USER_ACTOR_PAIR_FILTERING"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[102];
		ParamDef->init("NX_AF_USER_ACTOR_PAIR_FILTERING", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enable/disable custom contact filtering.\n						This flag will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enable/disable custom contact filtering.", true);
		ParamDefTable[102].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=103, longName="actorDescTemplate.density"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[103];
		ParamDef->init("density", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Density to be applied to the whole actor.  If the body descriptor contains a zero mass but the actor descriptor contains a non-zero density, we compute a new mass automatically from the density and a shapes.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Density to be applied to the whole actor.", true);
		ParamDefTable[103].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=104, longName="actorDescTemplate.actorCollisionGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[104];
		ParamDef->init("actorCollisionGroup", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Sets which NxActorGroup an actor is part of.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Sets which NxActorGroup an actor is part of", true);
		ParamDefTable[104].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=105, longName="actorDescTemplate.dominanceGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[105];
		ParamDef->init("dominanceGroup", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Dominance group for an actor.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Dominance group for an actor.", true);
		ParamDefTable[105].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=106, longName="actorDescTemplate.contactReportFlags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[106];
		ParamDef->init("contactReportFlags", TYPE_STRUCT, "ContactPairFlag", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Combination of ContactPairFlag flags.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Combination of ContactPairFlag flags", true);
		ParamDefTable[106].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=107, longName="actorDescTemplate.contactReportFlags.NX_IGNORE_PAIR"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[107];
		ParamDef->init("NX_IGNORE_PAIR", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Disable contact generation for this pair.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Disable contact generation for this pair", true);
		ParamDefTable[107].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=108, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_START_TOUCH"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[108];
		ParamDef->init("NX_NOTIFY_ON_START_TOUCH", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Pair callback will be called when the pair starts to be in contact.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Pair callback will be called when the pair starts to be in contact", true);
		ParamDefTable[108].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=109, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_END_TOUCH"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[109];
		ParamDef->init("NX_NOTIFY_ON_END_TOUCH", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Pair callback will be called when the pair stops to be in contact.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Pair callback will be called when the pair stops to be in contact", true);
		ParamDefTable[109].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=110, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_TOUCH"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[110];
		ParamDef->init("NX_NOTIFY_ON_TOUCH", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Pair callback will keep getting called while the pair is in contact.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Pair callback will keep getting called while the pair is in contact", true);
		ParamDefTable[110].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=111, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_IMPACT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[111];
		ParamDef->init("NX_NOTIFY_ON_IMPACT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "[Not yet implemented] pair callback will be called when it may be appropriate for the pair to play an impact sound.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "[Not yet implemented] pair callback will be called when it may be appropriate for the pair to play an impact sound", true);
		ParamDefTable[111].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=112, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_ROLL"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[112];
		ParamDef->init("NX_NOTIFY_ON_ROLL", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "[Not yet implemented] pair callback will be called when the pair is in contact and rolling.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "[Not yet implemented] pair callback will be called when the pair is in contact and rolling.", true);
		ParamDefTable[112].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=113, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_SLIDE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[113];
		ParamDef->init("NX_NOTIFY_ON_SLIDE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "[Not yet implemented] pair callback will be called when the pair is in contact and sliding (and not rolling).  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "[Not yet implemented] pair callback will be called when the pair is in contact and sliding (and not rolling).", true);
		ParamDefTable[113].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=114, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_FORCES"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[114];
		ParamDef->init("NX_NOTIFY_FORCES", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The (summed total) friction force and normal force will be given in the NxContactPair variable in the contact report.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "The (summed total) friction force and normal force will be given in the NxContactPair variable in the contact report.", true);
		ParamDefTable[114].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=115, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_START_TOUCH_FORCE_THRESHOLD"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[115];
		ParamDef->init("NX_NOTIFY_ON_START_TOUCH_FORCE_THRESHOLD", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Pair callback will be called when the contact force between two actors falls below the actor-defined force thresholds.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Pair callback will be called when the contact force between two actors falls below the actor-defined force thresholds", true);
		ParamDefTable[115].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=116, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_END_TOUCH_FORCE_THRESHOLD"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[116];
		ParamDef->init("NX_NOTIFY_ON_END_TOUCH_FORCE_THRESHOLD", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Pair callback will be called when the contact force between two actors falls below the actor-defined force thresholds.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Pair callback will be called when the contact force between two actors falls below the actor-defined force thresholds", true);
		ParamDefTable[116].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=117, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_TOUCH_FORCE_THRESHOLD"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[117];
		ParamDef->init("NX_NOTIFY_ON_TOUCH_FORCE_THRESHOLD", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Pair callback will keep getting called while the contact force between two actors exceeds one of the actor-defined force thresholds.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Pair callback will keep getting called while the contact force between two actors exceeds one of the actor-defined force thresholds", true);
		ParamDefTable[117].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=118, longName="actorDescTemplate.contactReportFlags.NX_NOTIFY_CONTACT_MODIFICATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[118];
		ParamDef->init("NX_NOTIFY_CONTACT_MODIFICATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Generate a callback for all associated contact constraints, making it possible to edit the constraint. This flag is not included in NX_NOTIFY_ALL for performance reasons. see NxUserContactModify.  See the PhysX documentation for more about contact reporting.", true);
		HintTable[1].init("shortDescription", "Generate a callback for all associated contact constraints, making it possible to edit the constraint. This flag is not included in NX_NOTIFY_ALL for performance reasons. see NxUserContactModify.", true);
		ParamDefTable[118].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=119, longName="actorDescTemplate.forceFieldMaterial"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[119];
		ParamDef->init("forceFieldMaterial", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Force Field Material Index, index != 0 has to be created.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Force Field Material Index", true);
		ParamDefTable[119].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=120, longName="actorDescTemplate.userData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[120];
		ParamDef->init("userData", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[120].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional user data pointer.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional user data pointer", true);
		ParamDefTable[120].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=121, longName="actorDescTemplate.name"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[121];
		ParamDef->init("name", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[121].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional name string for a shape; must be set by the application and must be a persistent pointer.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional name string for a shape; must be set by the application and must be a persistent pointer.", true);
		ParamDefTable[121].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=122, longName="actorDescTemplate.compartment"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[122];
		ParamDef->init("compartment", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[122].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Optional compartment pointer; must be set by the application.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[2].init("shortDescription", "Optional compartment pointer", true);
		ParamDefTable[122].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=123, longName="bodyDescTemplate"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[123];
		ParamDef->init("bodyDescTemplate", TYPE_STRUCT, "BodyDescTemplate", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[123].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Contains the parameterse that the application can override for the body descriptor of rigid body actors created.", true);
		HintTable[2].init("shortDescription", "Contains the parameterse that the application can override for the body descriptor of rigid body actors created", true);
		ParamDefTable[123].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=124, longName="bodyDescTemplate.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[124];
		ParamDef->init("flags", TYPE_STRUCT, "BodyDescFlags", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Combination of body descriptor flags.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Combination of body descriptor flags", true);
		ParamDefTable[124].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=125, longName="bodyDescTemplate.flags.NX_BF_DISABLE_GRAVITY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[125];
		ParamDef->init("NX_BF_DISABLE_GRAVITY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Set if gravity should not be applied on this body.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Set if gravity should not be applied on this body", true);
		ParamDefTable[125].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=126, longName="bodyDescTemplate.flags.NX_BF_FILTER_SLEEP_VEL"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[126];
		ParamDef->init("NX_BF_FILTER_SLEEP_VEL", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Filter velocities used keep body awake. The filter reduces rapid oscillations and transient spikes.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Filter velocities used keep body awake. The filter reduces rapid oscillations and transient spikes", true);
		ParamDefTable[126].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=127, longName="bodyDescTemplate.flags.NX_BF_ENERGY_SLEEP_TEST"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[127];
		ParamDef->init("NX_BF_ENERGY_SLEEP_TEST", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enables energy-based sleeping algorithm.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enables energy-based sleeping algorithm", true);
		ParamDefTable[127].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=128, longName="bodyDescTemplate.flags.NX_BF_VISUALIZATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[128];
		ParamDef->init("NX_BF_VISUALIZATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Enables debug visualization for this body.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Enables debug visualization for this body", true);
		ParamDefTable[128].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=129, longName="bodyDescTemplate.wakeUpCounter"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[129];
		ParamDef->init("wakeUpCounter", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The bodys initial wake up counter.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "The bodys initial wake up counter", true);
		ParamDefTable[129].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=130, longName="bodyDescTemplate.linearDamping"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[130];
		ParamDef->init("linearDamping", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Linear damping applied to the body.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Linear damping applied to the body", true);
		ParamDefTable[130].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=131, longName="bodyDescTemplate.angularDamping"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[131];
		ParamDef->init("angularDamping", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Angular damping applied to the body.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Angular damping applied to the body", true);
		ParamDefTable[131].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=132, longName="bodyDescTemplate.maxAngularVelocity"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[132];
		ParamDef->init("maxAngularVelocity", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Maximum allowed angular velocity.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Maximum allowed angular velocity", true);
		ParamDefTable[132].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=133, longName="bodyDescTemplate.CCDMotionThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[133];
		ParamDef->init("CCDMotionThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "When CCD is globally enabled, it is still not performed if the motion distance of all points on the body is below this threshold.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Distance threshold for CCD", true);
		ParamDefTable[133].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=134, longName="bodyDescTemplate.sleepLinearVelocity"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[134];
		ParamDef->init("sleepLinearVelocity", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Maximum linear velocity at which body can go to sleep.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Maximum linear velocity at which body can go to sleep", true);
		ParamDefTable[134].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=135, longName="bodyDescTemplate.sleepAngularVelocity"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[135];
		ParamDef->init("sleepAngularVelocity", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Maximum angular velocity at which body can go to sleep.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Maximum angular velocity at which body can go to sleep", true);
		ParamDefTable[135].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=136, longName="bodyDescTemplate.solverIterationCount"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[136];
		ParamDef->init("solverIterationCount", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Number of solver iterations performed when processing joint/contacts connected to this body.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Number of solver iterations performed when processing joint/contacts connected to this body", true);
		ParamDefTable[136].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=137, longName="bodyDescTemplate.sleepEnergyThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[137];
		ParamDef->init("sleepEnergyThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Threshold for the energy-based sleeping algorithm. Only used when the NX_BF_ENERGY_SLEEP_TEST flag is set.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Threshold for the energy-based sleeping algorithm. Only used when the NX_BF_ENERGY_SLEEP_TEST flag is set", true);
		ParamDefTable[137].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=138, longName="bodyDescTemplate.sleepDamping"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[138];
		ParamDef->init("sleepDamping", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Damping factor for bodies that are about to sleep.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Damping factor for bodies that are about to sleep", true);
		ParamDefTable[138].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=139, longName="bodyDescTemplate.contactReportThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[139];
		ParamDef->init("contactReportThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The force threshold for contact reports.\n						This will be applied to all NxActors generated for this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "The force threshold for contact reports", true);
		ParamDefTable[139].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// SetChildren for: nodeIndex=0, longName=""
	{
		static Definition* Children[13];
		Children[0] = PDEF_PTR(1);
		Children[1] = PDEF_PTR(2);
		Children[2] = PDEF_PTR(3);
		Children[3] = PDEF_PTR(4);
		Children[4] = PDEF_PTR(5);
		Children[5] = PDEF_PTR(6);
		Children[6] = PDEF_PTR(7);
		Children[7] = PDEF_PTR(9);
		Children[8] = PDEF_PTR(11);
		Children[9] = PDEF_PTR(50);
		Children[10] = PDEF_PTR(60);
		Children[11] = PDEF_PTR(94);
		Children[12] = PDEF_PTR(123);

		ParamDefTable[0].setChildren(Children, 13);
	}

	// SetChildren for: nodeIndex=7, longName="overrideSkinnedMaterialNames"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(8);

		ParamDefTable[7].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=9, longName="overrideStaticMaterialNames"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(10);

		ParamDefTable[9].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=11, longName="destructibleParameters"
	{
		static Definition* Children[25];
		Children[0] = PDEF_PTR(12);
		Children[1] = PDEF_PTR(13);
		Children[2] = PDEF_PTR(14);
		Children[3] = PDEF_PTR(15);
		Children[4] = PDEF_PTR(16);
		Children[5] = PDEF_PTR(17);
		Children[6] = PDEF_PTR(18);
		Children[7] = PDEF_PTR(19);
		Children[8] = PDEF_PTR(20);
		Children[9] = PDEF_PTR(21);
		Children[10] = PDEF_PTR(22);
		Children[11] = PDEF_PTR(23);
		Children[12] = PDEF_PTR(24);
		Children[13] = PDEF_PTR(25);
		Children[14] = PDEF_PTR(26);
		Children[15] = PDEF_PTR(27);
		Children[16] = PDEF_PTR(28);
		Children[17] = PDEF_PTR(29);
		Children[18] = PDEF_PTR(30);
		Children[19] = PDEF_PTR(31);
		Children[20] = PDEF_PTR(40);
		Children[21] = PDEF_PTR(41);
		Children[22] = PDEF_PTR(42);
		Children[23] = PDEF_PTR(43);
		Children[24] = PDEF_PTR(44);

		ParamDefTable[11].setChildren(Children, 25);
	}

	// SetChildren for: nodeIndex=31, longName="destructibleParameters.flags"
	{
		static Definition* Children[8];
		Children[0] = PDEF_PTR(32);
		Children[1] = PDEF_PTR(33);
		Children[2] = PDEF_PTR(34);
		Children[3] = PDEF_PTR(35);
		Children[4] = PDEF_PTR(36);
		Children[5] = PDEF_PTR(37);
		Children[6] = PDEF_PTR(38);
		Children[7] = PDEF_PTR(39);

		ParamDefTable[31].setChildren(Children, 8);
	}

	// SetChildren for: nodeIndex=44, longName="destructibleParameters.dynamicChunksGroupsMask"
	{
		static Definition* Children[5];
		Children[0] = PDEF_PTR(45);
		Children[1] = PDEF_PTR(46);
		Children[2] = PDEF_PTR(47);
		Children[3] = PDEF_PTR(48);
		Children[4] = PDEF_PTR(49);

		ParamDefTable[44].setChildren(Children, 5);
	}

	// SetChildren for: nodeIndex=50, longName="depthParameters"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(51);

		ParamDefTable[50].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=51, longName="depthParameters[]"
	{
		static Definition* Children[8];
		Children[0] = PDEF_PTR(52);
		Children[1] = PDEF_PTR(53);
		Children[2] = PDEF_PTR(54);
		Children[3] = PDEF_PTR(55);
		Children[4] = PDEF_PTR(56);
		Children[5] = PDEF_PTR(57);
		Children[6] = PDEF_PTR(58);
		Children[7] = PDEF_PTR(59);

		ParamDefTable[51].setChildren(Children, 8);
	}

	// SetChildren for: nodeIndex=60, longName="shapeDescTemplate"
	{
		static Definition* Children[8];
		Children[0] = PDEF_PTR(61);
		Children[1] = PDEF_PTR(82);
		Children[2] = PDEF_PTR(83);
		Children[3] = PDEF_PTR(89);
		Children[4] = PDEF_PTR(90);
		Children[5] = PDEF_PTR(91);
		Children[6] = PDEF_PTR(92);
		Children[7] = PDEF_PTR(93);

		ParamDefTable[60].setChildren(Children, 8);
	}

	// SetChildren for: nodeIndex=61, longName="shapeDescTemplate.flags"
	{
		static Definition* Children[20];
		Children[0] = PDEF_PTR(62);
		Children[1] = PDEF_PTR(63);
		Children[2] = PDEF_PTR(64);
		Children[3] = PDEF_PTR(65);
		Children[4] = PDEF_PTR(66);
		Children[5] = PDEF_PTR(67);
		Children[6] = PDEF_PTR(68);
		Children[7] = PDEF_PTR(69);
		Children[8] = PDEF_PTR(70);
		Children[9] = PDEF_PTR(71);
		Children[10] = PDEF_PTR(72);
		Children[11] = PDEF_PTR(73);
		Children[12] = PDEF_PTR(74);
		Children[13] = PDEF_PTR(75);
		Children[14] = PDEF_PTR(76);
		Children[15] = PDEF_PTR(77);
		Children[16] = PDEF_PTR(78);
		Children[17] = PDEF_PTR(79);
		Children[18] = PDEF_PTR(80);
		Children[19] = PDEF_PTR(81);

		ParamDefTable[61].setChildren(Children, 20);
	}

	// SetChildren for: nodeIndex=83, longName="shapeDescTemplate.groupsMask"
	{
		static Definition* Children[5];
		Children[0] = PDEF_PTR(84);
		Children[1] = PDEF_PTR(85);
		Children[2] = PDEF_PTR(86);
		Children[3] = PDEF_PTR(87);
		Children[4] = PDEF_PTR(88);

		ParamDefTable[83].setChildren(Children, 5);
	}

	// SetChildren for: nodeIndex=94, longName="actorDescTemplate"
	{
		static Definition* Children[9];
		Children[0] = PDEF_PTR(95);
		Children[1] = PDEF_PTR(103);
		Children[2] = PDEF_PTR(104);
		Children[3] = PDEF_PTR(105);
		Children[4] = PDEF_PTR(106);
		Children[5] = PDEF_PTR(119);
		Children[6] = PDEF_PTR(120);
		Children[7] = PDEF_PTR(121);
		Children[8] = PDEF_PTR(122);

		ParamDefTable[94].setChildren(Children, 9);
	}

	// SetChildren for: nodeIndex=95, longName="actorDescTemplate.flags"
	{
		static Definition* Children[7];
		Children[0] = PDEF_PTR(96);
		Children[1] = PDEF_PTR(97);
		Children[2] = PDEF_PTR(98);
		Children[3] = PDEF_PTR(99);
		Children[4] = PDEF_PTR(100);
		Children[5] = PDEF_PTR(101);
		Children[6] = PDEF_PTR(102);

		ParamDefTable[95].setChildren(Children, 7);
	}

	// SetChildren for: nodeIndex=106, longName="actorDescTemplate.contactReportFlags"
	{
		static Definition* Children[12];
		Children[0] = PDEF_PTR(107);
		Children[1] = PDEF_PTR(108);
		Children[2] = PDEF_PTR(109);
		Children[3] = PDEF_PTR(110);
		Children[4] = PDEF_PTR(111);
		Children[5] = PDEF_PTR(112);
		Children[6] = PDEF_PTR(113);
		Children[7] = PDEF_PTR(114);
		Children[8] = PDEF_PTR(115);
		Children[9] = PDEF_PTR(116);
		Children[10] = PDEF_PTR(117);
		Children[11] = PDEF_PTR(118);

		ParamDefTable[106].setChildren(Children, 12);
	}

	// SetChildren for: nodeIndex=123, longName="bodyDescTemplate"
	{
		static Definition* Children[12];
		Children[0] = PDEF_PTR(124);
		Children[1] = PDEF_PTR(129);
		Children[2] = PDEF_PTR(130);
		Children[3] = PDEF_PTR(131);
		Children[4] = PDEF_PTR(132);
		Children[5] = PDEF_PTR(133);
		Children[6] = PDEF_PTR(134);
		Children[7] = PDEF_PTR(135);
		Children[8] = PDEF_PTR(136);
		Children[9] = PDEF_PTR(137);
		Children[10] = PDEF_PTR(138);
		Children[11] = PDEF_PTR(139);

		ParamDefTable[123].setChildren(Children, 12);
	}

	// SetChildren for: nodeIndex=124, longName="bodyDescTemplate.flags"
	{
		static Definition* Children[4];
		Children[0] = PDEF_PTR(125);
		Children[1] = PDEF_PTR(126);
		Children[2] = PDEF_PTR(127);
		Children[3] = PDEF_PTR(128);

		ParamDefTable[124].setChildren(Children, 4);
	}

	mBuiltFlag = true;

}
void DestructibleActorParam_0p0::initStrings(void)
{
	crumbleEmitterName.isAllocated = false;
	crumbleEmitterName.buf = (const char*)0;
	dustEmitterName.isAllocated = false;
	dustEmitterName.buf = (const char*)0;
}

void DestructibleActorParam_0p0::initDynamicArrays(void)
{
	overrideSkinnedMaterialNames.buf = NULL;
	overrideSkinnedMaterialNames.isAllocated = true;
	overrideSkinnedMaterialNames.elementSize = sizeof(NvParameterized::DummyStringStruct);
	overrideSkinnedMaterialNames.arraySizes[0] = 0;
	overrideStaticMaterialNames.buf = NULL;
	overrideStaticMaterialNames.isAllocated = true;
	overrideStaticMaterialNames.elementSize = sizeof(NvParameterized::DummyStringStruct);
	overrideStaticMaterialNames.arraySizes[0] = 0;
	depthParameters.buf = NULL;
	depthParameters.isAllocated = true;
	depthParameters.elementSize = sizeof(DestructibleDepthParameters_Type);
	depthParameters.arraySizes[0] = 0;
}

void DestructibleActorParam_0p0::initDefaults(void)
{

	freeStrings();
	freeReferences();
	freeDynamicArrays();
	{
		const float value[12] = {true};
		for (int i = 0; i < 12; ++i)
		{
			globalPose[i] = value[i];
		}
	}
	scale = physx::PxVec3(init(1, 1, 1));
	dynamic = bool(true);
	renderStaticChunksSeparately = bool(false);
	destructibleParameters.damageThreshold = float(1);
	destructibleParameters.damageToRadius = float(0.1);
	destructibleParameters.damageCap = float(0);
	destructibleParameters.forceToDamage = float(0);
	destructibleParameters.impactVelocityThreshold = float(0);
	destructibleParameters.materialStrength = float(0);
	destructibleParameters.damageToPercentDeformation = float(0);
	destructibleParameters.deformationPercentLimit = float(1);
	destructibleParameters.formExtendedStructures = uint32_t(0);
	destructibleParameters.supportDepth = uint32_t(0);
	destructibleParameters.debrisDepth = int32_t(-1);
	destructibleParameters.essentialDepth = uint32_t(0);
	destructibleParameters.debrisLifetimeMin = float(1);
	destructibleParameters.debrisLifetimeMax = float(10);
	destructibleParameters.debrisMaxSeparationMin = float(1);
	destructibleParameters.debrisMaxSeparationMax = float(10);
	destructibleParameters.validBounds = physx::PxBounds3(init(-1000, -1000, -1000, 1000, 1000, 1000));
	destructibleParameters.maxChunkSpeed = float(0);
	destructibleParameters.massScaleExponent = float(0.5);
	destructibleParameters.flags.ACCUMULATE_DAMAGE = bool(true);
	destructibleParameters.flags.ASSET_DEFINED_SUPPORT = bool(false);
	destructibleParameters.flags.WORLD_SUPPORT = bool(false);
	destructibleParameters.flags.DEBRIS_TIMEOUT = bool(false);
	destructibleParameters.flags.DEBRIS_MAX_SEPARATION = bool(false);
	destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS = bool(false);
	destructibleParameters.flags.ACCURATE_RAYCASTS = bool(false);
	destructibleParameters.flags.USE_VALID_BOUNDS = bool(false);
	destructibleParameters.grbVolumeLimit = float(0.2);
	destructibleParameters.grbParticleSpacing = float(0.1);
	destructibleParameters.fractureImpulseScale = float(0);
	destructibleParameters.dynamicChunkDominanceGroup = uint16_t(UINT16_MAX);
	destructibleParameters.dynamicChunksGroupsMask.useGroupsMask = bool(false);
	destructibleParameters.dynamicChunksGroupsMask.bits0 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits1 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits2 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits3 = uint32_t(0);
	shapeDescTemplate.flags.NX_TRIGGER_ON_ENTER = bool(false);
	shapeDescTemplate.flags.NX_TRIGGER_ON_LEAVE = bool(false);
	shapeDescTemplate.flags.NX_TRIGGER_ON_STAY = bool(false);
	shapeDescTemplate.flags.NX_SF_VISUALIZATION = bool(true);
	shapeDescTemplate.flags.NX_SF_DISABLE_COLLISION = bool(false);
	shapeDescTemplate.flags.NX_SF_FEATURE_INDICES = bool(false);
	shapeDescTemplate.flags.NX_SF_DISABLE_RAYCASTING = bool(false);
	shapeDescTemplate.flags.NX_SF_POINT_CONTACT_FORCE = bool(false);
	shapeDescTemplate.flags.NX_SF_FLUID_DRAIN = bool(false);
	shapeDescTemplate.flags.NX_SF_FLUID_DISABLE_COLLISION = bool(false);
	shapeDescTemplate.flags.NX_SF_FLUID_TWOWAY = bool(false);
	shapeDescTemplate.flags.NX_SF_DISABLE_RESPONSE = bool(false);
	shapeDescTemplate.flags.NX_SF_DYNAMIC_DYNAMIC_CCD = bool(false);
	shapeDescTemplate.flags.NX_SF_DISABLE_SCENE_QUERIES = bool(false);
	shapeDescTemplate.flags.NX_SF_CLOTH_DRAIN = bool(false);
	shapeDescTemplate.flags.NX_SF_CLOTH_DISABLE_COLLISION = bool(false);
	shapeDescTemplate.flags.NX_SF_CLOTH_TWOWAY = bool(true);
	shapeDescTemplate.flags.NX_SF_SOFTBODY_DRAIN = bool(false);
	shapeDescTemplate.flags.NX_SF_SOFTBODY_DISABLE_COLLISION = bool(false);
	shapeDescTemplate.flags.NX_SF_SOFTBODY_TWOWAY = bool(true);
	shapeDescTemplate.collisionGroup = uint16_t(0);
	shapeDescTemplate.groupsMask.useGroupsMask = bool(false);
	shapeDescTemplate.groupsMask.bits0 = uint32_t(0);
	shapeDescTemplate.groupsMask.bits1 = uint32_t(0);
	shapeDescTemplate.groupsMask.bits2 = uint32_t(0);
	shapeDescTemplate.groupsMask.bits3 = uint32_t(0);
	shapeDescTemplate.materialIndex = uint16_t(0);
	shapeDescTemplate.density = float(1);
	shapeDescTemplate.skinWidth = float(-1);
	shapeDescTemplate.userData = uint64_t(0);
	shapeDescTemplate.name = uint64_t(0);
	actorDescTemplate.flags.NX_AF_DISABLE_COLLISION = bool(false);
	actorDescTemplate.flags.NX_AF_DISABLE_RESPONSE = bool(false);
	actorDescTemplate.flags.NX_AF_LOCK_COM = bool(false);
	actorDescTemplate.flags.NX_AF_FLUID_DISABLE_COLLISION = bool(false);
	actorDescTemplate.flags.NX_AF_CONTACT_MODIFICATION = bool(false);
	actorDescTemplate.flags.NX_AF_FORCE_CONE_FRICTION = bool(false);
	actorDescTemplate.flags.NX_AF_USER_ACTOR_PAIR_FILTERING = bool(false);
	actorDescTemplate.density = float(1);
	actorDescTemplate.actorCollisionGroup = uint16_t(0);
	actorDescTemplate.dominanceGroup = uint16_t(0);
	actorDescTemplate.contactReportFlags.NX_IGNORE_PAIR = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_START_TOUCH = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_END_TOUCH = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_TOUCH = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_IMPACT = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_ROLL = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_SLIDE = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_FORCES = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_START_TOUCH_FORCE_THRESHOLD = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_END_TOUCH_FORCE_THRESHOLD = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_ON_TOUCH_FORCE_THRESHOLD = bool(false);
	actorDescTemplate.contactReportFlags.NX_NOTIFY_CONTACT_MODIFICATION = bool(false);
	actorDescTemplate.forceFieldMaterial = uint16_t(0);
	actorDescTemplate.userData = uint64_t(0);
	actorDescTemplate.name = uint64_t(0);
	actorDescTemplate.compartment = uint64_t(0);
	bodyDescTemplate.flags.NX_BF_DISABLE_GRAVITY = bool(false);
	bodyDescTemplate.flags.NX_BF_FILTER_SLEEP_VEL = bool(false);
	bodyDescTemplate.flags.NX_BF_ENERGY_SLEEP_TEST = bool(true);
	bodyDescTemplate.flags.NX_BF_VISUALIZATION = bool(true);
	bodyDescTemplate.wakeUpCounter = float(0.4);
	bodyDescTemplate.linearDamping = float(0);
	bodyDescTemplate.angularDamping = float(0.05);
	bodyDescTemplate.maxAngularVelocity = float(-1);
	bodyDescTemplate.CCDMotionThreshold = float(0);
	bodyDescTemplate.sleepLinearVelocity = float(-1);
	bodyDescTemplate.sleepAngularVelocity = float(-1);
	bodyDescTemplate.solverIterationCount = uint32_t(4);
	bodyDescTemplate.sleepEnergyThreshold = float(0.005);
	bodyDescTemplate.sleepDamping = float(0);
	bodyDescTemplate.contactReportThreshold = float(PX_MAX_F32);

	initDynamicArrays();
	initStrings();
	initReferences();
}

void DestructibleActorParam_0p0::initReferences(void)
{
}

void DestructibleActorParam_0p0::freeDynamicArrays(void)
{
	if (overrideSkinnedMaterialNames.isAllocated && overrideSkinnedMaterialNames.buf)
	{
		mParameterizedTraits->free(overrideSkinnedMaterialNames.buf);
	}
	if (overrideStaticMaterialNames.isAllocated && overrideStaticMaterialNames.buf)
	{
		mParameterizedTraits->free(overrideStaticMaterialNames.buf);
	}
	if (depthParameters.isAllocated && depthParameters.buf)
	{
		mParameterizedTraits->free(depthParameters.buf);
	}
}

void DestructibleActorParam_0p0::freeStrings(void)
{

	if (crumbleEmitterName.isAllocated && crumbleEmitterName.buf)
	{
		mParameterizedTraits->strfree((char*)crumbleEmitterName.buf);
	}

	if (dustEmitterName.isAllocated && dustEmitterName.buf)
	{
		mParameterizedTraits->strfree((char*)dustEmitterName.buf);
	}

	for (int i = 0; i < overrideSkinnedMaterialNames.arraySizes[0]; ++i)
	{
		if (overrideSkinnedMaterialNames.buf[i].isAllocated && overrideSkinnedMaterialNames.buf[i].buf)
		{
			mParameterizedTraits->strfree((char*)overrideSkinnedMaterialNames.buf[i].buf);
		}
	}

	for (int i = 0; i < overrideStaticMaterialNames.arraySizes[0]; ++i)
	{
		if (overrideStaticMaterialNames.buf[i].isAllocated && overrideStaticMaterialNames.buf[i].buf)
		{
			mParameterizedTraits->strfree((char*)overrideStaticMaterialNames.buf[i].buf);
		}
	}
}

void DestructibleActorParam_0p0::freeReferences(void)
{
}

} // namespace parameterized
} // namespace nvidia
