// This code contains NVIDIA Confidential Information and is disclosed to you
// under a form of NVIDIA software license agreement provided separately to you.
//
// Notice
// NVIDIA Corporation and its licensors retain all intellectual property and
// proprietary rights in and to this software and related documentation and
// any modifications thereto. Any use, reproduction, disclosure, or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA Corporation is strictly prohibited.
//
// ALL NVIDIA DESIGN SPECIFICATIONS, CODE ARE PROVIDED "AS IS.". NVIDIA MAKES
// NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO
// THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT,
// MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE.
//
// Information and code furnished is believed to be accurate and reliable.
// However, NVIDIA Corporation assumes no responsibility for the consequences of use of such
// information or for any infringement of patents or other rights of third parties that may
// result from its use. No license is granted by implication or otherwise under any patent
// or patent rights of NVIDIA Corporation. Details are subject to change without notice.
// This code supersedes and replaces all information previously supplied.
// NVIDIA Corporation products are not authorized for use as critical
// components in life support devices or systems without express written approval of
// NVIDIA Corporation.
//
// Copyright (c) 2008-2020 NVIDIA Corporation. All rights reserved.

// This file was generated by NvParameterized/scripts/GenParameterized.pl


#include "DestructibleAssetParameters_0p20.h"
#include <string.h>
#include <stdlib.h>

using namespace NvParameterized;

namespace nvidia
{
namespace parameterized
{

using namespace DestructibleAssetParameters_0p20NS;

const char* const DestructibleAssetParameters_0p20Factory::vptr =
    NvParameterized::getVptr<DestructibleAssetParameters_0p20, DestructibleAssetParameters_0p20::ClassAlignment>();

const uint32_t NumParamDefs = 150;
static NvParameterized::DefinitionImpl* ParamDefTable; // now allocated in buildTree [NumParamDefs];


static const size_t ParamLookupChildrenTable[] =
{
	1, 2, 3, 4, 5, 22, 40, 41, 53, 55, 57, 108, 119, 120, 121, 122, 123, 124, 129, 131,
	132, 134, 136, 137, 138, 139, 140, 142, 144, 146, 6, 7, 8, 9, 13, 17, 18, 19, 20,
	21, 10, 11, 12, 14, 15, 16, 23, 24, 25, 26, 27, 31, 35, 36, 37, 38, 39, 28, 29, 30,
	32, 33, 34, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 54, 56, 58, 59, 60, 61, 62,
	63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 80, 81, 82, 83, 89, 73, 74, 75, 76, 77, 78,
	79, 84, 85, 86, 87, 88, 90, 91, 92, 93, 94, 95, 101, 96, 97, 98, 99, 100, 102, 103,
	104, 105, 106, 107, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 125, 126, 127,
	128, 130, 133, 135, 141, 143, 145, 147, 148, 149,
};

#define TENUM(type) nvidia::##type
#define CHILDREN(index) &ParamLookupChildrenTable[index]
static const NvParameterized::ParamLookupNode ParamLookupTable[NumParamDefs] =
{
	{ TYPE_STRUCT, false, 0, CHILDREN(0), 30 },
	{ TYPE_STRING, false, (size_t)(&((ParametersStruct*)0)->comments), NULL, 0 }, // comments
	{ TYPE_U32, false, (size_t)(&((ParametersStruct*)0)->depthCount), NULL, 0 }, // depthCount
	{ TYPE_U32, false, (size_t)(&((ParametersStruct*)0)->originalDepthCount), NULL, 0 }, // originalDepthCount
	{ TYPE_BOUNDS3, false, (size_t)(&((ParametersStruct*)0)->bounds), NULL, 0 }, // bounds
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->defaultBehaviorGroup), CHILDREN(30), 10 }, // defaultBehaviorGroup
	{ TYPE_STRING, false, (size_t)(&((BehaviorGroup_Type*)0)->name), NULL, 0 }, // defaultBehaviorGroup.name
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->damageThreshold), NULL, 0 }, // defaultBehaviorGroup.damageThreshold
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->damageToRadius), NULL, 0 }, // defaultBehaviorGroup.damageToRadius
	{ TYPE_STRUCT, false, (size_t)(&((BehaviorGroup_Type*)0)->damageSpread), CHILDREN(40), 3 }, // defaultBehaviorGroup.damageSpread
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->minimumRadius), NULL, 0 }, // defaultBehaviorGroup.damageSpread.minimumRadius
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->radiusMultiplier), NULL, 0 }, // defaultBehaviorGroup.damageSpread.radiusMultiplier
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->falloffExponent), NULL, 0 }, // defaultBehaviorGroup.damageSpread.falloffExponent
	{ TYPE_STRUCT, false, (size_t)(&((BehaviorGroup_Type*)0)->damageColorSpread), CHILDREN(43), 3 }, // defaultBehaviorGroup.damageColorSpread
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->minimumRadius), NULL, 0 }, // defaultBehaviorGroup.damageColorSpread.minimumRadius
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->radiusMultiplier), NULL, 0 }, // defaultBehaviorGroup.damageColorSpread.radiusMultiplier
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->falloffExponent), NULL, 0 }, // defaultBehaviorGroup.damageColorSpread.falloffExponent
	{ TYPE_VEC4, false, (size_t)(&((BehaviorGroup_Type*)0)->damageColorChange), NULL, 0 }, // defaultBehaviorGroup.damageColorChange
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->materialStrength), NULL, 0 }, // defaultBehaviorGroup.materialStrength
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->density), NULL, 0 }, // defaultBehaviorGroup.density
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->fadeOut), NULL, 0 }, // defaultBehaviorGroup.fadeOut
	{ TYPE_U64, false, (size_t)(&((BehaviorGroup_Type*)0)->userData), NULL, 0 }, // defaultBehaviorGroup.userData
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->behaviorGroups), CHILDREN(46), 1 }, // behaviorGroups
	{ TYPE_STRUCT, false, 1 * sizeof(BehaviorGroup_Type), CHILDREN(47), 10 }, // behaviorGroups[]
	{ TYPE_STRING, false, (size_t)(&((BehaviorGroup_Type*)0)->name), NULL, 0 }, // behaviorGroups[].name
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->damageThreshold), NULL, 0 }, // behaviorGroups[].damageThreshold
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->damageToRadius), NULL, 0 }, // behaviorGroups[].damageToRadius
	{ TYPE_STRUCT, false, (size_t)(&((BehaviorGroup_Type*)0)->damageSpread), CHILDREN(57), 3 }, // behaviorGroups[].damageSpread
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->minimumRadius), NULL, 0 }, // behaviorGroups[].damageSpread.minimumRadius
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->radiusMultiplier), NULL, 0 }, // behaviorGroups[].damageSpread.radiusMultiplier
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->falloffExponent), NULL, 0 }, // behaviorGroups[].damageSpread.falloffExponent
	{ TYPE_STRUCT, false, (size_t)(&((BehaviorGroup_Type*)0)->damageColorSpread), CHILDREN(60), 3 }, // behaviorGroups[].damageColorSpread
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->minimumRadius), NULL, 0 }, // behaviorGroups[].damageColorSpread.minimumRadius
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->radiusMultiplier), NULL, 0 }, // behaviorGroups[].damageColorSpread.radiusMultiplier
	{ TYPE_F32, false, (size_t)(&((DamageSpreadFunction_Type*)0)->falloffExponent), NULL, 0 }, // behaviorGroups[].damageColorSpread.falloffExponent
	{ TYPE_VEC4, false, (size_t)(&((BehaviorGroup_Type*)0)->damageColorChange), NULL, 0 }, // behaviorGroups[].damageColorChange
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->materialStrength), NULL, 0 }, // behaviorGroups[].materialStrength
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->density), NULL, 0 }, // behaviorGroups[].density
	{ TYPE_F32, false, (size_t)(&((BehaviorGroup_Type*)0)->fadeOut), NULL, 0 }, // behaviorGroups[].fadeOut
	{ TYPE_U64, false, (size_t)(&((BehaviorGroup_Type*)0)->userData), NULL, 0 }, // behaviorGroups[].userData
	{ TYPE_I8, false, (size_t)(&((ParametersStruct*)0)->RTFractureBehaviorGroup), NULL, 0 }, // RTFractureBehaviorGroup
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->chunks), CHILDREN(63), 1 }, // chunks
	{ TYPE_STRUCT, false, 1 * sizeof(Chunk_Type), CHILDREN(64), 10 }, // chunks[]
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->depth), NULL, 0 }, // chunks[].depth
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->parentIndex), NULL, 0 }, // chunks[].parentIndex
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->firstChildIndex), NULL, 0 }, // chunks[].firstChildIndex
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->numChildren), NULL, 0 }, // chunks[].numChildren
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->meshPartIndex), NULL, 0 }, // chunks[].meshPartIndex
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->flags), NULL, 0 }, // chunks[].flags
	{ TYPE_VEC3, false, (size_t)(&((Chunk_Type*)0)->surfaceNormal), NULL, 0 }, // chunks[].surfaceNormal
	{ TYPE_I8, false, (size_t)(&((Chunk_Type*)0)->behaviorGroupIndex), NULL, 0 }, // chunks[].behaviorGroupIndex
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->firstScatterMesh), NULL, 0 }, // chunks[].firstScatterMesh
	{ TYPE_U16, false, (size_t)(&((Chunk_Type*)0)->scatterMeshCount), NULL, 0 }, // chunks[].scatterMeshCount
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->chunkConvexHulls), CHILDREN(74), 1 }, // chunkConvexHulls
	{ TYPE_REF, false, 1 * sizeof(NvParameterized::Interface*), NULL, 0 }, // chunkConvexHulls[]
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->chunkConvexHullStartIndices), CHILDREN(75), 1 }, // chunkConvexHullStartIndices
	{ TYPE_U32, false, 1 * sizeof(uint32_t), NULL, 0 }, // chunkConvexHullStartIndices[]
	{ TYPE_STRUCT, false, (size_t)(&((ParametersStruct*)0)->destructibleParameters), CHILDREN(76), 20 }, // destructibleParameters
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->damageCap), NULL, 0 }, // destructibleParameters.damageCap
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->forceToDamage), NULL, 0 }, // destructibleParameters.forceToDamage
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->impactVelocityThreshold), NULL, 0 }, // destructibleParameters.impactVelocityThreshold
	{ TYPE_U32, false, (size_t)(&((DestructibleParameters_Type*)0)->minimumFractureDepth), NULL, 0 }, // destructibleParameters.minimumFractureDepth
	{ TYPE_I32, false, (size_t)(&((DestructibleParameters_Type*)0)->impactDamageDefaultDepth), NULL, 0 }, // destructibleParameters.impactDamageDefaultDepth
	{ TYPE_I32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisDepth), NULL, 0 }, // destructibleParameters.debrisDepth
	{ TYPE_U32, false, (size_t)(&((DestructibleParameters_Type*)0)->essentialDepth), NULL, 0 }, // destructibleParameters.essentialDepth
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisLifetimeMin), NULL, 0 }, // destructibleParameters.debrisLifetimeMin
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisLifetimeMax), NULL, 0 }, // destructibleParameters.debrisLifetimeMax
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisMaxSeparationMin), NULL, 0 }, // destructibleParameters.debrisMaxSeparationMin
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisMaxSeparationMax), NULL, 0 }, // destructibleParameters.debrisMaxSeparationMax
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->debrisDestructionProbability), NULL, 0 }, // destructibleParameters.debrisDestructionProbability
	{ TYPE_BOUNDS3, false, (size_t)(&((DestructibleParameters_Type*)0)->validBounds), NULL, 0 }, // destructibleParameters.validBounds
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->maxChunkSpeed), NULL, 0 }, // destructibleParameters.maxChunkSpeed
	{ TYPE_STRUCT, false, (size_t)(&((DestructibleParameters_Type*)0)->flags), CHILDREN(96), 7 }, // destructibleParameters.flags
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->ACCUMULATE_DAMAGE), NULL, 0 }, // destructibleParameters.flags.ACCUMULATE_DAMAGE
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->DEBRIS_TIMEOUT), NULL, 0 }, // destructibleParameters.flags.DEBRIS_TIMEOUT
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->DEBRIS_MAX_SEPARATION), NULL, 0 }, // destructibleParameters.flags.DEBRIS_MAX_SEPARATION
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->CRUMBLE_SMALLEST_CHUNKS), NULL, 0 }, // destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->ACCURATE_RAYCASTS), NULL, 0 }, // destructibleParameters.flags.ACCURATE_RAYCASTS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->USE_VALID_BOUNDS), NULL, 0 }, // destructibleParameters.flags.USE_VALID_BOUNDS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleParametersFlag_Type*)0)->CRUMBLE_VIA_RUNTIME_FRACTURE), NULL, 0 }, // destructibleParameters.flags.CRUMBLE_VIA_RUNTIME_FRACTURE
	{ TYPE_F32, false, (size_t)(&((DestructibleParameters_Type*)0)->fractureImpulseScale), NULL, 0 }, // destructibleParameters.fractureImpulseScale
	{ TYPE_U16, false, (size_t)(&((DestructibleParameters_Type*)0)->damageDepthLimit), NULL, 0 }, // destructibleParameters.damageDepthLimit
	{ TYPE_U16, false, (size_t)(&((DestructibleParameters_Type*)0)->dynamicChunkDominanceGroup), NULL, 0 }, // destructibleParameters.dynamicChunkDominanceGroup
	{ TYPE_STRUCT, false, (size_t)(&((DestructibleParameters_Type*)0)->dynamicChunksGroupsMask), CHILDREN(103), 5 }, // destructibleParameters.dynamicChunksGroupsMask
	{ TYPE_BOOL, false, (size_t)(&((GroupsMask_Type*)0)->useGroupsMask), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.useGroupsMask
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits0), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits0
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits1), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits1
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits2), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits2
	{ TYPE_U32, false, (size_t)(&((GroupsMask_Type*)0)->bits3), NULL, 0 }, // destructibleParameters.dynamicChunksGroupsMask.bits3
	{ TYPE_STRUCT, false, (size_t)(&((DestructibleParameters_Type*)0)->runtimeFracture), CHILDREN(108), 7 }, // destructibleParameters.runtimeFracture
	{ TYPE_BOOL, false, (size_t)(&((RuntimeFracture_Type*)0)->sheetFracture), NULL, 0 }, // destructibleParameters.runtimeFracture.sheetFracture
	{ TYPE_U32, false, (size_t)(&((RuntimeFracture_Type*)0)->depthLimit), NULL, 0 }, // destructibleParameters.runtimeFracture.depthLimit
	{ TYPE_BOOL, false, (size_t)(&((RuntimeFracture_Type*)0)->destroyIfAtDepthLimit), NULL, 0 }, // destructibleParameters.runtimeFracture.destroyIfAtDepthLimit
	{ TYPE_F32, false, (size_t)(&((RuntimeFracture_Type*)0)->minConvexSize), NULL, 0 }, // destructibleParameters.runtimeFracture.minConvexSize
	{ TYPE_F32, false, (size_t)(&((RuntimeFracture_Type*)0)->impulseScale), NULL, 0 }, // destructibleParameters.runtimeFracture.impulseScale
	{ TYPE_STRUCT, false, (size_t)(&((RuntimeFracture_Type*)0)->glass), CHILDREN(115), 5 }, // destructibleParameters.runtimeFracture.glass
	{ TYPE_U32, false, (size_t)(&((FractureGlass_Type*)0)->numSectors), NULL, 0 }, // destructibleParameters.runtimeFracture.glass.numSectors
	{ TYPE_F32, false, (size_t)(&((FractureGlass_Type*)0)->sectorRand), NULL, 0 }, // destructibleParameters.runtimeFracture.glass.sectorRand
	{ TYPE_F32, false, (size_t)(&((FractureGlass_Type*)0)->firstSegmentSize), NULL, 0 }, // destructibleParameters.runtimeFracture.glass.firstSegmentSize
	{ TYPE_F32, false, (size_t)(&((FractureGlass_Type*)0)->segmentScale), NULL, 0 }, // destructibleParameters.runtimeFracture.glass.segmentScale
	{ TYPE_F32, false, (size_t)(&((FractureGlass_Type*)0)->segmentRand), NULL, 0 }, // destructibleParameters.runtimeFracture.glass.segmentRand
	{ TYPE_STRUCT, false, (size_t)(&((RuntimeFracture_Type*)0)->attachment), CHILDREN(120), 6 }, // destructibleParameters.runtimeFracture.attachment
	{ TYPE_BOOL, false, (size_t)(&((FractureAttachment_Type*)0)->posX), NULL, 0 }, // destructibleParameters.runtimeFracture.attachment.posX
	{ TYPE_BOOL, false, (size_t)(&((FractureAttachment_Type*)0)->negX), NULL, 0 }, // destructibleParameters.runtimeFracture.attachment.negX
	{ TYPE_BOOL, false, (size_t)(&((FractureAttachment_Type*)0)->posY), NULL, 0 }, // destructibleParameters.runtimeFracture.attachment.posY
	{ TYPE_BOOL, false, (size_t)(&((FractureAttachment_Type*)0)->negY), NULL, 0 }, // destructibleParameters.runtimeFracture.attachment.negY
	{ TYPE_BOOL, false, (size_t)(&((FractureAttachment_Type*)0)->posZ), NULL, 0 }, // destructibleParameters.runtimeFracture.attachment.posZ
	{ TYPE_BOOL, false, (size_t)(&((FractureAttachment_Type*)0)->negZ), NULL, 0 }, // destructibleParameters.runtimeFracture.attachment.negZ
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->depthParameters), CHILDREN(126), 1 }, // depthParameters
	{ TYPE_STRUCT, false, 1 * sizeof(DestructibleDepthParameters_Type), CHILDREN(127), 9 }, // depthParameters[]
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->OVERRIDE_IMPACT_DAMAGE), NULL, 0 }, // depthParameters[].OVERRIDE_IMPACT_DAMAGE
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->OVERRIDE_IMPACT_DAMAGE_VALUE), NULL, 0 }, // depthParameters[].OVERRIDE_IMPACT_DAMAGE_VALUE
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->IGNORE_POSE_UPDATES), NULL, 0 }, // depthParameters[].IGNORE_POSE_UPDATES
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->IGNORE_RAYCAST_CALLBACKS), NULL, 0 }, // depthParameters[].IGNORE_RAYCAST_CALLBACKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->IGNORE_CONTACT_CALLBACKS), NULL, 0 }, // depthParameters[].IGNORE_CONTACT_CALLBACKS
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_0), NULL, 0 }, // depthParameters[].USER_FLAG_0
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_1), NULL, 0 }, // depthParameters[].USER_FLAG_1
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_2), NULL, 0 }, // depthParameters[].USER_FLAG_2
	{ TYPE_BOOL, false, (size_t)(&((DestructibleDepthParameters_Type*)0)->USER_FLAG_3), NULL, 0 }, // depthParameters[].USER_FLAG_3
	{ TYPE_STRING, false, (size_t)(&((ParametersStruct*)0)->crumbleEmitterName), NULL, 0 }, // crumbleEmitterName
	{ TYPE_STRING, false, (size_t)(&((ParametersStruct*)0)->dustEmitterName), NULL, 0 }, // dustEmitterName
	{ TYPE_REF, false, (size_t)(&((ParametersStruct*)0)->collisionData), NULL, 0 }, // collisionData
	{ TYPE_REF, false, (size_t)(&((ParametersStruct*)0)->renderMeshAsset), NULL, 0 }, // renderMeshAsset
	{ TYPE_U32, false, (size_t)(&((ParametersStruct*)0)->initialDestructibleActorAllowanceForInstancing), NULL, 0 }, // initialDestructibleActorAllowanceForInstancing
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->chunkInstanceInfo), CHILDREN(136), 1 }, // chunkInstanceInfo
	{ TYPE_STRUCT, false, 1 * sizeof(InstanceInfo_Type), CHILDREN(137), 3 }, // chunkInstanceInfo[]
	{ TYPE_U16, false, (size_t)(&((InstanceInfo_Type*)0)->partIndex), NULL, 0 }, // chunkInstanceInfo[].partIndex
	{ TYPE_VEC3, false, (size_t)(&((InstanceInfo_Type*)0)->chunkPositionOffset), NULL, 0 }, // chunkInstanceInfo[].chunkPositionOffset
	{ TYPE_VEC2, false, (size_t)(&((InstanceInfo_Type*)0)->chunkUVOffset), NULL, 0 }, // chunkInstanceInfo[].chunkUVOffset
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->staticMaterialNames), CHILDREN(140), 1 }, // staticMaterialNames
	{ TYPE_STRING, false, 1 * sizeof(NvParameterized::DummyStringStruct), NULL, 0 }, // staticMaterialNames[]
	{ TYPE_F32, false, (size_t)(&((ParametersStruct*)0)->neighborPadding), NULL, 0 }, // neighborPadding
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->overlapsAtDepth), CHILDREN(141), 1 }, // overlapsAtDepth
	{ TYPE_REF, false, 1 * sizeof(NvParameterized::Interface*), NULL, 0 }, // overlapsAtDepth[]
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->firstChunkAtDepth), CHILDREN(142), 1 }, // firstChunkAtDepth
	{ TYPE_U32, false, 1 * sizeof(uint32_t), NULL, 0 }, // firstChunkAtDepth[]
	{ TYPE_U32, false, (size_t)(&((ParametersStruct*)0)->supportDepth), NULL, 0 }, // supportDepth
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->formExtendedStructures), NULL, 0 }, // formExtendedStructures
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->useAssetDefinedSupport), NULL, 0 }, // useAssetDefinedSupport
	{ TYPE_BOOL, false, (size_t)(&((ParametersStruct*)0)->useWorldSupport), NULL, 0 }, // useWorldSupport
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->actorTransforms), CHILDREN(143), 1 }, // actorTransforms
	{ TYPE_MAT44, false, 1 * sizeof(physx::PxMat44), NULL, 0 }, // actorTransforms[]
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->scatterMeshAssets), CHILDREN(144), 1 }, // scatterMeshAssets
	{ TYPE_REF, false, 1 * sizeof(NvParameterized::Interface*), NULL, 0 }, // scatterMeshAssets[]
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->scatterMeshIndices), CHILDREN(145), 1 }, // scatterMeshIndices
	{ TYPE_U8, false, 1 * sizeof(uint8_t), NULL, 0 }, // scatterMeshIndices[]
	{ TYPE_ARRAY, true, (size_t)(&((ParametersStruct*)0)->scatterMeshTransforms), CHILDREN(146), 1 }, // scatterMeshTransforms
	{ TYPE_STRUCT, false, 1 * sizeof(M34_Type), CHILDREN(147), 2 }, // scatterMeshTransforms[]
	{ TYPE_MAT33, false, (size_t)(&((M34_Type*)0)->matrix), NULL, 0 }, // scatterMeshTransforms[].matrix
	{ TYPE_VEC3, false, (size_t)(&((M34_Type*)0)->vector), NULL, 0 }, // scatterMeshTransforms[].vector
};


bool DestructibleAssetParameters_0p20::mBuiltFlag = false;
NvParameterized::MutexType DestructibleAssetParameters_0p20::mBuiltFlagMutex;

DestructibleAssetParameters_0p20::DestructibleAssetParameters_0p20(NvParameterized::Traits* traits, void* buf, int32_t* refCount) :
	NvParameters(traits, buf, refCount)
{
	//mParameterizedTraits->registerFactory(className(), &DestructibleAssetParameters_0p20FactoryInst);

	if (!buf) //Do not init data if it is inplace-deserialized
	{
		initDynamicArrays();
		initStrings();
		initReferences();
		initDefaults();
	}
}

DestructibleAssetParameters_0p20::~DestructibleAssetParameters_0p20()
{
	freeStrings();
	freeReferences();
	freeDynamicArrays();
}

void DestructibleAssetParameters_0p20::destroy()
{
	// We cache these fields here to avoid overwrite in destructor
	bool doDeallocateSelf = mDoDeallocateSelf;
	NvParameterized::Traits* traits = mParameterizedTraits;
	int32_t* refCount = mRefCount;
	void* buf = mBuffer;

	this->~DestructibleAssetParameters_0p20();

	NvParameters::destroy(this, traits, doDeallocateSelf, refCount, buf);
}

const NvParameterized::DefinitionImpl* DestructibleAssetParameters_0p20::getParameterDefinitionTree(void)
{
	if (!mBuiltFlag) // Double-checked lock
	{
		NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);
		if (!mBuiltFlag)
		{
			buildTree();
		}
	}

	return(&ParamDefTable[0]);
}

const NvParameterized::DefinitionImpl* DestructibleAssetParameters_0p20::getParameterDefinitionTree(void) const
{
	DestructibleAssetParameters_0p20* tmpParam = const_cast<DestructibleAssetParameters_0p20*>(this);

	if (!mBuiltFlag) // Double-checked lock
	{
		NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);
		if (!mBuiltFlag)
		{
			tmpParam->buildTree();
		}
	}

	return(&ParamDefTable[0]);
}

NvParameterized::ErrorType DestructibleAssetParameters_0p20::getParameterHandle(const char* long_name, Handle& handle) const
{
	ErrorType Ret = NvParameters::getParameterHandle(long_name, handle);
	if (Ret != ERROR_NONE)
	{
		return(Ret);
	}

	size_t offset;
	void* ptr;

	getVarPtr(handle, ptr, offset);

	if (ptr == NULL)
	{
		return(ERROR_INDEX_OUT_OF_RANGE);
	}

	return(ERROR_NONE);
}

NvParameterized::ErrorType DestructibleAssetParameters_0p20::getParameterHandle(const char* long_name, Handle& handle)
{
	ErrorType Ret = NvParameters::getParameterHandle(long_name, handle);
	if (Ret != ERROR_NONE)
	{
		return(Ret);
	}

	size_t offset;
	void* ptr;

	getVarPtr(handle, ptr, offset);

	if (ptr == NULL)
	{
		return(ERROR_INDEX_OUT_OF_RANGE);
	}

	return(ERROR_NONE);
}

void DestructibleAssetParameters_0p20::getVarPtr(const Handle& handle, void*& ptr, size_t& offset) const
{
	ptr = getVarPtrHelper(&ParamLookupTable[0], const_cast<DestructibleAssetParameters_0p20::ParametersStruct*>(&parameters()), handle, offset);
}


/* Dynamic Handle Indices */
/* [1,0] - behaviorGroups.name */
/* [0] - chunkConvexHulls (not an array of structs) */
/* [0] - staticMaterialNames (not an array of structs) */
/* [0] - overlapsAtDepth (not an array of structs) */
/* [0] - scatterMeshAssets (not an array of structs) */

void DestructibleAssetParameters_0p20::freeParameterDefinitionTable(NvParameterized::Traits* traits)
{
	if (!traits)
	{
		return;
	}

	if (!mBuiltFlag) // Double-checked lock
	{
		return;
	}

	NvParameterized::MutexType::ScopedLock lock(mBuiltFlagMutex);

	if (!mBuiltFlag)
	{
		return;
	}

	for (uint32_t i = 0; i < NumParamDefs; ++i)
	{
		ParamDefTable[i].~DefinitionImpl();
	}

	traits->free(ParamDefTable);

	mBuiltFlag = false;
}

#define PDEF_PTR(index) (&ParamDefTable[index])

void DestructibleAssetParameters_0p20::buildTree(void)
{

	uint32_t allocSize = sizeof(NvParameterized::DefinitionImpl) * NumParamDefs;
	ParamDefTable = (NvParameterized::DefinitionImpl*)(mParameterizedTraits->alloc(allocSize));
	memset(ParamDefTable, 0, allocSize);

	for (uint32_t i = 0; i < NumParamDefs; ++i)
	{
		NV_PARAM_PLACEMENT_NEW(ParamDefTable + i, NvParameterized::DefinitionImpl)(*mParameterizedTraits);
	}

	// Initialize DefinitionImpl node: nodeIndex=0, longName=""
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[0];
		ParamDef->init("", TYPE_STRUCT, "STRUCT", true);






	}

	// Initialize DefinitionImpl node: nodeIndex=1, longName="comments"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[1];
		ParamDef->init("comments", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Human-readable string which describes which tool created this asset, its version, etc.", true);
		HintTable[1].init("shortDescription", "Human-readable string which describes which tool created this asset, its version, etc.", true);
		ParamDefTable[1].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=2, longName="depthCount"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[2];
		ParamDef->init("depthCount", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The number of chunk depth levels.  This is 1 for an unfractured mesh.", true);
		HintTable[1].init("shortDescription", "The number of chunk depth levels", true);
		ParamDefTable[2].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=3, longName="originalDepthCount"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[3];
		ParamDef->init("originalDepthCount", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The depth count when authored - this way we can tell how far it's been reduced.", true);
		HintTable[1].init("shortDescription", "The depth count when authored", true);
		ParamDefTable[3].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=4, longName="bounds"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[4];
		ParamDef->init("bounds", TYPE_BOUNDS3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The axis-aligned bounding box of the destructible asset.  This is the smallest AABB\n					which contains all chunk AABBs.", true);
		HintTable[1].init("shortDescription", "The AABB of the destructible asset", true);
		ParamDefTable[4].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=5, longName="defaultBehaviorGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[5];
		ParamDef->init("defaultBehaviorGroup", TYPE_STRUCT, "BehaviorGroup", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The default behavior group referenced by chunks. Each chunk references a behavior group for chunk-specific reactions.", true);
		HintTable[1].init("shortDescription", "The default behavior group referenced by chunks", true);
		ParamDefTable[5].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=6, longName="defaultBehaviorGroup.name"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[6];
		ParamDef->init("name", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Name of behavior group, eg Concrete or Glass.", true);
		HintTable[1].init("shortDescription", "Name of behavior group", true);
		ParamDefTable[6].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=7, longName="defaultBehaviorGroup.damageThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[7];
		ParamDef->init("damageThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.\n							This is obtained from the damage value passed into the NxDestructibleActor::applyDamage,\n							or NxDestructibleActor::applyRadiusDamage, or via impact (see 'forceToDamage', below).", true);
		HintTable[1].init("shortDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.", true);
		ParamDefTable[7].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=8, longName="defaultBehaviorGroup.damageToRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[8];
		ParamDef->init("damageToRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Controls the distance into the destructible to propagate damage.  The damage applied to the chunk\n							is multiplied by damageToRadius, to get the propagation distance.  All chunks within the radius\n							will have damage applied to them.  The damage applied to each chunk varies with distance to the damage\n							application position.  Full damage is taken at zero distance, and zero damage at the damage radius.\n							NOTE: This parameter is deprecated for point and radius damage.  It will be used for those types of damage if legacy damage\n							behavior is enabled with NxModuleDestructible::setUseLegacyDamageRadiusSpread.  Otherwise, the new parameters\n							damageSpread.minimumRadius, damageSpread.radiusMultiplier, and damageSpread.falloffExponent are used.  For impact damage, this parameter\n							will continue to be used, however the radius will no longer scale with object size.  The radius will continue\n							to scale with the damage as a fraction of damageThreshold, however.  If legacy damage behavior is used, this parameter\n							will behave as before with respect to impact damage as well (scaling with object size).", true);
		HintTable[1].init("shortDescription", "Controls the distance into the destructible to propagate damage.", true);
		ParamDefTable[8].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=9, longName="defaultBehaviorGroup.damageSpread"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[9];
		ParamDef->init("damageSpread", TYPE_STRUCT, "DamageSpreadFunction", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Describes the radius and damage envelope function for damage applied to the destructible.", true);
		HintTable[1].init("shortDescription", "Describes the radius and damage envelope function for damage applied to the destructible.", true);
		ParamDefTable[9].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=10, longName="defaultBehaviorGroup.damageSpread.minimumRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[10];
		ParamDef->init("minimumRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The minimum radius of damage spread when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "The minimum radius of damage spread when damage is applied.", true);
		ParamDefTable[10].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=11, longName="defaultBehaviorGroup.damageSpread.radiusMultiplier"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[11];
		ParamDef->init("radiusMultiplier", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A scale to apply to the input damage radius when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "A scale to apply to the input damage radius when damage is applied.", true);
		ParamDefTable[11].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=12, longName="defaultBehaviorGroup.damageSpread.falloffExponent"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[12];
		ParamDef->init("falloffExponent", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "How damage varies between the minimum radius and the calculated damage radius.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.\n						Within the minimumRadius, the full damage is applied to chunks.  Past the minimumRadius, the formla for damage is:\n						damage = (input damage) * ((radius - distance)/(radius - minimumRadius))^falloffExponent.\n						Note: falloffExponent = 0.0 gives no falloff, so that damage = (input damage) over the entire range [0, radius).\n						falloffExponent = 1.0 gives linear falloff.", true);
		HintTable[1].init("shortDescription", "How damage varies between the minimum radius and the calculated damage radius.", true);
		ParamDefTable[12].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=13, longName="defaultBehaviorGroup.damageColorSpread"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[13];
		ParamDef->init("damageColorSpread", TYPE_STRUCT, "DamageSpreadFunction", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Describes the radius and damage envelope function for color channel damage modification applied to the destructible.", true);
		HintTable[1].init("shortDescription", "Describes the radius and damage envelope function for color channel damage modification applied to the destructible.", true);
		ParamDefTable[13].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=14, longName="defaultBehaviorGroup.damageColorSpread.minimumRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[14];
		ParamDef->init("minimumRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The minimum radius of damage spread when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "The minimum radius of damage spread when damage is applied.", true);
		ParamDefTable[14].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=15, longName="defaultBehaviorGroup.damageColorSpread.radiusMultiplier"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[15];
		ParamDef->init("radiusMultiplier", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A scale to apply to the input damage radius when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "A scale to apply to the input damage radius when damage is applied.", true);
		ParamDefTable[15].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=16, longName="defaultBehaviorGroup.damageColorSpread.falloffExponent"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[16];
		ParamDef->init("falloffExponent", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "How damage varies between the minimum radius and the calculated damage radius.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.\n						Within the minimumRadius, the full damage is applied to chunks.  Past the minimumRadius, the formla for damage is:\n						damage = (input damage) * ((radius - distance)/(radius - minimumRadius))^falloffExponent.\n						Note: falloffExponent = 0.0 gives no falloff, so that damage = (input damage) over the entire range [0, radius).\n						falloffExponent = 1.0 gives linear falloff.", true);
		HintTable[1].init("shortDescription", "How damage varies between the minimum radius and the calculated damage radius.", true);
		ParamDefTable[16].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=17, longName="defaultBehaviorGroup.damageColorChange"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[17];
		ParamDef->init("damageColorChange", TYPE_VEC4, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Describes how damage changes the color of vertices in the render mesh.  If this vector is non-zero, then a dynamic\n							(per-actor) color channel will be created and initialized to the asset's color channel, if it exists.  Damage taken will go through\n							the spread and envelope function described by damageColoring, and each color will be modified by the resulting damage, scaled\n							by the values in damageColorChange.  The change to color channel C is given by\n							color[C] = clamp(color[C] + damageColorChange[C]*255*min(1.0, damage/damageThreshold), 0, 255).", true);
		HintTable[1].init("shortDescription", "Describes how damage changes the color of vertices in the render mesh.", true);
		ParamDefTable[17].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=18, longName="defaultBehaviorGroup.materialStrength"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[18];
		ParamDef->init("materialStrength", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "When a chunk takes impact damage due to physical contact (see see NxDestructibleDepthParameters), this parameter\n							is the maximum impulse the contact can generate.  Weak materials such as glass may have this set to a low value, so that\n							heavier objects will pass through them during fracture.\n							N.B.: Setting this parameter to 0 disables the impulse cap; that is, zero is interpreted as infinite.\n							Default value = 0.0f.", true);
		HintTable[1].init("shortDescription", "When a chunk takes impact, this is the maximum impulse the contact can generate.", true);
		ParamDefTable[18].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=19, longName="defaultBehaviorGroup.density"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[19];
		ParamDef->init("density", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunk density. (TODO: better description)", true);
		HintTable[1].init("shortDescription", "Chunk density", true);
		ParamDefTable[19].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=20, longName="defaultBehaviorGroup.fadeOut"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[20];
		ParamDef->init("fadeOut", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunk fade out.  (TODO: better description)", true);
		HintTable[1].init("shortDescription", "Chunk fade out", true);
		ParamDefTable[20].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=21, longName="defaultBehaviorGroup.userData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[21];
		ParamDef->init("userData", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User data field.  This 64-bit field can be set and retrieved by the user at runtime.", true);
		HintTable[1].init("shortDescription", "User data field.", true);
		ParamDefTable[21].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=22, longName="behaviorGroups"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[22];
		ParamDef->init("behaviorGroups", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The array of behavior groups referenced by chunks. Each chunk references a behavior group for chunk-specific reactions.", true);
		HintTable[1].init("shortDescription", "The array of behavior groups referenced by chunks", true);
		ParamDefTable[22].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[2] = { 1, 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 2);

	}

	// Initialize DefinitionImpl node: nodeIndex=23, longName="behaviorGroups[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[23];
		ParamDef->init("behaviorGroups", TYPE_STRUCT, "BehaviorGroup", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The array of behavior groups referenced by chunks. Each chunk references a behavior group for chunk-specific reactions.", true);
		HintTable[1].init("shortDescription", "The array of behavior groups referenced by chunks", true);
		ParamDefTable[23].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=24, longName="behaviorGroups[].name"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[24];
		ParamDef->init("name", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Name of behavior group, eg Concrete or Glass.", true);
		HintTable[1].init("shortDescription", "Name of behavior group", true);
		ParamDefTable[24].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=25, longName="behaviorGroups[].damageThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[25];
		ParamDef->init("damageThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.\n							This is obtained from the damage value passed into the NxDestructibleActor::applyDamage,\n							or NxDestructibleActor::applyRadiusDamage, or via impact (see 'forceToDamage', below).", true);
		HintTable[1].init("shortDescription", "The damage amount which will cause a chunk to fracture (break free) from the destructible.", true);
		ParamDefTable[25].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=26, longName="behaviorGroups[].damageToRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[26];
		ParamDef->init("damageToRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Controls the distance into the destructible to propagate damage.  The damage applied to the chunk\n							is multiplied by damageToRadius, to get the propagation distance.  All chunks within the radius\n							will have damage applied to them.  The damage applied to each chunk varies with distance to the damage\n							application position.  Full damage is taken at zero distance, and zero damage at the damage radius.\n							NOTE: This parameter is deprecated for point and radius damage.  It will be used for those types of damage if legacy damage\n							behavior is enabled with NxModuleDestructible::setUseLegacyDamageRadiusSpread.  Otherwise, the new parameters\n							damageSpread.minimumRadius, damageSpread.radiusMultiplier, and damageSpread.falloffExponent are used.  For impact damage, this parameter\n							will continue to be used, however the radius will no longer scale with object size.  The radius will continue\n							to scale with the damage as a fraction of damageThreshold, however.  If legacy damage behavior is used, this parameter\n							will behave as before with respect to impact damage as well (scaling with object size).", true);
		HintTable[1].init("shortDescription", "Controls the distance into the destructible to propagate damage.", true);
		ParamDefTable[26].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=27, longName="behaviorGroups[].damageSpread"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[27];
		ParamDef->init("damageSpread", TYPE_STRUCT, "DamageSpreadFunction", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Describes the radius and damage envelope function for damage applied to the destructible.", true);
		HintTable[1].init("shortDescription", "Describes the radius and damage envelope function for damage applied to the destructible.", true);
		ParamDefTable[27].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=28, longName="behaviorGroups[].damageSpread.minimumRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[28];
		ParamDef->init("minimumRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The minimum radius of damage spread when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "The minimum radius of damage spread when damage is applied.", true);
		ParamDefTable[28].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=29, longName="behaviorGroups[].damageSpread.radiusMultiplier"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[29];
		ParamDef->init("radiusMultiplier", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A scale to apply to the input damage radius when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "A scale to apply to the input damage radius when damage is applied.", true);
		ParamDefTable[29].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=30, longName="behaviorGroups[].damageSpread.falloffExponent"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[30];
		ParamDef->init("falloffExponent", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "How damage varies between the minimum radius and the calculated damage radius.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.\n						Within the minimumRadius, the full damage is applied to chunks.  Past the minimumRadius, the formla for damage is:\n						damage = (input damage) * ((radius - distance)/(radius - minimumRadius))^falloffExponent.\n						Note: falloffExponent = 0.0 gives no falloff, so that damage = (input damage) over the entire range [0, radius).\n						falloffExponent = 1.0 gives linear falloff.", true);
		HintTable[1].init("shortDescription", "How damage varies between the minimum radius and the calculated damage radius.", true);
		ParamDefTable[30].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=31, longName="behaviorGroups[].damageColorSpread"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[31];
		ParamDef->init("damageColorSpread", TYPE_STRUCT, "DamageSpreadFunction", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Describes the radius and damage envelope function for color channel damage modification applied to the destructible.", true);
		HintTable[1].init("shortDescription", "Describes the radius and damage envelope function for color channel damage modification applied to the destructible.", true);
		ParamDefTable[31].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=32, longName="behaviorGroups[].damageColorSpread.minimumRadius"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[32];
		ParamDef->init("minimumRadius", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The minimum radius of damage spread when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "The minimum radius of damage spread when damage is applied.", true);
		ParamDefTable[32].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=33, longName="behaviorGroups[].damageColorSpread.radiusMultiplier"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[33];
		ParamDef->init("radiusMultiplier", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A scale to apply to the input damage radius when damage is applied.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.", true);
		HintTable[1].init("shortDescription", "A scale to apply to the input damage radius when damage is applied.", true);
		ParamDefTable[33].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=34, longName="behaviorGroups[].damageColorSpread.falloffExponent"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[34];
		ParamDef->init("falloffExponent", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "How damage varies between the minimum radius and the calculated damage radius.  The formula for the damage radius is\n						radius = minimumRadius + (input radius) * radiusMultiplier.\n						Within the minimumRadius, the full damage is applied to chunks.  Past the minimumRadius, the formla for damage is:\n						damage = (input damage) * ((radius - distance)/(radius - minimumRadius))^falloffExponent.\n						Note: falloffExponent = 0.0 gives no falloff, so that damage = (input damage) over the entire range [0, radius).\n						falloffExponent = 1.0 gives linear falloff.", true);
		HintTable[1].init("shortDescription", "How damage varies between the minimum radius and the calculated damage radius.", true);
		ParamDefTable[34].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=35, longName="behaviorGroups[].damageColorChange"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[35];
		ParamDef->init("damageColorChange", TYPE_VEC4, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Describes how damage changes the color of vertices in the render mesh.  If this vector is non-zero, then a dynamic\n							(per-actor) color channel will be created and initialized to the asset's color channel, if it exists.  Damage taken will go through\n							the spread and envelope function described by damageColoring, and each color will be modified by the resulting damage, scaled\n							by the values in damageColorChange.  The change to color channel C is given by\n							color[C] = clamp(color[C] + damageColorChange[C]*255*min(1.0, damage/damageThreshold), 0, 255).", true);
		HintTable[1].init("shortDescription", "Describes how damage changes the color of vertices in the render mesh.", true);
		ParamDefTable[35].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=36, longName="behaviorGroups[].materialStrength"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[36];
		ParamDef->init("materialStrength", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "When a chunk takes impact damage due to physical contact (see see NxDestructibleDepthParameters), this parameter\n							is the maximum impulse the contact can generate.  Weak materials such as glass may have this set to a low value, so that\n							heavier objects will pass through them during fracture.\n							N.B.: Setting this parameter to 0 disables the impulse cap; that is, zero is interpreted as infinite.\n							Default value = 0.0f.", true);
		HintTable[1].init("shortDescription", "When a chunk takes impact, this is the maximum impulse the contact can generate.", true);
		ParamDefTable[36].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=37, longName="behaviorGroups[].density"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[37];
		ParamDef->init("density", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunk density. (TODO: better description)", true);
		HintTable[1].init("shortDescription", "Chunk density", true);
		ParamDefTable[37].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=38, longName="behaviorGroups[].fadeOut"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[38];
		ParamDef->init("fadeOut", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunk fade out.  (TODO: better description)", true);
		HintTable[1].init("shortDescription", "Chunk fade out", true);
		ParamDefTable[38].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=39, longName="behaviorGroups[].userData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[39];
		ParamDef->init("userData", TYPE_U64, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User data field.  This 64-bit field can be set and retrieved by the user at runtime.", true);
		HintTable[1].init("shortDescription", "User data field.", true);
		ParamDefTable[39].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=40, longName="RTFractureBehaviorGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[40];
		ParamDef->init("RTFractureBehaviorGroup", TYPE_I8, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The array of behavior groups referenced by chunks. Each chunk references a behavior group for chunk-specific reactions.", true);
		HintTable[1].init("shortDescription", "The array of behavior groups referenced by chunks", true);
		ParamDefTable[40].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=41, longName="chunks"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[41];
		ParamDef->init("chunks", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The array of chunks.  Chunks are stored breadth-first in their hierarchy.", true);
		HintTable[1].init("shortDescription", "The array of chunks", true);
		ParamDefTable[41].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=42, longName="chunks[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[42];
		ParamDef->init("chunks", TYPE_STRUCT, "Chunk", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The array of chunks.  Chunks are stored breadth-first in their hierarchy.", true);
		HintTable[1].init("shortDescription", "The array of chunks", true);
		ParamDefTable[42].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=43, longName="chunks[].depth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[43];
		ParamDef->init("depth", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The depth of the chunk in the hierarchy.\n						Level 0 chunks correspond to the unfractured (original) mesh.  Level 1 chunks\n						are their children, formed by splitting level 0 chunks, etc.", true);
		HintTable[1].init("shortDescription", "The depth of the chunk in the hierarchy", true);
		ParamDefTable[43].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=44, longName="chunks[].parentIndex"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[44];
		ParamDef->init("parentIndex", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The index of the chunk's parent in the hierarchy.\n						If the chunk has no parent (its depth is 0), then the parentIndex is -1.", true);
		HintTable[1].init("shortDescription", "The index of the chunk's parent in the hierarchy", true);
		ParamDefTable[44].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=45, longName="chunks[].firstChildIndex"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[45];
		ParamDef->init("firstChildIndex", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The index of this chunk's first child in the hierarchy.\n						All children have contiguous chunk indices, and lie in the range\n						[firstChildIndex,firstChildIndex+numChildren-1].  If the chunk has no children,\n						this value is undefined.", true);
		HintTable[1].init("shortDescription", "The index of this chunk's first child in the hierarchy", true);
		ParamDefTable[45].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=46, longName="chunks[].numChildren"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[46];
		ParamDef->init("numChildren", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "This chunk's number of children.  If not 0, firstChildIndex\n						is valid (see firstChildIndex).", true);
		HintTable[1].init("shortDescription", "This chunk's number of children", true);
		ParamDefTable[46].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=47, longName="chunks[].meshPartIndex"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[47];
		ParamDef->init("meshPartIndex", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If this chunk is not instanced, this is the corresponding mesh part for this chunk,\n						in the NxApexRenderMeshAsset included within this destructible asset.  If this chunk is instanced,\n						this refers to the InstanceInfo in the asset (see InstanceInfo).", true);
		HintTable[1].init("shortDescription", "The corresponding mesh part for this chunk", true);
		ParamDefTable[47].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=48, longName="chunks[].flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[48];
		ParamDef->init("flags", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("editorDisplay", "false", true);
		ParamDefTable[48].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("editorDisplay", "false", true);
		HintTable[1].init("longDescription", "Flags which define individual chunk attributes, such as support,\n						fractureability, etc.", true);
		HintTable[2].init("shortDescription", "Flags which define individual chunk attributes", true);
		ParamDefTable[48].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=49, longName="chunks[].surfaceNormal"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[49];
		ParamDef->init("surfaceNormal", TYPE_VEC3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The average surface normal of this chunk.  This is the normalized\n						average of all triangle normals which are part of the original (unfractured) mesh.", true);
		HintTable[1].init("shortDescription", "The average surface normal of this chunk", true);
		ParamDefTable[49].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=50, longName="chunks[].behaviorGroupIndex"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[50];
		ParamDef->init("behaviorGroupIndex", TYPE_I8, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Behavior group this chunk is associated with. This includes flags, damage threshold, density, impact\n						resistance, and collision mask.", true);
		HintTable[1].init("shortDescription", "Behavior group this chunk is associated with", true);
		ParamDefTable[50].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=51, longName="chunks[].firstScatterMesh"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[51];
		ParamDef->init("firstScatterMesh", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Index of first scatter mesh (in scatterMeshIndices and scatterMeshTransforms).", true);
		HintTable[1].init("shortDescription", "Index of first scatter mesh (in scatterMeshIndices and scatterMeshTransforms)", true);
		ParamDefTable[51].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=52, longName="chunks[].scatterMeshCount"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[52];
		ParamDef->init("scatterMeshCount", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Number of scatter meshes (in scatterMeshIndices and scatterMeshTransforms).", true);
		HintTable[1].init("shortDescription", "Number of scatter meshes (in scatterMeshIndices and scatterMeshTransforms)", true);
		ParamDefTable[52].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=53, longName="chunkConvexHulls"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[53];
		ParamDef->init("chunkConvexHulls", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[53].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "Convex hull data for each chunk.  This is not cooked convex hull data\n					used for PhysX collision.  These hulls are used to (a) create cooked PhysX convex hulls, and (b)\n					for APEX scene queries.", true);
		HintTable[2].init("shortDescription", "Convex hull data for each chunk", true);
		ParamDefTable[53].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "ConvexHullParameters" };
		ParamDefTable[53].setRefVariantVals((const char**)RefVariantVals, 1);


		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[1] = { 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 1);

	}

	// Initialize DefinitionImpl node: nodeIndex=54, longName="chunkConvexHulls[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[54];
		ParamDef->init("chunkConvexHulls", TYPE_REF, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[54].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "Convex hull data for each chunk.  This is not cooked convex hull data\n					used for PhysX collision.  These hulls are used to (a) create cooked PhysX convex hulls, and (b)\n					for APEX scene queries.", true);
		HintTable[2].init("shortDescription", "Convex hull data for each chunk", true);
		ParamDefTable[54].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "ConvexHullParameters" };
		ParamDefTable[54].setRefVariantVals((const char**)RefVariantVals, 1);



	}

	// Initialize DefinitionImpl node: nodeIndex=55, longName="chunkConvexHullStartIndices"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[55];
		ParamDef->init("chunkConvexHullStartIndices", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Map into array of convex hulls.  The convex hulls for chunk i are in\n					the chunkConvexHulls array, starting at chunkConvexHulls[i], and ending at chunkConvexHulls[i+1]-1.\n					The array length is one greater than that of chunkConvexHulls.", true);
		HintTable[1].init("shortDescription", "Map into array of convex hulls", true);
		ParamDefTable[55].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=56, longName="chunkConvexHullStartIndices[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[56];
		ParamDef->init("chunkConvexHullStartIndices", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Map into array of convex hulls.  The convex hulls for chunk i are in\n					the chunkConvexHulls array, starting at chunkConvexHulls[i], and ending at chunkConvexHulls[i+1]-1.\n					The array length is one greater than that of chunkConvexHulls.", true);
		HintTable[1].init("shortDescription", "Map into array of convex hulls", true);
		ParamDefTable[56].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=57, longName="destructibleParameters"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[57];
		ParamDef->init("destructibleParameters", TYPE_STRUCT, "DestructibleParameters", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The default destructible properties for this asset.  These may be overridden\n					for an instance (destructible actor), as a copy of the parameters is also stored in the actor.", true);
		HintTable[1].init("shortDescription", "The default destructible properties for this asset", true);
		ParamDefTable[57].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=58, longName="destructibleParameters.damageCap"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[58];
		ParamDef->init("damageCap", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Limits the amount of damage applied to a chunk.  This is useful for preventing the entire destructible\nfrom getting pulverized by a very large application of damage.  This can easily happen when impact damage is\nused, and the damage amount is proportional to the impact force (see forceToDamage).\n", true);
		HintTable[1].init("shortDescription", "Limits the amount of damage applied to a chunk.", true);
		ParamDefTable[58].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=59, longName="destructibleParameters.forceToDamage"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[59];
		ParamDef->init("forceToDamage", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If a chunk is at a depth which takes impact damage (see NxDestructibleDepthParameters),\nthen when a chunk has a collision in the NxScene, it will take damage equal to forceToDamage mulitplied by\nthe impact force.\nThe default value is zero, which effectively disables impact damage.\n", true);
		HintTable[1].init("shortDescription", "Multiplier to calculate applied damage from an impact.", true);
		ParamDefTable[59].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=60, longName="destructibleParameters.impactVelocityThreshold"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[60];
		ParamDef->init("impactVelocityThreshold", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Large impact force may be reported if rigid bodies are spawned inside one another.  In this case the relative velocity of the two\nobjects will be low.  This variable allows the user to set a minimum velocity threshold for impacts to ensure that the objects are\nmoving at a min velocity in order for the impact force to be considered.\n", true);
		HintTable[1].init("shortDescription", "Large impact force may be reported if rigid bodies are spawned inside one another.", true);
		ParamDefTable[60].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=61, longName="destructibleParameters.minimumFractureDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[61];
		ParamDef->init("minimumFractureDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks will not be broken free below this depth.\n", true);
		HintTable[1].init("shortDescription", "The chunks will not be broken free below this depth.", true);
		ParamDefTable[61].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=62, longName="destructibleParameters.impactDamageDefaultDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[62];
		ParamDef->init("impactDamageDefaultDepth", TYPE_I32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The default depth to which chunks will take impact damage.  This default may be overridden in the depth settings.\n", true);
		HintTable[1].init("shortDescription", "The default depth to which chunks will take impact damage.", true);
		ParamDefTable[62].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=63, longName="destructibleParameters.debrisDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[63];
		ParamDef->init("debrisDepth", TYPE_I32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth at which chunks are considered to be 'debris.'  Chunks at this depth or\nbelow will be considered for various debris settings, such as debrisLifetime.\nNegative values indicate that no chunk depth is considered debris.\nDefault value is -1.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth at which chunks are considered to be 'debris.'", true);
		ParamDefTable[63].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=64, longName="destructibleParameters.essentialDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[64];
		ParamDef->init("essentialDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth up to which chunks will always be processed.  These chunks are considered\nto be essential either for gameplay or visually.\nThe minimum value is 0, meaning the level 0 chunk is always considered essential.\nDefault value is 0.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth up to which chunks will always be processed", true);
		ParamDefTable[64].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=65, longName="destructibleParameters.debrisLifetimeMin"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[65];
		ParamDef->init("debrisLifetimeMin", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed after a time (in seconds)\nseparated from non-debris chunks.  The actual lifetime is interpolated between\ndebrisLifetimeMin and debrisLifetimeMax (see below), based upon the module\'s LOD setting.\nTo disable lifetime, clear the NxDestructibleDepthParametersFlag::DEBRIS_TIMEOUT\nflag in the flags field.  If debrisLifetimeMax < debrisLifetimeMin, the mean of the two\nis used for both.\nDefault debrisLifetimeMin = 1.0, debrisLifetimeMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum time to destroy debris", true);
		ParamDefTable[65].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=66, longName="destructibleParameters.debrisLifetimeMax"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[66];
		ParamDef->init("debrisLifetimeMax", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed after a time (in seconds)\nseparated from non-debris chunks.  The actual lifetime is interpolated between\ndebrisLifetimeMin (see above) and debrisLifetimeMax, based upon the module\'s LOD setting.\nTo disable lifetime, clear the NxDestructibleDepthParametersFlag::DEBRIS_TIMEOUT\nflag in the flags field.  If debrisLifetimeMax < debrisLifetimeMin, the mean of the two\nis used for both.\nDefault debrisLifetimeMin = 1.0, debrisLifetimeMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Maximum time to destroy debris", true);
		ParamDefTable[66].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=67, longName="destructibleParameters.debrisMaxSeparationMin"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[67];
		ParamDef->init("debrisMaxSeparationMin", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between debrisMaxSeparationMin and debrisMaxSeparationMax (see below),\nbased upon the module\'s LOD setting.  To disable maxSeparation, clear the\nNX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum separation distance", true);
		ParamDefTable[67].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=68, longName="destructibleParameters.debrisMaxSeparationMax"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[68];
		ParamDef->init("debrisMaxSeparationMax", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "'Debris chunks' (see debrisDepth, above) will be destroyed if they are separated from\ntheir origin by a distance greater than maxSeparation.  The actual maxSeparation is\ninterpolated between debrisMaxSeparationMin (see above) and debrisMaxSeparationMax,\nbased upon the module\'s LOD setting.  To disable maxSeparation, clear the\nNX_DESTRUCTIBLE_DEBRIS_MAX_SEPARATION flag in the flags field.\nIf debrisMaxSeparationMax < debrisMaxSeparationMin, the mean of the two is used for both.\nDefault debrisMaxSeparationMin = 1.0, debrisMaxSeparationMax = 10.0f.\n", true);
		HintTable[1].init("shortDescription", "Minimum separation distance", true);
		ParamDefTable[68].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=69, longName="destructibleParameters.debrisDestructionProbability"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[69];
		ParamDef->init("debrisDestructionProbability", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The probablity that a debris chunk, when fractured, will simply be destroyed instead of becoming dynamic or breaking down\n						further into child chunks.  Valid range = [0.0,1.0].  Default value = 0.0.", true);
		HintTable[1].init("shortDescription", "The probablity that a debris chunk, when fractured, will simply be destroyed", true);
		ParamDefTable[69].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=70, longName="destructibleParameters.validBounds"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[70];
		ParamDef->init("validBounds", TYPE_BOUNDS3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A bounding box around each NxDestructibleActor created, defining a range of validity\nfor chunks that break free.  These bounds are scaled and translated with the\nNxDestructibleActor\'s scale and position, but they are not rotated with the\nNxDestructibleActor.\n", true);
		HintTable[1].init("shortDescription", "valid bounding region for debris", true);
		ParamDefTable[70].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=71, longName="destructibleParameters.maxChunkSpeed"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[71];
		ParamDef->init("maxChunkSpeed", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If greater than 0, the chunks' speeds will not be allowed to exceed this value.  Use 0\nto disable this feature (this is the default).\n", true);
		HintTable[1].init("shortDescription", "Maximum speed of a chunk", true);
		ParamDefTable[71].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=72, longName="destructibleParameters.flags"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[72];
		ParamDef->init("flags", TYPE_STRUCT, "DestructibleParametersFlag", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "A collection of flags defined in NxDestructibleParametersFlag.\n", true);
		HintTable[1].init("shortDescription", "A collection of flags defined in DestructibleParametersFlag.", true);
		ParamDefTable[72].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=73, longName="destructibleParameters.flags.ACCUMULATE_DAMAGE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[73];
		ParamDef->init("ACCUMULATE_DAMAGE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, chunks will 'remember' damage applied to them, so that many applications of a damage amount\nbelow damageThreshold will eventually fracture the chunk.  If not set, a single application of\ndamage must exceed damageThreshold in order to fracture the chunk.\n", true);
		HintTable[1].init("shortDescription", "Determines if chunks accumulate damage", true);
		ParamDefTable[73].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=74, longName="destructibleParameters.flags.DEBRIS_TIMEOUT"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[74];
		ParamDef->init("DEBRIS_TIMEOUT", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not chunks at or deeper than the 'debris' depth (see NxDestructibleParameters::debrisDepth)\nwill time out.  The lifetime is a value between NxDestructibleParameters::debrisLifetimeMin and\nNxDestructibleParameters::debrisLifetimeMax, based upon the destructible module\'s LOD setting.\n", true);
		HintTable[1].init("shortDescription", "Whether or not chunks at or deeper than the 'debris' depth will timeout", true);
		ParamDefTable[74].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=75, longName="destructibleParameters.flags.DEBRIS_MAX_SEPARATION"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[75];
		ParamDef->init("DEBRIS_MAX_SEPARATION", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not chunks at or deeper than the 'debris' depth (see NxDestructibleParameters::debrisDepth)\nwill be removed if they separate too far from their origins.  The maxSeparation is a value between\nNxDestructibleParameters::debrisMaxSeparationMin and NxDestructibleParameters::debrisMaxSeparationMax,\nbased upon the destructible module\'s LOD setting.\n", true);
		HintTable[1].init("shortDescription", "Whether or not chunks at or deeper than the 'debris' depth will be removed if separated too far", true);
		ParamDefTable[75].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=76, longName="destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[76];
		ParamDef->init("CRUMBLE_SMALLEST_CHUNKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the smallest chunks may be further broken down, either by fluid crumbles (if a crumble particle\nsystem is specified in the NxDestructibleActorDesc), or by simply removing the chunk if no crumble\nparticle system is specified.  Note: the 'smallest chunks' are normally defined to be the deepest level\nof the fracture hierarchy.  However, they may be taken from higher levels of the hierarchy if\nNxModuleDestructible::setMaxChunkDepthOffset is called with a non-zero value.\n", true);
		HintTable[1].init("shortDescription", "If set, the smallest chunks may be further broken down", true);
		ParamDefTable[76].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=77, longName="destructibleParameters.flags.ACCURATE_RAYCASTS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[77];
		ParamDef->init("ACCURATE_RAYCASTS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the NxDestructibleActor::rayCast function will search within the nearest visible chunk hit\nfor collisions with child chunks.  This is used to get a better raycast position and normal, in\ncase the parent collision volume does not tightly fit the graphics mesh.  The returned chunk index\nwill always be that of the visible parent that is intersected, however.\n", true);
		HintTable[1].init("shortDescription", "If set, the NxDestructibleActor::rayCast function will search within the nearest visible chunk hit", true);
		ParamDefTable[77].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=78, longName="destructibleParameters.flags.USE_VALID_BOUNDS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[78];
		ParamDef->init("USE_VALID_BOUNDS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, the validBounds field of NxDestructibleParameters will be used.  These bounds are translated\n(but not scaled or rotated) to the origin of the destructible actor.  If a chunk or chunk island moves\noutside of those bounds, it is destroyed.\n", true);
		HintTable[1].init("shortDescription", "If set, the validBounds field of NxDestructibleParameters will be used.", true);
		ParamDefTable[78].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=79, longName="destructibleParameters.flags.CRUMBLE_VIA_RUNTIME_FRACTURE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[79];
		ParamDef->init("CRUMBLE_VIA_RUNTIME_FRACTURE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, crumbled chunks will use the runtime fracture pipeline. The chunk will be procedurally broken\ndestroyed using either the default or a specified fracture pattern.\n", true);
		HintTable[1].init("shortDescription", "If set, crumbled chunks will use the runtime fracture pipeline.", true);
		ParamDefTable[79].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=80, longName="destructibleParameters.fractureImpulseScale"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[80];
		ParamDef->init("fractureImpulseScale", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Scale factor used to apply an impulse force along the normal of chunk when fractured.  This is used\nin order to 'push' the pieces out as they fracture.\n", true);
		HintTable[1].init("shortDescription", "Scale factor used to apply an impulse force along the normal of chunk when fractured.", true);
		ParamDefTable[80].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=81, longName="destructibleParameters.damageDepthLimit"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[81];
		ParamDef->init("damageDepthLimit", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "How deep in the hierarchy damage will be propagated, relative to the chunk hit.", true);
		HintTable[1].init("shortDescription", "How deep in the hierarchy damage will be propagated, relative to the chunk hit.", true);
		ParamDefTable[81].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=82, longName="destructibleParameters.dynamicChunkDominanceGroup"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[82];
		ParamDef->init("dynamicChunkDominanceGroup", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Optional dominance group for dynamic chunks created when fractured. (ignored if > 31)\n", true);
		HintTable[1].init("shortDescription", "Optional dominance group for dynamic chunks created when fractured.", true);
		ParamDefTable[82].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=83, longName="destructibleParameters.dynamicChunksGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[83];
		ParamDef->init("dynamicChunksGroupsMask", TYPE_STRUCT, "GroupsMask", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Optional groups mask for dynamic chunks created when fractured.\n", true);
		HintTable[1].init("shortDescription", "Optional groups mask for dynamic chunks created when fractured.", true);
		ParamDefTable[83].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=84, longName="destructibleParameters.dynamicChunksGroupsMask.useGroupsMask"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[84];
		ParamDef->init("useGroupsMask", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Whether or not the groupsMask should be used.  If so, then this will be applied to all NxShapes\n						created to represent this destructible's chunks.", true);
		HintTable[1].init("shortDescription", "Whether or not the groupsMask should be used", true);
		ParamDefTable[84].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=85, longName="destructibleParameters.dynamicChunksGroupsMask.bits0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[85];
		ParamDef->init("bits0", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits0 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits0 of the groups mask", true);
		ParamDefTable[85].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=86, longName="destructibleParameters.dynamicChunksGroupsMask.bits1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[86];
		ParamDef->init("bits1", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits1 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits1 of the groups mask", true);
		ParamDefTable[86].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=87, longName="destructibleParameters.dynamicChunksGroupsMask.bits2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[87];
		ParamDef->init("bits2", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits2 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits2 of the groups mask", true);
		ParamDefTable[87].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=88, longName="destructibleParameters.dynamicChunksGroupsMask.bits3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[88];
		ParamDef->init("bits3", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If useGroupsMask is true, this is bits3 of the groups mask.  See the PhysX documentation for more on groups masks.", true);
		HintTable[1].init("shortDescription", "bits3 of the groups mask", true);
		ParamDefTable[88].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=89, longName="destructibleParameters.runtimeFracture"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[89];
		ParamDef->init("runtimeFracture", TYPE_STRUCT, "RuntimeFracture", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Runtime Fracture Settings. 'CRUMBLE_VIA_RUNTIME_FRACTURE' must be set for this to do anything.\n", true);
		HintTable[1].init("shortDescription", "Runtime Fracture Settings", true);
		ParamDefTable[89].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=90, longName="destructibleParameters.runtimeFracture.sheetFracture"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[90];
		ParamDef->init("sheetFracture", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, align fracture pattern to largest face. \nIf false, the fracture pattern will be aligned to the hit normal with each fracture.\n", true);
		HintTable[1].init("shortDescription", "If true, align fracture pattern to largest face", true);
		ParamDefTable[90].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=91, longName="destructibleParameters.runtimeFracture.depthLimit"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[91];
		ParamDef->init("depthLimit", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Number of times deep a chunk can be fractured. Can help limit the number of chunks produced by\nruntime fracture.\n", true);
		HintTable[1].init("shortDescription", "Number of times deep a chunk can be fractured.", true);
		ParamDefTable[91].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=92, longName="destructibleParameters.runtimeFracture.destroyIfAtDepthLimit"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[92];
		ParamDef->init("destroyIfAtDepthLimit", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, destroy chunks when they hit their depth limit. \nIf false, then chunks at their depth limit will not fracture but will have a force applied.\n", true);
		HintTable[1].init("shortDescription", "Destroy chunk if at depth limit", true);
		ParamDefTable[92].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=93, longName="destructibleParameters.runtimeFracture.minConvexSize"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[93];
		ParamDef->init("minConvexSize", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Minimum Convex Size. Minimum size of convex produced by a fracture.\n", true);
		HintTable[1].init("shortDescription", "Minimum Convex Size.", true);
		ParamDefTable[93].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=94, longName="destructibleParameters.runtimeFracture.impulseScale"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[94];
		ParamDef->init("impulseScale", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Scales impulse applied by a fracture.\n", true);
		HintTable[1].init("shortDescription", "Scales impulse applied by a fracture.", true);
		ParamDefTable[94].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=95, longName="destructibleParameters.runtimeFracture.glass"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[95];
		ParamDef->init("glass", TYPE_STRUCT, "FractureGlass", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Glass Fracture Pattern Settings.\n", true);
		HintTable[1].init("shortDescription", "Glass Fracture Pattern Settings.", true);
		ParamDefTable[95].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=96, longName="destructibleParameters.runtimeFracture.glass.numSectors"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[96];
		ParamDef->init("numSectors", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Number of angular slices in the glass fracture pattern. \n", true);
		HintTable[1].init("shortDescription", "Number of angular slices.", true);
		ParamDefTable[96].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=97, longName="destructibleParameters.runtimeFracture.glass.sectorRand"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[97];
		ParamDef->init("sectorRand", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Creates variance in the angle of slices. A value of zero results in all angular slices having the same angle.\n", true);
		HintTable[1].init("shortDescription", "Creates variance in the angle of slices.", true);
		ParamDefTable[97].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=98, longName="destructibleParameters.runtimeFracture.glass.firstSegmentSize"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[98];
		ParamDef->init("firstSegmentSize", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The minimum shard size. Shards below this size will not be created and thus not visible.\n", true);
		HintTable[1].init("shortDescription", "The minimum shard size.", true);
		ParamDefTable[98].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=99, longName="destructibleParameters.runtimeFracture.glass.segmentScale"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[99];
		ParamDef->init("segmentScale", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Scales the radial spacing in the glass fracture pattern. A larger value results in radially longer shards.\n", true);
		HintTable[1].init("shortDescription", "Scales the radial spacing.", true);
		ParamDefTable[99].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=100, longName="destructibleParameters.runtimeFracture.glass.segmentRand"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[100];
		ParamDef->init("segmentRand", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Creates variance in the radial size of shards. A value of zero results in a low noise circular pattern.\n", true);
		HintTable[1].init("shortDescription", "Creates variance in the radial size of shards.", true);
		ParamDefTable[100].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=101, longName="destructibleParameters.runtimeFracture.attachment"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[101];
		ParamDef->init("attachment", TYPE_STRUCT, "FractureAttachment", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Attachment Settings. Allows the sides of a runtime fracture chunk to be kinematic rather than dynamic.\n", true);
		HintTable[1].init("shortDescription", "Attachment Settings", true);
		ParamDefTable[101].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=102, longName="destructibleParameters.runtimeFracture.attachment.posX"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[102];
		ParamDef->init("posX", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, make the positive x side of the sheet an attachment point.\n", true);
		HintTable[1].init("shortDescription", "Attach to positive x side of sheet.", true);
		ParamDefTable[102].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=103, longName="destructibleParameters.runtimeFracture.attachment.negX"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[103];
		ParamDef->init("negX", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, make the negative x side of the sheet an attachment point.\n", true);
		HintTable[1].init("shortDescription", "Attach to negative x side of sheet.", true);
		ParamDefTable[103].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=104, longName="destructibleParameters.runtimeFracture.attachment.posY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[104];
		ParamDef->init("posY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, make the positive y side of the sheet an attachment point.\n", true);
		HintTable[1].init("shortDescription", "Attach to positive y side of sheet.", true);
		ParamDefTable[104].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=105, longName="destructibleParameters.runtimeFracture.attachment.negY"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[105];
		ParamDef->init("negY", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, make the negative y side of the sheet an attachment point.\n", true);
		HintTable[1].init("shortDescription", "Attach to negative y side of sheet.", true);
		ParamDefTable[105].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=106, longName="destructibleParameters.runtimeFracture.attachment.posZ"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[106];
		ParamDef->init("posZ", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, make the positive z side of the sheet an attachment point.\n", true);
		HintTable[1].init("shortDescription", "Attach to positive z side of sheet.", true);
		ParamDefTable[106].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=107, longName="destructibleParameters.runtimeFracture.attachment.negZ"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[107];
		ParamDef->init("negZ", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If true, make the negative z side of the sheet an attachment point.\n", true);
		HintTable[1].init("shortDescription", "Attach to negative z side of sheet.", true);
		ParamDefTable[107].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=108, longName="depthParameters"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[108];
		ParamDef->init("depthParameters", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The default destructible depth parameters for this asset.  These\n					are properties that apply to all chunks at a particular level of the hierarchy.  These may be overridden\n					for an instance (destructible actor), as a copy of the parameters is also stored in the actor.", true);
		HintTable[1].init("shortDescription", "The default destructible depth parameters for this asset", true);
		ParamDefTable[108].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=109, longName="depthParameters[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[109];
		ParamDef->init("depthParameters", TYPE_STRUCT, "DestructibleDepthParameters", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The default destructible depth parameters for this asset.  These\n					are properties that apply to all chunks at a particular level of the hierarchy.  These may be overridden\n					for an instance (destructible actor), as a copy of the parameters is also stored in the actor.", true);
		HintTable[1].init("shortDescription", "The default destructible depth parameters for this asset", true);
		ParamDefTable[109].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=110, longName="depthParameters[].OVERRIDE_IMPACT_DAMAGE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[110];
		ParamDef->init("OVERRIDE_IMPACT_DAMAGE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this hierarchy depth level will take impact damage iff OVERRIDE_IMPACT_DAMAGE_VALUE = TRUE, no matter the setting of impactDamageDefaultDepth.\n", true);
		HintTable[1].init("shortDescription", "If true, chunks at this hierarchy depth level will take impact damage iff OVERRIDE_IMPACT_DAMAGE_VALUE = TRUE, no matter the setting of impactDamageDefaultDepth.", true);
		ParamDefTable[110].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=111, longName="depthParameters[].OVERRIDE_IMPACT_DAMAGE_VALUE"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[111];
		ParamDef->init("OVERRIDE_IMPACT_DAMAGE_VALUE", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If OVERRIDE_IMPACT_DAMAGE = TRUE, chunks at this hierarchy depth level will take impact damage iff OVERRIDE_IMPACT_DAMAGE_VALUE = TRUE.\n", true);
		HintTable[1].init("shortDescription", "If OVERRIDE_IMPACT_DAMAGE = TRUE, chunks at this hierarchy depth level will take impact damage iff OVERRIDE_IMPACT_DAMAGE_VALUE = TRUE.", true);
		ParamDefTable[111].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=112, longName="depthParameters[].IGNORE_POSE_UPDATES"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[112];
		ParamDef->init("IGNORE_POSE_UPDATES", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this depth should have pose updates ignored.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this depth should have pose updates ignored.", true);
		ParamDefTable[112].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=113, longName="depthParameters[].IGNORE_RAYCAST_CALLBACKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[113];
		ParamDef->init("IGNORE_RAYCAST_CALLBACKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this depth should be ignored in raycast callbacks.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this depth should be ignored in raycast callbacks.", true);
		ParamDefTable[113].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=114, longName="depthParameters[].IGNORE_CONTACT_CALLBACKS"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[114];
		ParamDef->init("IGNORE_CONTACT_CALLBACKS", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Chunks at this depth should be ignored in contact callbacks.\n", true);
		HintTable[1].init("shortDescription", "Chunks at this depth should be ignored in contact callbacks.", true);
		ParamDefTable[114].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=115, longName="depthParameters[].USER_FLAG_0"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[115];
		ParamDef->init("USER_FLAG_0", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[115].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=116, longName="depthParameters[].USER_FLAG_1"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[116];
		ParamDef->init("USER_FLAG_1", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[116].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=117, longName="depthParameters[].USER_FLAG_2"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[117];
		ParamDef->init("USER_FLAG_2", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[117].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=118, longName="depthParameters[].USER_FLAG_3"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[118];
		ParamDef->init("USER_FLAG_3", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "User defined flag.\n", true);
		HintTable[1].init("shortDescription", "User defined flag.", true);
		ParamDefTable[118].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=119, longName="crumbleEmitterName"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[119];
		ParamDef->init("crumbleEmitterName", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The name of the crumble emitter to use when crumbling\n					the smallest chunks.", true);
		HintTable[1].init("shortDescription", "The name of the crumble emitter to use", true);
		ParamDefTable[119].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=120, longName="dustEmitterName"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[120];
		ParamDef->init("dustEmitterName", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The name of the dust emitter to use.  If defined, dust particles\n					will be spawned above the chunk surface traces when a chunk is fractured.", true);
		HintTable[1].init("shortDescription", "The name of the dust emitter to use", true);
		ParamDefTable[120].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=121, longName="collisionData"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[121];
		ParamDef->init("collisionData", TYPE_REF, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[121].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "The cooked convex data for PhysX collision.  All cooked convex hulls for a set of\n					scales may be included", true);
		HintTable[2].init("shortDescription", "The cooked convex data for PhysX collision", true);
		ParamDefTable[121].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "DestructibleAssetCollisionDataSet" };
		ParamDefTable[121].setRefVariantVals((const char**)RefVariantVals, 1);



	}

	// Initialize DefinitionImpl node: nodeIndex=122, longName="renderMeshAsset"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[122];
		ParamDef->init("renderMeshAsset", TYPE_REF, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[122].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "The included render mesh asset.", true);
		HintTable[2].init("shortDescription", "The included render mesh asset", true);
		ParamDefTable[122].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "RenderMeshAssetParameters" };
		ParamDefTable[122].setRefVariantVals((const char**)RefVariantVals, 1);



	}

	// Initialize DefinitionImpl node: nodeIndex=123, longName="initialDestructibleActorAllowanceForInstancing"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[123];
		ParamDef->init("initialDestructibleActorAllowanceForInstancing", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Initial actor estimate for instance buffer allocation.\n					Used for setting instance buffer sizes.", true);
		HintTable[1].init("shortDescription", "Initial actor estimate for instance buffer allocation", true);
		ParamDefTable[123].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=124, longName="chunkInstanceInfo"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[124];
		ParamDef->init("chunkInstanceInfo", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Per-instance data for each instanced chunk.", true);
		HintTable[1].init("shortDescription", "Per-instance data for each instanced chunk", true);
		ParamDefTable[124].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=125, longName="chunkInstanceInfo[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[125];
		ParamDef->init("chunkInstanceInfo", TYPE_STRUCT, "InstanceInfo", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Per-instance data for each instanced chunk.", true);
		HintTable[1].init("shortDescription", "Per-instance data for each instanced chunk", true);
		ParamDefTable[125].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=126, longName="chunkInstanceInfo[].partIndex"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[126];
		ParamDef->init("partIndex", TYPE_U16, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The part instanced for this chunk.", true);
		HintTable[1].init("shortDescription", "The part instanced for this chunk", true);
		ParamDefTable[126].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=127, longName="chunkInstanceInfo[].chunkPositionOffset"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[127];
		ParamDef->init("chunkPositionOffset", TYPE_VEC3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Translation for this chunk mesh within the asset.\n							Normally a chunk needs no translation, but if a chunk is instanced within\n							the asset, then this translation is needed.", true);
		HintTable[1].init("shortDescription", "Translation for this chunk mesh within the asset", true);
		ParamDefTable[127].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=128, longName="chunkInstanceInfo[].chunkUVOffset"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[128];
		ParamDef->init("chunkUVOffset", TYPE_VEC2, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "UV translation for this chunk mesh's vertices.", true);
		HintTable[1].init("shortDescription", "UV translation for this chunk mesh's vertices", true);
		ParamDefTable[128].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=129, longName="staticMaterialNames"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[129];
		ParamDef->init("staticMaterialNames", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Alternative material names for the static render mesh, if it's created.", true);
		HintTable[1].init("shortDescription", "Alternative material names for the static render mesh, if it's created", true);
		ParamDefTable[129].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[1] = { 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 1);

	}

	// Initialize DefinitionImpl node: nodeIndex=130, longName="staticMaterialNames[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[130];
		ParamDef->init("staticMaterialNames", TYPE_STRING, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Alternative material names for the static render mesh, if it's created.", true);
		HintTable[1].init("shortDescription", "Alternative material names for the static render mesh, if it's created", true);
		ParamDefTable[130].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=131, longName="neighborPadding"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[131];
		ParamDef->init("neighborPadding", TYPE_F32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Padding used for chunk neighbor tests.  This padding is relative to the largest diagonal\n					of the asset's local bounding box.\n					This value must be non-negative.\n					Default value = 0.001f.", true);
		HintTable[1].init("shortDescription", "Padding used for chunk neighbor tests.", true);
		ParamDefTable[131].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=132, longName="overlapsAtDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[132];
		ParamDef->init("overlapsAtDepth", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[132].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "The chunk overlaps (adjacencies) at each depth of the hierarchy.", true);
		HintTable[2].init("shortDescription", "The chunk overlaps at each depth of the hierarchy", true);
		ParamDefTable[132].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "CachedOverlaps" };
		ParamDefTable[132].setRefVariantVals((const char**)RefVariantVals, 1);


		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[1] = { 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 1);

	}

	// Initialize DefinitionImpl node: nodeIndex=133, longName="overlapsAtDepth[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[133];
		ParamDef->init("overlapsAtDepth", TYPE_REF, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[133].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "The chunk overlaps (adjacencies) at each depth of the hierarchy.", true);
		HintTable[2].init("shortDescription", "The chunk overlaps at each depth of the hierarchy", true);
		ParamDefTable[133].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "CachedOverlaps" };
		ParamDefTable[133].setRefVariantVals((const char**)RefVariantVals, 1);



	}

	// Initialize DefinitionImpl node: nodeIndex=134, longName="firstChunkAtDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[134];
		ParamDef->init("firstChunkAtDepth", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The first index of chunks at each depth in the hierarchy.  All chunks\n					at a given depth are stored contiguously.", true);
		HintTable[1].init("shortDescription", "The first index of chunks at each depth", true);
		ParamDefTable[134].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=135, longName="firstChunkAtDepth[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[135];
		ParamDef->init("firstChunkAtDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The first index of chunks at each depth in the hierarchy.  All chunks\n					at a given depth are stored contiguously.", true);
		HintTable[1].init("shortDescription", "The first index of chunks at each depth", true);
		ParamDefTable[135].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=136, longName="supportDepth"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[136];
		ParamDef->init("supportDepth", TYPE_U32, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The chunk hierarchy depth at which to create a support graph.  Higher depth levels give more detailed support,\nbut will give a higher computational load.  Chunks below the support depth will never be supported.\n", true);
		HintTable[1].init("shortDescription", "The chunk hierarchy depth at which to create a support graph.", true);
		ParamDefTable[136].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=137, longName="formExtendedStructures"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[137];
		ParamDef->init("formExtendedStructures", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If initially static, the destructible will become part of an extended support structure if it is\nin contact with another static destructible that also has this flag set.\n", true);
		HintTable[1].init("shortDescription", "If initially static, the destructible will become part of an extended support structure if it is in contact with another static destructible that also has this flag set.", true);
		ParamDefTable[137].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=138, longName="useAssetDefinedSupport"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[138];
		ParamDef->init("useAssetDefinedSupport", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, then chunks which are tagged as 'support' chunks (via NxDestructibleChunkDesc::isSupportChunk)\nwill have environmental support in static destructibles.\nNote: if both ASSET_DEFINED_SUPPORT and WORLD_SUPPORT are set, then chunks must be tagged as\n'support' chunks AND overlap the NxScene's static geometry in order to be environmentally supported.\n", true);
		HintTable[1].init("shortDescription", "If set, then chunks which are tagged as 'support' chunks", true);
		ParamDefTable[138].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=139, longName="useWorldSupport"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[139];
		ParamDef->init("useWorldSupport", TYPE_BOOL, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "If set, then chunks which overlap the NxScene\'s static geometry will have environmental support in\nstatic destructibles.\nNote: if both ASSET_DEFINED_SUPPORT and WORLD_SUPPORT are set, then chunks must be tagged as\n'support' chunks AND overlap the NxScene's static geometry in order to be environmentally supported.\n", true);
		HintTable[1].init("shortDescription", "If set, then chunks which overlap the NxScene's static geometry will have environmental support", true);
		ParamDefTable[139].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=140, longName="actorTransforms"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[140];
		ParamDef->init("actorTransforms", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "List of actor poses (that may contain scaling) which may be saved in the asset for convenience.", true);
		HintTable[1].init("shortDescription", "List of actor poses (that may contain scaling) which may be saved in the asset for convenience", true);
		ParamDefTable[140].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=141, longName="actorTransforms[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[141];
		ParamDef->init("actorTransforms", TYPE_MAT44, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "List of actor poses (that may contain scaling) which may be saved in the asset for convenience.", true);
		HintTable[1].init("shortDescription", "List of actor poses (that may contain scaling) which may be saved in the asset for convenience", true);
		ParamDefTable[141].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=142, longName="scatterMeshAssets"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[142];
		ParamDef->init("scatterMeshAssets", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[142].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "The included scatter mesh asset.", true);
		HintTable[2].init("shortDescription", "The included scatter mesh assets", true);
		ParamDefTable[142].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "RenderMeshAssetParameters" };
		ParamDefTable[142].setRefVariantVals((const char**)RefVariantVals, 1);


		ParamDef->setArraySize(-1);
		static const uint8_t dynHandleIndices[1] = { 0, };
		ParamDef->setDynamicHandleIndicesMap(dynHandleIndices, 1);

	}

	// Initialize DefinitionImpl node: nodeIndex=143, longName="scatterMeshAssets[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[143];
		ParamDef->init("scatterMeshAssets", TYPE_REF, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

		static HintImpl HintTable[1];
		static Hint* HintPtrTable[1] = { &HintTable[0], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		ParamDefTable[143].setHints((const NvParameterized::Hint**)HintPtrTable, 1);

#else

		static HintImpl HintTable[3];
		static Hint* HintPtrTable[3] = { &HintTable[0], &HintTable[1], &HintTable[2], };
		HintTable[0].init("INCLUDED", uint64_t(1), true);
		HintTable[1].init("longDescription", "The included scatter mesh asset.", true);
		HintTable[2].init("shortDescription", "The included scatter mesh assets", true);
		ParamDefTable[143].setHints((const NvParameterized::Hint**)HintPtrTable, 3);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */


		static const char* const RefVariantVals[] = { "RenderMeshAssetParameters" };
		ParamDefTable[143].setRefVariantVals((const char**)RefVariantVals, 1);



	}

	// Initialize DefinitionImpl node: nodeIndex=144, longName="scatterMeshIndices"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[144];
		ParamDef->init("scatterMeshIndices", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Array of indices for scatter meshes defined in the asset. Valid indices must be in the range [0,N), where N is the size of the scatterMeshAssets array.", true);
		HintTable[1].init("shortDescription", "Array of indices for scatter meshes defined in the asset", true);
		ParamDefTable[144].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=145, longName="scatterMeshIndices[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[145];
		ParamDef->init("scatterMeshIndices", TYPE_U8, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Array of indices for scatter meshes defined in the asset. Valid indices must be in the range [0,N), where N is the size of the scatterMeshAssets array.", true);
		HintTable[1].init("shortDescription", "Array of indices for scatter meshes defined in the asset", true);
		ParamDefTable[145].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=146, longName="scatterMeshTransforms"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[146];
		ParamDef->init("scatterMeshTransforms", TYPE_ARRAY, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Array of chunk-relative transforms for scatter meshes defined in the asset.  Must be the same size as scatterMeshIndices.", true);
		HintTable[1].init("shortDescription", "Array of chunk-relative transforms for scatter meshes defined in the asset", true);
		ParamDefTable[146].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */




		ParamDef->setArraySize(-1);
	}

	// Initialize DefinitionImpl node: nodeIndex=147, longName="scatterMeshTransforms[]"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[147];
		ParamDef->init("scatterMeshTransforms", TYPE_STRUCT, "M34", true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "Array of chunk-relative transforms for scatter meshes defined in the asset.  Must be the same size as scatterMeshIndices.", true);
		HintTable[1].init("shortDescription", "Array of chunk-relative transforms for scatter meshes defined in the asset", true);
		ParamDefTable[147].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=148, longName="scatterMeshTransforms[].matrix"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[148];
		ParamDef->init("matrix", TYPE_MAT33, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The matrix part of the transform, containing the (possibly scaled axis-unaligned) rotation.", true);
		HintTable[1].init("shortDescription", "The matrix part of the transform, containing the (possibly scaled axis-unaligned) rotation", true);
		ParamDefTable[148].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// Initialize DefinitionImpl node: nodeIndex=149, longName="scatterMeshTransforms[].vector"
	{
		NvParameterized::DefinitionImpl* ParamDef = &ParamDefTable[149];
		ParamDef->init("vector", TYPE_VEC3, NULL, true);

#ifdef NV_PARAMETERIZED_HIDE_DESCRIPTIONS

#else

		static HintImpl HintTable[2];
		static Hint* HintPtrTable[2] = { &HintTable[0], &HintTable[1], };
		HintTable[0].init("longDescription", "The vector part of the transform, containing a translation.", true);
		HintTable[1].init("shortDescription", "The vector part of the transform, containing a translation", true);
		ParamDefTable[149].setHints((const NvParameterized::Hint**)HintPtrTable, 2);

#endif /* NV_PARAMETERIZED_HIDE_DESCRIPTIONS */





	}

	// SetChildren for: nodeIndex=0, longName=""
	{
		static Definition* Children[30];
		Children[0] = PDEF_PTR(1);
		Children[1] = PDEF_PTR(2);
		Children[2] = PDEF_PTR(3);
		Children[3] = PDEF_PTR(4);
		Children[4] = PDEF_PTR(5);
		Children[5] = PDEF_PTR(22);
		Children[6] = PDEF_PTR(40);
		Children[7] = PDEF_PTR(41);
		Children[8] = PDEF_PTR(53);
		Children[9] = PDEF_PTR(55);
		Children[10] = PDEF_PTR(57);
		Children[11] = PDEF_PTR(108);
		Children[12] = PDEF_PTR(119);
		Children[13] = PDEF_PTR(120);
		Children[14] = PDEF_PTR(121);
		Children[15] = PDEF_PTR(122);
		Children[16] = PDEF_PTR(123);
		Children[17] = PDEF_PTR(124);
		Children[18] = PDEF_PTR(129);
		Children[19] = PDEF_PTR(131);
		Children[20] = PDEF_PTR(132);
		Children[21] = PDEF_PTR(134);
		Children[22] = PDEF_PTR(136);
		Children[23] = PDEF_PTR(137);
		Children[24] = PDEF_PTR(138);
		Children[25] = PDEF_PTR(139);
		Children[26] = PDEF_PTR(140);
		Children[27] = PDEF_PTR(142);
		Children[28] = PDEF_PTR(144);
		Children[29] = PDEF_PTR(146);

		ParamDefTable[0].setChildren(Children, 30);
	}

	// SetChildren for: nodeIndex=5, longName="defaultBehaviorGroup"
	{
		static Definition* Children[10];
		Children[0] = PDEF_PTR(6);
		Children[1] = PDEF_PTR(7);
		Children[2] = PDEF_PTR(8);
		Children[3] = PDEF_PTR(9);
		Children[4] = PDEF_PTR(13);
		Children[5] = PDEF_PTR(17);
		Children[6] = PDEF_PTR(18);
		Children[7] = PDEF_PTR(19);
		Children[8] = PDEF_PTR(20);
		Children[9] = PDEF_PTR(21);

		ParamDefTable[5].setChildren(Children, 10);
	}

	// SetChildren for: nodeIndex=9, longName="defaultBehaviorGroup.damageSpread"
	{
		static Definition* Children[3];
		Children[0] = PDEF_PTR(10);
		Children[1] = PDEF_PTR(11);
		Children[2] = PDEF_PTR(12);

		ParamDefTable[9].setChildren(Children, 3);
	}

	// SetChildren for: nodeIndex=13, longName="defaultBehaviorGroup.damageColorSpread"
	{
		static Definition* Children[3];
		Children[0] = PDEF_PTR(14);
		Children[1] = PDEF_PTR(15);
		Children[2] = PDEF_PTR(16);

		ParamDefTable[13].setChildren(Children, 3);
	}

	// SetChildren for: nodeIndex=22, longName="behaviorGroups"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(23);

		ParamDefTable[22].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=23, longName="behaviorGroups[]"
	{
		static Definition* Children[10];
		Children[0] = PDEF_PTR(24);
		Children[1] = PDEF_PTR(25);
		Children[2] = PDEF_PTR(26);
		Children[3] = PDEF_PTR(27);
		Children[4] = PDEF_PTR(31);
		Children[5] = PDEF_PTR(35);
		Children[6] = PDEF_PTR(36);
		Children[7] = PDEF_PTR(37);
		Children[8] = PDEF_PTR(38);
		Children[9] = PDEF_PTR(39);

		ParamDefTable[23].setChildren(Children, 10);
	}

	// SetChildren for: nodeIndex=27, longName="behaviorGroups[].damageSpread"
	{
		static Definition* Children[3];
		Children[0] = PDEF_PTR(28);
		Children[1] = PDEF_PTR(29);
		Children[2] = PDEF_PTR(30);

		ParamDefTable[27].setChildren(Children, 3);
	}

	// SetChildren for: nodeIndex=31, longName="behaviorGroups[].damageColorSpread"
	{
		static Definition* Children[3];
		Children[0] = PDEF_PTR(32);
		Children[1] = PDEF_PTR(33);
		Children[2] = PDEF_PTR(34);

		ParamDefTable[31].setChildren(Children, 3);
	}

	// SetChildren for: nodeIndex=41, longName="chunks"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(42);

		ParamDefTable[41].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=42, longName="chunks[]"
	{
		static Definition* Children[10];
		Children[0] = PDEF_PTR(43);
		Children[1] = PDEF_PTR(44);
		Children[2] = PDEF_PTR(45);
		Children[3] = PDEF_PTR(46);
		Children[4] = PDEF_PTR(47);
		Children[5] = PDEF_PTR(48);
		Children[6] = PDEF_PTR(49);
		Children[7] = PDEF_PTR(50);
		Children[8] = PDEF_PTR(51);
		Children[9] = PDEF_PTR(52);

		ParamDefTable[42].setChildren(Children, 10);
	}

	// SetChildren for: nodeIndex=53, longName="chunkConvexHulls"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(54);

		ParamDefTable[53].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=55, longName="chunkConvexHullStartIndices"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(56);

		ParamDefTable[55].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=57, longName="destructibleParameters"
	{
		static Definition* Children[20];
		Children[0] = PDEF_PTR(58);
		Children[1] = PDEF_PTR(59);
		Children[2] = PDEF_PTR(60);
		Children[3] = PDEF_PTR(61);
		Children[4] = PDEF_PTR(62);
		Children[5] = PDEF_PTR(63);
		Children[6] = PDEF_PTR(64);
		Children[7] = PDEF_PTR(65);
		Children[8] = PDEF_PTR(66);
		Children[9] = PDEF_PTR(67);
		Children[10] = PDEF_PTR(68);
		Children[11] = PDEF_PTR(69);
		Children[12] = PDEF_PTR(70);
		Children[13] = PDEF_PTR(71);
		Children[14] = PDEF_PTR(72);
		Children[15] = PDEF_PTR(80);
		Children[16] = PDEF_PTR(81);
		Children[17] = PDEF_PTR(82);
		Children[18] = PDEF_PTR(83);
		Children[19] = PDEF_PTR(89);

		ParamDefTable[57].setChildren(Children, 20);
	}

	// SetChildren for: nodeIndex=72, longName="destructibleParameters.flags"
	{
		static Definition* Children[7];
		Children[0] = PDEF_PTR(73);
		Children[1] = PDEF_PTR(74);
		Children[2] = PDEF_PTR(75);
		Children[3] = PDEF_PTR(76);
		Children[4] = PDEF_PTR(77);
		Children[5] = PDEF_PTR(78);
		Children[6] = PDEF_PTR(79);

		ParamDefTable[72].setChildren(Children, 7);
	}

	// SetChildren for: nodeIndex=83, longName="destructibleParameters.dynamicChunksGroupsMask"
	{
		static Definition* Children[5];
		Children[0] = PDEF_PTR(84);
		Children[1] = PDEF_PTR(85);
		Children[2] = PDEF_PTR(86);
		Children[3] = PDEF_PTR(87);
		Children[4] = PDEF_PTR(88);

		ParamDefTable[83].setChildren(Children, 5);
	}

	// SetChildren for: nodeIndex=89, longName="destructibleParameters.runtimeFracture"
	{
		static Definition* Children[7];
		Children[0] = PDEF_PTR(90);
		Children[1] = PDEF_PTR(91);
		Children[2] = PDEF_PTR(92);
		Children[3] = PDEF_PTR(93);
		Children[4] = PDEF_PTR(94);
		Children[5] = PDEF_PTR(95);
		Children[6] = PDEF_PTR(101);

		ParamDefTable[89].setChildren(Children, 7);
	}

	// SetChildren for: nodeIndex=95, longName="destructibleParameters.runtimeFracture.glass"
	{
		static Definition* Children[5];
		Children[0] = PDEF_PTR(96);
		Children[1] = PDEF_PTR(97);
		Children[2] = PDEF_PTR(98);
		Children[3] = PDEF_PTR(99);
		Children[4] = PDEF_PTR(100);

		ParamDefTable[95].setChildren(Children, 5);
	}

	// SetChildren for: nodeIndex=101, longName="destructibleParameters.runtimeFracture.attachment"
	{
		static Definition* Children[6];
		Children[0] = PDEF_PTR(102);
		Children[1] = PDEF_PTR(103);
		Children[2] = PDEF_PTR(104);
		Children[3] = PDEF_PTR(105);
		Children[4] = PDEF_PTR(106);
		Children[5] = PDEF_PTR(107);

		ParamDefTable[101].setChildren(Children, 6);
	}

	// SetChildren for: nodeIndex=108, longName="depthParameters"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(109);

		ParamDefTable[108].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=109, longName="depthParameters[]"
	{
		static Definition* Children[9];
		Children[0] = PDEF_PTR(110);
		Children[1] = PDEF_PTR(111);
		Children[2] = PDEF_PTR(112);
		Children[3] = PDEF_PTR(113);
		Children[4] = PDEF_PTR(114);
		Children[5] = PDEF_PTR(115);
		Children[6] = PDEF_PTR(116);
		Children[7] = PDEF_PTR(117);
		Children[8] = PDEF_PTR(118);

		ParamDefTable[109].setChildren(Children, 9);
	}

	// SetChildren for: nodeIndex=124, longName="chunkInstanceInfo"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(125);

		ParamDefTable[124].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=125, longName="chunkInstanceInfo[]"
	{
		static Definition* Children[3];
		Children[0] = PDEF_PTR(126);
		Children[1] = PDEF_PTR(127);
		Children[2] = PDEF_PTR(128);

		ParamDefTable[125].setChildren(Children, 3);
	}

	// SetChildren for: nodeIndex=129, longName="staticMaterialNames"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(130);

		ParamDefTable[129].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=132, longName="overlapsAtDepth"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(133);

		ParamDefTable[132].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=134, longName="firstChunkAtDepth"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(135);

		ParamDefTable[134].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=140, longName="actorTransforms"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(141);

		ParamDefTable[140].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=142, longName="scatterMeshAssets"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(143);

		ParamDefTable[142].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=144, longName="scatterMeshIndices"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(145);

		ParamDefTable[144].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=146, longName="scatterMeshTransforms"
	{
		static Definition* Children[1];
		Children[0] = PDEF_PTR(147);

		ParamDefTable[146].setChildren(Children, 1);
	}

	// SetChildren for: nodeIndex=147, longName="scatterMeshTransforms[]"
	{
		static Definition* Children[2];
		Children[0] = PDEF_PTR(148);
		Children[1] = PDEF_PTR(149);

		ParamDefTable[147].setChildren(Children, 2);
	}

	mBuiltFlag = true;

}
void DestructibleAssetParameters_0p20::initStrings(void)
{
	comments.isAllocated = true;
	comments.buf = NULL;
	defaultBehaviorGroup.name.isAllocated = true;
	defaultBehaviorGroup.name.buf = NULL;
	crumbleEmitterName.isAllocated = true;
	crumbleEmitterName.buf = NULL;
	dustEmitterName.isAllocated = true;
	dustEmitterName.buf = NULL;
}

void DestructibleAssetParameters_0p20::initDynamicArrays(void)
{
	behaviorGroups.buf = NULL;
	behaviorGroups.isAllocated = true;
	behaviorGroups.elementSize = sizeof(BehaviorGroup_Type);
	behaviorGroups.arraySizes[0] = 0;
	chunks.buf = NULL;
	chunks.isAllocated = true;
	chunks.elementSize = sizeof(Chunk_Type);
	chunks.arraySizes[0] = 0;
	chunkConvexHulls.buf = NULL;
	chunkConvexHulls.isAllocated = true;
	chunkConvexHulls.elementSize = sizeof(NvParameterized::Interface*);
	chunkConvexHulls.arraySizes[0] = 0;
	chunkConvexHullStartIndices.buf = NULL;
	chunkConvexHullStartIndices.isAllocated = true;
	chunkConvexHullStartIndices.elementSize = sizeof(uint32_t);
	chunkConvexHullStartIndices.arraySizes[0] = 0;
	depthParameters.buf = NULL;
	depthParameters.isAllocated = true;
	depthParameters.elementSize = sizeof(DestructibleDepthParameters_Type);
	depthParameters.arraySizes[0] = 0;
	chunkInstanceInfo.buf = NULL;
	chunkInstanceInfo.isAllocated = true;
	chunkInstanceInfo.elementSize = sizeof(InstanceInfo_Type);
	chunkInstanceInfo.arraySizes[0] = 0;
	staticMaterialNames.buf = NULL;
	staticMaterialNames.isAllocated = true;
	staticMaterialNames.elementSize = sizeof(NvParameterized::DummyStringStruct);
	staticMaterialNames.arraySizes[0] = 0;
	overlapsAtDepth.buf = NULL;
	overlapsAtDepth.isAllocated = true;
	overlapsAtDepth.elementSize = sizeof(NvParameterized::Interface*);
	overlapsAtDepth.arraySizes[0] = 0;
	firstChunkAtDepth.buf = NULL;
	firstChunkAtDepth.isAllocated = true;
	firstChunkAtDepth.elementSize = sizeof(uint32_t);
	firstChunkAtDepth.arraySizes[0] = 0;
	actorTransforms.buf = NULL;
	actorTransforms.isAllocated = true;
	actorTransforms.elementSize = sizeof(physx::PxMat44);
	actorTransforms.arraySizes[0] = 0;
	scatterMeshAssets.buf = NULL;
	scatterMeshAssets.isAllocated = true;
	scatterMeshAssets.elementSize = sizeof(NvParameterized::Interface*);
	scatterMeshAssets.arraySizes[0] = 0;
	scatterMeshIndices.buf = NULL;
	scatterMeshIndices.isAllocated = true;
	scatterMeshIndices.elementSize = sizeof(uint8_t);
	scatterMeshIndices.arraySizes[0] = 0;
	scatterMeshTransforms.buf = NULL;
	scatterMeshTransforms.isAllocated = true;
	scatterMeshTransforms.elementSize = sizeof(M34_Type);
	scatterMeshTransforms.arraySizes[0] = 0;
}

void DestructibleAssetParameters_0p20::initDefaults(void)
{

	freeStrings();
	freeReferences();
	freeDynamicArrays();
	depthCount = uint32_t(0);
	originalDepthCount = uint32_t(0);
	defaultBehaviorGroup.damageThreshold = float(1);
	defaultBehaviorGroup.damageToRadius = float(0.1);
	defaultBehaviorGroup.damageSpread.minimumRadius = float(0);
	defaultBehaviorGroup.damageSpread.radiusMultiplier = float(1);
	defaultBehaviorGroup.damageSpread.falloffExponent = float(1);
	defaultBehaviorGroup.damageColorSpread.minimumRadius = float(0);
	defaultBehaviorGroup.damageColorSpread.radiusMultiplier = float(1);
	defaultBehaviorGroup.damageColorSpread.falloffExponent = float(1);
	defaultBehaviorGroup.damageColorChange = physx::PxVec4(initVec4(0, 0, 0, 0));
	defaultBehaviorGroup.materialStrength = float(0);
	defaultBehaviorGroup.density = float(0);
	defaultBehaviorGroup.fadeOut = float(1);
	defaultBehaviorGroup.userData = uint64_t(0);
	RTFractureBehaviorGroup = int8_t(-1);
	destructibleParameters.damageCap = float(0);
	destructibleParameters.forceToDamage = float(0);
	destructibleParameters.impactVelocityThreshold = float(0);
	destructibleParameters.minimumFractureDepth = uint32_t(0);
	destructibleParameters.impactDamageDefaultDepth = int32_t(-1);
	destructibleParameters.debrisDepth = int32_t(-1);
	destructibleParameters.essentialDepth = uint32_t(0);
	destructibleParameters.debrisLifetimeMin = float(1);
	destructibleParameters.debrisLifetimeMax = float(10);
	destructibleParameters.debrisMaxSeparationMin = float(1);
	destructibleParameters.debrisMaxSeparationMax = float(10);
	destructibleParameters.debrisDestructionProbability = float(0);
	destructibleParameters.validBounds = physx::PxBounds3(init(-1000, -1000, -1000, 1000, 1000, 1000));
	destructibleParameters.maxChunkSpeed = float(0);
	destructibleParameters.flags.ACCUMULATE_DAMAGE = bool(true);
	destructibleParameters.flags.DEBRIS_TIMEOUT = bool(false);
	destructibleParameters.flags.DEBRIS_MAX_SEPARATION = bool(false);
	destructibleParameters.flags.CRUMBLE_SMALLEST_CHUNKS = bool(false);
	destructibleParameters.flags.ACCURATE_RAYCASTS = bool(false);
	destructibleParameters.flags.USE_VALID_BOUNDS = bool(false);
	destructibleParameters.flags.CRUMBLE_VIA_RUNTIME_FRACTURE = bool(false);
	destructibleParameters.fractureImpulseScale = float(0);
	destructibleParameters.damageDepthLimit = uint16_t(UINT16_MAX);
	destructibleParameters.dynamicChunkDominanceGroup = uint16_t(UINT16_MAX);
	destructibleParameters.dynamicChunksGroupsMask.useGroupsMask = bool(false);
	destructibleParameters.dynamicChunksGroupsMask.bits0 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits1 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits2 = uint32_t(0);
	destructibleParameters.dynamicChunksGroupsMask.bits3 = uint32_t(0);
	destructibleParameters.runtimeFracture.sheetFracture = bool(true);
	destructibleParameters.runtimeFracture.depthLimit = uint32_t(2);
	destructibleParameters.runtimeFracture.destroyIfAtDepthLimit = bool(false);
	destructibleParameters.runtimeFracture.minConvexSize = float(0.02);
	destructibleParameters.runtimeFracture.impulseScale = float(1);
	destructibleParameters.runtimeFracture.glass.numSectors = uint32_t(30);
	destructibleParameters.runtimeFracture.glass.sectorRand = float(0.3);
	destructibleParameters.runtimeFracture.glass.firstSegmentSize = float(0.03);
	destructibleParameters.runtimeFracture.glass.segmentScale = float(1.4);
	destructibleParameters.runtimeFracture.glass.segmentRand = float(0.3);
	destructibleParameters.runtimeFracture.attachment.posX = bool(false);
	destructibleParameters.runtimeFracture.attachment.negX = bool(false);
	destructibleParameters.runtimeFracture.attachment.posY = bool(false);
	destructibleParameters.runtimeFracture.attachment.negY = bool(false);
	destructibleParameters.runtimeFracture.attachment.posZ = bool(false);
	destructibleParameters.runtimeFracture.attachment.negZ = bool(false);
	initialDestructibleActorAllowanceForInstancing = uint32_t(0);
	neighborPadding = float(0.001);
	supportDepth = uint32_t(0);
	formExtendedStructures = bool(false);
	useAssetDefinedSupport = bool(false);
	useWorldSupport = bool(false);

	initDynamicArrays();
	initStrings();
	initReferences();
}

void DestructibleAssetParameters_0p20::initReferences(void)
{
	collisionData = NULL;

	renderMeshAsset = NULL;

}

void DestructibleAssetParameters_0p20::freeDynamicArrays(void)
{
	if (behaviorGroups.isAllocated && behaviorGroups.buf)
	{
		mParameterizedTraits->free(behaviorGroups.buf);
	}
	if (chunks.isAllocated && chunks.buf)
	{
		mParameterizedTraits->free(chunks.buf);
	}
	if (chunkConvexHulls.isAllocated && chunkConvexHulls.buf)
	{
		mParameterizedTraits->free(chunkConvexHulls.buf);
	}
	if (chunkConvexHullStartIndices.isAllocated && chunkConvexHullStartIndices.buf)
	{
		mParameterizedTraits->free(chunkConvexHullStartIndices.buf);
	}
	if (depthParameters.isAllocated && depthParameters.buf)
	{
		mParameterizedTraits->free(depthParameters.buf);
	}
	if (chunkInstanceInfo.isAllocated && chunkInstanceInfo.buf)
	{
		mParameterizedTraits->free(chunkInstanceInfo.buf);
	}
	if (staticMaterialNames.isAllocated && staticMaterialNames.buf)
	{
		mParameterizedTraits->free(staticMaterialNames.buf);
	}
	if (overlapsAtDepth.isAllocated && overlapsAtDepth.buf)
	{
		mParameterizedTraits->free(overlapsAtDepth.buf);
	}
	if (firstChunkAtDepth.isAllocated && firstChunkAtDepth.buf)
	{
		mParameterizedTraits->free(firstChunkAtDepth.buf);
	}
	if (actorTransforms.isAllocated && actorTransforms.buf)
	{
		mParameterizedTraits->free(actorTransforms.buf);
	}
	if (scatterMeshAssets.isAllocated && scatterMeshAssets.buf)
	{
		mParameterizedTraits->free(scatterMeshAssets.buf);
	}
	if (scatterMeshIndices.isAllocated && scatterMeshIndices.buf)
	{
		mParameterizedTraits->free(scatterMeshIndices.buf);
	}
	if (scatterMeshTransforms.isAllocated && scatterMeshTransforms.buf)
	{
		mParameterizedTraits->free(scatterMeshTransforms.buf);
	}
}

void DestructibleAssetParameters_0p20::freeStrings(void)
{

	if (comments.isAllocated && comments.buf)
	{
		mParameterizedTraits->strfree((char*)comments.buf);
	}

	if (defaultBehaviorGroup.name.isAllocated && defaultBehaviorGroup.name.buf)
	{
		mParameterizedTraits->strfree((char*)defaultBehaviorGroup.name.buf);
	}

	for (int i = 0; i < behaviorGroups.arraySizes[0]; ++i)
	{
		if (behaviorGroups.buf[i].name.isAllocated && behaviorGroups.buf[i].name.buf)
		{
			mParameterizedTraits->strfree((char*)behaviorGroups.buf[i].name.buf);
		}
	}

	if (crumbleEmitterName.isAllocated && crumbleEmitterName.buf)
	{
		mParameterizedTraits->strfree((char*)crumbleEmitterName.buf);
	}

	if (dustEmitterName.isAllocated && dustEmitterName.buf)
	{
		mParameterizedTraits->strfree((char*)dustEmitterName.buf);
	}

	for (int i = 0; i < staticMaterialNames.arraySizes[0]; ++i)
	{
		if (staticMaterialNames.buf[i].isAllocated && staticMaterialNames.buf[i].buf)
		{
			mParameterizedTraits->strfree((char*)staticMaterialNames.buf[i].buf);
		}
	}
}

void DestructibleAssetParameters_0p20::freeReferences(void)
{

	for (int i = 0; i < chunkConvexHulls.arraySizes[0]; ++i)
	{
		if (chunkConvexHulls.buf[i])
		{
			chunkConvexHulls.buf[i]->destroy();
		}
	}
	if (collisionData)
	{
		collisionData->destroy();
	}

	if (renderMeshAsset)
	{
		renderMeshAsset->destroy();
	}


	for (int i = 0; i < overlapsAtDepth.arraySizes[0]; ++i)
	{
		if (overlapsAtDepth.buf[i])
		{
			overlapsAtDepth.buf[i]->destroy();
		}
	}

	for (int i = 0; i < scatterMeshAssets.arraySizes[0]; ++i)
	{
		if (scatterMeshAssets.buf[i])
		{
			scatterMeshAssets.buf[i]->destroy();
		}
	}
}

} // namespace parameterized
} // namespace nvidia
