#
# Build BlastUnitTests Windows
#

FIND_PACKAGE(nvToolsExt $ENV{PM_nvToolsExt_VERSION} REQUIRED)

SET(BLASTUNITTESTS_PLATFORM_COMMON_FILES
)

SET(BLASTUNITTESTS_PLATFORM_INCLUDES
    PRIVATE $<$<OR:$<CONFIG:debug>,$<CONFIG:checked>,$<CONFIG:profile>>:${NVTOOLSEXT_INCLUDE_DIRS}>
)

SET(BLASTUNITTESTS_COMPILE_DEFS
	# Common to all configurations
	${BLASTTESTS_SLN_COMPILE_DEFS}
	
	$<$<CONFIG:debug>:${BLASTTESTS_SLN_DEBUG_COMPILE_DEFS}>
	$<$<CONFIG:checked>:${BLASTTESTS_SLN_CHECKED_COMPILE_DEFS}>
	$<$<CONFIG:profile>:${BLASTTESTS_SLN_PROFILE_COMPILE_DEFS}>
	$<$<CONFIG:release>:${BLASTTESTS_SLN_RELEASE_COMPILE_DEFS}>
)


if(SERIALIZATION_INCLUDED)
	MESSAGE("Serialization included")
	SET(BLASTUNITTESTS_PLATFORM_LINKED_LIBS
		NvBlastExtSerialization
        $<$<OR:$<CONFIG:debug>,$<CONFIG:checked>,$<CONFIG:profile>>:${NVTOOLSEXT_LIB}>
	)
else()
	MESSAGE("Serialization NOT NOT NOT included")
	SET(BLASTUNITTESTS_PLATFORM_LINKED_LIBS
        $<$<OR:$<CONFIG:debug>,$<CONFIG:checked>,$<CONFIG:profile>>:${NVTOOLSEXT_LIB}>
	)
endif()

