/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.serviceapi.ITransformerDiscoveryService;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.ImmediateWindowHandler;
import org.slf4j.Logger;

public class ModDirTransformerDiscoverer
implements ITransformerDiscoveryService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> SERVICES = Set.of("cpw.mods.modlauncher.api.ITransformationService", "net.minecraftforge.forgespi.locating.IModLocator", "net.minecraftforge.forgespi.locating.IDependencyLocator");
    private static final List<NamedPath> found = new ArrayList<NamedPath>();

    public List<NamedPath> candidates(Path gameDirectory, String launchTarget) {
        FMLPaths.loadAbsolutePaths(gameDirectory);
        FMLConfig.load();
        return this.candidates(gameDirectory);
    }

    public void earlyInitialization(String launchTarget, String[] arguments) {
        ImmediateWindowHandler.load(launchTarget, arguments);
    }

    public List<NamedPath> candidates(Path gameDirectory) {
        ModDirTransformerDiscoverer.scan(gameDirectory);
        return List.copyOf(found);
    }

    public static List<Path> allExcluded() {
        return found.stream().map(np -> np.paths()[0]).toList();
    }

    private static void scan(Path gameDirectory) {
        Path modsDir = gameDirectory.resolve(FMLPaths.MODSDIR.relative()).toAbsolutePath().normalize();
        if (!Files.exists(modsDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> walk = Files.walk(modsDir, 1, new FileVisitOption[0]);){
            walk.forEach(ModDirTransformerDiscoverer::visitFile);
        }
        catch (IOException | IllegalStateException ioe) {
            LOGGER.error("Error during early discovery", (Throwable)ioe);
        }
    }

    private static void visitFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return;
        }
        if (!path.toString().endsWith(".jar")) {
            return;
        }
        if ((Long)LamdbaExceptionUtils.uncheck(() -> Files.size(path)) == 0L) {
            return;
        }
        SecureJar jar = SecureJar.from((Path[])new Path[]{path});
        jar.moduleDataProvider().descriptor().provides().stream().map(ModuleDescriptor.Provides::service).filter(SERVICES::contains).forEach(s -> found.add(new NamedPath(s, new Path[]{path})));
    }
}

