/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;

@OnlyIn(value=Dist.CLIENT)
public abstract class EffectRenderingInventoryScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public EffectRenderingInventoryScreen(T p_98701_, Inventory p_98702_, Component p_98703_) {
        super(p_98701_, p_98702_, p_98703_);
    }

    @Override
    public void m_88315_(GuiGraphics p_283027_, int p_281444_, int p_282953_, float p_281666_) {
        super.m_88315_(p_283027_, p_281444_, p_282953_, p_281666_);
        this.m_280113_(p_283027_, p_281444_, p_282953_);
    }

    public boolean m_194018_() {
        int i = this.f_97735_ + this.f_97726_ + 2;
        int j = this.f_96543_ - i;
        return j >= 32;
    }

    private void m_280113_(GuiGraphics p_281945_, int p_282601_, int p_282335_) {
        int i = this.f_97735_ + this.f_97726_ + 2;
        int j = this.f_96543_ - i;
        Collection<MobEffectInstance> collection = this.f_96541_.f_91074_.m_21220_();
        if (!collection.isEmpty() && j >= 32) {
            boolean flag = j >= 120;
            ScreenEvent.RenderInventoryMobEffects event = ForgeHooksClient.onScreenPotionSize((Screen)this, (int)j, (!flag ? 1 : 0) != 0, (int)i);
            if (event.isCanceled()) {
                return;
            }
            flag = !event.isCompact();
            i = event.getHorizontalOffset();
            int k = 33;
            if (collection.size() > 5) {
                k = 132 / (collection.size() - 1);
            }
            Iterable iterable = collection.stream().filter(ForgeHooksClient::shouldRenderEffect).sorted().collect(Collectors.toList());
            this.m_280172_(p_281945_, i, k, iterable, flag);
            this.m_280301_(p_281945_, i, k, iterable, flag);
            if (flag) {
                this.m_280417_(p_281945_, i, k, iterable);
            } else if (p_282601_ >= i && p_282601_ <= i + 33) {
                int l = this.f_97736_;
                MobEffectInstance mobeffectinstance = null;
                for (MobEffectInstance mobeffectinstance1 : iterable) {
                    if (p_282335_ >= l && p_282335_ <= l + k) {
                        mobeffectinstance = mobeffectinstance1;
                    }
                    l += k;
                }
                if (mobeffectinstance != null) {
                    List<Component> list = List.of(this.m_194000_(mobeffectinstance), MobEffectUtil.m_267641_(mobeffectinstance, 1.0f));
                    p_281945_.m_280677_(this.f_96547_, list, Optional.empty(), p_282601_, p_282335_);
                }
            }
        }
    }

    private void m_280172_(GuiGraphics p_281540_, int p_282479_, int p_283680_, Iterable<MobEffectInstance> p_282013_, boolean p_283630_) {
        int i = this.f_97736_;
        for (MobEffectInstance mobeffectinstance : p_282013_) {
            if (p_283630_) {
                p_281540_.m_280218_(f_97725_, p_282479_, i, 0, 166, 120, 32);
            } else {
                p_281540_.m_280218_(f_97725_, p_282479_, i, 0, 198, 32, 32);
            }
            i += p_283680_;
        }
    }

    private void m_280301_(GuiGraphics p_282745_, int p_282521_, int p_282291_, Iterable<MobEffectInstance> p_282642_, boolean p_281536_) {
        MobEffectTextureManager mobeffecttexturemanager = this.f_96541_.m_91306_();
        int i = this.f_97736_;
        for (MobEffectInstance mobeffectinstance : p_282642_) {
            IClientMobEffectExtensions renderer = IClientMobEffectExtensions.of((MobEffectInstance)mobeffectinstance);
            if (renderer.renderInventoryIcon(mobeffectinstance, this, p_282745_, p_282521_ + (p_281536_ ? 6 : 7), i, 0)) {
                i += p_282291_;
                continue;
            }
            MobEffect mobeffect = mobeffectinstance.m_19544_();
            TextureAtlasSprite textureatlassprite = mobeffecttexturemanager.m_118732_(mobeffect);
            p_282745_.m_280159_(p_282521_ + (p_281536_ ? 6 : 7), i + 7, 0, 18, 18, textureatlassprite);
            i += p_282291_;
        }
    }

    private void m_280417_(GuiGraphics p_281462_, int p_283484_, int p_282057_, Iterable<MobEffectInstance> p_281986_) {
        int i = this.f_97736_;
        for (MobEffectInstance mobeffectinstance : p_281986_) {
            IClientMobEffectExtensions renderer = IClientMobEffectExtensions.of((MobEffectInstance)mobeffectinstance);
            if (renderer.renderInventoryText(mobeffectinstance, this, p_281462_, p_283484_, i, 0)) {
                i += p_282057_;
                continue;
            }
            Component component = this.m_194000_(mobeffectinstance);
            p_281462_.m_280430_(this.f_96547_, component, p_283484_ + 10 + 18, i + 6, 0xFFFFFF);
            Component component1 = MobEffectUtil.m_267641_(mobeffectinstance, 1.0f);
            p_281462_.m_280430_(this.f_96547_, component1, p_283484_ + 10 + 18, i + 6 + 10, 0x7F7F7F);
            i += p_282057_;
        }
    }

    private Component m_194000_(MobEffectInstance p_194001_) {
        MutableComponent mutablecomponent = p_194001_.m_19544_().m_19482_().m_6881_();
        if (p_194001_.m_19564_() >= 1 && p_194001_.m_19564_() <= 9) {
            mutablecomponent.m_7220_(CommonComponents.f_263701_).m_7220_(Component.m_237115_("enchantment.level." + (p_194001_.m_19564_() + 1)));
        }
        return mutablecomponent;
    }
}

