/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.packs;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.TransferableSelectionList;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PackSelectionScreen
extends Screen {
    static final Logger f_99969_ = LogUtils.getLogger();
    private static final int f_169993_ = 200;
    private static final Component f_99970_ = Component.m_237115_("pack.dropInfo").m_130940_(ChatFormatting.GRAY);
    private static final Component f_99971_ = Component.m_237115_("pack.folderInfo");
    private static final int f_169994_ = 20;
    private static final ResourceLocation f_99972_ = new ResourceLocation("textures/misc/unknown_pack.png");
    private final PackSelectionModel f_99973_;
    @Nullable
    private Watcher f_99975_;
    private long f_99976_;
    private TransferableSelectionList f_99977_;
    private TransferableSelectionList f_99978_;
    private final Path f_99979_;
    private Button f_99980_;
    private final Map<String, ResourceLocation> f_99981_ = Maps.newHashMap();

    public PackSelectionScreen(PackRepository p_275398_, Consumer<PackRepository> p_275659_, Path p_275522_, Component p_275337_) {
        super(p_275337_);
        this.f_99973_ = new PackSelectionModel(this::m_100040_, this::m_99989_, p_275398_, p_275659_);
        this.f_99979_ = p_275522_;
        this.f_99975_ = Watcher.m_245748_(p_275522_);
    }

    @Override
    public void m_7379_() {
        this.f_99973_.m_99923_();
        this.m_100039_();
    }

    private void m_100039_() {
        if (this.f_99975_ != null) {
            try {
                this.f_99975_.close();
                this.f_99975_ = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void m_7856_() {
        this.f_99977_ = new TransferableSelectionList(this.f_96541_, this, 200, this.f_96544_, Component.m_237115_("pack.available.title"));
        this.f_99977_.m_93507_(this.f_96543_ / 2 - 4 - 200);
        this.m_7787_(this.f_99977_);
        this.f_99978_ = new TransferableSelectionList(this.f_96541_, this, 200, this.f_96544_, Component.m_237115_("pack.selected.title"));
        this.f_99978_.m_93507_(this.f_96543_ / 2 + 4);
        this.m_7787_(this.f_99978_);
        this.m_142416_(Button.m_253074_(Component.m_237115_("pack.openFolder"), p_100004_ -> Util.m_137581_().m_137648_(this.f_99979_.toUri())).m_252987_(this.f_96543_ / 2 - 154, this.f_96544_ - 48, 150, 20).m_257505_(Tooltip.m_257550_(f_99971_)).m_253136_());
        this.f_99980_ = this.m_142416_(Button.m_253074_(CommonComponents.f_130655_, p_100036_ -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ - 48, 150, 20).m_253136_());
        this.m_100041_();
    }

    @Override
    public void m_86600_() {
        if (this.f_99975_ != null) {
            try {
                if (this.f_99975_.m_100046_()) {
                    this.f_99976_ = 20L;
                }
            }
            catch (IOException ioexception) {
                f_99969_.warn("Failed to poll for directory {} changes, stopping", (Object)this.f_99979_);
                this.m_100039_();
            }
        }
        if (this.f_99976_ > 0L && --this.f_99976_ == 0L) {
            this.m_100041_();
        }
    }

    private void m_100040_() {
        this.m_100013_(this.f_99978_, this.f_99973_.m_99918_());
        this.m_100013_(this.f_99977_, this.f_99973_.m_99913_());
        this.f_99980_.f_93623_ = !this.f_99978_.m_6702_().isEmpty();
    }

    private void m_100013_(TransferableSelectionList p_100014_, Stream<PackSelectionModel.Entry> p_100015_) {
        p_100014_.m_6702_().clear();
        TransferableSelectionList.PackEntry transferableselectionlist$packentry = (TransferableSelectionList.PackEntry)p_100014_.m_93511_();
        String s = transferableselectionlist$packentry == null ? "" : transferableselectionlist$packentry.m_264411_();
        p_100014_.m_6987_(null);
        p_100015_.filter(PackSelectionModel.Entry::notHidden).forEach(p_280875_ -> {
            TransferableSelectionList.PackEntry transferableselectionlist$packentry1 = new TransferableSelectionList.PackEntry(this.f_96541_, p_100014_, (PackSelectionModel.Entry)p_280875_);
            p_100014_.m_6702_().add(transferableselectionlist$packentry1);
            if (p_280875_.m_264249_().equals(s)) {
                p_100014_.m_6987_(transferableselectionlist$packentry1);
            }
        });
    }

    public void m_264285_(TransferableSelectionList p_265419_) {
        TransferableSelectionList transferableselectionlist = this.f_99978_ == p_265419_ ? this.f_99977_ : this.f_99978_;
        this.m_264158_(ComponentPath.m_264492_(transferableselectionlist.m_264567_(), new ContainerEventHandler[]{transferableselectionlist, this}));
    }

    public void m_264462_() {
        this.f_99978_.m_6987_(null);
        this.f_99977_.m_6987_(null);
    }

    private void m_100041_() {
        this.f_99973_.m_99926_();
        this.m_100040_();
        this.f_99976_ = 0L;
        this.f_99981_.clear();
    }

    @Override
    public void m_88315_(GuiGraphics p_281318_, int p_99996_, int p_99997_, float p_99998_) {
        this.m_280039_(p_281318_);
        this.f_99977_.m_88315_(p_281318_, p_99996_, p_99997_, p_99998_);
        this.f_99978_.m_88315_(p_281318_, p_99996_, p_99997_, p_99998_);
        p_281318_.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        p_281318_.m_280653_(this.f_96547_, f_99970_, this.f_96543_ / 2, 20, 0xFFFFFF);
        super.m_88315_(p_281318_, p_99996_, p_99997_, p_99998_);
    }

    protected static void m_99999_(Minecraft p_100000_, List<Path> p_100001_, Path p_100002_) {
        MutableBoolean mutableboolean = new MutableBoolean();
        p_100001_.forEach(p_170009_ -> {
            try (Stream<Path> stream = Files.walk(p_170009_, new FileVisitOption[0]);){
                stream.forEach(p_170005_ -> {
                    try {
                        Util.m_137563_(p_170009_.getParent(), p_100002_, p_170005_);
                    }
                    catch (IOException ioexception1) {
                        f_99969_.warn("Failed to copy datapack file  from {} to {}", new Object[]{p_170005_, p_100002_, ioexception1});
                        mutableboolean.setTrue();
                    }
                });
            }
            catch (IOException ioexception) {
                f_99969_.warn("Failed to copy datapack file from {} to {}", p_170009_, (Object)p_100002_);
                mutableboolean.setTrue();
            }
        });
        if (mutableboolean.isTrue()) {
            SystemToast.m_94875_(p_100000_, p_100002_.toString());
        }
    }

    @Override
    public void m_7400_(List<Path> p_100029_) {
        String s = p_100029_.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.f_96541_.m_91152_(new ConfirmScreen(p_280877_ -> {
            if (p_280877_) {
                PackSelectionScreen.m_99999_(this.f_96541_, p_100029_, this.f_99979_);
                this.m_100041_();
            }
            this.f_96541_.m_91152_(this);
        }, Component.m_237115_("pack.dropConfirm"), Component.m_237113_(s)));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ResourceLocation m_100016_(TextureManager p_100017_, Pack p_100018_) {
        try (PackResources packresources = p_100018_.m_10445_();){
            ResourceLocation resourceLocation;
            block16: {
                IoSupplier<InputStream> iosupplier = packresources.m_8017_("pack.png");
                if (iosupplier == null) {
                    ResourceLocation resourceLocation2 = f_99972_;
                    return resourceLocation2;
                }
                String s = p_100018_.m_10446_();
                ResourceLocation resourcelocation = new ResourceLocation("minecraft", "pack/" + Util.m_137483_(s, ResourceLocation::m_135828_) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)s) + "/icon");
                InputStream inputstream = iosupplier.m_247737_();
                try {
                    NativeImage nativeimage = NativeImage.m_85058_(inputstream);
                    p_100017_.m_118495_(resourcelocation, new DynamicTexture(nativeimage));
                    resourceLocation = resourcelocation;
                    if (inputstream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputstream.close();
            }
            return resourceLocation;
        }
        catch (Exception exception) {
            f_99969_.warn("Failed to load icon from pack {}", (Object)p_100018_.m_10446_(), (Object)exception);
            return f_99972_;
        }
    }

    private ResourceLocation m_99989_(Pack p_99990_) {
        return this.f_99981_.computeIfAbsent(p_99990_.m_10446_(), p_280879_ -> this.m_100016_(this.f_96541_.m_91097_(), p_99990_));
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Watcher
    implements AutoCloseable {
        private final WatchService f_100042_;
        private final Path f_100043_;

        public Watcher(Path p_250327_) throws IOException {
            this.f_100043_ = p_250327_;
            this.f_100042_ = p_250327_.getFileSystem().newWatchService();
            try {
                this.m_100049_(p_250327_);
                try (DirectoryStream<Path> directorystream = Files.newDirectoryStream(p_250327_);){
                    for (Path path : directorystream) {
                        if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) continue;
                        this.m_100049_(path);
                    }
                }
            }
            catch (Exception exception) {
                this.f_100042_.close();
                throw exception;
            }
        }

        @Nullable
        public static Watcher m_245748_(Path p_252119_) {
            try {
                return new Watcher(p_252119_);
            }
            catch (IOException ioexception) {
                f_99969_.warn("Failed to initialize pack directory {} monitoring", (Object)p_252119_, (Object)ioexception);
                return null;
            }
        }

        private void m_100049_(Path p_100050_) throws IOException {
            p_100050_.register(this.f_100042_, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }

        public boolean m_100046_() throws IOException {
            WatchKey watchkey;
            boolean flag = false;
            while ((watchkey = this.f_100042_.poll()) != null) {
                for (WatchEvent<?> watchevent : watchkey.pollEvents()) {
                    Path path;
                    flag = true;
                    if (watchkey.watchable() != this.f_100043_ || watchevent.kind() != StandardWatchEventKinds.ENTRY_CREATE || !Files.isDirectory(path = this.f_100043_.resolve((Path)watchevent.context()), LinkOption.NOFOLLOW_LINKS)) continue;
                    this.m_100049_(path);
                }
                watchkey.reset();
            }
            return flag;
        }

        @Override
        public void close() throws IOException {
            this.f_100042_.close();
        }
    }
}

