/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.main;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.client.telemetry.TelemetryProperty;
import net.minecraft.client.telemetry.events.GameLoadTimesEvent;
import net.minecraft.core.UUIDUtil;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.BackgroundWaiter;
import net.minecraftforge.fml.loading.FMLLoader;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Main {
    static final Logger f_129630_ = LogUtils.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DontObfuscate
    public static void main(String[] p_129642_) {
        Thread thread1;
        Minecraft minecraft;
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Ticker.systemTicker());
        Stopwatch stopwatch1 = Stopwatch.createStarted((Ticker)Ticker.systemTicker());
        GameLoadTimesEvent.f_285635_.m_285977_(TelemetryProperty.f_285605_, stopwatch);
        GameLoadTimesEvent.f_285635_.m_285977_(TelemetryProperty.f_285649_, stopwatch1);
        SharedConstants.m_142977_();
        SharedConstants.m_214358_();
        OptionParser optionparser = new OptionParser();
        optionparser.allowsUnrecognizedOptions();
        optionparser.accepts("demo");
        optionparser.accepts("disableMultiplayer");
        optionparser.accepts("disableChat");
        optionparser.accepts("fullscreen");
        optionparser.accepts("checkGlErrors");
        OptionSpecBuilder optionspec = optionparser.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec optionspec1 = optionparser.accepts("quickPlayPath").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec2 = optionparser.accepts("quickPlaySingleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec3 = optionparser.accepts("quickPlayMultiplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec4 = optionparser.accepts("quickPlayRealms").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec5 = optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec optionspec6 = optionparser.accepts("assetsDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionspec7 = optionparser.accepts("resourcePackDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionspec8 = optionparser.accepts("proxyHost").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec9 = optionparser.accepts("proxyPort").withRequiredArg().defaultsTo((Object)"8080", (Object[])new String[0]).ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec10 = optionparser.accepts("proxyUser").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec11 = optionparser.accepts("proxyPass").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec12 = optionparser.accepts("username").withRequiredArg().defaultsTo((Object)("Player" + Util.m_137550_() % 1000L), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec13 = optionparser.accepts("uuid").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec14 = optionparser.accepts("xuid").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec15 = optionparser.accepts("clientId").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec16 = optionparser.accepts("accessToken").withRequiredArg().required();
        ArgumentAcceptingOptionSpec optionspec17 = optionparser.accepts("version").withRequiredArg().required();
        ArgumentAcceptingOptionSpec optionspec18 = optionparser.accepts("width").withRequiredArg().ofType(Integer.class).defaultsTo((Object)854, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec19 = optionparser.accepts("height").withRequiredArg().ofType(Integer.class).defaultsTo((Object)480, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec20 = optionparser.accepts("fullscreenWidth").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec21 = optionparser.accepts("fullscreenHeight").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec22 = optionparser.accepts("userProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec23 = optionparser.accepts("profileProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec24 = optionparser.accepts("assetIndex").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec25 = optionparser.accepts("userType").withRequiredArg().defaultsTo((Object)User.Type.LEGACY.m_193808_(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec26 = optionparser.accepts("versionType").withRequiredArg().defaultsTo((Object)"release", (Object[])new String[0]);
        NonOptionArgumentSpec optionspec27 = optionparser.nonOptions();
        OptionSet optionset = optionparser.parse(p_129642_);
        List list = optionset.valuesOf((OptionSpec)optionspec27);
        if (!list.isEmpty()) {
            System.out.println("Completely ignored arguments: " + list);
        }
        String s = (String)Main.m_129638_(optionset, optionspec8);
        Proxy proxy = Proxy.NO_PROXY;
        if (s != null) {
            try {
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(s, (int)((Integer)Main.m_129638_(optionset, optionspec9))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        final String s1 = (String)Main.m_129638_(optionset, optionspec10);
        final String s2 = (String)Main.m_129638_(optionset, optionspec11);
        if (!proxy.equals(Proxy.NO_PROXY) && Main.m_129636_(s1) && Main.m_129636_(s2)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(s1, s2.toCharArray());
                }
            });
        }
        int i = (Integer)Main.m_129638_(optionset, optionspec18);
        int j = (Integer)Main.m_129638_(optionset, optionspec19);
        OptionalInt optionalint = Main.m_129634_((Integer)Main.m_129638_(optionset, optionspec20));
        OptionalInt optionalint1 = Main.m_129634_((Integer)Main.m_129638_(optionset, optionspec21));
        boolean flag = optionset.has("fullscreen");
        boolean flag1 = optionset.has("demo");
        boolean flag2 = optionset.has("disableMultiplayer");
        boolean flag3 = optionset.has("disableChat");
        String s3 = (String)Main.m_129638_(optionset, optionspec17);
        Gson gson = new GsonBuilder().registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).create();
        PropertyMap propertymap = GsonHelper.m_13794_(gson, (String)Main.m_129638_(optionset, optionspec22), PropertyMap.class);
        PropertyMap propertymap1 = GsonHelper.m_13794_(gson, (String)Main.m_129638_(optionset, optionspec23), PropertyMap.class);
        String s4 = (String)Main.m_129638_(optionset, optionspec26);
        File file1 = (File)Main.m_129638_(optionset, optionspec5);
        File file2 = optionset.has((OptionSpec)optionspec6) ? (File)Main.m_129638_(optionset, optionspec6) : new File(file1, "assets/");
        File file3 = optionset.has((OptionSpec)optionspec7) ? (File)Main.m_129638_(optionset, optionspec7) : new File(file1, "resourcepacks/");
        String s5 = optionset.has((OptionSpec)optionspec13) ? (String)optionspec13.value(optionset) : UUIDUtil.m_235879_((String)optionspec12.value(optionset)).toString();
        String s6 = optionset.has((OptionSpec)optionspec24) ? (String)optionspec24.value(optionset) : null;
        String s7 = (String)optionset.valueOf((OptionSpec)optionspec14);
        String s8 = (String)optionset.valueOf((OptionSpec)optionspec15);
        String s9 = (String)Main.m_129638_(optionset, optionspec1);
        String s10 = (String)Main.m_129638_(optionset, optionspec2);
        String s11 = (String)Main.m_129638_(optionset, optionspec3);
        String s12 = (String)Main.m_129638_(optionset, optionspec4);
        if (optionset.has((OptionSpec)optionspec)) {
            JvmProfiler.f_185340_.m_183425_(Environment.CLIENT);
        }
        CrashReport.m_127529_();
        GameLoadTimesEvent.f_285635_.m_286069_(Bootstrap.f_285608_.get());
        BackgroundWaiter.runAndTick(() -> Bootstrap.m_135870_(), (Runnable)FMLLoader.progressWindowTick);
        Bootstrap.m_135889_();
        Util.m_137584_();
        String s13 = (String)optionspec25.value(optionset);
        User.Type user$type = User.Type.m_92561_(s13);
        if (user$type == null) {
            f_129630_.warn("Unrecognized user type: {}", (Object)s13);
        }
        User user = new User((String)optionspec12.value(optionset), s5, (String)optionspec16.value(optionset), Main.m_195486_(s7), Main.m_195486_(s8), user$type);
        GameConfig gameconfig = new GameConfig(new GameConfig.UserData(user, propertymap, propertymap1, proxy), new DisplayData(i, j, optionalint, optionalint1, flag), new GameConfig.FolderData(file1, file3, file2, s6), new GameConfig.GameData(flag1, s3, s4, flag2, flag3), new GameConfig.QuickPlayData(s9, s10, s11, s12));
        Thread thread = new Thread("Client Shutdown Thread"){

            @Override
            public void run() {
                IntegratedServer integratedserver;
                Minecraft minecraft1 = Minecraft.m_91087_();
                if (minecraft1 != null && (integratedserver = minecraft1.m_91092_()) != null) {
                    integratedserver.m_7570_(true);
                }
            }
        };
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(f_129630_));
        Runtime.getRuntime().addShutdownHook(thread);
        try {
            Thread.currentThread().setName("Render thread");
            RenderSystem.initRenderThread();
            RenderSystem.beginInitialization();
            minecraft = new Minecraft(gameconfig);
            RenderSystem.finishInitialization();
        }
        catch (SilentInitException silentinitexception) {
            f_129630_.warn("Failed to create window: ", (Throwable)silentinitexception);
            return;
        }
        catch (Throwable throwable1) {
            CrashReport crashreport = CrashReport.m_127521_(throwable1, "Initializing game");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Initialization");
            NativeModuleLister.m_184679_(crashreportcategory);
            Minecraft.m_167872_(null, null, gameconfig.f_101908_.f_101927_, null, crashreport);
            Minecraft.m_91332_(crashreport);
            return;
        }
        if (minecraft.m_91267_()) {
            thread1 = new Thread("Game thread"){

                @Override
                public void run() {
                    try {
                        RenderSystem.initGameThread(true);
                        minecraft.m_91374_();
                    }
                    catch (Throwable throwable2) {
                        f_129630_.error("Exception in client thread", throwable2);
                    }
                }
            };
            thread1.start();
            while (minecraft.m_91396_()) {
            }
        } else {
            thread1 = null;
            try {
                RenderSystem.initGameThread(false);
                minecraft.m_91374_();
            }
            catch (Throwable throwable) {
                f_129630_.error("Unhandled game exception", throwable);
            }
        }
        BufferUploader.m_166835_();
        try {
            minecraft.m_91395_();
            if (thread1 != null) {
                thread1.join();
            }
        }
        catch (InterruptedException interruptedexception) {
            f_129630_.error("Exception during client thread shutdown", (Throwable)interruptedexception);
        }
        finally {
            minecraft.m_91393_();
        }
    }

    private static Optional<String> m_195486_(String p_195487_) {
        return p_195487_.isEmpty() ? Optional.empty() : Optional.of(p_195487_);
    }

    private static OptionalInt m_129634_(@Nullable Integer p_129635_) {
        return p_129635_ != null ? OptionalInt.of(p_129635_) : OptionalInt.empty();
    }

    @Nullable
    private static <T> T m_129638_(OptionSet p_129639_, OptionSpec<T> p_129640_) {
        try {
            return (T)p_129639_.valueOf(p_129640_);
        }
        catch (Throwable throwable) {
            ArgumentAcceptingOptionSpec argumentacceptingoptionspec;
            List list;
            if (p_129640_ instanceof ArgumentAcceptingOptionSpec && !(list = (argumentacceptingoptionspec = (ArgumentAcceptingOptionSpec)p_129640_).defaultValues()).isEmpty()) {
                return (T)list.get(0);
            }
            throw throwable;
        }
    }

    private static boolean m_129636_(@Nullable String p_129637_) {
        return p_129637_ != null && !p_129637_.isEmpty();
    }

    static {
        System.setProperty("java.awt.headless", "true");
    }
}

