/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignedMessageValidator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.GameType;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class PlayerInfo {
    private final GameProfile f_105298_;
    private final Map<MinecraftProfileTexture.Type, ResourceLocation> f_105299_ = Maps.newEnumMap(MinecraftProfileTexture.Type.class);
    private GameType f_105300_ = GameType.f_151492_;
    private int f_105301_;
    private boolean f_105302_;
    @Nullable
    private String f_105303_;
    @Nullable
    private Component f_105304_;
    @Nullable
    private RemoteChatSession f_244238_;
    private SignedMessageValidator f_240895_;

    public PlayerInfo(GameProfile p_253609_, boolean p_254409_) {
        this.f_105298_ = p_253609_;
        this.f_240895_ = PlayerInfo.m_253000_(p_254409_);
    }

    public GameProfile m_105312_() {
        return this.f_105298_;
    }

    @Nullable
    public RemoteChatSession m_247593_() {
        return this.f_244238_;
    }

    public SignedMessageValidator m_241043_() {
        return this.f_240895_;
    }

    public boolean m_247101_() {
        return this.f_244238_ != null;
    }

    protected void m_246479_(RemoteChatSession p_249599_) {
        this.f_244238_ = p_249599_;
        this.f_240895_ = p_249599_.m_245949_();
    }

    protected void m_253204_(boolean p_254536_) {
        this.f_244238_ = null;
        this.f_240895_ = PlayerInfo.m_253000_(p_254536_);
    }

    private static SignedMessageValidator m_253000_(boolean p_254311_) {
        return p_254311_ ? SignedMessageValidator.f_243754_ : SignedMessageValidator.f_244130_;
    }

    public GameType m_105325_() {
        return this.f_105300_;
    }

    protected void m_105317_(GameType p_105318_) {
        ForgeHooksClient.onClientChangeGameType((PlayerInfo)this, (GameType)this.f_105300_, (GameType)p_105318_);
        this.f_105300_ = p_105318_;
    }

    public int m_105330_() {
        return this.f_105301_;
    }

    protected void m_105313_(int p_105314_) {
        this.f_105301_ = p_105314_;
    }

    public boolean m_171808_() {
        return this.m_105338_() != null;
    }

    public boolean m_105335_() {
        return this.m_105337_() != null;
    }

    public String m_105336_() {
        return this.f_105303_ == null ? DefaultPlayerSkin.m_118629_(this.f_105298_.getId()) : this.f_105303_;
    }

    public ResourceLocation m_105337_() {
        this.m_105341_();
        return (ResourceLocation)MoreObjects.firstNonNull((Object)this.f_105299_.get(MinecraftProfileTexture.Type.SKIN), (Object)DefaultPlayerSkin.m_118627_(this.f_105298_.getId()));
    }

    @Nullable
    public ResourceLocation m_105338_() {
        this.m_105341_();
        return this.f_105299_.get(MinecraftProfileTexture.Type.CAPE);
    }

    @Nullable
    public ResourceLocation m_105339_() {
        this.m_105341_();
        return this.f_105299_.get(MinecraftProfileTexture.Type.ELYTRA);
    }

    @Nullable
    public PlayerTeam m_105340_() {
        return Minecraft.m_91087_().f_91073_.m_6188_().m_83500_(this.m_105312_().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void m_105341_() {
        PlayerInfo playerInfo = this;
        synchronized (playerInfo) {
            if (!this.f_105302_) {
                this.f_105302_ = true;
                Minecraft.m_91087_().m_91109_().m_118817_(this.f_105298_, (p_105320_, p_105321_, p_105322_) -> {
                    this.f_105299_.put(p_105320_, p_105321_);
                    if (p_105320_ == MinecraftProfileTexture.Type.SKIN) {
                        this.f_105303_ = p_105322_.getMetadata("model");
                        if (this.f_105303_ == null) {
                            this.f_105303_ = "default";
                        }
                    }
                }, true);
            }
        }
    }

    public void m_105323_(@Nullable Component p_105324_) {
        this.f_105304_ = p_105324_;
    }

    @Nullable
    public Component m_105342_() {
        return this.f_105304_;
    }
}

