/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Type;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.TransformationHelper;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class ItemTransform {
    public static final ItemTransform f_111754_ = new ItemTransform(new Vector3f(), new Vector3f(), new Vector3f(1.0f, 1.0f, 1.0f));
    public final Vector3f f_111755_;
    public final Vector3f f_111756_;
    public final Vector3f f_111757_;
    public final Vector3f rightRotation;

    public ItemTransform(Vector3f p_254427_, Vector3f p_254496_, Vector3f p_254022_) {
        this(p_254427_, p_254496_, p_254022_, new Vector3f());
    }

    public ItemTransform(Vector3f p_254427_, Vector3f p_254496_, Vector3f p_254022_, Vector3f rightRotation) {
        this.f_111755_ = new Vector3f((Vector3fc)p_254427_);
        this.f_111756_ = new Vector3f((Vector3fc)p_254496_);
        this.f_111757_ = new Vector3f((Vector3fc)p_254022_);
        this.rightRotation = new Vector3f((Vector3fc)rightRotation);
    }

    public void m_111763_(boolean p_111764_, PoseStack p_111765_) {
        if (this != f_111754_) {
            float f = this.f_111755_.x();
            float f1 = this.f_111755_.y();
            float f2 = this.f_111755_.z();
            if (p_111764_) {
                f1 = -f1;
                f2 = -f2;
            }
            int i = p_111764_ ? -1 : 1;
            p_111765_.m_252880_((float)i * this.f_111756_.x(), this.f_111756_.y(), this.f_111756_.z());
            p_111765_.m_252781_(new Quaternionf().rotationXYZ(f * ((float)Math.PI / 180), f1 * ((float)Math.PI / 180), f2 * ((float)Math.PI / 180)));
            p_111765_.m_85841_(this.f_111757_.x(), this.f_111757_.y(), this.f_111757_.z());
            p_111765_.m_252781_(TransformationHelper.quatFromXYZ((float)this.rightRotation.x(), (float)(this.rightRotation.y() * (float)(p_111764_ ? -1 : 1)), (float)(this.rightRotation.z() * (float)(p_111764_ ? -1 : 1)), (boolean)true));
        }
    }

    public boolean equals(Object p_111767_) {
        if (this == p_111767_) {
            return true;
        }
        if (this.getClass() != p_111767_.getClass()) {
            return false;
        }
        ItemTransform itemtransform = (ItemTransform)p_111767_;
        return this.f_111755_.equals((Object)itemtransform.f_111755_) && this.f_111757_.equals((Object)itemtransform.f_111757_) && this.f_111756_.equals((Object)itemtransform.f_111756_);
    }

    public int hashCode() {
        int i = this.f_111755_.hashCode();
        i = 31 * i + this.f_111756_.hashCode();
        return 31 * i + this.f_111757_.hashCode();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<ItemTransform> {
        public static final Vector3f f_111769_ = new Vector3f(0.0f, 0.0f, 0.0f);
        public static final Vector3f f_111770_ = new Vector3f(0.0f, 0.0f, 0.0f);
        public static final Vector3f f_111771_ = new Vector3f(1.0f, 1.0f, 1.0f);
        public static final float f_173492_ = 5.0f;
        public static final float f_173493_ = 4.0f;

        public ItemTransform deserialize(JsonElement p_111775_, Type p_111776_, JsonDeserializationContext p_111777_) throws JsonParseException {
            JsonObject jsonobject = p_111775_.getAsJsonObject();
            Vector3f vector3f = this.m_111778_(jsonobject, "rotation", f_111769_);
            Vector3f vector3f1 = this.m_111778_(jsonobject, "translation", f_111770_);
            vector3f1.mul(0.0625f);
            vector3f1.set(Mth.m_14036_(vector3f1.x, -5.0f, 5.0f), Mth.m_14036_(vector3f1.y, -5.0f, 5.0f), Mth.m_14036_(vector3f1.z, -5.0f, 5.0f));
            Vector3f vector3f2 = this.m_111778_(jsonobject, "scale", f_111771_);
            vector3f2.set(Mth.m_14036_(vector3f2.x, -4.0f, 4.0f), Mth.m_14036_(vector3f2.y, -4.0f, 4.0f), Mth.m_14036_(vector3f2.z, -4.0f, 4.0f));
            Vector3f rightRotation = this.m_111778_(jsonobject, "right_rotation", f_111769_);
            return new ItemTransform(vector3f, vector3f1, vector3f2, rightRotation);
        }

        private Vector3f m_111778_(JsonObject p_111779_, String p_111780_, Vector3f p_253777_) {
            if (!p_111779_.has(p_111780_)) {
                return p_253777_;
            }
            JsonArray jsonarray = GsonHelper.m_13933_(p_111779_, p_111780_);
            if (jsonarray.size() != 3) {
                throw new JsonParseException("Expected 3 " + p_111780_ + " values, found: " + jsonarray.size());
            }
            float[] afloat = new float[3];
            for (int i = 0; i < afloat.length; ++i) {
                afloat[i] = GsonHelper.m_13888_(jsonarray.get(i), p_111780_ + "[" + i + "]");
            }
            return new Vector3f(afloat[0], afloat[1], afloat[2]);
        }
    }
}

