/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class LivingEntityRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    private static final Logger f_115289_ = LogUtils.getLogger();
    private static final float f_174287_ = 0.1f;
    protected M f_115290_;
    protected final List<RenderLayer<T, M>> f_115291_ = Lists.newArrayList();

    public LivingEntityRenderer(EntityRendererProvider.Context p_174289_, M p_174290_, float p_174291_) {
        super(p_174289_);
        this.f_115290_ = p_174290_;
        this.f_114477_ = p_174291_;
    }

    public final boolean m_115326_(RenderLayer<T, M> p_115327_) {
        return this.f_115291_.add(p_115327_);
    }

    @Override
    public M m_7200_() {
        return this.f_115290_;
    }

    @Override
    public void m_7392_(T p_115308_, float p_115309_, float p_115310_, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_) {
        Direction direction;
        boolean shouldSit;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre(p_115308_, this, p_115310_, p_115311_, p_115312_, p_115313_))) {
            return;
        }
        p_115311_.m_85836_();
        ((EntityModel)this.f_115290_).f_102608_ = this.m_115342_(p_115308_, p_115310_);
        ((EntityModel)this.f_115290_).f_102609_ = shouldSit = ((Entity)p_115308_).m_20159_() && ((Entity)p_115308_).m_20202_() != null && ((Entity)p_115308_).m_20202_().shouldRiderSit();
        ((EntityModel)this.f_115290_).f_102610_ = ((LivingEntity)p_115308_).m_6162_();
        float f = Mth.m_14189_(p_115310_, ((LivingEntity)p_115308_).f_20884_, ((LivingEntity)p_115308_).f_20883_);
        float f1 = Mth.m_14189_(p_115310_, ((LivingEntity)p_115308_).f_20886_, ((LivingEntity)p_115308_).f_20885_);
        float f2 = f1 - f;
        if (shouldSit && ((Entity)p_115308_).m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)((Entity)p_115308_).m_20202_();
            f = Mth.m_14189_(p_115310_, livingentity.f_20884_, livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_(f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_(p_115310_, ((LivingEntity)p_115308_).f_19860_, ((Entity)p_115308_).m_146909_());
        if (LivingEntityRenderer.m_194453_(p_115308_)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        if (((Entity)p_115308_).m_217003_(Pose.SLEEPING) && (direction = ((LivingEntity)p_115308_).m_21259_()) != null) {
            float f4 = ((Entity)p_115308_).m_20236_(Pose.STANDING) - 0.1f;
            p_115311_.m_252880_((float)(-direction.m_122429_()) * f4, 0.0f, (float)(-direction.m_122431_()) * f4);
        }
        float f7 = this.m_6930_(p_115308_, p_115310_);
        this.m_7523_(p_115308_, p_115311_, f7, f, p_115310_);
        p_115311_.m_85841_(-1.0f, -1.0f, 1.0f);
        this.m_7546_(p_115308_, p_115311_, p_115310_);
        p_115311_.m_252880_(0.0f, -1.501f, 0.0f);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && ((LivingEntity)p_115308_).m_6084_()) {
            f8 = ((LivingEntity)p_115308_).f_267362_.m_267711_(p_115310_);
            f5 = ((LivingEntity)p_115308_).f_267362_.m_267590_(p_115310_);
            if (((LivingEntity)p_115308_).m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((EntityModel)this.f_115290_).m_6839_(p_115308_, f5, f8, p_115310_);
        ((EntityModel)this.f_115290_).m_6973_(p_115308_, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag = this.m_5933_(p_115308_);
        boolean flag1 = !flag && !((Entity)p_115308_).m_20177_(minecraft.f_91074_);
        boolean flag2 = minecraft.m_91314_((Entity)p_115308_);
        RenderType rendertype = this.m_7225_(p_115308_, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = p_115312_.m_6299_(rendertype);
            int i = LivingEntityRenderer.m_115338_(p_115308_, this.m_6931_(p_115308_, p_115310_));
            ((Model)this.f_115290_).m_7695_(p_115311_, vertexconsumer, p_115313_, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!((Entity)p_115308_).m_5833_()) {
            for (RenderLayer<T, M> renderlayer : this.f_115291_) {
                renderlayer.m_6494_(p_115311_, p_115312_, p_115313_, p_115308_, f5, f8, p_115310_, f7, f2, f6);
            }
        }
        p_115311_.m_85849_();
        super.m_7392_(p_115308_, p_115309_, p_115310_, p_115311_, p_115312_, p_115313_);
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(p_115308_, this, p_115310_, p_115311_, p_115312_, p_115313_));
    }

    @Nullable
    protected RenderType m_7225_(T p_115322_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation resourcelocation = this.m_5478_(p_115322_);
        if (p_115324_) {
            return RenderType.m_110467_(resourcelocation);
        }
        if (p_115323_) {
            return ((Model)this.f_115290_).m_103119_(resourcelocation);
        }
        return p_115325_ ? RenderType.m_110491_(resourcelocation) : null;
    }

    public static int m_115338_(LivingEntity p_115339_, float p_115340_) {
        return OverlayTexture.m_118093_(OverlayTexture.m_118088_(p_115340_), OverlayTexture.m_118096_(p_115339_.f_20916_ > 0 || p_115339_.f_20919_ > 0));
    }

    protected boolean m_5933_(T p_115341_) {
        return !((Entity)p_115341_).m_20145_();
    }

    private static float m_115328_(Direction p_115329_) {
        switch (p_115329_) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected boolean m_5936_(T p_115304_) {
        return ((Entity)p_115304_).m_146890_();
    }

    protected void m_7523_(T p_115317_, PoseStack p_115318_, float p_115319_, float p_115320_, float p_115321_) {
        if (this.m_5936_(p_115317_)) {
            p_115320_ += (float)(Math.cos((double)((LivingEntity)p_115317_).f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if (!((Entity)p_115317_).m_217003_(Pose.SLEEPING)) {
            p_115318_.m_252781_(Axis.f_252436_.m_252977_(180.0f - p_115320_));
        }
        if (((LivingEntity)p_115317_).f_20919_ > 0) {
            float f = ((float)((LivingEntity)p_115317_).f_20919_ + p_115321_ - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_(f)) > 1.0f) {
                f = 1.0f;
            }
            p_115318_.m_252781_(Axis.f_252403_.m_252977_(f * this.m_6441_(p_115317_)));
        } else if (((LivingEntity)p_115317_).m_21209_()) {
            p_115318_.m_252781_(Axis.f_252529_.m_252977_(-90.0f - ((Entity)p_115317_).m_146909_()));
            p_115318_.m_252781_(Axis.f_252436_.m_252977_(((float)((LivingEntity)p_115317_).f_19797_ + p_115321_) * -75.0f));
        } else if (((Entity)p_115317_).m_217003_(Pose.SLEEPING)) {
            Direction direction = ((LivingEntity)p_115317_).m_21259_();
            float f1 = direction != null ? LivingEntityRenderer.m_115328_(direction) : p_115320_;
            p_115318_.m_252781_(Axis.f_252436_.m_252977_(f1));
            p_115318_.m_252781_(Axis.f_252403_.m_252977_(this.m_6441_(p_115317_)));
            p_115318_.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        } else if (LivingEntityRenderer.m_194453_(p_115317_)) {
            p_115318_.m_252880_(0.0f, ((Entity)p_115317_).m_20206_() + 0.1f, 0.0f);
            p_115318_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    protected float m_115342_(T p_115343_, float p_115344_) {
        return ((LivingEntity)p_115343_).m_21324_(p_115344_);
    }

    protected float m_6930_(T p_115305_, float p_115306_) {
        return (float)((LivingEntity)p_115305_).f_19797_ + p_115306_;
    }

    protected float m_6441_(T p_115337_) {
        return 90.0f;
    }

    protected float m_6931_(T p_115334_, float p_115335_) {
        return 0.0f;
    }

    protected void m_7546_(T p_115314_, PoseStack p_115315_, float p_115316_) {
    }

    @Override
    protected boolean m_6512_(T p_115333_) {
        boolean flag;
        float f;
        double d0 = this.f_114476_.m_114471_((Entity)p_115333_);
        float f2 = f = ((Entity)p_115333_).m_20163_() ? 32.0f : 64.0f;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        boolean bl = flag = !((Entity)p_115333_).m_20177_(localplayer);
        if (p_115333_ != localplayer) {
            Team team = ((Entity)p_115333_).m_5647_();
            Team team1 = localplayer.m_5647_();
            if (team != null) {
                Team.Visibility team$visibility = team.m_7470_();
                switch (team$visibility) {
                    case ALWAYS: {
                        return flag;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? flag : team.m_83536_(team1) && (team.m_6259_() || flag);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? flag : !team.m_83536_(team1) && flag;
                    }
                }
                return true;
            }
        }
        return Minecraft.m_91404_() && p_115333_ != minecraft.m_91288_() && flag && !((Entity)p_115333_).m_20160_();
    }

    public static boolean m_194453_(LivingEntity p_194454_) {
        String s;
        if ((p_194454_ instanceof Player || p_194454_.m_8077_()) && ("Dinnerbone".equals(s = ChatFormatting.m_126649_(p_194454_.m_7755_().getString())) || "Grumm".equals(s))) {
            return !(p_194454_ instanceof Player) || ((Player)p_194454_).m_36170_(PlayerModelPart.CAPE);
        }
        return false;
    }
}

