/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.texture.MipmapGenerator;
import net.minecraft.client.renderer.texture.SpriteTicker;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.textures.ForgeTextureMetadata;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class SpriteContents
implements Stitcher.Entry,
AutoCloseable {
    private static final Logger f_243663_ = LogUtils.getLogger();
    private final ResourceLocation f_243877_;
    final int f_244302_;
    final int f_244600_;
    private final NativeImage f_243904_;
    public NativeImage[] f_243731_;
    @javax.annotation.Nullable
    final AnimatedTexture f_244575_;
    @javax.annotation.Nullable
    public final ForgeTextureMetadata forgeMeta;

    @Deprecated
    public SpriteContents(ResourceLocation p_249787_, FrameSize p_251031_, NativeImage p_252131_, AnimationMetadataSection p_250432_) {
        this(p_249787_, p_251031_, p_252131_, p_250432_, null);
    }

    public SpriteContents(ResourceLocation p_249787_, FrameSize p_251031_, NativeImage p_252131_, AnimationMetadataSection p_250432_, @Nullable ForgeTextureMetadata forgeMeta) {
        this.f_243877_ = p_249787_;
        this.f_244302_ = p_251031_.f_244129_();
        this.f_244600_ = p_251031_.f_244503_();
        this.f_244575_ = this.m_247391_(p_251031_, p_252131_.m_84982_(), p_252131_.m_85084_(), p_250432_);
        this.f_243904_ = p_252131_;
        this.f_243731_ = new NativeImage[]{this.f_243904_};
        this.forgeMeta = forgeMeta;
    }

    public NativeImage getOriginalImage() {
        return this.f_243904_;
    }

    public void m_246368_(int p_248864_) {
        try {
            this.f_243731_ = MipmapGenerator.m_246246_(this.f_243731_, p_248864_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, "Generating mipmaps for frame");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Sprite being mipmapped");
            crashreportcategory.m_128165_("First frame", () -> {
                StringBuilder stringbuilder = new StringBuilder();
                if (stringbuilder.length() > 0) {
                    stringbuilder.append(", ");
                }
                stringbuilder.append(this.f_243904_.m_84982_()).append("x").append(this.f_243904_.m_85084_());
                return stringbuilder.toString();
            });
            CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Frame being iterated");
            crashreportcategory1.m_128159_("Sprite name", this.f_243877_);
            crashreportcategory1.m_128165_("Sprite size", () -> this.f_244302_ + " x " + this.f_244600_);
            crashreportcategory1.m_128165_("Sprite frames", () -> this.m_245088_() + " frames");
            crashreportcategory1.m_128159_("Mipmap levels", p_248864_);
            throw new ReportedException(crashreport);
        }
    }

    int m_245088_() {
        return this.f_244575_ != null ? this.f_244575_.f_243714_.size() : 1;
    }

    @javax.annotation.Nullable
    private AnimatedTexture m_247391_(FrameSize p_250817_, int p_249792_, int p_252353_, AnimationMetadataSection p_250947_) {
        int i = p_249792_ / p_250817_.f_244129_();
        int j = p_252353_ / p_250817_.f_244503_();
        int k = i * j;
        ArrayList<FrameInfo> list = new ArrayList<FrameInfo>();
        p_250947_.m_174861_((p_251291_, p_251837_) -> list.add(new FrameInfo(p_251291_, p_251837_)));
        if (list.isEmpty()) {
            for (int l = 0; l < k; ++l) {
                list.add(new FrameInfo(l, p_250947_.m_119030_()));
            }
        } else {
            int i1 = 0;
            IntOpenHashSet intset = new IntOpenHashSet();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FrameInfo spritecontents$frameinfo = (FrameInfo)iterator.next();
                boolean flag = true;
                if (spritecontents$frameinfo.f_244553_ <= 0) {
                    f_243663_.warn("Invalid frame duration on sprite {} frame {}: {}", new Object[]{this.f_243877_, i1, spritecontents$frameinfo.f_244553_});
                    flag = false;
                }
                if (spritecontents$frameinfo.f_243751_ < 0 || spritecontents$frameinfo.f_243751_ >= k) {
                    f_243663_.warn("Invalid frame index on sprite {} frame {}: {}", new Object[]{this.f_243877_, i1, spritecontents$frameinfo.f_243751_});
                    flag = false;
                }
                if (flag) {
                    intset.add(spritecontents$frameinfo.f_243751_);
                } else {
                    iterator.remove();
                }
                ++i1;
            }
            int[] aint = IntStream.range(0, k).filter(arg_0 -> SpriteContents.m_247508_((IntSet)intset, arg_0)).toArray();
            if (aint.length > 0) {
                f_243663_.warn("Unused frames in sprite {}: {}", (Object)this.f_243877_, (Object)Arrays.toString(aint));
            }
        }
        return list.size() <= 1 ? null : new AnimatedTexture((List<FrameInfo>)ImmutableList.copyOf(list), i, p_250947_.m_119036_());
    }

    void m_247381_(int p_248895_, int p_250245_, int p_250458_, int p_251337_, NativeImage[] p_248825_) {
        for (int i = 0; i < this.f_243731_.length && this.f_244302_ >> i > 0 && this.f_244600_ >> i > 0; ++i) {
            p_248825_[i].m_85003_(i, p_248895_ >> i, p_250245_ >> i, p_250458_ >> i, p_251337_ >> i, this.f_244302_ >> i, this.f_244600_ >> i, this.f_243731_.length > 1, false);
        }
    }

    @Override
    public int m_246492_() {
        return this.f_244302_;
    }

    @Override
    public int m_245330_() {
        return this.f_244600_;
    }

    @Override
    public ResourceLocation m_246162_() {
        return this.f_243877_;
    }

    public IntStream m_245638_() {
        return this.f_244575_ != null ? this.f_244575_.m_246130_() : IntStream.of(1);
    }

    @javax.annotation.Nullable
    public SpriteTicker m_246786_() {
        return this.f_244575_ != null ? this.f_244575_.m_246690_() : null;
    }

    @Override
    public void close() {
        for (NativeImage nativeimage : this.f_243731_) {
            nativeimage.close();
        }
    }

    public String toString() {
        return "SpriteContents{name=" + this.f_243877_ + ", frameCount=" + this.m_245088_() + ", height=" + this.f_244600_ + ", width=" + this.f_244302_ + "}";
    }

    public boolean m_245970_(int p_250374_, int p_250934_, int p_249573_) {
        int i = p_250934_;
        int j = p_249573_;
        if (this.f_244575_ != null) {
            i = p_250934_ + this.f_244575_.m_245080_(p_250374_) * this.f_244302_;
            j = p_249573_ + this.f_244575_.m_246436_(p_250374_) * this.f_244600_;
        }
        return (this.f_243904_.m_84985_(i, j) >> 24 & 0xFF) == 0;
    }

    public void m_246850_(int p_252315_, int p_248634_) {
        if (this.f_244575_ != null) {
            this.f_244575_.m_247129_(p_252315_, p_248634_);
        } else {
            this.m_247381_(p_252315_, p_248634_, 0, 0, this.f_243731_);
        }
    }

    private static /* synthetic */ boolean m_247508_(IntSet p_251708_, int p_251185_) {
        return !p_251708_.contains(p_251185_);
    }

    @OnlyIn(value=Dist.CLIENT)
    class AnimatedTexture {
        final List<FrameInfo> f_243714_;
        private final int f_244229_;
        private final boolean f_244317_;

        AnimatedTexture(List<FrameInfo> p_250968_, int p_251686_, boolean p_251832_) {
            this.f_243714_ = p_250968_;
            this.f_244229_ = p_251686_;
            this.f_244317_ = p_251832_;
        }

        int m_245080_(int p_249475_) {
            return p_249475_ % this.f_244229_;
        }

        int m_246436_(int p_251327_) {
            return p_251327_ / this.f_244229_;
        }

        void m_245074_(int p_250449_, int p_248877_, int p_249060_) {
            int i = this.m_245080_(p_249060_) * SpriteContents.this.f_244302_;
            int j = this.m_246436_(p_249060_) * SpriteContents.this.f_244600_;
            SpriteContents.this.m_247381_(p_250449_, p_248877_, i, j, SpriteContents.this.f_243731_);
        }

        public SpriteTicker m_246690_() {
            SpriteContents spriteContents = SpriteContents.this;
            Objects.requireNonNull(spriteContents);
            return spriteContents.new Ticker(this, this.f_244317_ ? new InterpolationData() : null);
        }

        public void m_247129_(int p_251807_, int p_248676_) {
            this.m_245074_(p_251807_, p_248676_, this.f_243714_.get((int)0).f_243751_);
        }

        public IntStream m_246130_() {
            return this.f_243714_.stream().mapToInt(p_249981_ -> p_249981_.f_243751_).distinct();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FrameInfo {
        final int f_243751_;
        final int f_244553_;

        FrameInfo(int p_248909_, int p_250552_) {
            this.f_243751_ = p_248909_;
            this.f_244553_ = p_250552_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class Ticker
    implements SpriteTicker {
        int f_244631_;
        int f_244511_;
        final AnimatedTexture f_243921_;
        @javax.annotation.Nullable
        private final InterpolationData f_244570_;

        Ticker(@javax.annotation.Nullable AnimatedTexture p_249618_, InterpolationData p_251097_) {
            this.f_243921_ = p_249618_;
            this.f_244570_ = p_251097_;
        }

        @Override
        public void m_247697_(int p_249105_, int p_249676_) {
            ++this.f_244511_;
            FrameInfo spritecontents$frameinfo = this.f_243921_.f_243714_.get(this.f_244631_);
            if (this.f_244511_ >= spritecontents$frameinfo.f_244553_) {
                int i = spritecontents$frameinfo.f_243751_;
                this.f_244631_ = (this.f_244631_ + 1) % this.f_243921_.f_243714_.size();
                this.f_244511_ = 0;
                int j = this.f_243921_.f_243714_.get((int)this.f_244631_).f_243751_;
                if (i != j) {
                    this.f_243921_.m_245074_(p_249105_, p_249676_, j);
                }
            } else if (this.f_244570_ != null) {
                if (!RenderSystem.isOnRenderThread()) {
                    RenderSystem.recordRenderCall(() -> this.f_244570_.m_245152_(p_249105_, p_249676_, this));
                } else {
                    this.f_244570_.m_245152_(p_249105_, p_249676_, this);
                }
            }
        }

        @Override
        public void close() {
            if (this.f_244570_ != null) {
                this.f_244570_.close();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    final class InterpolationData
    implements AutoCloseable {
        private final NativeImage[] f_244527_;

        InterpolationData() {
            this.f_244527_ = new NativeImage[SpriteContents.this.f_243731_.length];
            for (int i = 0; i < this.f_244527_.length; ++i) {
                int j = SpriteContents.this.f_244302_ >> i;
                int k = SpriteContents.this.f_244600_ >> i;
                this.f_244527_[i] = new NativeImage(Math.max(1, j), Math.max(1, k), false);
            }
        }

        void m_245152_(int p_250513_, int p_251644_, Ticker p_248626_) {
            AnimatedTexture spritecontents$animatedtexture = p_248626_.f_243921_;
            List<FrameInfo> list = spritecontents$animatedtexture.f_243714_;
            FrameInfo spritecontents$frameinfo = list.get(p_248626_.f_244631_);
            double d0 = 1.0 - (double)p_248626_.f_244511_ / (double)spritecontents$frameinfo.f_244553_;
            int i = spritecontents$frameinfo.f_243751_;
            int j = list.get((int)((p_248626_.f_244631_ + 1) % list.size())).f_243751_;
            if (i != j) {
                for (int k = 0; k < this.f_244527_.length; ++k) {
                    int l = SpriteContents.this.f_244302_ >> k;
                    int i1 = SpriteContents.this.f_244600_ >> k;
                    if (l < 1 || i1 < 1) continue;
                    for (int j1 = 0; j1 < i1; ++j1) {
                        for (int k1 = 0; k1 < l; ++k1) {
                            int l1 = this.m_246491_(spritecontents$animatedtexture, i, k, k1, j1);
                            int i2 = this.m_246491_(spritecontents$animatedtexture, j, k, k1, j1);
                            int j2 = this.m_247111_(d0, l1 >> 16 & 0xFF, i2 >> 16 & 0xFF);
                            int k2 = this.m_247111_(d0, l1 >> 8 & 0xFF, i2 >> 8 & 0xFF);
                            int l2 = this.m_247111_(d0, l1 & 0xFF, i2 & 0xFF);
                            this.f_244527_[k].m_84988_(k1, j1, l1 & 0xFF000000 | j2 << 16 | k2 << 8 | l2);
                        }
                    }
                }
                SpriteContents.this.m_247381_(p_250513_, p_251644_, 0, 0, this.f_244527_);
            }
        }

        private int m_246491_(AnimatedTexture p_251976_, int p_250761_, int p_250049_, int p_250004_, int p_251489_) {
            return SpriteContents.this.f_243731_[p_250049_].m_84985_(p_250004_ + (p_251976_.m_245080_(p_250761_) * SpriteContents.this.f_244302_ >> p_250049_), p_251489_ + (p_251976_.m_246436_(p_250761_) * SpriteContents.this.f_244600_ >> p_250049_));
        }

        private int m_247111_(double p_250974_, int p_252151_, int p_249832_) {
            return (int)(p_250974_ * (double)p_252151_ + (1.0 - p_250974_) * (double)p_249832_);
        }

        @Override
        public void close() {
            for (NativeImage nativeimage : this.f_244527_) {
                nativeimage.close();
            }
        }
    }
}

