/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.language;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.metadata.language.LanguageMetadataSection;
import net.minecraft.locale.Language;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class LanguageManager
implements ResourceManagerReloadListener {
    private static final Logger f_118964_ = LogUtils.getLogger();
    public static final String f_174854_ = "en_us";
    private static final LanguageInfo f_118965_ = new LanguageInfo("US", "English", false);
    private Map<String, LanguageInfo> f_118966_ = ImmutableMap.of((Object)"en_us", (Object)f_118965_);
    private String f_118967_;
    private Locale javaLocale;

    public LanguageManager(String p_118971_) {
        this.m_264110_(p_118971_);
    }

    private static Map<String, LanguageInfo> m_118981_(Stream<PackResources> p_118982_) {
        HashMap map = Maps.newHashMap();
        p_118982_.forEach(p_264712_ -> {
            try {
                LanguageMetadataSection languagemetadatasection = p_264712_.m_5550_(LanguageMetadataSection.f_263724_);
                if (languagemetadatasection != null) {
                    languagemetadatasection.f_119097_().forEach(map::putIfAbsent);
                }
            }
            catch (IOException | RuntimeException runtimeexception) {
                f_118964_.warn("Unable to parse language metadata section of resourcepack: {}", (Object)p_264712_.m_5542_(), (Object)runtimeexception);
            }
        });
        return ImmutableMap.copyOf((Map)map);
    }

    @Override
    public void m_6213_(ResourceManager p_118973_) {
        LanguageInfo languageinfo;
        this.f_118966_ = LanguageManager.m_118981_(p_118973_.m_7536_());
        ArrayList<String> list = new ArrayList<String>(2);
        boolean flag = f_118965_.f_118946_();
        list.add(f_174854_);
        if (!this.f_118967_.equals(f_174854_) && (languageinfo = this.f_118966_.get(this.f_118967_)) != null) {
            list.add(this.f_118967_);
            flag = languageinfo.f_118946_();
        }
        ClientLanguage clientlanguage = ClientLanguage.m_264420_(p_118973_, list, flag);
        I18n.m_118941_(clientlanguage);
        Language.m_128114_(clientlanguage);
    }

    public Locale getJavaLocale() {
        return this.javaLocale;
    }

    public void m_264110_(String p_265224_) {
        this.f_118967_ = p_265224_;
        String[] langSplit = p_265224_.split("_", 2);
        this.javaLocale = langSplit.length == 1 ? new Locale(langSplit[0]) : new Locale(langSplit[0], langSplit[1]);
    }

    public String m_264236_() {
        return this.f_118967_;
    }

    public SortedMap<String, LanguageInfo> m_264450_() {
        return new TreeMap<String, LanguageInfo>(this.f_118966_);
    }

    @Nullable
    public LanguageInfo m_118976_(String p_118977_) {
        return this.f_118966_.get(p_118977_);
    }
}

