/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.telemetry.events;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.client.telemetry.TelemetryEventSender;
import net.minecraft.client.telemetry.TelemetryEventType;
import net.minecraft.client.telemetry.TelemetryProperty;
import org.slf4j.Logger;

public class GameLoadTimesEvent {
    public static final GameLoadTimesEvent f_285635_ = new GameLoadTimesEvent(Ticker.systemTicker());
    private static final Logger f_285561_ = LogUtils.getLogger();
    private final Ticker f_285636_;
    private final Map<TelemetryProperty<Measurement>, Stopwatch> f_285659_ = new HashMap<TelemetryProperty<Measurement>, Stopwatch>();
    private OptionalLong f_285644_ = OptionalLong.empty();

    protected GameLoadTimesEvent(Ticker p_286506_) {
        this.f_285636_ = p_286506_;
    }

    public synchronized void m_285833_(TelemetryProperty<Measurement> p_286394_) {
        this.m_285937_(p_286394_, p_286494_ -> Stopwatch.createStarted((Ticker)this.f_285636_));
    }

    public synchronized void m_285977_(TelemetryProperty<Measurement> p_286396_, Stopwatch p_286822_) {
        this.m_285937_(p_286396_, p_286421_ -> p_286822_);
    }

    private synchronized void m_285937_(TelemetryProperty<Measurement> p_286311_, Function<TelemetryProperty<Measurement>, Stopwatch> p_286454_) {
        this.f_285659_.computeIfAbsent(p_286311_, p_286454_);
    }

    public synchronized void m_285901_(TelemetryProperty<Measurement> p_286634_) {
        Stopwatch $$1 = this.f_285659_.get(p_286634_);
        if ($$1 == null) {
            f_285561_.warn("Attempted to end step for {} before starting it", (Object)p_286634_.f_260687_());
            return;
        }
        if ($$1.isRunning()) {
            $$1.stop();
        }
    }

    public void m_286019_(TelemetryEventSender p_286524_) {
        p_286524_.m_260919_(TelemetryEventType.f_285589_, p_286285_ -> {
            GameLoadTimesEvent gameLoadTimesEvent = this;
            synchronized (gameLoadTimesEvent) {
                this.f_285659_.forEach((p_286804_, p_286275_) -> {
                    if (!p_286275_.isRunning()) {
                        long $$3 = p_286275_.elapsed(TimeUnit.MILLISECONDS);
                        p_286285_.m_261137_(p_286804_, new Measurement((int)$$3));
                    } else {
                        f_285561_.warn("Measurement {} was discarded since it was still ongoing when the event {} was sent.", (Object)p_286804_.f_260687_(), (Object)TelemetryEventType.f_285589_.m_260927_());
                    }
                });
                this.f_285644_.ifPresent(p_286872_ -> p_286285_.m_261137_(TelemetryProperty.f_285586_, new Measurement((int)p_286872_)));
                this.f_285659_.clear();
            }
        });
    }

    public synchronized void m_286069_(long p_286847_) {
        this.f_285644_ = OptionalLong.of(p_286847_);
    }

    public record Measurement(int f_285578_) {
        public static final Codec<Measurement> f_285618_ = Codec.INT.xmap(Measurement::new, p_286736_ -> p_286736_.f_285578_);

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Measurement.class, "millis", "f_285578_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Measurement.class, "millis", "f_285578_"}, this);
        }

        @Override
        public final boolean equals(Object p_286789_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Measurement.class, "millis", "f_285578_"}, this, p_286789_);
        }
    }
}

