/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public abstract class AbstractPackResources
implements PackResources {
    private static final Logger f_10204_ = LogUtils.getLogger();
    private final String f_243737_;
    private final boolean f_254645_;

    protected AbstractPackResources(String p_255888_, boolean p_256392_) {
        this.f_243737_ = p_255888_;
        this.f_254645_ = p_256392_;
    }

    @Override
    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> p_10213_) throws IOException {
        IoSupplier<InputStream> iosupplier = this.m_8017_("pack.mcmeta");
        if (iosupplier == null) {
            return null;
        }
        try (InputStream inputstream = iosupplier.m_247737_();){
            T t = AbstractPackResources.m_10214_(p_10213_, inputstream);
            return t;
        }
    }

    @Nullable
    public static <T> T m_10214_(MetadataSectionSerializer<T> p_10215_, InputStream p_10216_) {
        JsonObject jsonobject;
        try (BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(p_10216_, StandardCharsets.UTF_8));){
            jsonobject = GsonHelper.m_13859_(bufferedreader);
        }
        catch (Exception exception1) {
            f_10204_.error("Couldn't load {} metadata", (Object)p_10215_.m_7991_(), (Object)exception1);
            return null;
        }
        if (!jsonobject.has(p_10215_.m_7991_())) {
            return null;
        }
        try {
            return p_10215_.m_6322_(GsonHelper.m_13930_(jsonobject, p_10215_.m_7991_()));
        }
        catch (Exception exception) {
            f_10204_.error("Couldn't load {} metadata", (Object)p_10215_.m_7991_(), (Object)exception);
            return null;
        }
    }

    @Override
    public String m_5542_() {
        return this.f_243737_;
    }

    @Override
    public boolean m_246538_() {
        return this.f_254645_;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s: %s", this.getClass().getName(), this.f_243737_);
    }
}

