/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.common.world.PieceBeardifierModifier;

public class Beardifier
implements DensityFunctions.BeardifierOrMarker {
    public static final int f_158060_ = 12;
    private static final int f_158061_ = 24;
    private static final float[] f_158062_ = Util.m_137469_(new float[13824], p_158082_ -> {
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < 24; ++j) {
                for (int k = 0; k < 24; ++k) {
                    p_158082_[i * 24 * 24 + j * 24 + k] = (float)Beardifier.m_158091_(j - 12, k - 12, i - 12);
                }
            }
        }
    });
    protected final ObjectListIterator<Rigid> f_158065_;
    protected final ObjectListIterator<JigsawJunction> f_158066_;

    public static Beardifier m_223937_(StructureManager p_223938_, ChunkPos p_223939_) {
        int i = p_223939_.m_45604_();
        int j = p_223939_.m_45605_();
        ObjectArrayList objectlist = new ObjectArrayList(10);
        ObjectArrayList objectlist1 = new ObjectArrayList(32);
        p_223938_.m_220477_(p_223939_, p_223941_ -> p_223941_.m_226620_() != TerrainAdjustment.NONE).forEach(arg_0 -> Beardifier.m_223930_(p_223939_, (ObjectList)objectlist, i, j, (ObjectList)objectlist1, arg_0));
        return new Beardifier((ObjectListIterator<Rigid>)objectlist.iterator(), (ObjectListIterator<JigsawJunction>)objectlist1.iterator());
    }

    @VisibleForTesting
    public Beardifier(ObjectListIterator<Rigid> p_223917_, ObjectListIterator<JigsawJunction> p_223918_) {
        this.f_158065_ = p_223917_;
        this.f_158066_ = p_223918_;
    }

    @Override
    public double m_207386_(DensityFunction.FunctionContext p_208200_) {
        int i = p_208200_.m_207115_();
        int j = p_208200_.m_207114_();
        int k = p_208200_.m_207113_();
        double d0 = 0.0;
        while (this.f_158065_.hasNext()) {
            Rigid beardifier$rigid = (Rigid)this.f_158065_.next();
            BoundingBox boundingbox = beardifier$rigid.f_223944_();
            int l = beardifier$rigid.f_223946_();
            int i1 = Math.max(0, Math.max(boundingbox.m_162395_() - i, i - boundingbox.m_162399_()));
            int j1 = Math.max(0, Math.max(boundingbox.m_162398_() - k, k - boundingbox.m_162401_()));
            int k1 = boundingbox.m_162396_() + l;
            int l1 = j - k1;
            int i2 = switch (beardifier$rigid.f_223945_()) {
                case TerrainAdjustment.NONE -> 0;
                case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN -> l1;
                case TerrainAdjustment.BEARD_BOX -> Math.max(0, Math.max(k1 - j, j - boundingbox.m_162400_()));
                default -> throw new IncompatibleClassChangeError();
            };
            d0 += (switch (beardifier$rigid.f_223945_()) {
                case TerrainAdjustment.NONE -> 0.0;
                case TerrainAdjustment.BURY -> Beardifier.m_158083_(i1, i2, j1);
                case TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> Beardifier.m_223925_(i1, i2, j1, l1) * 0.8;
                default -> throw new IncompatibleClassChangeError();
            });
        }
        this.f_158065_.back(Integer.MAX_VALUE);
        while (this.f_158066_.hasNext()) {
            JigsawJunction jigsawjunction = (JigsawJunction)this.f_158066_.next();
            int j2 = i - jigsawjunction.m_210252_();
            int k2 = j - jigsawjunction.m_210257_();
            int l2 = k - jigsawjunction.m_210258_();
            d0 += Beardifier.m_223925_(j2, k2, l2, k2) * 0.4;
        }
        this.f_158066_.back(Integer.MAX_VALUE);
        return d0;
    }

    @Override
    public double m_207402_() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double m_207401_() {
        return Double.POSITIVE_INFINITY;
    }

    protected static double m_158083_(int p_158084_, int p_158085_, int p_158086_) {
        double d0 = Mth.m_184648_(p_158084_, (double)p_158085_ / 2.0, p_158086_);
        return Mth.m_144851_(d0, 0.0, 6.0, 1.0, 0.0);
    }

    protected static double m_223925_(int p_223926_, int p_223927_, int p_223928_, int p_223929_) {
        int i = p_223926_ + 12;
        int j = p_223927_ + 12;
        int k = p_223928_ + 12;
        if (Beardifier.m_223919_(i) && Beardifier.m_223919_(j) && Beardifier.m_223919_(k)) {
            double d0 = (double)p_223929_ + 0.5;
            double d1 = Mth.m_211592_(p_223926_, d0, p_223928_);
            double d2 = -d0 * Mth.m_14193_(d1 / 2.0) / 2.0;
            return d2 * (double)f_158062_[k * 24 * 24 + i * 24 + j];
        }
        return 0.0;
    }

    private static boolean m_223919_(int p_223920_) {
        return p_223920_ >= 0 && p_223920_ < 24;
    }

    private static double m_158091_(int p_158092_, int p_158093_, int p_158094_) {
        return Beardifier.m_223921_(p_158092_, (double)p_158093_ + 0.5, p_158094_);
    }

    private static double m_223921_(int p_223922_, double p_223923_, int p_223924_) {
        double d0 = Mth.m_211592_(p_223922_, p_223923_, p_223924_);
        return Math.pow(Math.E, -d0 / 16.0);
    }

    private static /* synthetic */ void m_223930_(ChunkPos p_223931_, ObjectList p_223932_, int p_223933_, int p_223934_, ObjectList p_223935_, StructureStart p_223936_) {
        TerrainAdjustment terrainadjustment = p_223936_.m_226861_().m_226620_();
        for (StructurePiece structurepiece : p_223936_.m_73602_()) {
            if (!structurepiece.m_73411_(p_223931_, 12)) continue;
            if (structurepiece instanceof PieceBeardifierModifier) {
                PieceBeardifierModifier pieceBeardifierModifier = (PieceBeardifierModifier)structurepiece;
                if (pieceBeardifierModifier.getTerrainAdjustment() == TerrainAdjustment.NONE) continue;
                p_223932_.add((Object)new Rigid(pieceBeardifierModifier.getBeardifierBox(), pieceBeardifierModifier.getTerrainAdjustment(), pieceBeardifierModifier.getGroundLevelDelta()));
                continue;
            }
            if (structurepiece instanceof PoolElementStructurePiece) {
                PoolElementStructurePiece poolelementstructurepiece = (PoolElementStructurePiece)structurepiece;
                StructureTemplatePool.Projection structuretemplatepool$projection = poolelementstructurepiece.m_209918_().m_210539_();
                if (structuretemplatepool$projection == StructureTemplatePool.Projection.RIGID) {
                    p_223932_.add((Object)new Rigid(poolelementstructurepiece.m_73547_(), terrainadjustment, poolelementstructurepiece.m_72647_()));
                }
                for (JigsawJunction jigsawjunction : poolelementstructurepiece.m_72648_()) {
                    int k = jigsawjunction.m_210252_();
                    int l = jigsawjunction.m_210258_();
                    if (k <= p_223933_ - 12 || l <= p_223934_ - 12 || k >= p_223933_ + 15 + 12 || l >= p_223934_ + 15 + 12) continue;
                    p_223935_.add((Object)jigsawjunction);
                }
                continue;
            }
            p_223932_.add((Object)new Rigid(structurepiece.m_73547_(), terrainadjustment, 0));
        }
    }

    @VisibleForTesting
    public record Rigid(BoundingBox f_223944_, TerrainAdjustment f_223945_, int f_223946_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Rigid.class, "box;terrainAdjustment;groundLevelDelta", "f_223944_", "f_223945_", "f_223946_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Rigid.class, "box;terrainAdjustment;groundLevelDelta", "f_223944_", "f_223945_", "f_223946_"}, this);
        }

        @Override
        public final boolean equals(Object p_223955_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Rigid.class, "box;terrainAdjustment;groundLevelDelta", "f_223944_", "f_223945_", "f_223946_"}, this, p_223955_);
        }
    }
}

