/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.audio;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.stb.STBVorbisAlloc;
import org.lwjgl.stb.STBVorbisInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class OggAudioStream
implements AudioStream {
    private static final int EXPECTED_MAX_FRAME_SIZE = 8192;
    private long handle;
    private final AudioFormat audioFormat;
    private final InputStream input;
    private ByteBuffer buffer = MemoryUtil.memAlloc((int)8192);

    public OggAudioStream(InputStream p_83751_) throws IOException {
        this.input = p_83751_;
        this.buffer.limit(0);
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            while (this.handle == 0L) {
                if (!this.refillFromStream()) {
                    throw new IOException("Failed to find Ogg header");
                }
                int i = this.buffer.position();
                this.buffer.position(0);
                this.handle = STBVorbis.stb_vorbis_open_pushdata((ByteBuffer)this.buffer, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (STBVorbisAlloc)null);
                this.buffer.position(i);
                int j = intbuffer1.get(0);
                if (j == 1) {
                    this.forwardBuffer();
                    continue;
                }
                if (j == 0) continue;
                throw new IOException("Failed to read Ogg file " + j);
            }
            this.buffer.position(this.buffer.position() + intbuffer.get(0));
            STBVorbisInfo stbvorbisinfo = STBVorbisInfo.mallocStack((MemoryStack)memorystack);
            STBVorbis.stb_vorbis_get_info((long)this.handle, (STBVorbisInfo)stbvorbisinfo);
            this.audioFormat = new AudioFormat(stbvorbisinfo.sample_rate(), 16, stbvorbisinfo.channels(), true, false);
        }
    }

    private boolean refillFromStream() throws IOException {
        int i = this.buffer.limit();
        int j = this.buffer.capacity() - i;
        if (j == 0) {
            return true;
        }
        byte[] abyte = new byte[j];
        int k = this.input.read(abyte);
        if (k == -1) {
            return false;
        }
        int l = this.buffer.position();
        this.buffer.limit(i + k);
        this.buffer.position(i);
        this.buffer.put(abyte, 0, k);
        this.buffer.position(l);
        return true;
    }

    private void forwardBuffer() {
        boolean flag1;
        boolean flag = this.buffer.position() == 0;
        boolean bl = flag1 = this.buffer.position() == this.buffer.limit();
        if (flag1 && !flag) {
            this.buffer.position(0);
            this.buffer.limit(0);
        } else {
            ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)(flag ? 2 * this.buffer.capacity() : this.buffer.capacity()));
            bytebuffer.put(this.buffer);
            MemoryUtil.memFree((Buffer)this.buffer);
            bytebuffer.flip();
            this.buffer = bytebuffer;
        }
    }

    private boolean readFrame(OutputConcat p_83756_) throws IOException {
        if (this.handle == 0L) {
            return false;
        }
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            while (true) {
                int i = STBVorbis.stb_vorbis_decode_frame_pushdata((long)this.handle, (ByteBuffer)this.buffer, (IntBuffer)intbuffer, (PointerBuffer)pointerbuffer, (IntBuffer)intbuffer1);
                this.buffer.position(this.buffer.position() + i);
                int j = STBVorbis.stb_vorbis_get_error((long)this.handle);
                if (j == 1) {
                    this.forwardBuffer();
                    if (this.refillFromStream()) continue;
                    boolean bl = false;
                    return bl;
                }
                if (j != 0) {
                    throw new IOException("Failed to read Ogg file " + j);
                }
                int k = intbuffer1.get(0);
                if (k == 0) continue;
                int l = intbuffer.get(0);
                PointerBuffer pointerbuffer1 = pointerbuffer.getPointerBuffer(l);
                if (l == 1) {
                    this.convertMono(pointerbuffer1.getFloatBuffer(0, k), p_83756_);
                    boolean bl = true;
                    return bl;
                }
                if (l != 2) {
                    throw new IllegalStateException("Invalid number of channels: " + l);
                }
                this.convertStereo(pointerbuffer1.getFloatBuffer(0, k), pointerbuffer1.getFloatBuffer(1, k), p_83756_);
                boolean bl = true;
                return bl;
            }
        }
    }

    private void convertMono(FloatBuffer p_83758_, OutputConcat p_83759_) {
        while (p_83758_.hasRemaining()) {
            p_83759_.put(p_83758_.get());
        }
    }

    private void convertStereo(FloatBuffer p_83761_, FloatBuffer p_83762_, OutputConcat p_83763_) {
        while (p_83761_.hasRemaining() && p_83762_.hasRemaining()) {
            p_83763_.put(p_83761_.get());
            p_83763_.put(p_83762_.get());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.handle != 0L) {
            STBVorbis.stb_vorbis_close((long)this.handle);
            this.handle = 0L;
        }
        MemoryUtil.memFree((Buffer)this.buffer);
        this.input.close();
    }

    @Override
    public AudioFormat getFormat() {
        return this.audioFormat;
    }

    @Override
    public ByteBuffer read(int p_83754_) throws IOException {
        OutputConcat oggaudiostream$outputconcat = new OutputConcat(p_83754_ + 8192);
        while (this.readFrame(oggaudiostream$outputconcat) && oggaudiostream$outputconcat.byteCount < p_83754_) {
        }
        return oggaudiostream$outputconcat.get();
    }

    public ByteBuffer readAll() throws IOException {
        OutputConcat oggaudiostream$outputconcat = new OutputConcat(16384);
        while (this.readFrame(oggaudiostream$outputconcat)) {
        }
        return oggaudiostream$outputconcat.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class OutputConcat {
        private final List<ByteBuffer> buffers = Lists.newArrayList();
        private final int bufferSize;
        int byteCount;
        private ByteBuffer currentBuffer;

        public OutputConcat(int p_83773_) {
            this.bufferSize = p_83773_ + 1 & 0xFFFFFFFE;
            this.createNewBuffer();
        }

        private void createNewBuffer() {
            this.currentBuffer = BufferUtils.createByteBuffer((int)this.bufferSize);
        }

        public void put(float p_83776_) {
            if (this.currentBuffer.remaining() == 0) {
                this.currentBuffer.flip();
                this.buffers.add(this.currentBuffer);
                this.createNewBuffer();
            }
            int i = Mth.clamp((int)(p_83776_ * 32767.5f - 0.5f), Short.MIN_VALUE, Short.MAX_VALUE);
            this.currentBuffer.putShort((short)i);
            this.byteCount += 2;
        }

        public ByteBuffer get() {
            this.currentBuffer.flip();
            if (this.buffers.isEmpty()) {
                return this.currentBuffer;
            }
            ByteBuffer bytebuffer = BufferUtils.createByteBuffer((int)this.byteCount);
            this.buffers.forEach(bytebuffer::put);
            bytebuffer.put(this.currentBuffer);
            bytebuffer.flip();
            return bytebuffer;
        }
    }
}

