/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.audio;

import com.mojang.logging.LogUtils;
import javax.sound.sampled.AudioFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class OpenAlUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    private static String alErrorToString(int p_83783_) {
        switch (p_83783_) {
            case 40961: {
                return "Invalid name parameter.";
            }
            case 40962: {
                return "Invalid enumerated parameter value.";
            }
            case 40963: {
                return "Invalid parameter parameter value.";
            }
            case 40964: {
                return "Invalid operation.";
            }
            case 40965: {
                return "Unable to allocate memory.";
            }
        }
        return "An unrecognized error occurred.";
    }

    static boolean checkALError(String p_83788_) {
        int i = AL10.alGetError();
        if (i != 0) {
            LOGGER.error("{}: {}", (Object)p_83788_, (Object)OpenAlUtil.alErrorToString(i));
            return true;
        }
        return false;
    }

    private static String alcErrorToString(int p_83792_) {
        switch (p_83792_) {
            case 40961: {
                return "Invalid device.";
            }
            case 40962: {
                return "Invalid context.";
            }
            case 40963: {
                return "Illegal enum.";
            }
            case 40964: {
                return "Invalid value.";
            }
            case 40965: {
                return "Unable to allocate memory.";
            }
        }
        return "An unrecognized error occurred.";
    }

    static boolean checkALCError(long p_83785_, String p_83786_) {
        int i = ALC10.alcGetError((long)p_83785_);
        if (i != 0) {
            LOGGER.error("{}{}: {}", new Object[]{p_83786_, p_83785_, OpenAlUtil.alcErrorToString(i)});
            return true;
        }
        return false;
    }

    static int audioFormatToOpenAl(AudioFormat p_83790_) {
        AudioFormat.Encoding encoding = p_83790_.getEncoding();
        int i = p_83790_.getChannels();
        int j = p_83790_.getSampleSizeInBits();
        if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) || encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (i == 1) {
                if (j == 8) {
                    return 4352;
                }
                if (j == 16) {
                    return 4353;
                }
            } else if (i == 2) {
                if (j == 8) {
                    return 4354;
                }
                if (j == 16) {
                    return 4355;
                }
            }
        }
        throw new IllegalArgumentException("Invalid audio format: " + String.valueOf(p_83790_));
    }
}

